/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.Cash;
import net.corda.contracts.asset.OnLedgerAsset;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.StructuresKt;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionType;
import net.corda.core.crypto.CompositeKeyKt;
import net.corda.core.crypto.CryptoUtilitiesKt;
import net.corda.core.crypto.Party;
import net.corda.core.flows.FlowLogic;
import net.corda.core.node.services.Vault;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.flows.BroadcastTransactionFlow;
import net.corda.flows.CashCommand;
import net.corda.flows.CashFlowResult;
import net.corda.flows.FinalityFlow;
import net.corda.flows.InputStateRefResolveFailed;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0002H\u0017J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\rH\u0003J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000fH\u0003R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lnet/corda/flows/CashFlow;", "Lnet/corda/core/flows/FlowLogic;", "Lnet/corda/flows/CashFlowResult;", "command", "Lnet/corda/flows/CashCommand;", "(Lnet/corda/flows/CashCommand;)V", "getCommand", "()Lnet/corda/flows/CashCommand;", "call", "exitCash", "req", "Lnet/corda/flows/CashCommand$ExitCash;", "initiatePayment", "Lnet/corda/flows/CashCommand$PayCash;", "issueCash", "Lnet/corda/flows/CashCommand$IssueCash;", "finance_main"})
public final class CashFlow
extends FlowLogic<CashFlowResult> {
    @NotNull
    private final CashCommand command;

    @Suspendable
    @NotNull
    public CashFlowResult call() {
        CashFlowResult cashFlowResult;
        CashCommand cashCommand = this.command;
        if (cashCommand instanceof CashCommand.IssueCash) {
            cashFlowResult = this.issueCash((CashCommand.IssueCash)this.command);
        } else if (cashCommand instanceof CashCommand.PayCash) {
            cashFlowResult = this.initiatePayment((CashCommand.PayCash)this.command);
        } else if (cashCommand instanceof CashCommand.ExitCash) {
            cashFlowResult = this.exitCash((CashCommand.ExitCash)this.command);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return cashFlowResult;
    }

    /*
     * WARNING - void declaration
     */
    @Suspendable
    private final CashFlowResult initiatePayment(CashCommand.PayCash req) {
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        try {
            void spendTX;
            void $receiver$iv;
            void keysForSigning;
            Object object = this.getServiceHub().getVaultService().generateSpend(builder, StructuresKt.withoutIssuer(req.getAmount()), req.getRecipient().getOwningKey(), SetsKt.setOf((Object)((Issued)req.getAmount().getToken()).getIssuer().getParty()));
            TransactionBuilder transactionBuilder = (TransactionBuilder)object.component1();
            List list = (List)object.component2();
            object = null;
            object = CompositeKeyKt.getKeys((Iterable)((Iterable)keysForSigning));
            for (Object element$iv : $receiver$iv) {
                PrivateKey key;
                PublicKey it = (PublicKey)element$iv;
                if ((PrivateKey)this.getServiceHub().getKeyManagementService().getKeys().get(it) == null) {
                    throw (Throwable)new IllegalStateException("Could not find signing key for " + CryptoUtilitiesKt.toStringShort((PublicKey)it));
                }
                builder.signWith(new KeyPair(it, key));
            }
            SignedTransaction tx = spendTX.toSignedTransaction(false);
            FinalityFlow flow = new FinalityFlow(tx, SetsKt.setOf((Object)req.getRecipient()), null, 4, null);
            FlowLogic.subFlow$default((FlowLogic)this, (FlowLogic)((FlowLogic)flow), (boolean)false, (int)2, null);
            return new CashFlowResult.Success(this.getFsm().getId(), tx, "Cash payment transaction generated");
        }
        catch (InsufficientBalanceException ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "Insufficient balance";
            }
            return new CashFlowResult.Failed(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Suspendable
    private final CashFlowResult exitCash(CashCommand.ExitCash req) {
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        try {
            Collection destination$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable destination$iv$iv2;
            Map $receiver$iv$iv2;
            void $receiver$iv2;
            void destination$iv$iv3;
            Object it;
            Object element$iv$iv2;
            void $receiver$iv3;
            Iterable destination$iv$iv$iv;
            Collection $receiver$iv$iv$iv;
            void $receiver$iv$iv3;
            Iterable this_$iv;
            PartyAndReference issuer = new PartyAndReference(this.getServiceHub().getMyInfo().getLegalIdentity(), req.getIssueRef());
            Vault vault = this.getServiceHub().getVaultService().getCurrentVault();
            Amount amount = ContractsDSL.issuedBy(req.getAmount(), (PartyAndReference)issuer);
            TransactionBuilder transactionBuilder = builder;
            Object object = new Cash();
            Iterable iterable = this_$iv.getStates();
            void var6_10 = $receiver$iv$iv3;
            Collection collection = new ArrayList();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                StateAndRef it$iv = (StateAndRef)element$iv$iv$iv;
                if (!(it$iv.getState().getData() instanceof Cash.State)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            List list = (List)destination$iv$iv$iv;
            this_$iv = list;
            $receiver$iv$iv3 = $receiver$iv3;
            $receiver$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                it = (StateAndRef)element$iv$iv2;
                if (!Intrinsics.areEqual((Object)((Cash.State)it.getState().getData()).getOwner(), (Object)issuer.getParty().getOwningKey())) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            list = (List)destination$iv$iv3;
            ((OnLedgerAsset)object).generateExit(transactionBuilder, amount, list);
            KeyPair myKey = this.getServiceHub().getLegalIdentityKey();
            builder.signWith(myKey);
            Map inputStatesNullable = this.getServiceHub().getVaultService().statesForRefs(builder.inputStates());
            destination$iv$iv$iv = CollectionsKt.filterNotNull((Iterable)inputStatesNullable.values());
            element$iv$iv2 = $receiver$iv2;
            it = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            Object $i$a$1$filter = $receiver$iv$iv2.iterator();
            while ($i$a$1$filter.hasNext()) {
                Iterator it2;
                Object item$iv$iv = $i$a$1$filter.next();
                TransactionState $i$f$filter = (TransactionState)item$iv$iv;
                object = destination$iv$iv2;
                transactionBuilder = it2.getData();
                object.add(transactionBuilder);
            }
            List inputStates = (List)destination$iv$iv2;
            if (inputStatesNullable.size() != inputStates.size()) {
                Map.Entry it3;
                $receiver$iv$iv2 = inputStatesNullable;
                destination$iv$iv2 = $receiver$iv;
                $i$a$1$filter = new LinkedHashMap();
                Iterator iterator = $receiver$iv$iv;
                for (Map.Entry element$iv$iv3 : iterator.entrySet()) {
                    it3 = element$iv$iv3;
                    if (!(it3.getValue() == null)) continue;
                    destination$iv$iv.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
                }
                $receiver$iv = destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList($receiver$iv.size());
                iterator = $receiver$iv$iv;
                for (Map.Entry item$iv$iv : iterator.entrySet()) {
                    it3 = item$iv$iv;
                    object = destination$iv$iv;
                    transactionBuilder = (StateRef)it3.getKey();
                    object.add(transactionBuilder);
                }
                List unresolvedStateRefs = (List)destination$iv$iv;
                throw (Throwable)new InputStateRefResolveFailed(unresolvedStateRefs);
            }
            $receiver$iv = inputStates;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv4 : $receiver$iv$iv) {
                if (!(element$iv$iv4 instanceof Cash.State)) continue;
                destination$iv$iv.add(element$iv$iv4);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it4;
                Cash.State $i$f$filterIsInstanceTo = (Cash.State)item$iv$iv;
                object = destination$iv$iv;
                transactionBuilder = this.getServiceHub().getIdentityService().partyFromKey(it4.getOwner());
                object.add(transactionBuilder);
            }
            Set participants = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
            SignedTransaction tx = builder.toSignedTransaction(false);
            FlowLogic.subFlow$default((FlowLogic)this, (FlowLogic)((FlowLogic)new FinalityFlow(tx, participants, null, 4, null)), (boolean)false, (int)2, null);
            return new CashFlowResult.Success(this.getFsm().getId(), tx, "Cash destruction transaction generated");
        }
        catch (InsufficientBalanceException ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "Insufficient balance";
            }
            return new CashFlowResult.Failed(string);
        }
    }

    @Suspendable
    private final CashFlowResult issueCash(CashCommand.IssueCash req) {
        TransactionBuilder builder = (TransactionBuilder)new TransactionType.General.Builder((Party)null);
        PartyAndReference issuer = new PartyAndReference(this.getServiceHub().getMyInfo().getLegalIdentity(), req.getIssueRef());
        new Cash().generateIssue(builder, (Amount<Issued<Currency>>)ContractsDSL.issuedBy(req.getAmount(), (PartyAndReference)issuer), req.getRecipient().getOwningKey(), req.getNotary());
        KeyPair myKey = this.getServiceHub().getLegalIdentityKey();
        builder.signWith(myKey);
        SignedTransaction tx = builder.toSignedTransaction(true);
        FlowLogic.subFlow$default((FlowLogic)this, (FlowLogic)((FlowLogic)new BroadcastTransactionFlow(tx, SetsKt.setOf((Object)req.getRecipient()))), (boolean)false, (int)2, null);
        return new CashFlowResult.Success(this.getFsm().getId(), tx, "Cash issuance completed");
    }

    @NotNull
    public final CashCommand getCommand() {
        return this.command;
    }

    public CashFlow(@NotNull CashCommand command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.command = command;
    }
}

