/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts.clause;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.FungibleAssetKt;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.MoveCommand;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.Party;
import net.corda.core.transactions.TransactionBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0004*\u00020\u0005*\b\b\u0002\u0010\u0003*\u00020\u00062\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\b0\u0007B\u0005\u00a2\u0006\u0002\u0010\tJH\u0010\n\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u000e0\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u000eH\u0003J\u009c\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\u000e2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u001826\u0010\u0019\u001a2\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\u000e\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u001e\u0010\u001e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\u000e\u0012\u0004\u0012\u00020\u00050\u001fJ\b\u0010 \u001a\u00020!H\u0016JV\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010#2\u0006\u0010\u0014\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010(0\u00182\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\bH\u0016\u00a8\u0006*"}, d2={"Lnet/corda/contracts/clause/AbstractConserveAmount;", "S", "Lnet/corda/core/contracts/FungibleAsset;", "T", "C", "Lnet/corda/core/contracts/CommandData;", "", "Lnet/corda/core/contracts/clauses/Clause;", "Lnet/corda/core/contracts/Issued;", "()V", "gatherCoins", "Lkotlin/Pair;", "Ljava/util/ArrayList;", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/Amount;", "acceptableCoins", "", "amount", "generateExit", "Lnet/corda/core/crypto/CompositeKey;", "tx", "Lnet/corda/core/transactions/TransactionBuilder;", "amountIssued", "assetStates", "", "deriveState", "Lkotlin/Function3;", "Lnet/corda/core/contracts/TransactionState;", "generateMoveCommand", "Lkotlin/Function0;", "generateExitCommand", "Lkotlin/Function1;", "toString", "", "verify", "", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "finance_main"})
public abstract class AbstractConserveAmount<S extends FungibleAsset<T>, C extends CommandData, T>
extends Clause<S, C, Issued<? extends T>> {
    private final Pair<ArrayList<StateAndRef<S>>, Amount<T>> gatherCoins(Collection<? extends StateAndRef<? extends S>> acceptableCoins, Amount<T> amount) throws InsufficientBalanceException {
        ArrayList gathered = CollectionsKt.arrayListOf((Object[])new StateAndRef[0]);
        Amount gatheredAmount = new Amount(0L, amount.getToken());
        for (StateAndRef<S> stateAndRef : acceptableCoins) {
            if (gatheredAmount.compareTo(amount) >= 0) break;
            gathered.add(stateAndRef);
            gatheredAmount = gatheredAmount.plus(new Amount(((FungibleAsset)stateAndRef.getState().getData()).getAmount().getQuantity(), amount.getToken()));
        }
        if (gatheredAmount.compareTo(amount) < 0) {
            throw (Throwable)new InsufficientBalanceException(amount.minus(gatheredAmount));
        }
        return new Pair((Object)gathered, (Object)gatheredAmount);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompositeKey generateExit(@NotNull TransactionBuilder tx, @NotNull Amount<Issued<T>> amountIssued, @NotNull List<? extends StateAndRef<? extends S>> assetStates, @NotNull Function3<? super TransactionState<? extends S>, ? super Amount<Issued<T>>, ? super CompositeKey, ? extends TransactionState<? extends S>> deriveState, @NotNull Function0<? extends CommandData> generateMoveCommand, @NotNull Function1<? super Amount<Issued<T>>, ? extends CommandData> generateExitCommand) {
        StateAndRef it;
        List list;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Object state2;
        void gatheredAmount;
        void gathered;
        Pair<ArrayList<StateAndRef<S>>, Amount<T>> destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        CompositeKey compositeKey;
        Collection it2;
        TransactionBuilder transactionBuilder;
        void destination$iv$iv3;
        Object item$iv$iv2;
        void $receiver$iv$iv3;
        void $receiver$iv3;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(amountIssued, (String)"amountIssued");
        Intrinsics.checkParameterIsNotNull(assetStates, (String)"assetStates");
        Intrinsics.checkParameterIsNotNull(deriveState, (String)"deriveState");
        Intrinsics.checkParameterIsNotNull(generateMoveCommand, (String)"generateMoveCommand");
        Intrinsics.checkParameterIsNotNull(generateExitCommand, (String)"generateExitCommand");
        Iterable iterable = assetStates;
        void var9_8 = $receiver$iv3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv3) {
            StateAndRef stateAndRef = (StateAndRef)item$iv$iv2;
            transactionBuilder = destination$iv$iv3;
            compositeKey = ((FungibleAsset)it2.getState().getData()).getOwner();
            transactionBuilder.add(compositeKey);
        }
        CompositeKey owner = (CompositeKey)CollectionsKt.single((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv3)));
        Object currency = ((Issued)amountIssued.getToken()).getProduct();
        Amount amount = new Amount(amountIssued.getQuantity(), currency);
        Iterable iterable2 = assetStates;
        item$iv$iv2 = $receiver$iv2;
        it2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            StateAndRef ref = (StateAndRef)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Issued)((FungibleAsset)ref.getState().getData()).getAmount().getToken()), (Object)((Issued)amountIssued.getToken()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List acceptableCoins = (List)destination$iv$iv2;
        StateAndRef stateAndRef = (StateAndRef)CollectionsKt.firstOrNull((List)acceptableCoins);
        tx.setNotary(stateAndRef != null && (stateAndRef = stateAndRef.getState()) != null ? stateAndRef.getNotary() : null);
        $receiver$iv2 = acceptableCoins;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = (Pair<ArrayList<StateAndRef<S>>, Amount<T>>)new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            StateAndRef it3 = (StateAndRef)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it3.getState().getNotary(), (Object)tx.getNotary())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        acceptableCoins = (List)destination$iv$iv2;
        destination$iv$iv2 = this.gatherCoins(acceptableCoins, new Amount(amount.getQuantity(), currency));
        $receiver$iv2 = (ArrayList)destination$iv$iv2.component1();
        $receiver$iv$iv2 = (Amount)destination$iv$iv2.component2();
        destination$iv$iv2 = null;
        StateAndRef takeChangeFrom = (StateAndRef)CollectionsKt.lastOrNull((List)((List)gathered));
        Amount change = takeChangeFrom != null && gatheredAmount.compareTo(amount) > 0 ? new Amount(gatheredAmount.getQuantity() - amount.getQuantity(), ((FungibleAsset)takeChangeFrom.getState().getData()).getAmount().getToken()) : (Amount)null;
        List outputs = change != null ? CollectionsKt.listOf((Object)deriveState.invoke((Object)((StateAndRef)CollectionsKt.last((List)((List)gathered))).getState(), (Object)change, (Object)owner)) : CollectionsKt.emptyList();
        Iterator $i$a$1$filter = gathered.iterator();
        while ($i$a$1$filter.hasNext()) {
            StateAndRef stateAndRef2 = state2 = (StateAndRef)$i$a$1$filter.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)stateAndRef2, (String)"state");
            tx.addInputState(stateAndRef2);
        }
        for (Object state2 : outputs) {
            tx.addOutputState((TransactionState)state2);
        }
        state2 = (Iterable)gathered;
        compositeKey = (CommandData)generateMoveCommand.invoke();
        transactionBuilder = tx;
        $i$a$1$filter = $receiver$iv;
        Collection $i$f$filterTo = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv3 : $receiver$iv$iv) {
            StateAndRef stateAndRef3 = (StateAndRef)item$iv$iv3;
            list = destination$iv$iv;
            CompositeKey compositeKey2 = ((FungibleAsset)it.getState().getData()).getOwner();
            list.add(compositeKey2);
        }
        list = (List)destination$iv$iv;
        transactionBuilder.addCommand((CommandData)compositeKey, list);
        $receiver$iv = (Iterable)gathered;
        compositeKey = (CommandData)generateExitCommand.invoke(amountIssued);
        transactionBuilder = tx;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (StateAndRef)element$iv$iv;
            Iterable list$iv$iv = ((FungibleAsset)it.getState().getData()).getExitKeys();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list = (List)destination$iv$iv;
        transactionBuilder.addCommand((CommandData)compositeKey, list);
        return ((Issued)amountIssued.getToken()).getIssuer().getParty().getOwningKey();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<C> verify(@NotNull TransactionForContract tx, @NotNull List<? extends S> inputs, @NotNull List<? extends S> outputs, @NotNull List<? extends AuthenticatedObject<? extends C>> commands, @Nullable Issued<? extends T> groupingKey) {
        void destination$iv$iv;
        void $receiver$iv;
        void expr$iv$iv2;
        Collection $receiver$iv2;
        Party party$iv$iv$iv;
        Iterable destination$iv$iv$iv;
        Collection $receiver$iv$iv$iv;
        String $receiver$iv3;
        boolean expr$iv;
        boolean bl;
        FungibleAsset it;
        Iterable $receiver;
        AuthenticatedObject amountExitingLedger;
        Requirements $receiver$iv$iv;
        Object $receiver$iv$iv$iv2;
        Iterable $receiver$iv$iv2;
        Amount outputAmount;
        PartyAndReference deposit;
        Amount inputAmount;
        List matchedCommands;
        block28: {
            void $receiver$iv4;
            String destination$iv$iv2;
            Object element$iv$iv4;
            Iterable parties$iv;
            Collection destination$iv$iv$iv2;
            AuthenticatedObject it$iv;
            Object element$iv$iv$iv;
            Iterable $receiver$iv5;
            Collection destination$iv$iv3;
            Object it2;
            Object element$iv$iv22;
            Collection $receiver$iv$iv3;
            void $receiver$iv6;
            void destination$iv$iv4;
            AuthenticatedObject command;
            Object element$iv$iv32;
            void $receiver$iv$iv4;
            void $receiver$iv7;
            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
            Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
            Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
            Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
            boolean bl2 = groupingKey != null;
            if (!bl2) {
                String string = "Conserve amount clause can only be used on grouped states";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Iterable $i$a$1$require = commands;
            void var8_9 = $receiver$iv7;
            Collection collection = new ArrayList();
            for (Object element$iv$iv32 : $receiver$iv$iv4) {
                command = (AuthenticatedObject)element$iv$iv32;
                if (!(command.getValue() instanceof FungibleAsset.Commands.Move || command.getValue() instanceof FungibleAsset.Commands.Exit)) continue;
                destination$iv$iv4.add(element$iv$iv32);
            }
            matchedCommands = (List)destination$iv$iv4;
            Amount amount = FungibleAssetKt.sumFungibleOrNull((Iterable)inputs);
            if (amount == null) {
                throw (Throwable)new IllegalArgumentException("there is at least one asset input for group " + groupingKey);
            }
            inputAmount = amount;
            Issued<? extends T> issued = groupingKey;
            if (issued == null) {
                Intrinsics.throwNpe();
            }
            deposit = issued.getIssuer();
            outputAmount = FungibleAssetKt.sumFungibleOrZero((Iterable)outputs, groupingKey);
            element$iv$iv32 = inputs;
            command = $receiver$iv6;
            Collection $i$a$1$filter = new ArrayList();
            for (Object element$iv$iv22 : $receiver$iv$iv3) {
                it2 = (FungibleAsset)element$iv$iv22;
                Iterable list$iv$iv = it2.getExitKeys();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            Set exitKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            $receiver$iv$iv3 = matchedCommands;
            destination$iv$iv3 = null;
            Iterable $i$f$filterTo = $receiver$iv5;
            element$iv$iv22 = $receiver$iv$iv2;
            it2 = new ArrayList();
            Iterator $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                element$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)element$iv$iv$iv;
                if (!(it$iv.getValue() instanceof FungibleAsset.Commands.Exit)) continue;
                destination$iv$iv$iv2.add(element$iv$iv$iv);
            }
            $receiver$iv$iv2 = (List)destination$iv$iv$iv2;
            $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            destination$iv$iv$iv2 = new ArrayList();
            $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                element$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)element$iv$iv$iv;
                if (!((Collection)exitKeys == null ? true : it$iv.getSigners().containsAll(exitKeys))) continue;
                destination$iv$iv$iv2.add(element$iv$iv$iv);
            }
            $receiver$iv$iv2 = (List)destination$iv$iv$iv2;
            $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            destination$iv$iv$iv2 = new ArrayList();
            $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                element$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)element$iv$iv$iv;
                if (!(parties$iv == null ? true : it$iv.getSigningParties().containsAll((Collection<?>)parties$iv))) continue;
                destination$iv$iv$iv2.add(element$iv$iv$iv);
            }
            $receiver$iv$iv2 = (List)destination$iv$iv$iv2;
            $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            destination$iv$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv2, (int)10));
            $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                Object item$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)item$iv$iv$iv;
                Collection $i$f$flatMap = destination$iv$iv$iv2;
                Object object = it$iv.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.core.contracts.FungibleAsset.Commands.Exit<T>");
                }
                AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv.getSigners(), it$iv.getSigningParties(), (Object)((FungibleAsset.Commands.Exit)object));
                $i$f$flatMap.add(authenticatedObject);
            }
            $receiver$iv5 = (List)destination$iv$iv$iv2;
            parties$iv = $receiver$iv5;
            $receiver$iv$iv2 = new ArrayList();
            for (Object element$iv$iv4 : $receiver$iv$iv) {
                AuthenticatedObject it3 = (AuthenticatedObject)element$iv$iv4;
                if (!Intrinsics.areEqual((Object)((Issued)((FungibleAsset.Commands.Exit)it3.getValue()).getAmount().getToken()), groupingKey)) continue;
                destination$iv$iv2.add(element$iv$iv4);
            }
            AuthenticatedObject exitCommand = (AuthenticatedObject)CollectionsKt.singleOrNull((List)((List)((Object)destination$iv$iv2)));
            AuthenticatedObject authenticatedObject = exitCommand;
            if (authenticatedObject == null || (authenticatedObject = (FungibleAsset.Commands.Exit)authenticatedObject.getValue()) == null || (authenticatedObject = authenticatedObject.getAmount()) == null) {
                authenticatedObject = new Amount(0L, groupingKey);
            }
            amountExitingLedger = authenticatedObject;
            $receiver$iv$iv = Requirements.INSTANCE;
            destination$iv$iv2 = "there are no zero sized inputs";
            $receiver$iv$iv$iv2 = $receiver;
            element$iv$iv4 = inputs;
            for (Object element$iv : $receiver$iv4) {
                it = (FungibleAsset)element$iv;
                if (!(it.getAmount().getQuantity() == 0L)) continue;
                bl = false;
                break block28;
            }
            bl = true;
        }
        boolean $receiver$iv4 = bl;
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
        }
        $receiver$iv3 = "for reference " + deposit.getReference() + " at issuer " + deposit.getParty().getName() + " the amounts balance: " + inputAmount.getQuantity() + " - " + amountExitingLedger.getQuantity() + " != " + outputAmount.getQuantity();
        Collection this_$iv = $receiver;
        expr$iv = Intrinsics.areEqual((Object)inputAmount, (Object)outputAmount.plus((Amount)amountExitingLedger));
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
        }
        $receiver = inputs;
        $receiver$iv3 = $receiver$iv$iv;
        this_$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv;
            Object element$iv;
            element$iv = (OwnableState)item$iv$iv$iv;
            it = destination$iv$iv$iv;
            CompositeKey $i$a$1$none = it$iv.getOwner();
            it.add($i$a$1$none);
        }
        Set owningPubKeys$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv$iv));
        $receiver$iv$iv$iv = commands;
        try {
            Collection destination$iv$iv$iv$iv$iv;
            AuthenticatedObject it$iv$iv$iv;
            Iterable $receiver$iv$iv$iv$iv$iv;
            Iterable $receiver$iv$iv$iv$iv;
            CompositeKey signer$iv$iv$iv;
            Object item$iv$iv$iv;
            destination$iv$iv$iv = $receiver$iv$iv2;
            Iterator expr$iv2 = null;
            item$iv$iv$iv = null;
            int it$iv = 3;
            Iterable $i$a$1$map = null;
            if ($i$a$1$map != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: select");
            }
            if ((it$iv & 1) != 0) {
                signer$iv$iv$iv = null;
            }
            if ((it$iv & 2) != 0) {
                party$iv$iv$iv = null;
            }
            $i$a$1$map = (Iterable)$receiver$iv$iv$iv2;
            void $i$f$mapTo = $receiver$iv$iv$iv$iv;
            Collection $i$f$map = new ArrayList();
            for (Object element$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv$iv;
                if (!(it$iv$iv$iv.getValue() instanceof FungibleAsset.Commands.Move)) continue;
                destination$iv$iv$iv$iv$iv.add(element$iv$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv$iv = $receiver$iv$iv$iv$iv;
            destination$iv$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv$iv;
                if (!(signer$iv$iv$iv == null ? true : it$iv$iv$iv.getSigners().contains(signer$iv$iv$iv))) continue;
                destination$iv$iv$iv$iv$iv.add(element$iv$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv$iv = $receiver$iv$iv$iv$iv;
            destination$iv$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv$iv;
                if (!(party$iv$iv$iv == null ? true : it$iv$iv$iv.getSigningParties().contains(party$iv$iv$iv))) continue;
                destination$iv$iv$iv$iv$iv.add(element$iv$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv$iv = $receiver$iv$iv$iv$iv;
            destination$iv$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv$iv, (int)10));
            for (Object item$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv$iv;
                Collection collection = destination$iv$iv$iv$iv$iv;
                Object object = it$iv$iv$iv.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.core.contracts.FungibleAsset.Commands.Move");
                }
                AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv$iv.getSigners(), it$iv$iv$iv.getSigningParties(), (Object)((FungibleAsset.Commands.Move)object));
                collection.add(authenticatedObject);
            }
            $receiver$iv$iv$iv2 = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv$iv));
        }
        catch (NoSuchElementException e$iv$iv) {
            throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(FungibleAsset.Commands.Move.class).getQualifiedName() + " command");
        }
        Object command$iv = $receiver$iv$iv$iv2;
        Set keysThatSigned$iv = CollectionsKt.toSet((Iterable)command$iv.getSigners());
        $receiver$iv$iv$iv2 = Requirements.INSTANCE;
        String e$iv$iv = "the owning keys are the same as the signing keys";
        party$iv$iv$iv = $receiver$iv2;
        boolean $i$f$select = keysThatSigned$iv.containsAll(owningPubKeys$iv);
        if (expr$iv$iv2 == false) {
            void $receiver$iv$iv5;
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv$iv5);
        }
        MoveCommand cfr_ignored_0 = (MoveCommand)command$iv.getValue();
        command$iv = matchedCommands;
        keysThatSigned$iv = $receiver$iv;
        $receiver$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it4;
            AuthenticatedObject expr$iv$iv2 = (AuthenticatedObject)item$iv$iv;
            void var35_37 = destination$iv$iv;
            CommandData commandData = (CommandData)it4.getValue();
            var35_37.add(commandData);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public String toString() {
        return "Conserve amount between inputs and outputs";
    }
}

