/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.CashKt;
import net.corda.core.Utils;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StructuresKt;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionType;
import net.corda.core.crypto.DigitalSignature;
import net.corda.core.flows.FlowException;
import net.corda.core.flows.FlowLogic;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.AnonymousParty;
import net.corda.core.identity.Party;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.services.VaultService;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.transactions.WireTransaction;
import net.corda.core.utilities.ProgressTracker;
import net.corda.core.utilities.UntrustworthyData;
import net.corda.flows.FinalityFlow;
import net.corda.flows.ResolveTransactionsFlow;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\b"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow;", "", "()V", "AssetMismatchException", "Buyer", "Seller", "SellerTradeInfo", "UnacceptablePriceException", "finance_main"})
public final class TwoPartyTradeFlow {
    public static final TwoPartyTradeFlow INSTANCE;

    private TwoPartyTradeFlow() {
        INSTANCE = this;
    }

    static {
        new TwoPartyTradeFlow();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$UnacceptablePriceException;", "Lnet/corda/core/flows/FlowException;", "givenPrice", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "(Lnet/corda/core/contracts/Amount;)V", "finance_main"})
    public static final class UnacceptablePriceException
    extends FlowException {
        public UnacceptablePriceException(@NotNull Amount<Currency> givenPrice) {
            Intrinsics.checkParameterIsNotNull(givenPrice, (String)"givenPrice");
            super("Unacceptable price: " + givenPrice);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$AssetMismatchException;", "Lnet/corda/core/flows/FlowException;", "expectedTypeName", "", "typeName", "(Ljava/lang/String;Ljava/lang/String;)V", "getExpectedTypeName", "()Ljava/lang/String;", "getTypeName", "toString", "finance_main"})
    public static final class AssetMismatchException
    extends FlowException {
        @NotNull
        private final String expectedTypeName;
        @NotNull
        private final String typeName;

        @NotNull
        public String toString() {
            return "The submitted asset didn't match the expected type: " + this.expectedTypeName + " vs " + this.typeName;
        }

        @NotNull
        public final String getExpectedTypeName() {
            return this.expectedTypeName;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        public AssetMismatchException(@NotNull String expectedTypeName, @NotNull String typeName) {
            Intrinsics.checkParameterIsNotNull((Object)expectedTypeName, (String)"expectedTypeName");
            Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
            this.expectedTypeName = expectedTypeName;
            this.typeName = typeName;
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$SellerTradeInfo;", "", "assetForSale", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/OwnableState;", "price", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "sellerOwnerKey", "Ljava/security/PublicKey;", "(Lnet/corda/core/contracts/StateAndRef;Lnet/corda/core/contracts/Amount;Ljava/security/PublicKey;)V", "getAssetForSale", "()Lnet/corda/core/contracts/StateAndRef;", "getPrice", "()Lnet/corda/core/contracts/Amount;", "getSellerOwnerKey", "()Ljava/security/PublicKey;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "finance_main"})
    public static final class SellerTradeInfo {
        @NotNull
        private final StateAndRef<OwnableState> assetForSale;
        @NotNull
        private final Amount<Currency> price;
        @NotNull
        private final PublicKey sellerOwnerKey;

        @NotNull
        public final StateAndRef<OwnableState> getAssetForSale() {
            return this.assetForSale;
        }

        @NotNull
        public final Amount<Currency> getPrice() {
            return this.price;
        }

        @NotNull
        public final PublicKey getSellerOwnerKey() {
            return this.sellerOwnerKey;
        }

        public SellerTradeInfo(@NotNull StateAndRef<? extends OwnableState> assetForSale, @NotNull Amount<Currency> price, @NotNull PublicKey sellerOwnerKey) {
            Intrinsics.checkParameterIsNotNull(assetForSale, (String)"assetForSale");
            Intrinsics.checkParameterIsNotNull(price, (String)"price");
            Intrinsics.checkParameterIsNotNull((Object)sellerOwnerKey, (String)"sellerOwnerKey");
            this.assetForSale = assetForSale;
            this.price = price;
            this.sellerOwnerKey = sellerOwnerKey;
        }

        @NotNull
        public final StateAndRef<OwnableState> component1() {
            return this.assetForSale;
        }

        @NotNull
        public final Amount<Currency> component2() {
            return this.price;
        }

        @NotNull
        public final PublicKey component3() {
            return this.sellerOwnerKey;
        }

        @NotNull
        public final SellerTradeInfo copy(@NotNull StateAndRef<? extends OwnableState> assetForSale, @NotNull Amount<Currency> price, @NotNull PublicKey sellerOwnerKey) {
            Intrinsics.checkParameterIsNotNull(assetForSale, (String)"assetForSale");
            Intrinsics.checkParameterIsNotNull(price, (String)"price");
            Intrinsics.checkParameterIsNotNull((Object)sellerOwnerKey, (String)"sellerOwnerKey");
            return new SellerTradeInfo(assetForSale, price, sellerOwnerKey);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SellerTradeInfo copy$default(SellerTradeInfo sellerTradeInfo, StateAndRef stateAndRef, Amount amount, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                stateAndRef = sellerTradeInfo.assetForSale;
            }
            if ((n & 2) != 0) {
                amount = sellerTradeInfo.price;
            }
            if ((n & 4) != 0) {
                publicKey = sellerTradeInfo.sellerOwnerKey;
            }
            return sellerTradeInfo.copy(stateAndRef, amount, publicKey);
        }

        public String toString() {
            return "SellerTradeInfo(assetForSale=" + this.assetForSale + ", price=" + this.price + ", sellerOwnerKey=" + this.sellerOwnerKey + ")";
        }

        public int hashCode() {
            StateAndRef<OwnableState> stateAndRef = this.assetForSale;
            Amount<Currency> amount = this.price;
            PublicKey publicKey = this.sellerOwnerKey;
            return ((stateAndRef != null ? stateAndRef.hashCode() : 0) * 31 + (amount != null ? amount.hashCode() : 0)) * 31 + (publicKey != null ? publicKey.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SellerTradeInfo)) break block3;
                    SellerTradeInfo sellerTradeInfo = (SellerTradeInfo)object;
                    if (!Intrinsics.areEqual(this.assetForSale, sellerTradeInfo.assetForSale) || !Intrinsics.areEqual(this.price, sellerTradeInfo.price) || !Intrinsics.areEqual((Object)this.sellerOwnerKey, (Object)sellerTradeInfo.sellerOwnerKey)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0002H\u0017J\b\u0010\"\u001a\u00020\u0002H\u0003R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Seller;", "Lnet/corda/core/flows/FlowLogic;", "Lnet/corda/core/transactions/SignedTransaction;", "otherParty", "Lnet/corda/core/identity/Party;", "notaryNode", "Lnet/corda/core/node/NodeInfo;", "assetToSell", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/OwnableState;", "price", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "myKey", "Ljava/security/PublicKey;", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "(Lnet/corda/core/identity/Party;Lnet/corda/core/node/NodeInfo;Lnet/corda/core/contracts/StateAndRef;Lnet/corda/core/contracts/Amount;Ljava/security/PublicKey;Lnet/corda/core/utilities/ProgressTracker;)V", "getAssetToSell", "()Lnet/corda/core/contracts/StateAndRef;", "getMyKey", "()Ljava/security/PublicKey;", "getNotaryNode", "()Lnet/corda/core/node/NodeInfo;", "getOtherParty", "()Lnet/corda/core/identity/Party;", "getPrice", "()Lnet/corda/core/contracts/Amount;", "getProgressTracker", "()Lnet/corda/core/utilities/ProgressTracker;", "calculateOurSignature", "Lnet/corda/core/crypto/DigitalSignature$WithKey;", "partialTX", "call", "receiveAndCheckProposedTransaction", "Companion", "finance_main"})
    public static class Seller
    extends FlowLogic<SignedTransaction> {
        @NotNull
        private final Party otherParty;
        @NotNull
        private final NodeInfo notaryNode;
        @NotNull
        private final StateAndRef<OwnableState> assetToSell;
        @NotNull
        private final Amount<Currency> price;
        @NotNull
        private final PublicKey myKey;
        @NotNull
        private final ProgressTracker progressTracker;
        public static final Companion Companion = new Companion(null);

        @Suspendable
        @NotNull
        public SignedTransaction call() {
            SignedTransaction partialSTX = this.receiveAndCheckProposedTransaction();
            DigitalSignature.WithKey ourSignature = this.calculateOurSignature(partialSTX);
            SignedTransaction unnotarisedSTX = partialSTX.plus(ourSignature);
            SignedTransaction finishedSTX = (SignedTransaction)CollectionsKt.single((List)((List)this.subFlow((FlowLogic)new FinalityFlow(unnotarisedSTX))));
            return finishedSTX;
        }

        /*
         * WARNING - void declaration
         */
        @Suspendable
        private final SignedTransaction receiveAndCheckProposedTransaction() {
            void $receiver$iv$iv;
            String string;
            Object object;
            void this_$iv;
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.AWAITING_PROPOSAL.INSTANCE);
            SellerTradeInfo hello = new SellerTradeInfo(this.assetToSell, this.price, this.myKey);
            Seller seller = this;
            Party otherParty$iv = this.otherParty;
            UntrustworthyData untrustedSTX = this_$iv.sendAndReceive(SignedTransaction.class, otherParty$iv, (Object)hello);
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.VERIFYING.INSTANCE);
            UntrustworthyData $receiver$iv = untrustedSTX;
            SignedTransaction it = (SignedTransaction)$receiver$iv.getData();
            WireTransaction wtx = it.verifySignatures(new PublicKey[]{this.myKey, this.notaryNode.getNotaryIdentity().getOwningKey()});
            Object $receiver$iv2 = this.getLogger();
            if ($receiver$iv2.isTraceEnabled()) {
                object = $receiver$iv2;
                string = "Received partially signed transaction: " + it.getId();
                object.trace(string);
            }
            this.subFlow((FlowLogic)new ResolveTransactionsFlow(wtx, this.otherParty));
            Object $i$a$1$trace = $receiver$iv2 = (Iterable)wtx.getOutputs();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                TransactionState transactionState = (TransactionState)item$iv$iv;
                object = destination$iv$iv;
                string = it2.getData();
                object.add(string);
            }
            if (Intrinsics.areEqual((Object)StructuresKt.withoutIssuer(CashKt.sumCashBy((List)destination$iv$iv, (AbstractParty)new AnonymousParty(this.myKey))), this.price) ^ true) {
                throw (Throwable)new FlowException("Transaction is not sending us the right amount of cash");
            }
            return it;
        }

        @NotNull
        public DigitalSignature.WithKey calculateOurSignature(@NotNull SignedTransaction partialTX) {
            Intrinsics.checkParameterIsNotNull((Object)partialTX, (String)"partialTX");
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.SIGNING.INSTANCE);
            return this.getServiceHub().createSignature(partialTX, this.myKey);
        }

        @NotNull
        public final Party getOtherParty() {
            return this.otherParty;
        }

        @NotNull
        public final NodeInfo getNotaryNode() {
            return this.notaryNode;
        }

        @NotNull
        public final StateAndRef<OwnableState> getAssetToSell() {
            return this.assetToSell;
        }

        @NotNull
        public final Amount<Currency> getPrice() {
            return this.price;
        }

        @NotNull
        public final PublicKey getMyKey() {
            return this.myKey;
        }

        @NotNull
        public ProgressTracker getProgressTracker() {
            return this.progressTracker;
        }

        public Seller(@NotNull Party otherParty, @NotNull NodeInfo notaryNode, @NotNull StateAndRef<? extends OwnableState> assetToSell, @NotNull Amount<Currency> price, @NotNull PublicKey myKey, @NotNull ProgressTracker progressTracker) {
            Intrinsics.checkParameterIsNotNull((Object)otherParty, (String)"otherParty");
            Intrinsics.checkParameterIsNotNull((Object)notaryNode, (String)"notaryNode");
            Intrinsics.checkParameterIsNotNull(assetToSell, (String)"assetToSell");
            Intrinsics.checkParameterIsNotNull(price, (String)"price");
            Intrinsics.checkParameterIsNotNull((Object)myKey, (String)"myKey");
            Intrinsics.checkParameterIsNotNull((Object)progressTracker, (String)"progressTracker");
            this.otherParty = otherParty;
            this.notaryNode = notaryNode;
            this.assetToSell = assetToSell;
            this.price = price;
            this.myKey = myKey;
            this.progressTracker = progressTracker;
        }

        public /* synthetic */ Seller(Party party, NodeInfo nodeInfo, StateAndRef stateAndRef, Amount amount, PublicKey publicKey, ProgressTracker progressTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                progressTracker = Companion.tracker();
            }
            this(party, nodeInfo, (StateAndRef<? extends OwnableState>)stateAndRef, (Amount<Currency>)amount, publicKey, progressTracker);
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0005\u0005\u0006\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Seller$Companion;", "", "()V", "tracker", "Lnet/corda/core/utilities/ProgressTracker;", "AWAITING_PROPOSAL", "COMMITTING", "SENDING_FINAL_TX", "SIGNING", "VERIFYING", "finance_main"})
        public static final class Companion {
            @NotNull
            public final ProgressTracker tracker() {
                return new ProgressTracker(new ProgressTracker.Step[]{AWAITING_PROPOSAL.INSTANCE, VERIFYING.INSTANCE, SIGNING.INSTANCE, COMMITTING.INSTANCE, SENDING_FINAL_TX.INSTANCE});
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Seller$Companion$AWAITING_PROPOSAL;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class AWAITING_PROPOSAL
            extends ProgressTracker.Step {
                public static final AWAITING_PROPOSAL INSTANCE;

                private AWAITING_PROPOSAL() {
                    super("Awaiting transaction proposal");
                    INSTANCE = this;
                }

                static {
                    new AWAITING_PROPOSAL();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Seller$Companion$VERIFYING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class VERIFYING
            extends ProgressTracker.Step {
                public static final VERIFYING INSTANCE;

                private VERIFYING() {
                    super("Verifying transaction proposal");
                    INSTANCE = this;
                }

                static {
                    new VERIFYING();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Seller$Companion$SIGNING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class SIGNING
            extends ProgressTracker.Step {
                public static final SIGNING INSTANCE;

                private SIGNING() {
                    super("Signing transaction");
                    INSTANCE = this;
                }

                static {
                    new SIGNING();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Seller$Companion$COMMITTING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "childProgressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "finance_main"})
            public static final class COMMITTING
            extends ProgressTracker.Step {
                public static final COMMITTING INSTANCE;

                @NotNull
                public ProgressTracker childProgressTracker() {
                    return FinalityFlow.Companion.tracker();
                }

                private COMMITTING() {
                    super("Committing transaction to the ledger");
                    INSTANCE = this;
                }

                static {
                    new COMMITTING();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Seller$Companion$SENDING_FINAL_TX;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class SENDING_FINAL_TX
            extends ProgressTracker.Step {
                public static final SENDING_FINAL_TX INSTANCE;

                private SENDING_FINAL_TX() {
                    super("Sending final transaction to buyer");
                    INSTANCE = this;
                }

                static {
                    new SENDING_FINAL_TX();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005$%&'(B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\b\u0010\u001f\u001a\u00020\u0002H\u0017J\b\u0010 \u001a\u00020\u001eH\u0003J\u001e\u0010!\u001a\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010#\u001a\u00020\u001aH\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Buyer;", "Lnet/corda/core/flows/FlowLogic;", "Lnet/corda/core/transactions/SignedTransaction;", "otherParty", "Lnet/corda/core/identity/Party;", "notary", "acceptablePrice", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "typeToBuy", "Ljava/lang/Class;", "Lnet/corda/core/contracts/OwnableState;", "(Lnet/corda/core/identity/Party;Lnet/corda/core/identity/Party;Lnet/corda/core/contracts/Amount;Ljava/lang/Class;)V", "getAcceptablePrice", "()Lnet/corda/core/contracts/Amount;", "getNotary", "()Lnet/corda/core/identity/Party;", "getOtherParty", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "getProgressTracker", "()Lnet/corda/core/utilities/ProgressTracker;", "getTypeToBuy", "()Ljava/lang/Class;", "assembleSharedTX", "Lkotlin/Pair;", "Lnet/corda/core/transactions/TransactionBuilder;", "", "Ljava/security/PublicKey;", "tradeRequest", "Lnet/corda/flows/TwoPartyTradeFlow$SellerTradeInfo;", "call", "receiveAndValidateTradeRequest", "signWithOurKeys", "cashSigningPubKeys", "ptx", "RECEIVING", "SENDING_SIGNATURES", "SIGNING", "VERIFYING", "WAITING_FOR_TX", "finance_main"})
    public static class Buyer
    extends FlowLogic<SignedTransaction> {
        @NotNull
        private final ProgressTracker progressTracker;
        @NotNull
        private final Party otherParty;
        @NotNull
        private final Party notary;
        @NotNull
        private final Amount<Currency> acceptablePrice;
        @NotNull
        private final Class<? extends OwnableState> typeToBuy;

        @NotNull
        public ProgressTracker getProgressTracker() {
            return this.progressTracker;
        }

        /*
         * WARNING - void declaration
         */
        @Suspendable
        @NotNull
        public SignedTransaction call() {
            void ptx;
            void cashSigningPubKeys;
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)RECEIVING.INSTANCE);
            SellerTradeInfo tradeRequest = this.receiveAndValidateTradeRequest();
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)SIGNING.INSTANCE);
            Pair<TransactionBuilder, List<PublicKey>> pair = this.assembleSharedTX(tradeRequest);
            TransactionBuilder transactionBuilder = (TransactionBuilder)pair.component1();
            List list = (List)pair.component2();
            pair = null;
            SignedTransaction stx = this.signWithOurKeys((List<? extends PublicKey>)cashSigningPubKeys, (TransactionBuilder)ptx);
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)SENDING_SIGNATURES.INSTANCE);
            this.send(this.otherParty, stx);
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)WAITING_FOR_TX.INSTANCE);
            return this.waitForLedgerCommit(stx.getId());
        }

        /*
         * WARNING - void declaration
         */
        @Suspendable
        private final SellerTradeInfo receiveAndValidateTradeRequest() {
            void this_$iv;
            Buyer buyer = this;
            Party otherParty$iv = this.otherParty;
            UntrustworthyData maybeTradeRequest = this_$iv.receive(SellerTradeInfo.class, otherParty$iv);
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)VERIFYING.INSTANCE);
            UntrustworthyData $receiver$iv = maybeTradeRequest;
            SellerTradeInfo it = (SellerTradeInfo)$receiver$iv.getData();
            OwnableState asset = (OwnableState)it.getAssetForSale().getState().getData();
            String assetTypeName = asset.getClass().getName();
            Logger $receiver$iv2 = this.getLogger();
            if ($receiver$iv2.isTraceEnabled()) {
                Logger logger = $receiver$iv2;
                String string = "Got trade request for a " + assetTypeName + ": " + it.getAssetForSale();
                logger.trace(string);
            }
            if (it.getPrice().compareTo(this.acceptablePrice) > 0) {
                throw (Throwable)((Object)new UnacceptablePriceException(it.getPrice()));
            }
            if (!this.typeToBuy.isInstance(asset)) {
                String string = this.typeToBuy.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typeToBuy.name");
                String string2 = assetTypeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"assetTypeName");
                throw (Throwable)((Object)new AssetMismatchException(string, string2));
            }
            this.subFlow((FlowLogic)new ResolveTransactionsFlow(SetsKt.setOf((Object)it.getAssetForSale().getRef().getTxhash()), this.otherParty));
            return it;
        }

        private final SignedTransaction signWithOurKeys(List<? extends PublicKey> cashSigningPubKeys, TransactionBuilder ptx) {
            return this.getServiceHub().signInitialTransaction(ptx, cashSigningPubKeys);
        }

        /*
         * WARNING - void declaration
         */
        @Suspendable
        private final Pair<TransactionBuilder, List<PublicKey>> assembleSharedTX(SellerTradeInfo tradeRequest) {
            void cashSigningPubKeys;
            Instant currentTime;
            void command;
            void state;
            void tx;
            TransactionType.General.Builder ptx = new TransactionType.General.Builder(this.notary);
            Pair pair = VaultService.DefaultImpls.generateSpend$default((VaultService)this.getServiceHub().getVaultService(), (TransactionBuilder)((TransactionBuilder)ptx), tradeRequest.getPrice(), (AbstractParty)((AbstractParty)new AnonymousParty(tradeRequest.getSellerOwnerKey())), null, (int)8, null);
            TransactionBuilder transactionBuilder = (TransactionBuilder)pair.component1();
            List list = (List)pair.component2();
            pair = null;
            tx.addInputState(tradeRequest.getAssetForSale());
            PublicKey freshKey = this.getServiceHub().getKeyManagementService().freshKey();
            Pair pair2 = ((OwnableState)tradeRequest.getAssetForSale().getState().getData()).withNewOwner((AbstractParty)new AnonymousParty(freshKey));
            CommandData commandData = (CommandData)pair2.component1();
            OwnableState ownableState = (OwnableState)pair2.component2();
            pair2 = null;
            TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)state), (Party)tradeRequest.getAssetForSale().getState().getNotary(), null, (int)4, null);
            tx.addCommand((CommandData)command, new PublicKey[]{((OwnableState)tradeRequest.getAssetForSale().getState().getData()).getOwner().getOwningKey()});
            Instant instant = currentTime = this.getServiceHub().getClock().instant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"currentTime");
            tx.addTimeWindow(instant, Utils.getSeconds((int)30));
            return new Pair((Object)tx, (Object)cashSigningPubKeys);
        }

        @NotNull
        public final Party getOtherParty() {
            return this.otherParty;
        }

        @NotNull
        public final Party getNotary() {
            return this.notary;
        }

        @NotNull
        public final Amount<Currency> getAcceptablePrice() {
            return this.acceptablePrice;
        }

        @NotNull
        public final Class<? extends OwnableState> getTypeToBuy() {
            return this.typeToBuy;
        }

        public Buyer(@NotNull Party otherParty, @NotNull Party notary, @NotNull Amount<Currency> acceptablePrice, @NotNull Class<? extends OwnableState> typeToBuy) {
            Intrinsics.checkParameterIsNotNull((Object)otherParty, (String)"otherParty");
            Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
            Intrinsics.checkParameterIsNotNull(acceptablePrice, (String)"acceptablePrice");
            Intrinsics.checkParameterIsNotNull(typeToBuy, (String)"typeToBuy");
            this.otherParty = otherParty;
            this.notary = notary;
            this.acceptablePrice = acceptablePrice;
            this.typeToBuy = typeToBuy;
            this.progressTracker = new ProgressTracker(new ProgressTracker.Step[]{RECEIVING.INSTANCE, VERIFYING.INSTANCE, SIGNING.INSTANCE, SENDING_SIGNATURES.INSTANCE, WAITING_FOR_TX.INSTANCE});
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Buyer$RECEIVING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class RECEIVING
        extends ProgressTracker.Step {
            public static final RECEIVING INSTANCE;

            private RECEIVING() {
                super("Waiting for seller trading info");
                INSTANCE = this;
            }

            static {
                new RECEIVING();
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Buyer$VERIFYING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class VERIFYING
        extends ProgressTracker.Step {
            public static final VERIFYING INSTANCE;

            private VERIFYING() {
                super("Verifying seller assets");
                INSTANCE = this;
            }

            static {
                new VERIFYING();
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Buyer$SIGNING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class SIGNING
        extends ProgressTracker.Step {
            public static final SIGNING INSTANCE;

            private SIGNING() {
                super("Generating and signing transaction proposal");
                INSTANCE = this;
            }

            static {
                new SIGNING();
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Buyer$SENDING_SIGNATURES;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class SENDING_SIGNATURES
        extends ProgressTracker.Step {
            public static final SENDING_SIGNATURES INSTANCE;

            private SENDING_SIGNATURES() {
                super("Sending signatures to the seller");
                INSTANCE = this;
            }

            static {
                new SENDING_SIGNATURES();
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/TwoPartyTradeFlow$Buyer$WAITING_FOR_TX;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
        public static final class WAITING_FOR_TX
        extends ProgressTracker.Step {
            public static final WAITING_FOR_TX INSTANCE;

            private WAITING_FOR_TX() {
                super("Waiting for the transaction to finalise.");
                INSTANCE = this;
            }

            static {
                new WAITING_FOR_TX();
            }
        }
    }
}

