/*
 * Decompiled with CFR 0.152.
 */
package net.corda.flows;

import co.paralleluniverse.fibers.Suspendable;
import java.util.Currency;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.flows.FlowException;
import net.corda.core.flows.FlowLogic;
import net.corda.core.flows.InitiatedBy;
import net.corda.core.flows.InitiatingFlow;
import net.corda.core.flows.StartableByRPC;
import net.corda.core.identity.Party;
import net.corda.core.node.NodeInfo;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.OpaqueBytes;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.utilities.ProgressTracker;
import net.corda.core.utilities.UntrustworthyData;
import net.corda.flows.CashException;
import net.corda.flows.CashIssueFlow;
import net.corda.flows.CashPaymentFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lnet/corda/flows/IssuerFlow;", "", "()V", "IssuanceRequestState", "IssuanceRequester", "Issuer", "finance_main"})
public final class IssuerFlow {
    public static final IssuerFlow INSTANCE;

    private IssuerFlow() {
        INSTANCE = this;
    }

    static {
        new IssuerFlow();
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lnet/corda/flows/IssuerFlow$IssuanceRequestState;", "", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "issueToParty", "Lnet/corda/core/identity/Party;", "issuerPartyRef", "Lnet/corda/core/serialization/OpaqueBytes;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/Party;Lnet/corda/core/serialization/OpaqueBytes;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getIssueToParty", "()Lnet/corda/core/identity/Party;", "getIssuerPartyRef", "()Lnet/corda/core/serialization/OpaqueBytes;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "finance_main"})
    public static final class IssuanceRequestState {
        @NotNull
        private final Amount<Currency> amount;
        @NotNull
        private final Party issueToParty;
        @NotNull
        private final OpaqueBytes issuerPartyRef;

        @NotNull
        public final Amount<Currency> getAmount() {
            return this.amount;
        }

        @NotNull
        public final Party getIssueToParty() {
            return this.issueToParty;
        }

        @NotNull
        public final OpaqueBytes getIssuerPartyRef() {
            return this.issuerPartyRef;
        }

        public IssuanceRequestState(@NotNull Amount<Currency> amount, @NotNull Party issueToParty, @NotNull OpaqueBytes issuerPartyRef) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)issueToParty, (String)"issueToParty");
            Intrinsics.checkParameterIsNotNull((Object)issuerPartyRef, (String)"issuerPartyRef");
            this.amount = amount;
            this.issueToParty = issueToParty;
            this.issuerPartyRef = issuerPartyRef;
        }

        @NotNull
        public final Amount<Currency> component1() {
            return this.amount;
        }

        @NotNull
        public final Party component2() {
            return this.issueToParty;
        }

        @NotNull
        public final OpaqueBytes component3() {
            return this.issuerPartyRef;
        }

        @NotNull
        public final IssuanceRequestState copy(@NotNull Amount<Currency> amount, @NotNull Party issueToParty, @NotNull OpaqueBytes issuerPartyRef) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)issueToParty, (String)"issueToParty");
            Intrinsics.checkParameterIsNotNull((Object)issuerPartyRef, (String)"issuerPartyRef");
            return new IssuanceRequestState(amount, issueToParty, issuerPartyRef);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ IssuanceRequestState copy$default(IssuanceRequestState issuanceRequestState, Amount amount, Party party, OpaqueBytes opaqueBytes, int n, Object object) {
            if ((n & 1) != 0) {
                amount = issuanceRequestState.amount;
            }
            if ((n & 2) != 0) {
                party = issuanceRequestState.issueToParty;
            }
            if ((n & 4) != 0) {
                opaqueBytes = issuanceRequestState.issuerPartyRef;
            }
            return issuanceRequestState.copy(amount, party, opaqueBytes);
        }

        public String toString() {
            return "IssuanceRequestState(amount=" + this.amount + ", issueToParty=" + this.issueToParty + ", issuerPartyRef=" + this.issuerPartyRef + ")";
        }

        public int hashCode() {
            Amount<Currency> amount = this.amount;
            Party party = this.issueToParty;
            OpaqueBytes opaqueBytes = this.issuerPartyRef;
            return ((amount != null ? amount.hashCode() : 0) * 31 + (party != null ? party.hashCode() : 0)) * 31 + (opaqueBytes != null ? opaqueBytes.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IssuanceRequestState)) break block3;
                    IssuanceRequestState issuanceRequestState = (IssuanceRequestState)object;
                    if (!Intrinsics.areEqual(this.amount, issuanceRequestState.amount) || !Intrinsics.areEqual((Object)this.issueToParty, (Object)issuanceRequestState.issueToParty) || !Intrinsics.areEqual((Object)this.issuerPartyRef, (Object)issuanceRequestState.issuerPartyRef)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @InitiatingFlow
    @StartableByRPC
    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0002H\u0017R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lnet/corda/flows/IssuerFlow$IssuanceRequester;", "Lnet/corda/core/flows/FlowLogic;", "Lnet/corda/core/transactions/SignedTransaction;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "issueToParty", "Lnet/corda/core/identity/Party;", "issueToPartyRef", "Lnet/corda/core/serialization/OpaqueBytes;", "issuerBankParty", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/Party;Lnet/corda/core/serialization/OpaqueBytes;Lnet/corda/core/identity/Party;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getIssueToParty", "()Lnet/corda/core/identity/Party;", "getIssueToPartyRef", "()Lnet/corda/core/serialization/OpaqueBytes;", "getIssuerBankParty", "call", "finance_main"})
    public static final class IssuanceRequester
    extends FlowLogic<SignedTransaction> {
        @NotNull
        private final Amount<Currency> amount;
        @NotNull
        private final Party issueToParty;
        @NotNull
        private final OpaqueBytes issueToPartyRef;
        @NotNull
        private final Party issuerBankParty;

        /*
         * WARNING - void declaration
         */
        @Suspendable
        @NotNull
        public SignedTransaction call() throws CashException {
            void var3_3;
            void this_$iv;
            IssuanceRequestState issueRequest = new IssuanceRequestState(this.amount, this.issueToParty, this.issueToPartyRef);
            IssuanceRequester issuanceRequester = this;
            Party otherParty$iv = this.issuerBankParty;
            UntrustworthyData $receiver$iv = this_$iv.sendAndReceive(SignedTransaction.class, otherParty$iv, (Object)issueRequest);
            SignedTransaction it = (SignedTransaction)$receiver$iv.getData();
            return var3_3;
        }

        @NotNull
        public final Amount<Currency> getAmount() {
            return this.amount;
        }

        @NotNull
        public final Party getIssueToParty() {
            return this.issueToParty;
        }

        @NotNull
        public final OpaqueBytes getIssueToPartyRef() {
            return this.issueToPartyRef;
        }

        @NotNull
        public final Party getIssuerBankParty() {
            return this.issuerBankParty;
        }

        public IssuanceRequester(@NotNull Amount<Currency> amount, @NotNull Party issueToParty, @NotNull OpaqueBytes issueToPartyRef, @NotNull Party issuerBankParty) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)issueToParty, (String)"issueToParty");
            Intrinsics.checkParameterIsNotNull((Object)issueToPartyRef, (String)"issueToPartyRef");
            Intrinsics.checkParameterIsNotNull((Object)issuerBankParty, (String)"issuerBankParty");
            this.amount = amount;
            this.issueToParty = issueToParty;
            this.issueToPartyRef = issueToPartyRef;
            this.issuerBankParty = issuerBankParty;
        }
    }

    @InitiatedBy(value=IssuanceRequester.class)
    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0002H\u0017J&\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/corda/flows/IssuerFlow$Issuer;", "Lnet/corda/core/flows/FlowLogic;", "Lnet/corda/core/transactions/SignedTransaction;", "otherParty", "Lnet/corda/core/identity/Party;", "(Lnet/corda/core/identity/Party;)V", "getOtherParty", "()Lnet/corda/core/identity/Party;", "progressTracker", "Lnet/corda/core/utilities/ProgressTracker;", "getProgressTracker", "()Lnet/corda/core/utilities/ProgressTracker;", "call", "issueCashTo", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "issueTo", "issuerPartyRef", "Lnet/corda/core/serialization/OpaqueBytes;", "Companion", "finance_main"})
    public static final class Issuer
    extends FlowLogic<SignedTransaction> {
        @NotNull
        private final ProgressTracker progressTracker;
        @NotNull
        private final Party otherParty;
        private static final List<Currency> VALID_CURRENCIES;
        public static final Companion Companion;

        @NotNull
        public ProgressTracker getProgressTracker() {
            return this.progressTracker;
        }

        /*
         * WARNING - void declaration
         */
        @Suspendable
        @NotNull
        public SignedTransaction call() throws CashException {
            void var3_2;
            void this_$iv;
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.AWAITING_REQUEST.INSTANCE);
            Issuer issuer = this;
            Party otherParty$iv = this.otherParty;
            UntrustworthyData $receiver$iv = this_$iv.receive(IssuanceRequestState.class, otherParty$iv);
            IssuanceRequestState it = (IssuanceRequestState)$receiver$iv.getData();
            if (Issuer.Companion.getVALID_CURRENCIES().contains(it.getAmount().getToken()) ^ true) {
                throw (Throwable)new FlowException("Currency must be one of " + Issuer.Companion.getVALID_CURRENCIES());
            }
            void issueRequest = var3_2;
            SignedTransaction txn = this.issueCashTo(issueRequest.getAmount(), issueRequest.getIssueToParty(), issueRequest.getIssuerPartyRef());
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.SENDING_CONFIRM.INSTANCE);
            this.send(this.otherParty, txn);
            return txn;
        }

        @Suspendable
        private final SignedTransaction issueCashTo(Amount<Currency> amount, Party issueTo, OpaqueBytes issuerPartyRef) {
            Party notaryParty = ((NodeInfo)this.getServiceHub().getNetworkMapCache().getNotaryNodes().get(0)).getNotaryIdentity();
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.ISSUING.INSTANCE);
            Party bankOfCordaParty = this.getServiceHub().getMyInfo().getLegalIdentity();
            CashIssueFlow issueCashFlow = new CashIssueFlow(amount, issuerPartyRef, bankOfCordaParty, notaryParty);
            SignedTransaction issueTx = (SignedTransaction)this.subFlow(issueCashFlow);
            if (Intrinsics.areEqual((Object)issueTo, (Object)this.getServiceHub().getMyInfo().getLegalIdentity())) {
                return issueTx;
            }
            this.getProgressTracker().setCurrentStep((ProgressTracker.Step)Companion.TRANSFERRING.INSTANCE);
            CashPaymentFlow moveCashFlow = new CashPaymentFlow(amount, issueTo);
            SignedTransaction moveTx = (SignedTransaction)this.subFlow(moveCashFlow);
            return moveTx;
        }

        @NotNull
        public final Party getOtherParty() {
            return this.otherParty;
        }

        public Issuer(@NotNull Party otherParty) {
            Intrinsics.checkParameterIsNotNull((Object)otherParty, (String)"otherParty");
            this.otherParty = otherParty;
            this.progressTracker = Companion.tracker();
        }

        static {
            Companion = new Companion(null);
            VALID_CURRENCIES = CollectionsKt.listOf((Object[])new Currency[]{ContractsDSL.USD, ContractsDSL.GBP, ContractsDSL.EUR, ContractsDSL.CHF});
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lnet/corda/flows/IssuerFlow$Issuer$Companion;", "", "()V", "VALID_CURRENCIES", "", "Ljava/util/Currency;", "getVALID_CURRENCIES", "()Ljava/util/List;", "tracker", "Lnet/corda/core/utilities/ProgressTracker;", "AWAITING_REQUEST", "ISSUING", "SENDING_CONFIRM", "TRANSFERRING", "finance_main"})
        public static final class Companion {
            @NotNull
            public final ProgressTracker tracker() {
                return new ProgressTracker(new ProgressTracker.Step[]{AWAITING_REQUEST.INSTANCE, ISSUING.INSTANCE, TRANSFERRING.INSTANCE, SENDING_CONFIRM.INSTANCE});
            }

            private final List<Currency> getVALID_CURRENCIES() {
                return VALID_CURRENCIES;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/IssuerFlow$Issuer$Companion$AWAITING_REQUEST;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class AWAITING_REQUEST
            extends ProgressTracker.Step {
                public static final AWAITING_REQUEST INSTANCE;

                private AWAITING_REQUEST() {
                    super("Awaiting issuance request");
                    INSTANCE = this;
                }

                static {
                    new AWAITING_REQUEST();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/IssuerFlow$Issuer$Companion$ISSUING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class ISSUING
            extends ProgressTracker.Step {
                public static final ISSUING INSTANCE;

                private ISSUING() {
                    super("Self issuing asset");
                    INSTANCE = this;
                }

                static {
                    new ISSUING();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/IssuerFlow$Issuer$Companion$TRANSFERRING;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class TRANSFERRING
            extends ProgressTracker.Step {
                public static final TRANSFERRING INSTANCE;

                private TRANSFERRING() {
                    super("Transferring asset to issuance requester");
                    INSTANCE = this;
                }

                static {
                    new TRANSFERRING();
                }
            }

            @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/flows/IssuerFlow$Issuer$Companion$SENDING_CONFIRM;", "Lnet/corda/core/utilities/ProgressTracker$Step;", "()V", "finance_main"})
            public static final class SENDING_CONFIRM
            extends ProgressTracker.Step {
                public static final SENDING_CONFIRM INSTANCE;

                private SENDING_CONFIRM() {
                    super("Confirming asset issuance to requester");
                    INSTANCE = this;
                }

                static {
                    new SENDING_CONFIRM();
                }
            }
        }
    }
}

