/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts.asset;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.contracts.asset.CommodityContractKt;
import net.corda.contracts.asset.OnLedgerAsset;
import net.corda.contracts.clause.AbstractConserveAmount;
import net.corda.contracts.clause.AbstractIssue;
import net.corda.contracts.clause.NoZeroSizedOutputs;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.Commodity;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.clauses.AnyOf;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.contracts.clauses.ClauseVerifier;
import net.corda.core.contracts.clauses.GroupClauseVerifier;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.Party;
import net.corda.core.crypto.SecureHash;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.transactions.TransactionBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003)*+B\u0005\u00a2\u0006\u0002\u0010\u0005J8\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00140\u0016H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000eH\u0016J2\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ4\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020(H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006,"}, d2={"Lnet/corda/contracts/asset/CommodityContract;", "Lnet/corda/contracts/asset/OnLedgerAsset;", "Lnet/corda/core/contracts/Commodity;", "Lnet/corda/contracts/asset/CommodityContract$Commands;", "Lnet/corda/contracts/asset/CommodityContract$State;", "()V", "legalContractReference", "Lnet/corda/core/crypto/SecureHash;", "getLegalContractReference", "()Lnet/corda/core/crypto/SecureHash;", "deriveState", "Lnet/corda/core/contracts/TransactionState;", "txState", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "owner", "Ljava/security/PublicKey;", "extractCommands", "", "Lnet/corda/core/contracts/AuthenticatedObject;", "commands", "", "Lnet/corda/core/contracts/CommandData;", "generateExitCommand", "Lnet/corda/contracts/asset/CommodityContract$Commands$Exit;", "generateIssue", "", "tx", "Lnet/corda/core/transactions/TransactionBuilder;", "notary", "Lnet/corda/core/crypto/Party;", "tokenDef", "pennies", "", "generateIssueCommand", "Lnet/corda/contracts/asset/CommodityContract$Commands$Issue;", "generateMoveCommand", "Lnet/corda/contracts/asset/CommodityContract$Commands$Move;", "verify", "Lnet/corda/core/contracts/TransactionForContract;", "Clauses", "Commands", "State", "finance_main"})
public final class CommodityContract
extends OnLedgerAsset<Commodity, Commands, State> {
    @NotNull
    private final SecureHash legalContractReference = (SecureHash)SecureHash.Companion.sha256("https://www.big-book-of-banking-law.gov/commodity-claims.html");

    @NotNull
    public SecureHash getLegalContractReference() {
        return this.legalContractReference;
    }

    public void verify(@NotNull TransactionForContract tx) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        ClauseVerifier.verifyClause((TransactionForContract)tx, (Clause)((Clause)new Clauses.Group()), (List)this.extractCommands((Collection)tx.getCommands()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AuthenticatedObject<Commands>> extractCommands(@NotNull Collection<? extends AuthenticatedObject<? extends CommandData>> commands) {
        AuthenticatedObject it$iv;
        Iterable $receiver$iv$iv$iv;
        void $receiver$iv;
        Iterable $receiver$iv$iv;
        Party party$iv;
        PublicKey signer$iv;
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        Collection<? extends AuthenticatedObject<? extends CommandData>> collection = commands;
        Object var3_3 = null;
        Object var4_4 = null;
        int n = 3;
        Object var6_6 = null;
        if ((n & 1) != 0) {
            signer$iv = null;
        }
        if ((n & 2) != 0) {
            party$iv = null;
        }
        Iterable iterable = $receiver$iv$iv = (Iterable)$receiver$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(it$iv.getValue() instanceof Commands)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(signer$iv == null ? true : it$iv.getSigners().contains(signer$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(party$iv == null ? true : it$iv.getSigningParties().contains(party$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)item$iv$iv$iv;
            Collection collection2 = destination$iv$iv$iv;
            Object object = it$iv.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.asset.CommodityContract.Commands");
            }
            AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv.getSigners(), it$iv.getSigningParties(), (Object)((Commands)object));
            collection2.add(authenticatedObject);
        }
        return (List)destination$iv$iv$iv;
    }

    public final void generateIssue(@NotNull TransactionBuilder tx, @NotNull Issued<Commodity> tokenDef, long pennies, @NotNull PublicKey owner, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(tokenDef, (String)"tokenDef");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        this.generateIssue(tx, (Amount<Issued<Commodity>>)new Amount(pennies, tokenDef), owner, notary);
    }

    public final void generateIssue(@NotNull TransactionBuilder tx, @NotNull Amount<Issued<Commodity>> amount, @NotNull PublicKey owner, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        OnLedgerAsset.Companion.generateIssue(tx, new TransactionState((ContractState)new State(amount, owner), notary, null, 4, null), (CommandData)this.generateIssueCommand());
    }

    @Override
    @NotNull
    public TransactionState<State> deriveState(@NotNull TransactionState<State> txState, @NotNull Amount<Issued<Commodity>> amount, @NotNull PublicKey owner) {
        Intrinsics.checkParameterIsNotNull(txState, (String)"txState");
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return TransactionState.copy$default(txState, (ContractState)((ContractState)((State)txState.getData()).copy(amount, owner)), null, null, (int)6, null);
    }

    @NotNull
    public Commands.Exit generateExitCommand(@NotNull Amount<Issued<Commodity>> amount) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        return new Commands.Exit(amount);
    }

    @Override
    @NotNull
    public Commands.Issue generateIssueCommand() {
        return new Commands.Issue(0L, 1, null);
    }

    @Override
    @NotNull
    public Commands.Move generateMoveCommand() {
        return new Commands.Move(null, 1, null);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Clauses;", "", "ConserveAmount", "Group", "Issue", "finance_main"})
    public static interface Clauses {

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Clauses$Group;", "Lnet/corda/core/contracts/clauses/GroupClauseVerifier;", "Lnet/corda/contracts/asset/CommodityContract$State;", "Lnet/corda/contracts/asset/CommodityContract$Commands;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/core/contracts/Commodity;", "()V", "groupStates", "", "Lnet/corda/core/contracts/TransactionForContract$InOutGroup;", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "finance_main"})
        public static final class Group
        extends GroupClauseVerifier<State, Commands, Issued<? extends Commodity>> {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TransactionForContract.InOutGroup<State, Issued<Commodity>>> groupStates(@NotNull TransactionForContract tx) {
                void $receiver$iv$iv$iv;
                State it;
                void $receiver$iv$iv$iv2;
                Object element$iv$iv$iv3;
                void $receiver$iv$iv$iv3;
                void $receiver$iv$iv$iv4;
                Iterable $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                TransactionForContract this_$iv = tx;
                Iterable iterable = $receiver$iv$iv = (Iterable)this_$iv.getInputs();
                Iterable destination$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv2 : $receiver$iv$iv$iv4) {
                    if (!(element$iv$iv$iv2 instanceof State)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv2);
                }
                List inputs$iv = (List)destination$iv$iv$iv;
                Iterable $receiver$iv$iv2 = this_$iv.getOutputs();
                destination$iv$iv$iv = $receiver$iv$iv2;
                Iterable destination$iv$iv$iv2 = new ArrayList();
                for (Object element$iv$iv$iv3 : $receiver$iv$iv$iv3) {
                    if (!(element$iv$iv$iv3 instanceof State)) continue;
                    destination$iv$iv$iv2.add(element$iv$iv$iv3);
                }
                List outputs$iv = (List)destination$iv$iv$iv2;
                Iterable $receiver$iv$iv3 = inputs$iv;
                destination$iv$iv$iv2 = $receiver$iv$iv3;
                Object destination$iv$iv$iv3 = new LinkedHashMap();
                element$iv$iv$iv3 = $receiver$iv$iv$iv2.iterator();
                while (element$iv$iv$iv3.hasNext()) {
                    Object object;
                    Object $receiver$iv$iv$iv$iv = destination$iv$iv$iv3;
                    Object element$iv$iv$iv4 = element$iv$iv$iv3.next();
                    it = (State)element$iv$iv$iv4;
                    Issued key$iv$iv$iv = (Issued)it.getAmount().getToken();
                    Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv4);
                }
                Map inGroups$iv = destination$iv$iv$iv3;
                Iterable $receiver$iv$iv4 = outputs$iv;
                destination$iv$iv$iv3 = $receiver$iv$iv4;
                Map destination$iv$iv$iv4 = new LinkedHashMap();
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Map $receiver$iv$iv$iv$iv = destination$iv$iv$iv4;
                    Object element$iv$iv$iv5 = iterator.next();
                    it = (State)element$iv$iv$iv5;
                    Issued key$iv$iv$iv = (Issued)it.getAmount().getToken();
                    Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv5);
                }
                Map outGroups$iv = destination$iv$iv$iv4;
                return this_$iv.groupStatesInternal(inGroups$iv, outGroups$iv);
            }

            public Group() {
                super((Clause)new AnyOf(new Clause[]{new NoZeroSizedOutputs(), new Issue(), new ConserveAmount()}));
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005R\"\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Clauses$Issue;", "Lnet/corda/contracts/clause/AbstractIssue;", "Lnet/corda/contracts/asset/CommodityContract$State;", "Lnet/corda/contracts/asset/CommodityContract$Commands;", "Lnet/corda/core/contracts/Commodity;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "finance_main"})
        public static final class Issue
        extends AbstractIssue<State, Commands, Commodity> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.Issue.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            public Issue() {
                super(1.INSTANCE, 2.INSTANCE);
            }
        }

        @CordaSerializable
        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Clauses$ConserveAmount;", "Lnet/corda/contracts/clause/AbstractConserveAmount;", "Lnet/corda/contracts/asset/CommodityContract$State;", "Lnet/corda/contracts/asset/CommodityContract$Commands;", "Lnet/corda/core/contracts/Commodity;", "()V", "finance_main"})
        public static final class ConserveAmount
        extends AbstractConserveAmount<State, Commands, Commodity> {
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB!\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J)\u0010 \u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00062\u0006\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020+H\u0016J\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00000-2\u0006\u0010)\u001a\u00020\bH\u0016R \u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R8\u0010\u0012\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\b0\b \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\b0\b\u0018\u00010\u00150\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lnet/corda/contracts/asset/CommodityContract$State;", "Lnet/corda/core/contracts/FungibleAsset;", "Lnet/corda/core/contracts/Commodity;", "deposit", "Lnet/corda/core/contracts/PartyAndReference;", "amount", "Lnet/corda/core/contracts/Amount;", "owner", "Ljava/security/PublicKey;", "(Lnet/corda/core/contracts/PartyAndReference;Lnet/corda/core/contracts/Amount;Ljava/security/PublicKey;)V", "Lnet/corda/core/contracts/Issued;", "(Lnet/corda/core/contracts/Amount;Ljava/security/PublicKey;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "contract", "Lnet/corda/contracts/asset/CommodityContract;", "getContract", "()Lnet/corda/contracts/asset/CommodityContract;", "exitKeys", "", "kotlin.jvm.PlatformType", "", "getExitKeys", "()Ljava/util/Set;", "getOwner", "()Ljava/security/PublicKey;", "participants", "", "getParticipants", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "move", "newAmount", "newOwner", "toString", "", "withNewOwner", "Lkotlin/Pair;", "Lnet/corda/contracts/asset/CommodityContract$Commands$Move;", "finance_main"})
    public static final class State
    implements FungibleAsset<Commodity> {
        @NotNull
        private final CommodityContract contract;
        private final Set<PublicKey> exitKeys;
        @NotNull
        private final List<PublicKey> participants;
        @NotNull
        private final Amount<Issued<Commodity>> amount;
        @NotNull
        private final PublicKey owner;

        @NotNull
        public CommodityContract getContract() {
            return this.contract;
        }

        public Set<PublicKey> getExitKeys() {
            return this.exitKeys;
        }

        @NotNull
        public List<PublicKey> getParticipants() {
            return this.participants;
        }

        @NotNull
        public FungibleAsset<Commodity> move(@NotNull Amount<Issued<Commodity>> newAmount, @NotNull PublicKey newOwner) {
            Intrinsics.checkParameterIsNotNull(newAmount, (String)"newAmount");
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return this.copy((Amount<Issued<Commodity>>)Amount.copy$default(this.getAmount(), (long)newAmount.getQuantity(), null, null, (int)6, null), newOwner);
        }

        @NotNull
        public String toString() {
            return "Commodity(" + this.getAmount() + " at " + ((Issued)this.getAmount().getToken()).getIssuer() + " owned by " + this.getOwner() + ")";
        }

        @NotNull
        public Pair<Commands.Move, State> withNewOwner(@NotNull PublicKey newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new Pair((Object)new Commands.Move(null, 1, null), (Object)State.copy$default(this, null, newOwner, 1, null));
        }

        @NotNull
        public Amount<Issued<Commodity>> getAmount() {
            return this.amount;
        }

        @NotNull
        public PublicKey getOwner() {
            return this.owner;
        }

        public State(@NotNull Amount<Issued<Commodity>> amount, @NotNull PublicKey owner) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this.amount = amount;
            this.owner = owner;
            this.contract = CommodityContractKt.getCOMMODITY_PROGRAM_ID();
            this.exitKeys = Collections.singleton(this.getOwner());
            this.participants = CollectionsKt.listOf((Object)this.getOwner());
        }

        public State(@NotNull PartyAndReference deposit, @NotNull Amount<Commodity> amount, @NotNull PublicKey owner) {
            Intrinsics.checkParameterIsNotNull((Object)deposit, (String)"deposit");
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this((Amount<Issued<Commodity>>)new Amount(amount.getQuantity(), (Object)new Issued(deposit, amount.getToken())), owner);
        }

        @NotNull
        public final Amount<Issued<Commodity>> component1() {
            return this.getAmount();
        }

        @NotNull
        public final PublicKey component2() {
            return this.getOwner();
        }

        @NotNull
        public final State copy(@NotNull Amount<Issued<Commodity>> amount, @NotNull PublicKey owner) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            return new State(amount, owner);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, Amount amount, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                amount = state.getAmount();
            }
            if ((n & 2) != 0) {
                publicKey = state.getOwner();
            }
            return state.copy(amount, publicKey);
        }

        public int hashCode() {
            Amount<Issued<Commodity>> amount = this.getAmount();
            PublicKey publicKey = this.getOwner();
            return (amount != null ? amount.hashCode() : 0) * 31 + (publicKey != null ? publicKey.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.getAmount(), state.getAmount()) || !Intrinsics.areEqual((Object)this.getOwner(), (Object)state.getOwner())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bg\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Commands;", "Lnet/corda/core/contracts/FungibleAsset$Commands;", "Exit", "Issue", "Move", "finance_main"})
    public static interface Commands
    extends FungibleAsset.Commands {

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Commands$Move;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Move;", "Lnet/corda/contracts/asset/CommodityContract$Commands;", "contractHash", "Lnet/corda/core/crypto/SecureHash;", "(Lnet/corda/core/crypto/SecureHash;)V", "getContractHash", "()Lnet/corda/core/crypto/SecureHash;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Move
        implements FungibleAsset.Commands.Move,
        Commands {
            @Nullable
            private final SecureHash contractHash;

            @Nullable
            public SecureHash getContractHash() {
                return this.contractHash;
            }

            public Move(@Nullable SecureHash contractHash) {
                this.contractHash = contractHash;
            }

            public /* synthetic */ Move(SecureHash secureHash, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    secureHash = null;
                }
                this(secureHash);
            }

            public Move() {
                this(null, 1, null);
            }

            @Nullable
            public final SecureHash component1() {
                return this.getContractHash();
            }

            @NotNull
            public final Move copy(@Nullable SecureHash contractHash) {
                return new Move(contractHash);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Move copy$default(Move move, SecureHash secureHash, int n, Object object) {
                if ((n & 1) != 0) {
                    secureHash = move.getContractHash();
                }
                return move.copy(secureHash);
            }

            public String toString() {
                return "Move(contractHash=" + this.getContractHash() + ")";
            }

            public int hashCode() {
                SecureHash secureHash = this.getContractHash();
                return secureHash != null ? secureHash.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Move)) break block3;
                        Move move = (Move)object;
                        if (!Intrinsics.areEqual((Object)this.getContractHash(), (Object)move.getContractHash())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Commands$Issue;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Issue;", "Lnet/corda/contracts/asset/CommodityContract$Commands;", "nonce", "", "(J)V", "getNonce", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Issue
        implements FungibleAsset.Commands.Issue,
        Commands {
            private final long nonce;

            public long getNonce() {
                return this.nonce;
            }

            public Issue(long nonce) {
                this.nonce = nonce;
            }

            public /* synthetic */ Issue(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    l = CryptoUtils.newSecureRandom().nextLong();
                }
                this(l);
            }

            public Issue() {
                this(0L, 1, null);
            }

            public final long component1() {
                return this.getNonce();
            }

            @NotNull
            public final Issue copy(long nonce) {
                return new Issue(nonce);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Issue copy$default(Issue issue, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = issue.getNonce();
                }
                return issue.copy(l);
            }

            public String toString() {
                return "Issue(nonce=" + this.getNonce() + ")";
            }

            public int hashCode() {
                long l = this.getNonce();
                return (int)(l ^ l >>> 32);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Issue)) break block3;
                        Issue issue = (Issue)object;
                        if (!(this.getNonce() == issue.getNonce())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lnet/corda/contracts/asset/CommodityContract$Commands$Exit;", "Lnet/corda/contracts/asset/CommodityContract$Commands;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Exit;", "Lnet/corda/core/contracts/Commodity;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "(Lnet/corda/core/contracts/Amount;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Exit
        implements Commands,
        FungibleAsset.Commands.Exit<Commodity> {
            @NotNull
            private final Amount<Issued<Commodity>> amount;

            @NotNull
            public Amount<Issued<Commodity>> getAmount() {
                return this.amount;
            }

            public Exit(@NotNull Amount<Issued<Commodity>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                this.amount = amount;
            }

            @NotNull
            public final Amount<Issued<Commodity>> component1() {
                return this.getAmount();
            }

            @NotNull
            public final Exit copy(@NotNull Amount<Issued<Commodity>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                return new Exit(amount);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Exit copy$default(Exit exit, Amount amount, int n, Object object) {
                if ((n & 1) != 0) {
                    amount = exit.getAmount();
                }
                return exit.copy(amount);
            }

            public String toString() {
                return "Exit(amount=" + this.getAmount() + ")";
            }

            public int hashCode() {
                Amount<Issued<Commodity>> amount = this.getAmount();
                return amount != null ? amount.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Exit)) break block3;
                        Exit exit = (Exit)object;
                        if (!Intrinsics.areEqual(this.getAmount(), exit.getAmount())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

