/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts;

import co.paralleluniverse.fibers.Suspendable;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.corda.contracts.CommercialPaperKt;
import net.corda.contracts.ICommercialPaperState;
import net.corda.contracts.asset.CashKt;
import net.corda.contracts.clause.AbstractIssue;
import net.corda.core.Utils;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.Command;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.IssueCommand;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.Timestamp;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionType;
import net.corda.core.contracts.TypeOnlyCommandData;
import net.corda.core.contracts.clauses.AnyOf;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.contracts.clauses.ClauseVerifier;
import net.corda.core.contracts.clauses.GroupClauseVerifier;
import net.corda.core.crypto.EncodingUtils;
import net.corda.core.crypto.Party;
import net.corda.core.crypto.SecureHash;
import net.corda.core.node.services.VaultService;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.schemas.QueryableState;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.Emoji;
import net.corda.schemas.CommercialPaperSchemaV1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004 !\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lnet/corda/contracts/CommercialPaper;", "Lnet/corda/core/contracts/Contract;", "()V", "legalContractReference", "Lnet/corda/core/crypto/SecureHash;", "getLegalContractReference", "()Lnet/corda/core/crypto/SecureHash;", "generateIssue", "Lnet/corda/core/transactions/TransactionBuilder;", "issuance", "Lnet/corda/core/contracts/PartyAndReference;", "faceValue", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "maturityDate", "Ljava/time/Instant;", "notary", "Lnet/corda/core/crypto/Party;", "generateMove", "", "tx", "paper", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/contracts/CommercialPaper$State;", "newOwner", "Ljava/security/PublicKey;", "generateRedeem", "vault", "Lnet/corda/core/node/services/VaultService;", "verify", "Lnet/corda/core/contracts/TransactionForContract;", "Clauses", "Commands", "State", "Terms", "finance_main"})
public final class CommercialPaper
implements Contract {
    @NotNull
    private final SecureHash legalContractReference = (SecureHash)SecureHash.Companion.sha256("https://en.wikipedia.org/wiki/Commercial_paper");

    @NotNull
    public SecureHash getLegalContractReference() {
        return this.legalContractReference;
    }

    /*
     * WARNING - void declaration
     */
    public void verify(@NotNull TransactionForContract tx) {
        AuthenticatedObject it$iv;
        Iterable $receiver$iv$iv$iv;
        void $receiver$iv;
        Iterable $receiver$iv$iv;
        Party party$iv;
        PublicKey signer$iv;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Collection collection = tx.getCommands();
        Object var3_3 = null;
        Object var4_4 = null;
        int n = 3;
        Object var6_6 = null;
        Clause clause = (Clause)new Clauses.Group();
        TransactionForContract transactionForContract = tx;
        if ((n & 1) != 0) {
            signer$iv = null;
        }
        if ((n & 2) != 0) {
            party$iv = null;
        }
        Iterable iterable = $receiver$iv$iv = (Iterable)$receiver$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(it$iv.getValue() instanceof Commands)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(signer$iv == null ? true : it$iv.getSigners().contains(signer$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(party$iv == null ? true : it$iv.getSigningParties().contains(party$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)item$iv$iv$iv;
            Collection collection2 = destination$iv$iv$iv;
            Object object = it$iv.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.CommercialPaper.Commands");
            }
            AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv.getSigners(), it$iv.getSigningParties(), (Object)((Commands)object));
            collection2.add(authenticatedObject);
        }
        List list = (List)destination$iv$iv$iv;
        ClauseVerifier.verifyClause((TransactionForContract)transactionForContract, (Clause)clause, (List)list);
    }

    @NotNull
    public final TransactionBuilder generateIssue(@NotNull PartyAndReference issuance, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
        Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
        Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        TransactionState state = new TransactionState((ContractState)new State(issuance, issuance.getParty().getOwningKey(), faceValue, maturityDate), notary, null, 4, null);
        return new TransactionType.General.Builder(notary).withItems(new Object[]{state, new Command((CommandData)new Commands.Issue(0L, 1, null), issuance.getParty().getOwningKey())});
    }

    public final void generateMove(@NotNull TransactionBuilder tx, @NotNull StateAndRef<State> paper, @NotNull PublicKey newOwner) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(paper, (String)"paper");
        Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
        tx.addInputState(paper);
        tx.addOutputState(new TransactionState((ContractState)State.copy$default((State)paper.getState().getData(), null, newOwner, null, null, 13, null), paper.getState().getNotary(), null, 4, null));
        tx.addCommand((CommandData)new Commands.Move(null, 1, null), new PublicKey[]{((State)paper.getState().getData()).getOwner()});
    }

    @Suspendable
    public final void generateRedeem(@NotNull TransactionBuilder tx, @NotNull StateAndRef<State> paper, @NotNull VaultService vault) throws InsufficientBalanceException {
        Amount<Issued<Currency>> amount;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(paper, (String)"paper");
        Intrinsics.checkParameterIsNotNull((Object)vault, (String)"vault");
        Amount<Issued<Currency>> amount2 = amount = ((State)paper.getState().getData()).getFaceValue();
        Amount amount3 = new Amount(amount2.getQuantity(), ((Issued)amount2.getToken()).getProduct());
        VaultService.DefaultImpls.generateSpend$default((VaultService)vault, (TransactionBuilder)tx, (Amount)amount3, (PublicKey)((State)paper.getState().getData()).getOwner(), null, (int)8, null);
        tx.addInputState(paper);
        tx.addCommand((CommandData)new Commands.Redeem(), new PublicKey[]{((State)paper.getState().getData()).getOwner()});
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lnet/corda/contracts/CommercialPaper$Terms;", "", "asset", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "maturityDate", "Ljava/time/Instant;", "(Lnet/corda/core/contracts/Issued;Ljava/time/Instant;)V", "getAsset", "()Lnet/corda/core/contracts/Issued;", "getMaturityDate", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "finance_main"})
    public static final class Terms {
        @NotNull
        private final Issued<Currency> asset;
        @NotNull
        private final Instant maturityDate;

        @NotNull
        public final Issued<Currency> getAsset() {
            return this.asset;
        }

        @NotNull
        public final Instant getMaturityDate() {
            return this.maturityDate;
        }

        public Terms(@NotNull Issued<Currency> asset, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull(asset, (String)"asset");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            this.asset = asset;
            this.maturityDate = maturityDate;
        }

        @NotNull
        public final Issued<Currency> component1() {
            return this.asset;
        }

        @NotNull
        public final Instant component2() {
            return this.maturityDate;
        }

        @NotNull
        public final Terms copy(@NotNull Issued<Currency> asset, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull(asset, (String)"asset");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            return new Terms(asset, maturityDate);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Terms copy$default(Terms terms, Issued issued, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                issued = terms.asset;
            }
            if ((n & 2) != 0) {
                instant = terms.maturityDate;
            }
            return terms.copy(issued, instant);
        }

        public String toString() {
            return "Terms(asset=" + this.asset + ", maturityDate=" + this.maturityDate + ")";
        }

        public int hashCode() {
            Issued<Currency> issued = this.asset;
            Instant instant = this.maturityDate;
            return (issued != null ? issued.hashCode() : 0) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Terms)) break block3;
                    Terms terms = (Terms)object;
                    if (!Intrinsics.areEqual(this.asset, terms.asset) || !Intrinsics.areEqual((Object)this.maturityDate, (Object)terms.maturityDate)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u00c6\u0003J\t\u0010&\u001a\u00020\rH\u00c6\u0003J=\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u000201H\u00d6\u0001J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020/03H\u0016J\b\u00104\u001a\u000205H\u0016J\u001c\u00106\u001a\u00020\u00032\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016J\u0010\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\rH\u0016J\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u00000;2\u0006\u0010=\u001a\u00020\u0007H\u0016J\u0010\u0010>\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0007H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006?"}, d2={"Lnet/corda/contracts/CommercialPaper$State;", "Lnet/corda/core/contracts/OwnableState;", "Lnet/corda/core/schemas/QueryableState;", "Lnet/corda/contracts/ICommercialPaperState;", "issuance", "Lnet/corda/core/contracts/PartyAndReference;", "owner", "Ljava/security/PublicKey;", "faceValue", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "maturityDate", "Ljava/time/Instant;", "(Lnet/corda/core/contracts/PartyAndReference;Ljava/security/PublicKey;Lnet/corda/core/contracts/Amount;Ljava/time/Instant;)V", "contract", "Lnet/corda/contracts/CommercialPaper;", "getContract", "()Lnet/corda/contracts/CommercialPaper;", "getFaceValue", "()Lnet/corda/core/contracts/Amount;", "getIssuance", "()Lnet/corda/core/contracts/PartyAndReference;", "getMaturityDate", "()Ljava/time/Instant;", "getOwner", "()Ljava/security/PublicKey;", "participants", "", "getParticipants", "()Ljava/util/List;", "token", "Lnet/corda/contracts/CommercialPaper$Terms;", "getToken", "()Lnet/corda/core/contracts/Issued;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "generateMappedObject", "Lnet/corda/core/schemas/PersistentState;", "schema", "Lnet/corda/core/schemas/MappedSchema;", "hashCode", "", "supportedSchemas", "", "toString", "", "withFaceValue", "newFaceValue", "withMaturityDate", "newMaturityDate", "withNewOwner", "Lkotlin/Pair;", "Lnet/corda/contracts/CommercialPaper$Commands$Move;", "newOwner", "withOwner", "finance_main"})
    public static final class State
    implements OwnableState,
    QueryableState,
    ICommercialPaperState {
        @NotNull
        private final CommercialPaper contract;
        @NotNull
        private final PartyAndReference issuance;
        @NotNull
        private final PublicKey owner;
        @NotNull
        private final Amount<Issued<Currency>> faceValue;
        @NotNull
        private final Instant maturityDate;

        @NotNull
        public CommercialPaper getContract() {
            return this.contract;
        }

        @NotNull
        public List<PublicKey> getParticipants() {
            return CollectionsKt.listOf((Object)this.getOwner());
        }

        @NotNull
        public final Issued<Terms> getToken() {
            return new Issued(this.issuance, (Object)new Terms((Issued<Currency>)((Issued)this.faceValue.getToken()), this.maturityDate));
        }

        @NotNull
        public Pair<Commands.Move, State> withNewOwner(@NotNull PublicKey newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new Pair((Object)new Commands.Move(null, 1, null), (Object)State.copy$default(this, null, newOwner, null, null, 13, null));
        }

        @NotNull
        public String toString() {
            return Emoji.INSTANCE.getNewspaper() + "CommercialPaper(of " + this.faceValue + " redeemable on " + this.maturityDate + " by '" + this.issuance + "', owned by " + this.getOwner() + ")";
        }

        @Override
        @NotNull
        public ICommercialPaperState withOwner(@NotNull PublicKey newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return State.copy$default(this, null, newOwner, null, null, 13, null);
        }

        @Override
        @NotNull
        public ICommercialPaperState withFaceValue(@NotNull Amount<Issued<Currency>> newFaceValue) {
            Intrinsics.checkParameterIsNotNull(newFaceValue, (String)"newFaceValue");
            return State.copy$default(this, null, null, newFaceValue, null, 11, null);
        }

        @Override
        @NotNull
        public ICommercialPaperState withMaturityDate(@NotNull Instant newMaturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)newMaturityDate, (String)"newMaturityDate");
            return State.copy$default(this, null, null, null, newMaturityDate, 7, null);
        }

        @NotNull
        public Iterable<MappedSchema> supportedSchemas() {
            return CollectionsKt.listOf((Object)((Object)CommercialPaperSchemaV1.INSTANCE));
        }

        @NotNull
        public PersistentState generateMappedObject(@NotNull MappedSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            MappedSchema mappedSchema = schema;
            if (!(mappedSchema instanceof CommercialPaperSchemaV1)) {
                throw (Throwable)new IllegalArgumentException("Unrecognised schema " + schema);
            }
            String string = EncodingUtils.toBase58String((PublicKey)this.issuance.getParty().getOwningKey());
            byte[] byArray = this.issuance.getReference().getBytes();
            String string2 = EncodingUtils.toBase58String((PublicKey)this.getOwner());
            long l = this.faceValue.getQuantity();
            String string3 = ((Currency)((Issued)this.faceValue.getToken()).getProduct()).getCurrencyCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"this.faceValue.token.product.currencyCode");
            return new CommercialPaperSchemaV1.PersistentCommericalPaperState(string, byArray, string2, this.maturityDate, l, string3, EncodingUtils.toBase58String((PublicKey)((Issued)this.faceValue.getToken()).getIssuer().getParty().getOwningKey()), ((Issued)this.faceValue.getToken()).getIssuer().getReference().getBytes());
        }

        @NotNull
        public final PartyAndReference getIssuance() {
            return this.issuance;
        }

        @NotNull
        public PublicKey getOwner() {
            return this.owner;
        }

        @NotNull
        public final Amount<Issued<Currency>> getFaceValue() {
            return this.faceValue;
        }

        @NotNull
        public final Instant getMaturityDate() {
            return this.maturityDate;
        }

        public State(@NotNull PartyAndReference issuance, @NotNull PublicKey owner, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            this.issuance = issuance;
            this.owner = owner;
            this.faceValue = faceValue;
            this.maturityDate = maturityDate;
            this.contract = CommercialPaperKt.getCP_PROGRAM_ID();
        }

        @NotNull
        public final PartyAndReference component1() {
            return this.issuance;
        }

        @NotNull
        public final PublicKey component2() {
            return this.getOwner();
        }

        @NotNull
        public final Amount<Issued<Currency>> component3() {
            return this.faceValue;
        }

        @NotNull
        public final Instant component4() {
            return this.maturityDate;
        }

        @NotNull
        public final State copy(@NotNull PartyAndReference issuance, @NotNull PublicKey owner, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            return new State(issuance, owner, faceValue, maturityDate);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, PartyAndReference partyAndReference, PublicKey publicKey, Amount amount, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                partyAndReference = state.issuance;
            }
            if ((n & 2) != 0) {
                publicKey = state.getOwner();
            }
            if ((n & 4) != 0) {
                amount = state.faceValue;
            }
            if ((n & 8) != 0) {
                instant = state.maturityDate;
            }
            return state.copy(partyAndReference, publicKey, amount, instant);
        }

        public int hashCode() {
            PartyAndReference partyAndReference = this.issuance;
            PublicKey publicKey = this.getOwner();
            Amount<Issued<Currency>> amount = this.faceValue;
            Instant instant = this.maturityDate;
            return (((partyAndReference != null ? partyAndReference.hashCode() : 0) * 31 + (publicKey != null ? publicKey.hashCode() : 0)) * 31 + (amount != null ? amount.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual((Object)this.issuance, (Object)state.issuance) || !Intrinsics.areEqual((Object)this.getOwner(), (Object)state.getOwner()) || !Intrinsics.areEqual(this.faceValue, state.faceValue) || !Intrinsics.areEqual((Object)this.maturityDate, (Object)state.maturityDate)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/contracts/CommercialPaper$Clauses;", "", "Group", "Issue", "Move", "Redeem", "finance_main"})
    public static interface Clauses {

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lnet/corda/contracts/CommercialPaper$Clauses$Group;", "Lnet/corda/core/contracts/clauses/GroupClauseVerifier;", "Lnet/corda/contracts/CommercialPaper$State;", "Lnet/corda/contracts/CommercialPaper$Commands;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/CommercialPaper$Terms;", "()V", "groupStates", "", "Lnet/corda/core/contracts/TransactionForContract$InOutGroup;", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "finance_main"})
        public static final class Group
        extends GroupClauseVerifier<State, Commands, Issued<? extends Terms>> {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TransactionForContract.InOutGroup<State, Issued<Terms>>> groupStates(@NotNull TransactionForContract tx) {
                void $receiver$iv$iv$iv;
                State it;
                void $receiver$iv$iv$iv2;
                Object element$iv$iv$iv3;
                void $receiver$iv$iv$iv3;
                void $receiver$iv$iv$iv4;
                Iterable $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                TransactionForContract this_$iv = tx;
                Iterable iterable = $receiver$iv$iv = (Iterable)this_$iv.getInputs();
                Iterable destination$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv2 : $receiver$iv$iv$iv4) {
                    if (!(element$iv$iv$iv2 instanceof State)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv2);
                }
                List inputs$iv = (List)destination$iv$iv$iv;
                Iterable $receiver$iv$iv2 = this_$iv.getOutputs();
                destination$iv$iv$iv = $receiver$iv$iv2;
                Iterable destination$iv$iv$iv2 = new ArrayList();
                for (Object element$iv$iv$iv3 : $receiver$iv$iv$iv3) {
                    if (!(element$iv$iv$iv3 instanceof State)) continue;
                    destination$iv$iv$iv2.add(element$iv$iv$iv3);
                }
                List outputs$iv = (List)destination$iv$iv$iv2;
                Iterable $receiver$iv$iv3 = inputs$iv;
                destination$iv$iv$iv2 = $receiver$iv$iv3;
                Object destination$iv$iv$iv3 = new LinkedHashMap();
                element$iv$iv$iv3 = $receiver$iv$iv$iv2.iterator();
                while (element$iv$iv$iv3.hasNext()) {
                    Object object;
                    Object $receiver$iv$iv$iv$iv = destination$iv$iv$iv3;
                    Object element$iv$iv$iv4 = element$iv$iv$iv3.next();
                    it = (State)element$iv$iv$iv4;
                    Issued<Terms> key$iv$iv$iv = it.getToken();
                    Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv4);
                }
                Map inGroups$iv = destination$iv$iv$iv3;
                Iterable $receiver$iv$iv4 = outputs$iv;
                destination$iv$iv$iv3 = $receiver$iv$iv4;
                Map destination$iv$iv$iv4 = new LinkedHashMap();
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Map $receiver$iv$iv$iv$iv = destination$iv$iv$iv4;
                    Object element$iv$iv$iv5 = iterator.next();
                    it = (State)element$iv$iv$iv5;
                    Issued<Terms> key$iv$iv$iv = it.getToken();
                    Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv5);
                }
                Map outGroups$iv = destination$iv$iv$iv4;
                return this_$iv.groupStatesInternal(inGroups$iv, outGroups$iv);
            }

            public Group() {
                super((Clause)new AnyOf(new Clause[]{new Redeem(), new Move(), new Issue()}));
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005JV\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u00102\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0015H\u0016R\"\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lnet/corda/contracts/CommercialPaper$Clauses$Issue;", "Lnet/corda/contracts/clause/AbstractIssue;", "Lnet/corda/contracts/CommercialPaper$State;", "Lnet/corda/contracts/CommercialPaper$Commands;", "Lnet/corda/contracts/CommercialPaper$Terms;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "verify", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "Lnet/corda/core/contracts/Issued;", "finance_main"})
        public static final class Issue
        extends AbstractIssue<State, Commands, Terms> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.Issue.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            @Override
            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<State> inputs, @NotNull List<State> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @Nullable Issued<Terms> groupingKey) {
                boolean bl;
                Set<Commands> consumedCommands;
                block12: {
                    boolean bl2;
                    Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                    Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
                    Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
                    Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
                    consumedCommands = super.verify(tx, inputs, outputs, commands, groupingKey);
                    Collection $receiver$iv = commands;
                    try {
                        AuthenticatedObject it$iv$iv;
                        Iterable $receiver$iv$iv$iv$iv;
                        AuthenticatedObject $receiver$iv$iv;
                        Iterable $receiver$iv$iv$iv;
                        Party party$iv$iv;
                        PublicKey signer$iv$iv;
                        Collection collection = $receiver$iv;
                        Object var9_9 = null;
                        Object var10_12 = null;
                        int n = 3;
                        Object var12_16 = null;
                        if ((n & 1) != 0) {
                            signer$iv$iv = null;
                        }
                        if ((n & 2) != 0) {
                            party$iv$iv = null;
                        }
                        Iterable iterable = $receiver$iv$iv$iv = (Iterable)$receiver$iv$iv;
                        Collection destination$iv$iv$iv$iv = new ArrayList();
                        for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                            it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                            if (!(it$iv$iv.getValue() instanceof Commands.Issue)) continue;
                            destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                        }
                        $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                        $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                        destination$iv$iv$iv$iv = new ArrayList();
                        for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                            it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                            if (!(signer$iv$iv == null ? true : it$iv$iv.getSigners().contains(signer$iv$iv))) continue;
                            destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                        }
                        $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                        $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                        destination$iv$iv$iv$iv = new ArrayList();
                        for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                            it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                            if (!(party$iv$iv == null ? true : it$iv$iv.getSigningParties().contains(party$iv$iv))) continue;
                            destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                        }
                        $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                        $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                        destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv, (int)10));
                        for (Object item$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                            it$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv;
                            Collection collection2 = destination$iv$iv$iv$iv;
                            Object object = it$iv$iv.getValue();
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.CommercialPaper.Commands.Issue");
                            }
                            AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv.getSigners(), it$iv$iv.getSigningParties(), (Object)((Commands.Issue)object));
                            collection2.add(authenticatedObject);
                        }
                        $receiver$iv$iv = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv));
                    }
                    catch (NoSuchElementException e$iv) {
                        throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(Commands.Issue.class).getQualifiedName() + " command");
                    }
                    Timestamp timestamp = tx.getTimestamp();
                    Object object = timestamp;
                    if (object == null || (object = object.getBefore()) == null) {
                        throw (Throwable)new IllegalArgumentException("Issuances must be timestamped");
                    }
                    Object time = object;
                    Iterable $receiver$iv2 = outputs;
                    for (Object element$iv : $receiver$iv2) {
                        State it = (State)element$iv;
                        if (((Instant)time).compareTo(it.getMaturityDate()) < 0) continue;
                        bl2 = false;
                        break block12;
                    }
                    bl2 = bl = true;
                }
                if (!bl) {
                    String string = "maturity date is not in the past";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return consumedCommands;
            }

            public Issue() {
                super(1.INSTANCE, 2.INSTANCE);
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006JV\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00140\u00112\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lnet/corda/contracts/CommercialPaper$Clauses$Move;", "Lnet/corda/core/contracts/clauses/Clause;", "Lnet/corda/contracts/CommercialPaper$State;", "Lnet/corda/contracts/CommercialPaper$Commands;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/CommercialPaper$Terms;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "verify", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "finance_main"})
        public static final class Move
        extends Clause<State, Commands, Issued<? extends Terms>> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.Move.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<State> inputs, @NotNull List<State> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @Nullable Issued<Terms> groupingKey) {
                String $receiver$iv;
                AuthenticatedObject $receiver$iv$iv;
                Party party$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
                Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
                Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
                Collection $receiver$iv2 = commands;
                try {
                    AuthenticatedObject it$iv$iv;
                    Iterable $receiver$iv$iv$iv$iv;
                    Iterable $receiver$iv$iv$iv;
                    PublicKey signer$iv$iv;
                    Collection collection = $receiver$iv2;
                    Object var9_8 = null;
                    Object var10_10 = null;
                    int n = 3;
                    Object var12_12 = null;
                    if ((n & 1) != 0) {
                        signer$iv$iv = null;
                    }
                    if ((n & 2) != 0) {
                        party$iv$iv = null;
                    }
                    Iterable iterable = $receiver$iv$iv$iv = (Iterable)$receiver$iv$iv;
                    Collection destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(it$iv$iv.getValue() instanceof Commands.Move)) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(signer$iv$iv == null ? true : it$iv$iv.getSigners().contains(signer$iv$iv))) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(party$iv$iv == null ? true : it$iv$iv.getSigningParties().contains(party$iv$iv))) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv, (int)10));
                    for (Object item$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv;
                        Collection collection2 = destination$iv$iv$iv$iv;
                        Object object = it$iv$iv.getValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.CommercialPaper.Commands.Move");
                        }
                        AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv.getSigners(), it$iv$iv.getSigningParties(), (Object)((Commands.Move)object));
                        collection2.add(authenticatedObject);
                    }
                    $receiver$iv$iv = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv));
                }
                catch (NoSuchElementException e$iv) {
                    throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(Commands.Move.class).getQualifiedName() + " command");
                }
                AuthenticatedObject command = $receiver$iv$iv;
                State input = (State)CollectionsKt.single(inputs);
                Requirements $receiver = Requirements.INSTANCE;
                String e$iv = "the transaction is signed by the owner of the CP";
                party$iv$iv = $receiver;
                boolean expr$iv = command.getSigners().contains(input.getOwner());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                $receiver$iv = "the state is propagated";
                Requirements this_$iv = $receiver;
                boolean bl = expr$iv = outputs.size() == 1;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                return SetsKt.setOf((Object)command.getValue());
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006JV\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00140\u00112\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lnet/corda/contracts/CommercialPaper$Clauses$Redeem;", "Lnet/corda/core/contracts/clauses/Clause;", "Lnet/corda/contracts/CommercialPaper$State;", "Lnet/corda/contracts/CommercialPaper$Commands;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/CommercialPaper$Terms;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "verify", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "finance_main"})
        public static final class Redeem
        extends Clause<State, Commands, Issued<? extends Terms>> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.Redeem.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<State> inputs, @NotNull List<State> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @Nullable Issued<Terms> groupingKey) {
                String $receiver$iv;
                boolean expr$iv;
                Iterable $receiver$iv$iv$iv$iv;
                Object $receiver$iv$iv$iv;
                AuthenticatedObject $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
                Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
                Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
                Collection $receiver$iv2 = commands;
                try {
                    AuthenticatedObject it$iv$iv;
                    Party party$iv$iv;
                    PublicKey signer$iv$iv;
                    Collection collection = $receiver$iv2;
                    Object var9_8 = null;
                    Object var10_10 = null;
                    int n = 3;
                    Object var12_13 = null;
                    if ((n & 1) != 0) {
                        signer$iv$iv = null;
                    }
                    if ((n & 2) != 0) {
                        party$iv$iv = null;
                    }
                    $receiver$iv$iv$iv = (Iterable)$receiver$iv$iv;
                    Iterable iterable = $receiver$iv$iv$iv;
                    Collection destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(it$iv$iv.getValue() instanceof Commands.Redeem)) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(signer$iv$iv == null ? true : it$iv$iv.getSigners().contains(signer$iv$iv))) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(party$iv$iv == null ? true : it$iv$iv.getSigningParties().contains(party$iv$iv))) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv, (int)10));
                    for (Object item$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv;
                        Collection collection2 = destination$iv$iv$iv$iv;
                        Object object = it$iv$iv.getValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.CommercialPaper.Commands.Redeem");
                        }
                        AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv.getSigners(), it$iv$iv.getSigningParties(), (Object)((Commands.Redeem)object));
                        collection2.add(authenticatedObject);
                    }
                    $receiver$iv$iv = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv));
                }
                catch (NoSuchElementException e$iv) {
                    throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(Commands.Redeem.class).getQualifiedName() + " command");
                }
                AuthenticatedObject command = $receiver$iv$iv;
                Timestamp timestamp = tx.getTimestamp();
                State input = (State)CollectionsKt.single(inputs);
                Amount<Issued<Currency>> received = CashKt.sumCashBy(tx.getOutputs(), input.getOwner());
                Object object = timestamp;
                if (object == null || (object = object.getAfter()) == null) {
                    throw (Throwable)new IllegalArgumentException("Redemptions must be timestamped");
                }
                Object time = object;
                Requirements $receiver = Requirements.INSTANCE;
                $receiver$iv$iv$iv = "the paper must have matured";
                $receiver$iv$iv$iv$iv = $receiver;
                boolean bl = expr$iv = ((Instant)time).compareTo(input.getMaturityDate()) >= 0;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                $receiver$iv = "the received amount equals the face value";
                Requirements this_$iv = $receiver;
                expr$iv = Intrinsics.areEqual(received, input.getFaceValue());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                $receiver$iv = "the paper must be destroyed";
                this_$iv = $receiver;
                expr$iv = outputs.isEmpty();
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                $receiver$iv = "the transaction is signed by the owner of the CP";
                this_$iv = $receiver;
                expr$iv = command.getSigners().contains(input.getOwner());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                return SetsKt.setOf((Object)command.getValue());
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/contracts/CommercialPaper$Commands;", "Lnet/corda/core/contracts/CommandData;", "Issue", "Move", "Redeem", "finance_main"})
    public static interface Commands
    extends CommandData {

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/contracts/CommercialPaper$Commands$Move;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Move;", "Lnet/corda/contracts/CommercialPaper$Commands;", "contractHash", "Lnet/corda/core/crypto/SecureHash;", "(Lnet/corda/core/crypto/SecureHash;)V", "getContractHash", "()Lnet/corda/core/crypto/SecureHash;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Move
        implements FungibleAsset.Commands.Move,
        Commands {
            @Nullable
            private final SecureHash contractHash;

            @Nullable
            public SecureHash getContractHash() {
                return this.contractHash;
            }

            public Move(@Nullable SecureHash contractHash) {
                this.contractHash = contractHash;
            }

            public /* synthetic */ Move(SecureHash secureHash, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    secureHash = null;
                }
                this(secureHash);
            }

            public Move() {
                this(null, 1, null);
            }

            @Nullable
            public final SecureHash component1() {
                return this.getContractHash();
            }

            @NotNull
            public final Move copy(@Nullable SecureHash contractHash) {
                return new Move(contractHash);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Move copy$default(Move move, SecureHash secureHash, int n, Object object) {
                if ((n & 1) != 0) {
                    secureHash = move.getContractHash();
                }
                return move.copy(secureHash);
            }

            public String toString() {
                return "Move(contractHash=" + this.getContractHash() + ")";
            }

            public int hashCode() {
                SecureHash secureHash = this.getContractHash();
                return secureHash != null ? secureHash.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Move)) break block3;
                        Move move = (Move)object;
                        if (!Intrinsics.areEqual((Object)this.getContractHash(), (Object)move.getContractHash())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/contracts/CommercialPaper$Commands$Redeem;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "Lnet/corda/contracts/CommercialPaper$Commands;", "()V", "finance_main"})
        public static final class Redeem
        extends TypeOnlyCommandData
        implements Commands {
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/contracts/CommercialPaper$Commands$Issue;", "Lnet/corda/core/contracts/IssueCommand;", "Lnet/corda/contracts/CommercialPaper$Commands;", "nonce", "", "(J)V", "getNonce", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Issue
        implements IssueCommand,
        Commands {
            private final long nonce;

            public long getNonce() {
                return this.nonce;
            }

            public Issue(long nonce) {
                this.nonce = nonce;
            }

            public /* synthetic */ Issue(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    l = Utils.random63BitValue();
                }
                this(l);
            }

            public Issue() {
                this(0L, 1, null);
            }

            public final long component1() {
                return this.getNonce();
            }

            @NotNull
            public final Issue copy(long nonce) {
                return new Issue(nonce);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Issue copy$default(Issue issue, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = issue.getNonce();
                }
                return issue.copy(l);
            }

            public String toString() {
                return "Issue(nonce=" + this.getNonce() + ")";
            }

            public int hashCode() {
                long l = this.getNonce();
                return (int)(l ^ l >>> 32);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Issue)) break block3;
                        Issue issue = (Issue)object;
                        if (!(this.getNonce() == issue.getNonce())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

