/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts.clause;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.FungibleAssetKt;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.MoveCommand;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.Party;
import net.corda.core.transactions.TransactionBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 **\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0004*\u00020\u0005*\b\b\u0002\u0010\u0003*\u00020\u00062\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\b0\u0007:\u0001*B\u0005\u00a2\u0006\u0002\u0010\tJH\u0010\n\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u000e0\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u000eH\u0003J\u009e\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\u000e2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u001826\u0010\u0019\u001a2\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\u000e\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u001e\u0010\u001e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\b0\u000e\u0012\u0004\u0012\u00020\u00050\u001fH\u0007J\b\u0010 \u001a\u00020!H\u0016JV\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010#2\u0006\u0010\u0014\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010(0\u00182\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\bH\u0016\u00a8\u0006+"}, d2={"Lnet/corda/contracts/clause/AbstractConserveAmount;", "S", "Lnet/corda/core/contracts/FungibleAsset;", "T", "C", "Lnet/corda/core/contracts/CommandData;", "", "Lnet/corda/core/contracts/clauses/Clause;", "Lnet/corda/core/contracts/Issued;", "()V", "gatherCoins", "Lkotlin/Pair;", "Ljava/util/ArrayList;", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/Amount;", "acceptableCoins", "", "amount", "generateExit", "Lnet/corda/core/crypto/CompositeKey;", "tx", "Lnet/corda/core/transactions/TransactionBuilder;", "amountIssued", "assetStates", "", "deriveState", "Lkotlin/Function3;", "Lnet/corda/core/contracts/TransactionState;", "generateMoveCommand", "Lkotlin/Function0;", "generateExitCommand", "Lkotlin/Function1;", "toString", "", "verify", "", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "Companion", "finance_main"})
public abstract class AbstractConserveAmount<S extends FungibleAsset<T>, C extends CommandData, T>
extends Clause<S, C, Issued<? extends T>> {
    @NotNull
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final Pair<ArrayList<StateAndRef<S>>, Amount<T>> gatherCoins(Collection<? extends StateAndRef<? extends S>> acceptableCoins, Amount<T> amount) throws InsufficientBalanceException {
        void gatheredAmount;
        ArrayList<StateAndRef<S>> gathered = new ArrayList<StateAndRef<S>>();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new Amount(0L, amount.getToken());
        for (StateAndRef<S> stateAndRef : acceptableCoins) {
            if (((Amount)gatheredAmount.element).compareTo(amount) >= 0) break;
            gathered.add(stateAndRef);
            gatheredAmount.element = ((Amount)gatheredAmount.element).plus(new Amount(((FungibleAsset)stateAndRef.getState().getData()).getAmount().getQuantity(), amount.getToken()));
        }
        if (((Amount)gatheredAmount.element).compareTo(amount) < 0) {
            Logger logger = Companion.getLog();
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                String string = "Insufficient balance: requested " + amount + ", available " + (Amount)gatheredAmount.element;
                logger2.trace(string);
            }
            throw (Throwable)new InsufficientBalanceException(amount.minus((Amount)gatheredAmount.element));
        }
        Logger logger = Companion.getLog();
        if (logger.isTraceEnabled()) {
            Logger logger3 = logger;
            String string = "Gathered coins: requested " + amount + ", available " + (Amount)gatheredAmount.element + ", change: " + ((Amount)gatheredAmount.element).minus(amount);
            logger3.trace(string);
        }
        return new Pair(gathered, (Object)((Amount)gatheredAmount.element));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompositeKey generateExit(@NotNull TransactionBuilder tx, @NotNull Amount<Issued<T>> amountIssued, @NotNull List<? extends StateAndRef<? extends S>> assetStates, @NotNull Function3<? super TransactionState<? extends S>, ? super Amount<Issued<T>>, ? super CompositeKey, ? extends TransactionState<? extends S>> deriveState, @NotNull Function0<? extends CommandData> generateMoveCommand, @NotNull Function1<? super Amount<Issued<T>>, ? extends CommandData> generateExitCommand) throws InsufficientBalanceException {
        StateAndRef it;
        Collection<CompositeKey> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Object state2;
        void gatheredAmount;
        void gathered;
        Iterable $receiver$iv$iv2;
        CompositeKey compositeKey;
        Collection collection2;
        Object item$iv$iv2;
        void $receiver$iv$iv3;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(amountIssued, (String)"amountIssued");
        Intrinsics.checkParameterIsNotNull(assetStates, (String)"assetStates");
        Intrinsics.checkParameterIsNotNull(deriveState, (String)"deriveState");
        Intrinsics.checkParameterIsNotNull(generateMoveCommand, (String)"generateMoveCommand");
        Intrinsics.checkParameterIsNotNull(generateExitCommand, (String)"generateExitCommand");
        Iterable iterable = $receiver$iv2 = (Iterable)assetStates;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv3) {
            void it2;
            StateAndRef stateAndRef = (StateAndRef)item$iv$iv2;
            collection2 = destination$iv$iv;
            compositeKey = ((FungibleAsset)it2.getState().getData()).getOwner();
            collection2.add(compositeKey);
        }
        CompositeKey compositeKey2 = (CompositeKey)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        if (compositeKey2 == null) {
            throw (Throwable)new InsufficientBalanceException(amountIssued);
        }
        CompositeKey owner = compositeKey2;
        Object currency = ((Issued)amountIssued.getToken()).getProduct();
        Amount amount = new Amount(amountIssued.getQuantity(), currency);
        Iterable $receiver$iv3 = assetStates;
        item$iv$iv2 = $receiver$iv3;
        Pair<ArrayList<StateAndRef<S>>, Amount<T>> destination$iv$iv2 = (Pair<ArrayList<StateAndRef<S>>, Amount<T>>)new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            StateAndRef ref = (StateAndRef)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Issued)((FungibleAsset)ref.getState().getData()).getAmount().getToken()), (Object)((Issued)amountIssued.getToken()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List acceptableCoins = (List)destination$iv$iv2;
        StateAndRef stateAndRef = (StateAndRef)CollectionsKt.firstOrNull((List)acceptableCoins);
        tx.setNotary(stateAndRef != null && (stateAndRef = stateAndRef.getState()) != null ? stateAndRef.getNotary() : null);
        $receiver$iv$iv2 = $receiver$iv3 = (Iterable)acceptableCoins;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            StateAndRef it3 = (StateAndRef)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it3.getState().getNotary(), (Object)tx.getNotary())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        acceptableCoins = (List)destination$iv$iv2;
        destination$iv$iv2 = this.gatherCoins(acceptableCoins, amount);
        $receiver$iv3 = (ArrayList)destination$iv$iv2.component1();
        $receiver$iv$iv2 = (Amount)destination$iv$iv2.component2();
        destination$iv$iv2 = null;
        StateAndRef takeChangeFrom = (StateAndRef)CollectionsKt.lastOrNull((List)((List)gathered));
        Amount change = takeChangeFrom != null && gatheredAmount.compareTo(amount) > 0 ? new Amount(gatheredAmount.getQuantity() - amount.getQuantity(), ((FungibleAsset)takeChangeFrom.getState().getData()).getAmount().getToken()) : null;
        List outputs = change != null ? CollectionsKt.listOf((Object)deriveState.invoke((Object)((StateAndRef)CollectionsKt.last((List)((List)gathered))).getState(), (Object)change, (Object)owner)) : CollectionsKt.emptyList();
        Iterator $i$a$1$filter = gathered.iterator();
        while ($i$a$1$filter.hasNext()) {
            StateAndRef stateAndRef2 = state2 = (StateAndRef)$i$a$1$filter.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)stateAndRef2, (String)"state");
            tx.addInputState(stateAndRef2);
        }
        for (Object state2 : outputs) {
            tx.addOutputState((TransactionState)state2);
        }
        state2 = (Iterable)gathered;
        compositeKey = (CommandData)generateMoveCommand.invoke();
        collection2 = tx;
        $i$a$1$filter = $receiver$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv3 : $receiver$iv$iv) {
            StateAndRef stateAndRef3 = (StateAndRef)item$iv$iv3;
            collection = destination$iv$iv3;
            CompositeKey compositeKey3 = ((FungibleAsset)it.getState().getData()).getOwner();
            collection.add(compositeKey3);
        }
        collection = (List)destination$iv$iv3;
        collection2.addCommand((CommandData)compositeKey, (List)collection);
        $receiver$iv = (Iterable)gathered;
        compositeKey = (CommandData)generateExitCommand.invoke(amountIssued);
        collection2 = tx;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (StateAndRef)element$iv$iv;
            Iterable list$iv$iv = ((FungibleAsset)it.getState().getData()).getExitKeys();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv3;
        collection2.addCommand((CommandData)compositeKey, (List)collection);
        return ((Issued)amountIssued.getToken()).getIssuer().getParty().getOwningKey();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<C> verify(@NotNull TransactionForContract tx, @NotNull List<? extends S> inputs, @NotNull List<? extends S> outputs, @NotNull List<? extends AuthenticatedObject<? extends C>> commands, @Nullable Issued<? extends T> groupingKey) {
        Party party$iv$iv$iv;
        void $receiver$iv$iv$iv;
        Object $receiver$iv;
        boolean expr$iv;
        Object it;
        Requirements $receiver;
        AuthenticatedObject amountExitingLedger;
        Iterable $receiver$iv$iv;
        Object $receiver$iv$iv$iv2;
        Iterable $receiver$iv$iv2;
        Amount outputAmount;
        PartyAndReference deposit;
        Amount inputAmount;
        List matchedCommands;
        block27: {
            boolean bl;
            AuthenticatedObject it$iv;
            Object element$iv$iv$iv;
            Iterable $receiver$iv2;
            Object element$iv$iv3;
            Collection $receiver$iv$iv3;
            Object command;
            void $receiver$iv$iv4;
            Iterable $receiver$iv3;
            boolean bl2;
            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
            Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
            Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
            Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
            boolean bl3 = bl2 = groupingKey != null;
            if (!bl2) {
                String string = "Conserve amount clause can only be used on grouped states";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Iterable iterable = $receiver$iv3 = (Iterable)commands;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv4) {
                command = (AuthenticatedObject)element$iv$iv2;
                if (!(command.getValue() instanceof FungibleAsset.Commands.Move || command.getValue() instanceof FungibleAsset.Commands.Exit)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            matchedCommands = (List)destination$iv$iv;
            Amount amount = FungibleAssetKt.sumFungibleOrNull((Iterable)inputs);
            if (amount == null) {
                throw (Throwable)new IllegalArgumentException("there is at least one asset input for group " + groupingKey);
            }
            inputAmount = amount;
            Issued<? extends T> issued = groupingKey;
            if (issued == null) {
                Intrinsics.throwNpe();
            }
            deposit = issued.getIssuer();
            outputAmount = FungibleAssetKt.sumFungibleOrZero((Iterable)outputs, groupingKey);
            Iterable $receiver$iv4 = inputs;
            command = $receiver$iv4;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv3 : $receiver$iv$iv3) {
                FungibleAsset it2 = (FungibleAsset)element$iv$iv3;
                Iterable list$iv$iv = it2.getExitKeys();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Set exitKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            $receiver$iv$iv3 = matchedCommands;
            Iterable parties$iv = null;
            $receiver$iv$iv2 = $receiver$iv2;
            element$iv$iv3 = $receiver$iv$iv2;
            Collection destination$iv$iv$iv = new ArrayList();
            Iterator $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                element$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)element$iv$iv$iv;
                if (!(it$iv.getValue() instanceof FungibleAsset.Commands.Exit)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $receiver$iv$iv2 = (List)destination$iv$iv$iv;
            $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            destination$iv$iv$iv = new ArrayList();
            $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                element$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)element$iv$iv$iv;
                if (!((Collection)exitKeys == null ? true : it$iv.getSigners().containsAll(exitKeys))) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $receiver$iv$iv2 = (List)destination$iv$iv$iv;
            $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            destination$iv$iv$iv = new ArrayList();
            $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                element$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)element$iv$iv$iv;
                if (!(parties$iv == null ? true : it$iv.getSigningParties().containsAll((Collection<?>)parties$iv))) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $receiver$iv$iv2 = (List)destination$iv$iv$iv;
            $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv2, (int)10));
            $i$a$1$flatMap = $receiver$iv$iv$iv2.iterator();
            while ($i$a$1$flatMap.hasNext()) {
                Object item$iv$iv$iv = $i$a$1$flatMap.next();
                it$iv = (AuthenticatedObject)item$iv$iv$iv;
                Collection $i$f$flatMap = destination$iv$iv$iv;
                Object object = it$iv.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.core.contracts.FungibleAsset.Commands.Exit<T>");
                }
                AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv.getSigners(), it$iv.getSigningParties(), (Object)((FungibleAsset.Commands.Exit)object));
                $i$f$flatMap.add(authenticatedObject);
            }
            $receiver$iv2 = (List)destination$iv$iv$iv;
            parties$iv = $receiver$iv2;
            Object destination$iv$iv3 = new ArrayList();
            for (Object element$iv$iv4 : $receiver$iv$iv) {
                AuthenticatedObject it3 = (AuthenticatedObject)element$iv$iv4;
                if (!Intrinsics.areEqual((Object)((Issued)((FungibleAsset.Commands.Exit)it3.getValue()).getAmount().getToken()), groupingKey)) continue;
                destination$iv$iv3.add(element$iv$iv4);
            }
            AuthenticatedObject exitCommand = (AuthenticatedObject)CollectionsKt.singleOrNull((List)((List)destination$iv$iv3));
            AuthenticatedObject authenticatedObject = exitCommand;
            if (authenticatedObject == null || (authenticatedObject = (FungibleAsset.Commands.Exit)authenticatedObject.getValue()) == null || (authenticatedObject = authenticatedObject.getAmount()) == null) {
                authenticatedObject = new Amount(0L, groupingKey);
            }
            amountExitingLedger = authenticatedObject;
            $receiver = Requirements.INSTANCE;
            destination$iv$iv3 = "there are no zero sized inputs";
            $receiver$iv$iv$iv2 = $receiver;
            Iterable $receiver$iv5 = inputs;
            for (Object element$iv : $receiver$iv5) {
                it = (FungibleAsset)element$iv;
                if (!(it.getAmount().getQuantity() == 0L)) continue;
                bl = false;
                break block27;
            }
            bl = expr$iv = true;
        }
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
        }
        $receiver$iv = "for reference " + deposit.getReference() + " at issuer " + deposit.getParty() + " the amounts balance: " + inputAmount.getQuantity() + " - " + amountExitingLedger.getQuantity() + " != " + outputAmount.getQuantity();
        Requirements this_$iv = $receiver;
        expr$iv = Intrinsics.areEqual((Object)inputAmount, (Object)outputAmount.plus((Amount)amountExitingLedger));
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
        }
        $receiver$iv$iv = inputs;
        $receiver$iv = $receiver$iv$iv;
        Iterable destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv;
            Object element$iv;
            element$iv = (OwnableState)item$iv$iv$iv;
            it = destination$iv$iv$iv;
            CompositeKey $i$a$1$none = it$iv.getOwner();
            it.add($i$a$1$none);
        }
        Set owningPubKeys$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv$iv));
        $receiver$iv$iv2 = commands;
        try {
            AuthenticatedObject it$iv$iv$iv;
            Iterable $receiver$iv$iv$iv$iv$iv;
            Iterable $receiver$iv$iv$iv$iv;
            CompositeKey signer$iv$iv$iv;
            Object item$iv$iv$iv;
            destination$iv$iv$iv = $receiver$iv$iv2;
            Iterator expr$iv2 = null;
            item$iv$iv$iv = null;
            int it$iv = 3;
            Object $i$a$1$map = null;
            if ((it$iv & 1) != 0) {
                signer$iv$iv$iv = null;
            }
            if ((it$iv & 2) != 0) {
                party$iv$iv$iv = null;
            }
            Iterable $i$f$mapTo = $receiver$iv$iv$iv$iv = (Iterable)$receiver$iv$iv$iv2;
            Collection destination$iv$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv$iv;
                if (!(it$iv$iv$iv.getValue() instanceof FungibleAsset.Commands.Move)) continue;
                destination$iv$iv$iv$iv$iv.add(element$iv$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv$iv = $receiver$iv$iv$iv$iv;
            destination$iv$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv$iv;
                if (!(signer$iv$iv$iv == null ? true : it$iv$iv$iv.getSigners().contains(signer$iv$iv$iv))) continue;
                destination$iv$iv$iv$iv$iv.add(element$iv$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv$iv = $receiver$iv$iv$iv$iv;
            destination$iv$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv$iv;
                if (!(party$iv$iv$iv == null ? true : it$iv$iv$iv.getSigningParties().contains(party$iv$iv$iv))) continue;
                destination$iv$iv$iv$iv$iv.add(element$iv$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv$iv = (List)destination$iv$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv$iv = $receiver$iv$iv$iv$iv;
            destination$iv$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv$iv, (int)10));
            for (Object item$iv$iv$iv$iv$iv : $receiver$iv$iv$iv$iv$iv) {
                it$iv$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv$iv;
                Collection collection = destination$iv$iv$iv$iv$iv;
                Object object = it$iv$iv$iv.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.core.contracts.FungibleAsset.Commands.Move");
                }
                AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv$iv.getSigners(), it$iv$iv$iv.getSigningParties(), (Object)((FungibleAsset.Commands.Move)object));
                collection.add(authenticatedObject);
            }
            $receiver$iv$iv$iv2 = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv$iv));
        }
        catch (NoSuchElementException e$iv$iv) {
            throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(FungibleAsset.Commands.Move.class).getQualifiedName() + " command");
        }
        Object command$iv = $receiver$iv$iv$iv2;
        Iterable keysThatSigned$iv = CollectionsKt.toSet((Iterable)command$iv.getSigners());
        Requirements $receiver$iv6 = Requirements.INSTANCE;
        String e$iv$iv = "the owning keys are a subset of the signing keys";
        party$iv$iv$iv = $receiver$iv6;
        boolean expr$iv$iv2 = keysThatSigned$iv.containsAll(owningPubKeys$iv);
        if (!expr$iv$iv2) {
            void $receiver$iv$iv5;
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv$iv5);
        }
        MoveCommand cfr_ignored_0 = (MoveCommand)command$iv.getValue();
        Iterable $receiver$iv7 = matchedCommands;
        keysThatSigned$iv = $receiver$iv7;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv7, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it4;
            AuthenticatedObject expr$iv$iv2 = (AuthenticatedObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            CommandData commandData = (CommandData)it4.getValue();
            collection.add(commandData);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public String toString() {
        return "Conserve amount between inputs and outputs";
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(AbstractConserveAmount.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(T::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/contracts/clause/AbstractConserveAmount$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "finance_main"})
    private static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

