/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts.asset;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import net.corda.contracts.asset.Obligation;
import net.corda.contracts.asset.Obligation$Commands$SetLifecycle$WhenMappings;
import net.corda.contracts.asset.Obligation$State$WhenMappings;
import net.corda.contracts.asset.Obligation$WhenMappings;
import net.corda.contracts.asset.ObligationKt;
import net.corda.contracts.clause.AbstractConserveAmount;
import net.corda.contracts.clause.AbstractIssue;
import net.corda.contracts.clause.BilateralNetState;
import net.corda.contracts.clause.MultilateralNetState;
import net.corda.contracts.clause.NetClause;
import net.corda.contracts.clause.NoZeroSizedOutputs;
import net.corda.core.Utils;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.FungibleAssetKt;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.MoveCommand;
import net.corda.core.contracts.NetCommand;
import net.corda.core.contracts.NetType;
import net.corda.core.contracts.NettableState;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.Timestamp;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.clauses.AllOf;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.contracts.clauses.ClauseVerifier;
import net.corda.core.contracts.clauses.FirstOf;
import net.corda.core.contracts.clauses.GroupClauseVerifier;
import net.corda.core.crypto.AbstractParty;
import net.corda.core.crypto.AnonymousParty;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.Party;
import net.corda.core.crypto.SecureHash;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.Emoji;
import net.corda.core.utilities.NonEmptySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0005;<=>?B\u0005\u00a2\u0006\u0002\u0010\u0004J;\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u001e\u0010\u000f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010\"\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\u0002\u0010\u0012JD\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u00160\u00152\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u001a0\u0019H\u0007J<\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#JO\u0010$\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u00162\u0006\u0010\"\u001a\u00020#2\u001e\u0010\u000f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010\"\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\u0002\u0010&J8\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u001a0\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020#JR\u0010+\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u001a0,2\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000.0\u001a0,2\u0006\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u00020#J(\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u00162\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110,H\u0002J\"\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110,H\u0002J\u0010\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u000204H\u0016JR\u00105\u001a\u00020\n2\u0018\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170.0\u00192\u0018\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170.0\u00192\u0006\u0010\u000b\u001a\u0002042\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0003R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006@"}, d2={"Lnet/corda/contracts/asset/Obligation;", "P", "", "Lnet/corda/core/contracts/Contract;", "()V", "legalContractReference", "Lnet/corda/core/crypto/SecureHash;", "getLegalContractReference", "()Lnet/corda/core/crypto/SecureHash;", "generateCloseOutNetting", "", "tx", "Lnet/corda/core/transactions/TransactionBuilder;", "signer", "Lnet/corda/core/crypto/CompositeKey;", "states", "", "Lnet/corda/contracts/asset/Obligation$State;", "(Lnet/corda/core/transactions/TransactionBuilder;Lnet/corda/core/crypto/CompositeKey;[Lnet/corda/contracts/asset/Obligation$State;)V", "generateExit", "amountIssued", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/asset/Obligation$Terms;", "assetStates", "", "Lnet/corda/core/contracts/StateAndRef;", "generateIssue", "obligor", "Lnet/corda/core/crypto/AbstractParty;", "issuanceDef", "pennies", "", "beneficiary", "notary", "Lnet/corda/core/crypto/Party;", "generatePaymentNetting", "issued", "(Lnet/corda/core/transactions/TransactionBuilder;Lnet/corda/core/contracts/Issued;Lnet/corda/core/crypto/Party;[Lnet/corda/contracts/asset/Obligation$State;)V", "generateSetLifecycle", "statesAndRefs", "lifecycle", "Lnet/corda/contracts/asset/Obligation$Lifecycle;", "generateSettle", "", "assetStatesAndRefs", "Lnet/corda/core/contracts/FungibleAsset;", "moveCommand", "Lnet/corda/core/contracts/MoveCommand;", "getIssuanceDefinitionOrThrow", "getTermsOrThrow", "verify", "Lnet/corda/core/contracts/TransactionForContract;", "verifySetLifecycleCommand", "inputs", "outputs", "setLifecycleCommand", "Lnet/corda/core/contracts/AuthenticatedObject;", "Lnet/corda/contracts/asset/Obligation$Commands$SetLifecycle;", "Clauses", "Commands", "Lifecycle", "State", "Terms", "finance_main"})
public final class Obligation<P>
implements Contract {
    @NotNull
    private final SecureHash legalContractReference = (SecureHash)SecureHash.Companion.sha256("https://www.big-book-of-banking-law.example.gov/cash-settlement.html");

    @NotNull
    public SecureHash getLegalContractReference() {
        return this.legalContractReference;
    }

    /*
     * WARNING - void declaration
     */
    public void verify(@NotNull TransactionForContract tx) {
        AuthenticatedObject it$iv;
        Iterable $receiver$iv$iv$iv;
        void $receiver$iv;
        Iterable $receiver$iv$iv;
        Party party$iv;
        CompositeKey signer$iv;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Collection collection = tx.getCommands();
        Object var3_3 = null;
        Object var4_4 = null;
        int n = 3;
        Object var6_6 = null;
        Clause clause = (Clause)new FirstOf((Clause)new Clauses.Net(), new Clause[]{(Clause)new Clauses.Group()});
        TransactionForContract transactionForContract = tx;
        if ((n & 1) != 0) {
            signer$iv = null;
        }
        if ((n & 2) != 0) {
            party$iv = null;
        }
        Iterable iterable = $receiver$iv$iv = (Iterable)$receiver$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(it$iv.getValue() instanceof Commands)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(signer$iv == null ? true : it$iv.getSigners().contains(signer$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)element$iv$iv$iv;
            if (!(party$iv == null ? true : it$iv.getSigningParties().contains(party$iv))) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        $receiver$iv$iv$iv = $receiver$iv$iv;
        destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
            it$iv = (AuthenticatedObject)item$iv$iv$iv;
            Collection collection2 = destination$iv$iv$iv;
            Object object = it$iv.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.asset.Obligation.Commands");
            }
            AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv.getSigners(), it$iv.getSigningParties(), (Object)((Commands)object));
            collection2.add(authenticatedObject);
        }
        List list = (List)destination$iv$iv$iv;
        ClauseVerifier.verifyClause((TransactionForContract)transactionForContract, (Clause)clause, (List)list);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    private final void verifySetLifecycleCommand(List<? extends FungibleAsset<Terms<P>>> inputs, List<? extends FungibleAsset<Terms<P>>> outputs, TransactionForContract tx, AuthenticatedObject<Commands.SetLifecycle> setLifecycleCommand) {
        FungibleAsset it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Requirements actualOutput;
        boolean bl;
        boolean bl2 = bl = inputs.size() == outputs.size();
        if (!bl) {
            String string = "Number of inputs and outputs must match";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Lifecycle expectedInputLifecycle = ((Commands.SetLifecycle)setLifecycleCommand.getValue()).getInverse();
        Lifecycle expectedOutputLifecycle = ((Commands.SetLifecycle)setLifecycleCommand.getValue()).getLifecycle();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)inputs)) {
            String $receiver$iv2;
            boolean expr$iv;
            int stateIdx = indexedValue.component1();
            FungibleAsset input = (FungibleAsset)indexedValue.component2();
            if (!(input instanceof State)) continue;
            actualOutput = outputs.get(stateIdx);
            Instant deadline = ((State)input).getDueBefore();
            Timestamp timestamp = tx.getTimestamp();
            State expectedOutput = State.copy$default((State)input, expectedOutputLifecycle, null, null, 0L, null, 30, null);
            Requirements $receiver = Requirements.INSTANCE;
            String string = "there is a timestamp from the authority";
            Requirements requirements = $receiver;
            boolean bl3 = expr$iv = timestamp != null;
            if (!expr$iv) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
            }
            $receiver$iv2 = "the due date has passed";
            Requirements this_$iv = $receiver;
            Timestamp timestamp2 = timestamp;
            if (timestamp2 == null) {
                Intrinsics.throwNpe();
            }
            Instant instant = timestamp2.getAfter();
            boolean bl4 = expr$iv = instant != null ? instant.isAfter(deadline) : false;
            if (!expr$iv) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
            }
            $receiver$iv2 = "input state lifecycle is correct";
            this_$iv = $receiver;
            expr$iv = Intrinsics.areEqual((Object)((Object)((State)input).getLifecycle()), (Object)((Object)expectedInputLifecycle));
            if (!expr$iv) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
            }
            $receiver$iv2 = "output state corresponds exactly to input state, with lifecycle changed";
            this_$iv = $receiver;
            expr$iv = Intrinsics.areEqual((Object)expectedOutput, (Object)actualOutput);
            if (expr$iv) continue;
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
        }
        Iterable stateIdx = $receiver$iv = (Iterable)inputs;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (FungibleAsset)element$iv$iv;
            if (!(it instanceof State)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (FungibleAsset)item$iv$iv;
            Collection collection = destination$iv$iv;
            FungibleAsset fungibleAsset = it;
            if (fungibleAsset == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.asset.Obligation.State<P>");
            }
            CompositeKey compositeKey = ((State)fungibleAsset).getBeneficiary();
            collection.add(compositeKey);
        }
        Set owningPubKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set keysThatSigned = CollectionsKt.toSet((Iterable)setLifecycleCommand.getSigners());
        Requirements $receiver = Requirements.INSTANCE;
        destination$iv$iv = "the owning keys are a subset of the signing keys";
        actualOutput = $receiver;
        boolean expr$iv = keysThatSigned.containsAll(owningPubKeys);
        if (!expr$iv) {
            void $receiver$iv3;
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void generateCloseOutNetting(@NotNull TransactionBuilder tx, @NotNull CompositeKey signer, State<P> ... states) {
        State out;
        int expr$iv;
        Object element$iv;
        Object[] this_$iv;
        Object[] $receiver$iv;
        Object[] $receiver;
        Object netState;
        block12: {
            int n;
            boolean expr$iv2;
            State it;
            int $i$f$by;
            block11: {
                boolean bl;
                boolean expr$iv3;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                Intrinsics.checkParameterIsNotNull((Object)signer, (String)"signer");
                Intrinsics.checkParameterIsNotNull(states, (String)"states");
                State state = (State)ArraysKt.firstOrNull((Object[])states);
                netState = state != null ? state.getBilateralNetState() : null;
                $receiver = Requirements.INSTANCE;
                String string = "at least two states are provided";
                Object[] objectArray = $receiver;
                boolean bl2 = expr$iv3 = ((Object[])states).length >= 2;
                if (!expr$iv3) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                }
                $receiver$iv = "all states are in the normal lifecycle state ";
                this_$iv = $receiver;
                Object[] $receiver$iv2 = states;
                for ($i$f$by = 0; $i$f$by < $receiver$iv2.length; ++$i$f$by) {
                    element$iv = $receiver$iv2[$i$f$by];
                    it = (State)element$iv;
                    if (Intrinsics.areEqual((Object)((Object)it.getLifecycle()), (Object)((Object)Lifecycle.NORMAL))) continue;
                    bl = false;
                    break block11;
                }
                bl = expr$iv2 = true;
            }
            if (!expr$iv2) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
            }
            $receiver$iv = "all states must be bilateral nettable";
            this_$iv = $receiver;
            Object[] $receiver$iv3 = states;
            for ($i$f$by = 0; $i$f$by < $receiver$iv3.length; ++$i$f$by) {
                element$iv = $receiver$iv3[$i$f$by];
                it = (State)element$iv;
                if (Intrinsics.areEqual((Object)it.getBilateralNetState(), (Object)netState)) continue;
                n = 0;
                break block12;
            }
            n = expr$iv = 1;
        }
        if (expr$iv == 0) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
        }
        $receiver$iv = "signer is in the state parties";
        this_$iv = $receiver;
        Object object = netState;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if ((expr$iv = ((BilateralNetState)object).getPartyKeys().contains(signer)) == 0) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
        }
        $receiver$iv = states;
        this_$iv = $receiver$iv;
        if (this_$iv.length == 0) {
            throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
        }
        State accumulator$iv = $receiver$iv[0];
        expr$iv = 1;
        int n = ArraysKt.getLastIndex((Object[])$receiver$iv);
        if (expr$iv <= n) {
            while (true) {
                void p2;
                void index$iv;
                element$iv = (State)$receiver$iv[index$iv];
                State p1 = accumulator$iv;
                accumulator$iv = p1.net(p2);
                if (index$iv == n) break;
                ++index$iv;
            }
        }
        if ((out = (State)accumulator$iv).getQuantity() > 0L) {
            tx.addOutputState((ContractState)out);
        }
        tx.addCommand((CommandData)new Commands.Net(NetType.PAYMENT), new CompositeKey[]{signer});
    }

    @NotNull
    public final CompositeKey generateExit(@NotNull TransactionBuilder tx, @NotNull Amount<Issued<Terms<P>>> amountIssued, @NotNull List<StateAndRef<State<P>>> assetStates) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(amountIssued, (String)"amountIssued");
        Intrinsics.checkParameterIsNotNull(assetStates, (String)"assetStates");
        return new Clauses.ConserveAmount().generateExit(tx, amountIssued, assetStates, generateExit.1.INSTANCE, (Function0<CommandData>)((Function0)generateExit.2.INSTANCE), generateExit.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateIssue(@NotNull TransactionBuilder tx, @NotNull AbstractParty obligor, @NotNull Terms<P> issuanceDef, long pennies, @NotNull CompositeKey beneficiary, @NotNull Party notary) {
        boolean bl;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull((Object)obligor, (String)"obligor");
        Intrinsics.checkParameterIsNotNull(issuanceDef, (String)"issuanceDef");
        Intrinsics.checkParameterIsNotNull((Object)beneficiary, (String)"beneficiary");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        boolean bl2 = tx.inputStates().isEmpty();
        if (!bl2) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Iterable $receiver$iv = tx.outputStates();
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TransactionState transactionState = (TransactionState)item$iv$iv;
            Collection collection = destination$iv$iv;
            ContractState contractState = it.getData();
            collection.add(contractState);
        }
        boolean bl3 = bl = ObligationKt.sumObligationsOrNull((List)destination$iv$iv) == null;
        if (!bl) {
            object = "Check failed.";
            throw (Throwable)new IllegalStateException(object.toString());
        }
        TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)new State<P>(Lifecycle.NORMAL, obligor.toAnonymous(), issuanceDef, pennies, beneficiary)), (Party)notary, null, (int)4, null);
        tx.addCommand((CommandData)new Commands.Issue(0L, 1, null), new CompositeKey[]{obligor.getOwningKey()});
    }

    /*
     * WARNING - void declaration
     */
    public final void generatePaymentNetting(@NotNull TransactionBuilder tx, @NotNull Issued<Terms<P>> issued, @NotNull Party notary, State<P> ... states) {
        Object object;
        State it;
        Iterable iterable;
        Object item$iv$iv;
        Object[] $receiver$iv$iv;
        int it2;
        Object list$iv$iv;
        Object key$iv$iv;
        void $receiver$iv$iv2;
        Object[] $receiver$iv;
        boolean expr$iv;
        State it3;
        Object element$iv;
        block13: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
            Intrinsics.checkParameterIsNotNull(issued, (String)"issued");
            Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
            Intrinsics.checkParameterIsNotNull(states, (String)"states");
            Requirements $receiver = Requirements.INSTANCE;
            String string = "all states are in the normal lifecycle state ";
            Requirements requirements = $receiver;
            Object[] $receiver$iv2 = states;
            for (int i = 0; i < $receiver$iv2.length; ++i) {
                element$iv = $receiver$iv2[i];
                it3 = (State)element$iv;
                if (Intrinsics.areEqual((Object)((Object)it3.getLifecycle()), (Object)((Object)Lifecycle.NORMAL))) continue;
                bl = false;
                break block13;
            }
            bl = expr$iv = true;
        }
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
        }
        Object[] this_$iv = $receiver$iv = (Object[])states;
        Map destination$iv$iv = new LinkedHashMap();
        for (int $i$f$by = 0; $i$f$by < ((void)$receiver$iv$iv2).length; ++$i$f$by) {
            Object object2;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            void element$iv$iv = $receiver$iv$iv2[$i$f$by];
            it3 = (State)element$iv$iv;
            key$iv$iv = it3.getMultilateralNetState();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map groups = destination$iv$iv;
        HashMap<CompositeKey, AnonymousParty> partyLookup = new HashMap<CompositeKey, AnonymousParty>();
        Object $receiver$iv3 = states;
        Object[] $i$f$by = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(((Object[])$receiver$iv3).length);
        for (it2 = 0; it2 < $receiver$iv$iv.length; ++it2) {
            item$iv$iv = $receiver$iv$iv[it2];
            key$iv$iv = (State)item$iv$iv;
            iterable = destination$iv$iv2;
            object = it.getBeneficiary();
            iterable.add(object);
        }
        $receiver$iv3 = states;
        iterable = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv3;
        destination$iv$iv2 = new ArrayList(((Object[])$receiver$iv3).length);
        for (it2 = 0; it2 < $receiver$iv$iv.length; ++it2) {
            item$iv$iv = $receiver$iv$iv[it2];
            it = (State)item$iv$iv;
            object = destination$iv$iv2;
            CompositeKey compositeKey = it.getObligor().getOwningKey();
            object.add(compositeKey);
        }
        object = (List)destination$iv$iv2;
        Set signers = CollectionsKt.toSet((Iterable)CollectionsKt.union((Iterable)iterable, (Iterable)((Iterable)object)));
        $receiver$iv3 = states;
        $receiver$iv$iv = $receiver$iv3;
        destination$iv$iv2 = new ArrayList(((Object[])$receiver$iv3).length);
        for (it2 = 0; it2 < $receiver$iv$iv.length; ++it2) {
            item$iv$iv = $receiver$iv$iv[it2];
            it = (State)item$iv$iv;
            iterable = destination$iv$iv2;
            object = it.getObligor();
            iterable.add(object);
        }
        $receiver$iv3 = (List)destination$iv$iv2;
        Iterator<Object> iterator = $receiver$iv3.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            AnonymousParty it4 = (AnonymousParty)element$iv;
            partyLookup.put(it4.getOwningKey(), it4);
        }
        element$iv = groups;
        iterator = element$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $receiver$iv$iv3;
            Iterable $receiver$iv4;
            Map netBalances;
            Map.Entry entry;
            Map.Entry $i$a$3$forEach = entry = (Map.Entry)iterator.next();
            MultilateralNetState netState = (MultilateralNetState)$i$a$3$forEach.getKey();
            $i$a$3$forEach = entry;
            List groupStates = (List)$i$a$3$forEach.getValue();
            Map $i$f$forEach = netBalances = ObligationKt.netAmountsDue(ObligationKt.extractAmountsDue((Terms)issued.getProduct(), ArraysKt.asIterable((Object[])states)));
            void $i$a$2$map = $receiver$iv4;
            Collection destination$iv$iv3 = new ArrayList($receiver$iv4.size());
            void $i$f$map = $receiver$iv$iv3;
            list$iv$iv = $i$f$map.entrySet().iterator();
            while (list$iv$iv.hasNext()) {
                void entry2;
                Map.Entry item$iv$iv2;
                Map.Entry $i$f$groupByTo = item$iv$iv2 = (Map.Entry)list$iv$iv.next();
                iterable = destination$iv$iv3;
                Object v = partyLookup.get(((Pair)entry2.getKey()).getFirst());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"partyLookup[entry.key.first]!!");
                object = new State(Lifecycle.NORMAL, (AnonymousParty)v, netState.getTemplate(), ((Amount)entry2.getValue()).getQuantity(), (CompositeKey)((Pair)entry2.getKey()).getSecond());
                iterable.add(object);
            }
            $receiver$iv4 = (List)destination$iv$iv3;
            for (Object element$iv2 : $receiver$iv4) {
                State it5 = (State)element$iv2;
                TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)it5), (Party)notary, null, (int)4, null);
            }
            tx.addCommand((CommandData)new Commands.Net(NetType.PAYMENT), CollectionsKt.toList((Iterable)signers));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void generateSetLifecycle(@NotNull TransactionBuilder tx, @NotNull List<StateAndRef<State<P>>> statesAndRefs, @NotNull Lifecycle lifecycle, @NotNull Party notary) {
        Map groups;
        void $receiver$iv$iv;
        boolean $receiver$iv3;
        Object element$iv;
        Object object;
        Lifecycle existingLifecycle;
        Terms<P> issuanceDef;
        block12: {
            boolean bl;
            Lifecycle lifecycle2;
            State it;
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
            Intrinsics.checkParameterIsNotNull(statesAndRefs, (String)"statesAndRefs");
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
            Iterable iterable = $receiver$iv2 = (Iterable)statesAndRefs;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                StateAndRef stateAndRef = (StateAndRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                State state = (State)it.getState().getData();
                collection.add(state);
            }
            List states = (List)destination$iv$iv;
            issuanceDef = this.getTermsOrThrow(states);
            switch (Obligation$WhenMappings.$EnumSwitchMapping$0[lifecycle.ordinal()]) {
                case 1: {
                    lifecycle2 = Lifecycle.NORMAL;
                    break;
                }
                case 2: {
                    lifecycle2 = Lifecycle.DEFAULTED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            existingLifecycle = lifecycle2;
            Iterable $receiver$iv3 = states;
            object = $receiver$iv3.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (State)element$iv;
                if (Intrinsics.areEqual((Object)((Object)it.getLifecycle()), (Object)((Object)existingLifecycle))) continue;
                bl = false;
                break block12;
            }
            bl = $receiver$iv3 = true;
        }
        if (!$receiver$iv3) {
            element$iv = "initial lifecycle must be " + (Object)((Object)existingLifecycle) + " for all input states";
            throw (Throwable)new IllegalArgumentException(element$iv.toString());
        }
        Iterable $receiver$iv4 = statesAndRefs;
        element$iv = $receiver$iv4;
        Map destination$iv$iv = new LinkedHashMap();
        Object $i$a$1$all = $receiver$iv$iv.iterator();
        while ($i$a$1$all.hasNext()) {
            Object object2;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = $i$a$1$all.next();
            StateAndRef it = (StateAndRef)element$iv$iv;
            Issued key$iv$iv = (Issued)((State)it.getState().getData()).getAmount().getToken();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv = groups = destination$iv$iv;
        Iterator iterator = destination$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            $i$a$1$all = object = iterator.next();
            List stateAndRefs = (List)$i$a$1$all.getValue();
            ArrayList<CompositeKey> partiesUsed = new ArrayList<CompositeKey>();
            Iterable $receiver$iv5 = stateAndRefs;
            for (Object element$iv2 : $receiver$iv5) {
                StateAndRef stateAndRef = (StateAndRef)element$iv2;
                State outState = State.copy$default((State)stateAndRef.getState().getData(), lifecycle, null, null, 0L, null, 30, null);
                tx.addInputState(stateAndRef);
                TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)outState), (Party)notary, null, (int)4, null);
                partiesUsed.add(((State)stateAndRef.getState().getData()).getBeneficiary());
            }
            tx.addCommand((CommandData)new Commands.SetLifecycle(lifecycle), CollectionsKt.distinct((Iterable)partiesUsed));
        }
        tx.setTime(issuanceDef.getDueBefore(), issuanceDef.getTimeTolerance());
    }

    /*
     * WARNING - void declaration
     */
    public final void generateSettle(@NotNull TransactionBuilder tx, @NotNull Iterable<StateAndRef<State<P>>> statesAndRefs, @NotNull Iterable<? extends StateAndRef<? extends FungibleAsset<P>>> assetStatesAndRefs, @NotNull MoveCommand moveCommand, @NotNull Party notary) {
        Object obligationRemaining;
        StateAndRef it;
        void $receiver$iv$iv;
        Ref.ObjectRef $receiver$iv;
        Amount amount;
        Object object;
        void $receiver$iv$iv2;
        boolean expr$iv;
        Object $receiver$iv2;
        StateAndRef<State<P>> it2;
        Object this_$iv;
        CompositeKey obligationOwner;
        AnonymousParty obligationIssuer;
        List states;
        Object object2;
        Object object3;
        block22: {
            boolean bl;
            boolean expr$iv2;
            Requirements $receiver;
            block21: {
                boolean bl2;
                boolean expr$iv3;
                block20: {
                    boolean bl3;
                    boolean expr$iv4;
                    block19: {
                        boolean bl4;
                        String $receiver$iv22;
                        boolean expr$iv5;
                        block18: {
                            boolean bl5;
                            Object item$iv$iv22;
                            void $receiver$iv$iv3;
                            Iterable<StateAndRef<State<P>>> $receiver$iv3;
                            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                            Intrinsics.checkParameterIsNotNull(statesAndRefs, (String)"statesAndRefs");
                            Intrinsics.checkParameterIsNotNull(assetStatesAndRefs, (String)"assetStatesAndRefs");
                            Intrinsics.checkParameterIsNotNull((Object)moveCommand, (String)"moveCommand");
                            Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
                            Iterable<StateAndRef<State<P>>> iterable = $receiver$iv3 = statesAndRefs;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, (int)10));
                            for (Object item$iv$iv22 : $receiver$iv$iv3) {
                                void it3;
                                StateAndRef stateAndRef = (StateAndRef)item$iv$iv22;
                                object3 = destination$iv$iv;
                                object2 = it3.getState();
                                object3.add(object2);
                            }
                            states = (List)destination$iv$iv;
                            obligationIssuer = ((State)((TransactionState)CollectionsKt.first((List)states)).getData()).getObligor();
                            obligationOwner = ((State)((TransactionState)CollectionsKt.first((List)states)).getData()).getBeneficiary();
                            $receiver = Requirements.INSTANCE;
                            String string = "all fungible asset states use the same notary";
                            item$iv$iv22 = $receiver;
                            Iterable<StateAndRef<FungibleAsset<P>>> $receiver$iv4 = assetStatesAndRefs;
                            for (StateAndRef<FungibleAsset<P>> stateAndRef : $receiver$iv4) {
                                StateAndRef<FungibleAsset<P>> it22 = stateAndRef;
                                if (Intrinsics.areEqual((Object)it22.getState().getNotary(), (Object)notary)) continue;
                                bl5 = false;
                                break block18;
                            }
                            bl5 = expr$iv5 = true;
                        }
                        if (!expr$iv5) {
                            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv22);
                        }
                        $receiver$iv22 = "all obligation states are in the normal state";
                        this_$iv = $receiver;
                        Iterable<StateAndRef<State<P>>> $receiver$iv5 = statesAndRefs;
                        for (StateAndRef<State<P>> stateAndRef : $receiver$iv5) {
                            it2 = stateAndRef;
                            if (Intrinsics.areEqual((Object)((Object)((State)it2.getState().getData()).getLifecycle()), (Object)((Object)Lifecycle.NORMAL))) continue;
                            bl4 = false;
                            break block19;
                        }
                        bl4 = expr$iv4 = true;
                    }
                    if (!expr$iv4) {
                        throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv2);
                    }
                    $receiver$iv2 = "all obligation states use the same notary";
                    this_$iv = $receiver;
                    Iterable<StateAndRef<State<P>>> $receiver$iv6 = statesAndRefs;
                    for (StateAndRef<State<P>> stateAndRef : $receiver$iv6) {
                        it2 = stateAndRef;
                        if (Intrinsics.areEqual((Object)it2.getState().getNotary(), (Object)notary)) continue;
                        bl3 = false;
                        break block20;
                    }
                    bl3 = expr$iv3 = true;
                }
                if (!expr$iv3) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv2);
                }
                $receiver$iv2 = "all obligation states have the same obligor";
                this_$iv = $receiver;
                Iterable<StateAndRef<State<P>>> $receiver$iv7 = statesAndRefs;
                for (StateAndRef<State<P>> stateAndRef : $receiver$iv7) {
                    it2 = stateAndRef;
                    if (Intrinsics.areEqual((Object)((State)it2.getState().getData()).getObligor(), (Object)obligationIssuer)) continue;
                    bl2 = false;
                    break block21;
                }
                bl2 = expr$iv2 = true;
            }
            if (!expr$iv2) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv2);
            }
            $receiver$iv2 = "all obligation states have the same beneficiary";
            this_$iv = $receiver;
            Iterable<StateAndRef<State<P>>> $receiver$iv8 = statesAndRefs;
            for (StateAndRef<State<P>> stateAndRef : $receiver$iv8) {
                it2 = stateAndRef;
                if (Intrinsics.areEqual((Object)((State)it2.getState().getData()).getBeneficiary(), (Object)obligationOwner)) continue;
                bl = false;
                break block22;
            }
            bl = expr$iv = true;
        }
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv2);
        }
        $receiver$iv2 = statesAndRefs;
        object3 = this;
        this_$iv = $receiver$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object object4 : $receiver$iv$iv2) {
            it2 = (StateAndRef<State<P>>)object4;
            object2 = destination$iv$iv;
            object = (State)it2.getState().getData();
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        Issued<Terms<P>> issuanceDef = super.getIssuanceDefinitionOrThrow((Iterable)object2);
        Terms template = (Terms)issuanceDef.getProduct();
        destination$iv$iv = states;
        object2 = amount;
        object3 = amount;
        Iterator<Object> $i$f$by = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            TransactionState $i$f$mapTo = (TransactionState)t;
            object = collection;
            State state = (State)it.getData();
            object.add(state);
        }
        object = (List)collection;
        object2(ObligationKt.sumObligations((Iterable)object).getQuantity(), template.getProduct());
        Object obligationTotal = object3;
        $receiver$iv = new Ref.ObjectRef();
        $receiver$iv.element = obligationTotal;
        HashSet<CompositeKey> assetSigners = new HashSet<CompositeKey>();
        Iterable<StateAndRef<State<P>>> iterable = statesAndRefs;
        for (Object object5 : iterable) {
            it = (StateAndRef)object5;
            tx.addInputState(it);
        }
        Iterable<StateAndRef<FungibleAsset<P>>> iterable2 = assetStatesAndRefs;
        for (Object object6 : iterable2) {
            StateAndRef ref = (StateAndRef)object6;
            if (((Amount)obligationRemaining.element).getQuantity() <= 0L) continue;
            tx.addInputState(ref);
            FungibleAsset assetState = (FungibleAsset)ref.getState().getData();
            Amount amount2 = new Amount(assetState.getAmount().getQuantity(), ((Issued)assetState.getAmount().getToken()).getProduct());
            if (((Amount)obligationRemaining.element).compareTo(amount2) >= 0) {
                TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)assetState.move(assetState.getAmount(), obligationOwner)), (Party)notary, null, (int)4, null);
                obligationRemaining.element = ((Amount)obligationRemaining.element).minus(amount2);
            } else {
                Amount change = new Amount(((Amount)obligationRemaining.element).getQuantity(), assetState.getAmount().getToken());
                TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)assetState.move(change, obligationOwner)), (Party)notary, null, (int)4, null);
                TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)assetState.move(assetState.getAmount().minus(change), assetState.getOwner())), (Party)notary, null, (int)4, null);
                obligationRemaining.element = ((Amount)obligationRemaining.element).minus(new Amount(0L, ((Amount)obligationRemaining.element).getToken()));
            }
            assetSigners.add(assetState.getOwner());
        }
        if (((Amount)obligationRemaining.element).getQuantity() > 0L) {
            TransactionBuilder.addOutputState$default((TransactionBuilder)tx, (ContractState)((ContractState)new State(Lifecycle.NORMAL, obligationIssuer, template, ((Amount)obligationRemaining.element).getQuantity(), obligationOwner)), (Party)notary, null, (int)4, null);
        }
        tx.addCommand((CommandData)moveCommand, CollectionsKt.toList((Iterable)assetSigners));
        tx.addCommand((CommandData)new Commands.Settle(new Amount(obligationTotal.minus((Amount)obligationRemaining.element).getQuantity(), issuanceDef)), new CompositeKey[]{obligationIssuer.getOwningKey()});
        obligationRemaining = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Issued<Terms<P>> getIssuanceDefinitionOrThrow(Iterable<State<P>> states) {
        void $receiver$iv$iv;
        Iterable<State<P>> $receiver$iv;
        Iterable<State<P>> iterable = $receiver$iv = states;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            Issued issued = (Issued)it.getAmount().getToken();
            collection.add(issued);
        }
        return (Issued)CollectionsKt.single((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private final Terms<P> getTermsOrThrow(Iterable<State<P>> states) {
        void $receiver$iv$iv;
        Iterable<State<P>> $receiver$iv;
        Iterable<State<P>> iterable = $receiver$iv = states;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            Terms terms = it.getTemplate();
            collection.add(terms);
        }
        return (Terms)CollectionsKt.single((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\bf\u0018\u00002\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses;", "", "ConserveAmount", "Group", "Issue", "Net", "SetLifecycle", "Settle", "VerifyLifecycle", "finance_main"})
    public static interface Clauses {

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00070\u00060\u0003B\u0005\u00a2\u0006\u0002\u0010\bJ4\u0010\t\u001a&\u0012\"\u0012 \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses$Group;", "P", "", "Lnet/corda/core/contracts/clauses/GroupClauseVerifier;", "Lnet/corda/contracts/asset/Obligation$State;", "Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/asset/Obligation$Terms;", "()V", "groupStates", "", "Lnet/corda/core/contracts/TransactionForContract$InOutGroup;", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "finance_main"})
        public static final class Group<P>
        extends GroupClauseVerifier<State<P>, Commands, Issued<? extends Terms<P>>> {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TransactionForContract.InOutGroup<State<P>, Issued<Terms<P>>>> groupStates(@NotNull TransactionForContract tx) {
                void $receiver$iv$iv$iv;
                State it;
                void $receiver$iv$iv$iv2;
                Object element$iv$iv$iv3;
                void $receiver$iv$iv$iv3;
                void $receiver$iv$iv$iv4;
                Iterable $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                TransactionForContract this_$iv = tx;
                Iterable iterable = $receiver$iv$iv = (Iterable)this_$iv.getInputs();
                Iterable destination$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv2 : $receiver$iv$iv$iv4) {
                    if (!(element$iv$iv$iv2 instanceof State)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv2);
                }
                List inputs$iv = (List)destination$iv$iv$iv;
                Iterable $receiver$iv$iv2 = this_$iv.getOutputs();
                destination$iv$iv$iv = $receiver$iv$iv2;
                Iterable destination$iv$iv$iv2 = new ArrayList();
                for (Object element$iv$iv$iv3 : $receiver$iv$iv$iv3) {
                    if (!(element$iv$iv$iv3 instanceof State)) continue;
                    destination$iv$iv$iv2.add(element$iv$iv$iv3);
                }
                List outputs$iv = (List)destination$iv$iv$iv2;
                Iterable $receiver$iv$iv3 = inputs$iv;
                destination$iv$iv$iv2 = $receiver$iv$iv3;
                Object destination$iv$iv$iv3 = new LinkedHashMap();
                element$iv$iv$iv3 = $receiver$iv$iv$iv2.iterator();
                while (element$iv$iv$iv3.hasNext()) {
                    Object object;
                    Object $receiver$iv$iv$iv$iv = destination$iv$iv$iv3;
                    Object element$iv$iv$iv4 = element$iv$iv$iv3.next();
                    it = (State)element$iv$iv$iv4;
                    Issued key$iv$iv$iv = (Issued)it.getAmount().getToken();
                    Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv4);
                }
                Map inGroups$iv = destination$iv$iv$iv3;
                Iterable $receiver$iv$iv4 = outputs$iv;
                destination$iv$iv$iv3 = $receiver$iv$iv4;
                Map destination$iv$iv$iv4 = new LinkedHashMap();
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Map $receiver$iv$iv$iv$iv = destination$iv$iv$iv4;
                    Object element$iv$iv$iv5 = iterator.next();
                    it = (State)element$iv$iv$iv5;
                    Issued key$iv$iv$iv = (Issued)it.getAmount().getToken();
                    Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                        object = answer$iv$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv$iv;
                    }
                    List list$iv$iv$iv = (List)object;
                    list$iv$iv$iv.add(element$iv$iv$iv5);
                }
                Map outGroups$iv = destination$iv$iv$iv4;
                return this_$iv.groupStatesInternal(inGroups$iv, outGroups$iv);
            }

            public Group() {
                super((Clause)new AllOf((Clause)new NoZeroSizedOutputs(), new Clause[]{(Clause)new FirstOf((Clause)new SetLifecycle(), new Clause[]{(Clause)new AllOf((Clause)new VerifyLifecycle(), new Clause[]{(Clause)new FirstOf((Clause)new Settle(), new Clause[]{new Issue(), new ConserveAmount()})})})}));
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022 \u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0003B\u0005\u00a2\u0006\u0002\u0010\u0007R\"\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses$Issue;", "P", "", "Lnet/corda/contracts/clause/AbstractIssue;", "Lnet/corda/contracts/asset/Obligation$State;", "Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/contracts/asset/Obligation$Terms;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "finance_main"})
        public static final class Issue<P>
        extends AbstractIssue<State<P>, Commands, Terms<P>> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.Issue.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            public Issue() {
                super(1.INSTANCE, 2.INSTANCE);
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022 \u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0003B\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses$ConserveAmount;", "P", "", "Lnet/corda/contracts/clause/AbstractConserveAmount;", "Lnet/corda/contracts/asset/Obligation$State;", "Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/contracts/asset/Obligation$Terms;", "()V", "finance_main"})
        public static final class ConserveAmount<P>
        extends AbstractConserveAmount<State<P>, Commands, Terms<P>> {
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u0002*\b\b\u0002\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016JU\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00170\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u0019R)\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses$Net;", "C", "Lnet/corda/core/contracts/CommandData;", "P", "", "Lnet/corda/contracts/clause/NetClause;", "()V", "lifecycleClause", "Lnet/corda/contracts/asset/Obligation$Clauses$VerifyLifecycle;", "Lnet/corda/core/contracts/ContractState;", "", "getLifecycleClause", "()Lnet/corda/contracts/asset/Obligation$Clauses$VerifyLifecycle;", "toString", "", "verify", "", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "(Lnet/corda/core/contracts/TransactionForContract;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/Unit;)Ljava/util/Set;", "finance_main"})
        public static final class Net<C extends CommandData, P>
        extends NetClause<C, P> {
            @NotNull
            private final VerifyLifecycle<ContractState, C, Unit, P> lifecycleClause = new VerifyLifecycle();

            @NotNull
            public final VerifyLifecycle<ContractState, C, Unit, P> getLifecycleClause() {
                return this.lifecycleClause;
            }

            @NotNull
            public String toString() {
                return "Net obligations";
            }

            @Override
            @NotNull
            public Set<C> verify(@NotNull TransactionForContract tx, @NotNull List<? extends ContractState> inputs, @NotNull List<? extends ContractState> outputs, @NotNull List<? extends AuthenticatedObject<? extends C>> commands, @Nullable Unit groupingKey) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
                Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
                Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
                this.lifecycleClause.verify(tx, inputs, outputs, commands, groupingKey);
                return super.verify(tx, inputs, outputs, commands, groupingKey);
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00070\u00060\u0003B\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016Jh\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00152\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u00152\u0014\u0010\u0019\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0007\u0018\u00010\u0006H\u0016R\"\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses$SetLifecycle;", "P", "", "Lnet/corda/core/contracts/clauses/Clause;", "Lnet/corda/contracts/asset/Obligation$State;", "Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/asset/Obligation$Terms;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "toString", "", "verify", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "finance_main"})
        public static final class SetLifecycle<P>
        extends Clause<State<P>, Commands, Issued<? extends Terms<P>>> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.SetLifecycle.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<State<P>> inputs, @NotNull List<State<P>> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @Nullable Issued<Terms<P>> groupingKey) {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
                Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
                Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
                Collection $receiver$iv = commands;
                try {
                    AuthenticatedObject it$iv$iv;
                    Iterable $receiver$iv$iv$iv$iv;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv$iv$iv;
                    Party party$iv$iv;
                    CompositeKey signer$iv$iv;
                    collection = $receiver$iv;
                    Object var9_8 = null;
                    Object var10_10 = null;
                    int n = 3;
                    Object var12_12 = null;
                    if ((n & 1) != 0) {
                        signer$iv$iv = null;
                    }
                    if ((n & 2) != 0) {
                        party$iv$iv = null;
                    }
                    Iterable iterable = $receiver$iv$iv$iv = (Iterable)$receiver$iv$iv;
                    Collection destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(it$iv$iv.getValue() instanceof Commands.SetLifecycle)) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(signer$iv$iv == null ? true : it$iv$iv.getSigners().contains(signer$iv$iv))) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList();
                    for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                        if (!(party$iv$iv == null ? true : it$iv$iv.getSigningParties().contains(party$iv$iv))) continue;
                        destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                    }
                    $receiver$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                    destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv, (int)10));
                    for (Object item$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                        it$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv;
                        Collection collection2 = destination$iv$iv$iv$iv;
                        Object object = it$iv$iv.getValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.asset.Obligation.Commands.SetLifecycle");
                        }
                        AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv.getSigners(), it$iv$iv.getSigningParties(), (Object)((Commands.SetLifecycle)object));
                        collection2.add(authenticatedObject);
                    }
                    collection = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv));
                }
                catch (NoSuchElementException e$iv) {
                    throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(Commands.SetLifecycle.class).getQualifiedName() + " command");
                }
                Collection command = collection;
                new Obligation().verifySetLifecycleCommand(inputs, outputs, tx, (AuthenticatedObject<Commands.SetLifecycle>)((AuthenticatedObject)command));
                return SetsKt.setOf((Object)command.getValue());
            }

            @NotNull
            public String toString() {
                return "Set obligation lifecycle";
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00070\u00060\u0003B\u0005\u00a2\u0006\u0002\u0010\bJh\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00132\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00160\u00132\u0014\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0007\u0018\u00010\u0006H\u0016R\"\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses$Settle;", "P", "", "Lnet/corda/core/contracts/clauses/Clause;", "Lnet/corda/contracts/asset/Obligation$State;", "Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/asset/Obligation$Terms;", "()V", "requiredCommands", "", "Ljava/lang/Class;", "Lnet/corda/core/contracts/CommandData;", "getRequiredCommands", "()Ljava/util/Set;", "verify", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "inputs", "", "outputs", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "finance_main"})
        public static final class Settle<P>
        extends Clause<State<P>, Commands, Issued<? extends Terms<P>>> {
            @NotNull
            private final Set<Class<? extends CommandData>> requiredCommands = SetsKt.setOf(Commands.Settle.class);

            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return this.requiredCommands;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<State<P>> inputs, @NotNull List<State<P>> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @Nullable Issued<Terms<P>> groupingKey) {
                boolean expr$iv;
                Requirements this_$iv;
                Requirements $receiver;
                void totalPenniesSettled;
                Object $receiver$iv;
                Amount<Issued<Terms<P>>> outputAmount;
                Amount inputAmount;
                AnonymousParty obligor;
                AuthenticatedObject command;
                block44: {
                    boolean bl;
                    boolean expr$iv2;
                    SecureHash secureHash;
                    void it;
                    Collection collection;
                    Object item$iv$iv;
                    Iterator $receiver$iv$iv;
                    Collection destination$iv$iv;
                    Amount totalAmountSettled;
                    Object it2;
                    Set requiredSigners;
                    Map amountReceivedByOwner;
                    block43: {
                        boolean bl2;
                        Amount<Issued<Terms<P>>> debt;
                        List obligations;
                        Object beneficiary;
                        CompositeKey key$iv$iv;
                        void $receiver$iv$iv2;
                        Iterator it3;
                        Iterator $receiver$iv$iv3;
                        AuthenticatedObject it$iv;
                        Object element$iv$iv$iv;
                        Object $receiver$iv$iv$iv;
                        Ref.LongRef $receiver$iv2;
                        Iterable $receiver$iv$iv4;
                        Party party$iv;
                        CompositeKey signer$iv;
                        Collection<AuthenticatedObject> list$iv$iv;
                        FungibleAsset it4;
                        Object $receiver$iv$iv$iv2;
                        Collection $receiver$iv$iv5;
                        Object $receiver$iv3;
                        boolean expr$iv3;
                        FungibleAsset it5;
                        Object element$iv$iv;
                        Object $receiver$iv$iv6;
                        Iterable $receiver$iv4;
                        Object element$iv$iv22;
                        Iterable $receiver$iv$iv7;
                        Iterable $receiver$iv5;
                        Iterable $receiver$iv$iv$iv$iv;
                        AuthenticatedObject $receiver$iv$iv8;
                        boolean bl3;
                        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
                        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
                        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
                        boolean bl4 = bl3 = groupingKey != null;
                        if (!bl3) {
                            String string = "Failed requirement.";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        Collection $receiver$iv6 = commands;
                        try {
                            AuthenticatedObject it$iv$iv;
                            Iterable $receiver$iv$iv$iv3;
                            Party party$iv$iv;
                            CompositeKey signer$iv$iv;
                            Collection collection2 = $receiver$iv6;
                            Object var9_11 = null;
                            Object var10_13 = null;
                            int n = 3;
                            Object var12_16 = null;
                            if ((n & 1) != 0) {
                                signer$iv$iv = null;
                            }
                            if ((n & 2) != 0) {
                                party$iv$iv = null;
                            }
                            Iterable iterable = $receiver$iv$iv$iv3 = (Iterable)$receiver$iv$iv8;
                            Collection destination$iv$iv$iv$iv = new ArrayList();
                            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                                if (!(it$iv$iv.getValue() instanceof Commands.Settle)) continue;
                                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                            }
                            $receiver$iv$iv$iv3 = (List)destination$iv$iv$iv$iv;
                            $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv3;
                            destination$iv$iv$iv$iv = new ArrayList();
                            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                                if (!(signer$iv$iv == null ? true : it$iv$iv.getSigners().contains(signer$iv$iv))) continue;
                                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                            }
                            $receiver$iv$iv$iv3 = (List)destination$iv$iv$iv$iv;
                            $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv3;
                            destination$iv$iv$iv$iv = new ArrayList();
                            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                                if (!(party$iv$iv == null ? true : it$iv$iv.getSigningParties().contains(party$iv$iv))) continue;
                                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                            }
                            $receiver$iv$iv$iv3 = (List)destination$iv$iv$iv$iv;
                            $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv3;
                            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv3, (int)10));
                            for (Object item$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                                it$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv;
                                Collection collection3 = destination$iv$iv$iv$iv;
                                Object object = it$iv$iv.getValue();
                                if (object == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.asset.Obligation.Commands.Settle<P>");
                                }
                                AuthenticatedObject authenticatedObject = new AuthenticatedObject(it$iv$iv.getSigners(), it$iv$iv.getSigningParties(), (Object)((Commands.Settle)object));
                                collection3.add(authenticatedObject);
                            }
                            $receiver$iv$iv8 = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv));
                        }
                        catch (NoSuchElementException e$iv) {
                            throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(Commands.Settle.class).getQualifiedName() + " command");
                        }
                        command = $receiver$iv$iv8;
                        Issued<Terms<P>> issued = groupingKey;
                        if (issued == null) {
                            Intrinsics.throwNpe();
                        }
                        obligor = issued.getIssuer().getParty();
                        Terms template = (Terms)groupingKey.getProduct();
                        Amount amount = ObligationKt.sumObligationsOrNull((Iterable<? extends ContractState>)inputs);
                        if (amount == null) {
                            throw (Throwable)new IllegalArgumentException("there is at least one obligation input for this group");
                        }
                        inputAmount = amount;
                        outputAmount = ObligationKt.sumObligationsOrZero((Iterable<? extends ContractState>)outputs, groupingKey);
                        $receiver$iv$iv$iv$iv = $receiver$iv5 = (Iterable)tx.getOutputs();
                        Collection destination$iv$iv2 = new ArrayList();
                        for (Object element$iv$iv22 : $receiver$iv$iv7) {
                            if (!(element$iv$iv22 instanceof FungibleAsset)) continue;
                            destination$iv$iv2.add(element$iv$iv22);
                        }
                        List assetStates = (List)destination$iv$iv2;
                        $receiver$iv$iv7 = assetStates;
                        destination$iv$iv2 = $receiver$iv4;
                        Collection destination$iv$iv3 = new ArrayList();
                        element$iv$iv22 = $receiver$iv$iv6.iterator();
                        while (element$iv$iv22.hasNext()) {
                            element$iv$iv = element$iv$iv22.next();
                            it5 = (FungibleAsset)element$iv$iv;
                            if (!template.getAcceptableContracts().contains((Object)it5.getContract().getLegalContractReference())) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        $receiver$iv4 = (List)destination$iv$iv3;
                        $receiver$iv$iv6 = $receiver$iv4;
                        destination$iv$iv3 = new ArrayList();
                        element$iv$iv22 = $receiver$iv$iv6.iterator();
                        while (element$iv$iv22.hasNext()) {
                            element$iv$iv = element$iv$iv22.next();
                            it5 = (FungibleAsset)element$iv$iv;
                            if (!CollectionsKt.contains((Iterable)((Iterable)template.getAcceptableIssuedProducts()), (Object)it5.getAmount().getToken())) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        List acceptableAssetStates = (List)destination$iv$iv3;
                        Requirements $receiver2 = Requirements.INSTANCE;
                        $receiver$iv$iv6 = "there are fungible asset state outputs";
                        destination$iv$iv3 = $receiver2;
                        boolean bl5 = expr$iv3 = assetStates.size() > 0;
                        if (!expr$iv3) {
                            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv3);
                        }
                        $receiver$iv3 = "there are defined acceptable fungible asset states";
                        Object this_$iv2 = $receiver2;
                        boolean bl6 = expr$iv3 = acceptableAssetStates.size() > 0;
                        if (!expr$iv3) {
                            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv3);
                        }
                        $receiver$iv3 = acceptableAssetStates;
                        this_$iv2 = $receiver$iv3;
                        Map destination$iv$iv4 = new LinkedHashMap();
                        Iterator $i$f$by = $receiver$iv$iv5.iterator();
                        while ($i$f$by.hasNext()) {
                            Object object;
                            $receiver$iv$iv$iv2 = destination$iv$iv4;
                            Object element$iv$iv3 = $i$f$by.next();
                            it4 = (FungibleAsset)element$iv$iv3;
                            CompositeKey key$iv$iv2 = it4.getOwner();
                            Object value$iv$iv$iv = $receiver$iv$iv$iv2.get(key$iv$iv2);
                            if (value$iv$iv$iv == null) {
                                ArrayList answer$iv$iv$iv = new ArrayList();
                                $receiver$iv$iv$iv2.put(key$iv$iv2, answer$iv$iv$iv);
                                object = answer$iv$iv$iv;
                            } else {
                                object = value$iv$iv$iv;
                            }
                            list$iv$iv = (List)object;
                            list$iv$iv.add((AuthenticatedObject)element$iv$iv3);
                        }
                        amountReceivedByOwner = destination$iv$iv4;
                        $receiver$iv$iv5 = tx.getCommands();
                        destination$iv$iv4 = null;
                        $i$f$by = null;
                        int element$iv$iv3 = 3;
                        it4 = null;
                        if ((element$iv$iv3 & 1) != 0) {
                            signer$iv = null;
                        }
                        if ((element$iv$iv3 & 2) != 0) {
                            party$iv = null;
                        }
                        Iterable $i$a$1$groupBy = $receiver$iv$iv4 = (Iterable)$receiver$iv2;
                        Collection destination$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv2 = $receiver$iv$iv$iv.iterator();
                        while ($receiver$iv$iv$iv2.hasNext()) {
                            element$iv$iv$iv = $receiver$iv$iv$iv2.next();
                            it$iv = (AuthenticatedObject)element$iv$iv$iv;
                            if (!(it$iv.getValue() instanceof MoveCommand)) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        $receiver$iv$iv4 = (List)destination$iv$iv$iv;
                        $receiver$iv$iv$iv = $receiver$iv$iv4;
                        destination$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv2 = $receiver$iv$iv$iv.iterator();
                        while ($receiver$iv$iv$iv2.hasNext()) {
                            element$iv$iv$iv = $receiver$iv$iv$iv2.next();
                            it$iv = (AuthenticatedObject)element$iv$iv$iv;
                            if (!(signer$iv == null ? true : it$iv.getSigners().contains(signer$iv))) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        $receiver$iv$iv4 = (List)destination$iv$iv$iv;
                        $receiver$iv$iv$iv = $receiver$iv$iv4;
                        destination$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv2 = $receiver$iv$iv$iv.iterator();
                        while ($receiver$iv$iv$iv2.hasNext()) {
                            element$iv$iv$iv = $receiver$iv$iv$iv2.next();
                            it$iv = (AuthenticatedObject)element$iv$iv$iv;
                            if (!(party$iv == null ? true : it$iv.getSigningParties().contains(party$iv))) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        $receiver$iv$iv4 = (List)destination$iv$iv$iv;
                        $receiver$iv$iv$iv = $receiver$iv$iv4;
                        destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv4, (int)10));
                        $receiver$iv$iv$iv2 = $receiver$iv$iv$iv.iterator();
                        while ($receiver$iv$iv$iv2.hasNext()) {
                            Object item$iv$iv$iv = $receiver$iv$iv$iv2.next();
                            it$iv = (AuthenticatedObject)item$iv$iv$iv;
                            list$iv$iv = destination$iv$iv$iv;
                            Object object = it$iv.getValue();
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type net.corda.core.contracts.MoveCommand");
                            }
                            AuthenticatedObject $i$f$getOrPut = new AuthenticatedObject(it$iv.getSigners(), it$iv.getSigningParties(), (Object)((MoveCommand)object));
                            list$iv$iv.add($i$f$getOrPut);
                        }
                        List moveCommands = (List)destination$iv$iv$iv;
                        $receiver$iv2 = new Ref.LongRef();
                        $receiver$iv2.element = 0L;
                        Object $receiver$iv7 = inputs;
                        Iterable $i$f$select = $receiver$iv7;
                        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv7, (int)10));
                        $receiver$iv$iv$iv = $receiver$iv$iv3.iterator();
                        while ($receiver$iv$iv$iv.hasNext()) {
                            Object item$iv$iv2 = $receiver$iv$iv$iv.next();
                            $receiver$iv$iv$iv2 = (State)item$iv$iv2;
                            Collection collection4 = destination$iv$iv5;
                            CompositeKey compositeKey = ((Issued)((State)((Object)it3)).getAmount().getToken()).getIssuer().getParty().getOwningKey();
                            collection4.add(compositeKey);
                        }
                        requiredSigners = CollectionsKt.toSet((Iterable)((List)destination$iv$iv5));
                        $receiver$iv$iv$iv = $receiver$iv = (Iterable)inputs;
                        Object destination$iv$iv6 = new LinkedHashMap();
                        it3 = $receiver$iv$iv2.iterator();
                        while (it3.hasNext()) {
                            Object object;
                            Object $receiver$iv$iv$iv4 = destination$iv$iv6;
                            Object element$iv$iv4 = it3.next();
                            it2 = (State)element$iv$iv4;
                            key$iv$iv = ((State)it2).getOwner();
                            Object value$iv$iv$iv = $receiver$iv$iv$iv4.get(key$iv$iv);
                            if (value$iv$iv$iv == null) {
                                ArrayList answer$iv$iv$iv = new ArrayList();
                                $receiver$iv$iv$iv4.put(key$iv$iv, answer$iv$iv$iv);
                                object = answer$iv$iv$iv;
                            } else {
                                object = value$iv$iv$iv;
                            }
                            List list$iv$iv2 = (List)object;
                            list$iv$iv2.add(element$iv$iv4);
                        }
                        $receiver$iv = destination$iv$iv6;
                        $receiver$iv$iv3 = $receiver$iv.entrySet().iterator();
                        while ($receiver$iv$iv3.hasNext()) {
                            boolean element$iv$iv4;
                            destination$iv$iv6 = $receiver$iv7 = $receiver$iv$iv3.next();
                            beneficiary = (CompositeKey)destination$iv$iv6.getKey();
                            destination$iv$iv6 = $receiver$iv7;
                            obligations = (List)destination$iv$iv6.getValue();
                            List list = (List)amountReceivedByOwner.get(beneficiary);
                            Object settled = list != null ? FungibleAssetKt.sumFungibleOrNull((Iterable)list) : null;
                            if (settled == null) continue;
                            debt = ObligationKt.sumObligationsOrZero(obligations, groupingKey);
                            boolean bl7 = element$iv$iv4 = settled.getQuantity() <= debt.getQuantity();
                            if (!element$iv$iv4) {
                                String $i$a$2$groupBy = "Payment of " + settled + " must not exceed debt " + debt;
                                throw (Throwable)new IllegalArgumentException($i$a$2$groupBy.toString());
                            }
                            totalPenniesSettled.element += settled.getQuantity();
                        }
                        totalAmountSettled = new Amount(totalPenniesSettled.element, ((Commands.Settle)command.getValue()).getAmount().getToken());
                        $receiver = Requirements.INSTANCE;
                        beneficiary = "all move commands relate to this contract";
                        obligations = $receiver;
                        Object $receiver$iv8 = (Amount<Issued<Terms<P>>>)moveCommands;
                        debt = $receiver$iv8;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv8, (int)10));
                        Iterator $i$a$3$require = $receiver$iv$iv.iterator();
                        while ($i$a$3$require.hasNext()) {
                            item$iv$iv = $i$a$3$require.next();
                            key$iv$iv = (AuthenticatedObject)item$iv$iv;
                            collection = destination$iv$iv;
                            secureHash = ((MoveCommand)it.getValue()).getContractHash();
                            collection.add(secureHash);
                        }
                        $receiver$iv8 = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv8.iterator();
                        while ($receiver$iv$iv.hasNext()) {
                            Object element$iv = $receiver$iv$iv.next();
                            it2 = (SecureHash)element$iv;
                            if (it2 == null || Intrinsics.areEqual((Object)it2, (Object)new Obligation().getLegalContractReference())) continue;
                            bl2 = false;
                            break block43;
                        }
                        bl2 = expr$iv2 = true;
                    }
                    if (!expr$iv2) {
                        throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                    }
                    $receiver$iv = "amounts paid must match recipients to settle";
                    this_$iv = $receiver;
                    Iterable $receiver$iv9 = inputs;
                    Iterable $i$f$by = $receiver$iv9;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv9, (int)10));
                    it2 = $receiver$iv$iv.iterator();
                    while (it2.hasNext()) {
                        item$iv$iv = it2.next();
                        State $i$f$all = (State)item$iv$iv;
                        collection = destination$iv$iv;
                        secureHash = it.getOwner();
                        collection.add(secureHash);
                    }
                    expr$iv = ((List)destination$iv$iv).containsAll(amountReceivedByOwner.keySet());
                    if (!expr$iv) {
                        throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                    }
                    $receiver$iv = "amount in settle command " + ((Commands.Settle)command.getValue()).getAmount() + " matches settled total " + totalAmountSettled;
                    this_$iv = $receiver;
                    expr$iv = Intrinsics.areEqual(((Commands.Settle)command.getValue()).getAmount(), (Object)totalAmountSettled);
                    if (!expr$iv) {
                        throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                    }
                    $receiver$iv = "signatures are present from all obligors";
                    this_$iv = $receiver;
                    expr$iv = command.getSigners().containsAll(requiredSigners);
                    if (!expr$iv) {
                        throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                    }
                    $receiver$iv = "there are no zero sized inputs";
                    this_$iv = $receiver;
                    $receiver$iv = inputs;
                    for (Object element$iv : $receiver$iv) {
                        it2 = (State)element$iv;
                        if (!(((State)it2).getAmount().getQuantity() == 0L)) continue;
                        bl = false;
                        break block44;
                    }
                    bl = expr$iv = true;
                }
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                }
                $receiver$iv = "at obligor " + obligor + " the obligations after settlement balance";
                this_$iv = $receiver;
                expr$iv = Intrinsics.areEqual(inputAmount, (Object)outputAmount.plus(new Amount(totalPenniesSettled.element, groupingKey)));
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                }
                return SetsKt.setOf((Object)command.getValue());
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u0002*\b\b\u0002\u0010\u0003*\u00020\u0004*\b\b\u0003\u0010\u0005*\u00020\u0006*\b\b\u0004\u0010\u0007*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\bB\u0005\u00a2\u0006\u0002\u0010\tJ6\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00040\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00040\u000e0\rH\u0002JU\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00130\r2\b\u0010\u0014\u001a\u0004\u0018\u00018\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lnet/corda/contracts/asset/Obligation$Clauses$VerifyLifecycle;", "S", "Lnet/corda/core/contracts/ContractState;", "C", "Lnet/corda/core/contracts/CommandData;", "T", "", "P", "Lnet/corda/core/contracts/clauses/Clause;", "()V", "verify", "", "inputs", "", "Lnet/corda/contracts/asset/Obligation$State;", "outputs", "tx", "Lnet/corda/core/contracts/TransactionForContract;", "commands", "Lnet/corda/core/contracts/AuthenticatedObject;", "groupingKey", "(Lnet/corda/core/contracts/TransactionForContract;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Object;)Ljava/util/Set;", "finance_main"})
        public static final class VerifyLifecycle<S extends ContractState, C extends CommandData, T, P>
        extends Clause<S, C, T> {
            @NotNull
            public Set<C> verify(@NotNull TransactionForContract tx, @NotNull List<? extends S> inputs, @NotNull List<? extends S> outputs, @NotNull List<? extends AuthenticatedObject<? extends C>> commands, @Nullable T groupingKey) {
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
                Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
                Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
                Iterable iterable = inputs;
                VerifyLifecycle verifyLifecycle = this;
                void var7_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof State)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv = (Iterable)outputs;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof State)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                return verifyLifecycle.verify(list, list2);
            }

            private final Set<C> verify(List<State<P>> inputs, List<State<P>> outputs) {
                boolean expr$iv;
                String $receiver$iv;
                block5: {
                    boolean bl;
                    boolean expr$iv2;
                    State it;
                    Requirements $receiver;
                    block4: {
                        boolean bl2;
                        $receiver = Requirements.INSTANCE;
                        String string = "all inputs are in the normal state ";
                        Requirements requirements = $receiver;
                        Iterable $receiver$iv2 = inputs;
                        for (Object element$iv : $receiver$iv2) {
                            it = (State)element$iv;
                            if (Intrinsics.areEqual((Object)((Object)it.getLifecycle()), (Object)((Object)Lifecycle.NORMAL))) continue;
                            bl2 = false;
                            break block4;
                        }
                        bl2 = expr$iv2 = true;
                    }
                    if (!expr$iv2) {
                        throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                    }
                    $receiver$iv = "all outputs are in the normal state ";
                    Requirements this_$iv = $receiver;
                    Iterable $receiver$iv3 = outputs;
                    for (Object element$iv : $receiver$iv3) {
                        it = (State)element$iv;
                        if (Intrinsics.areEqual((Object)((Object)it.getLifecycle()), (Object)((Object)Lifecycle.NORMAL))) continue;
                        bl = false;
                        break block5;
                    }
                    bl = expr$iv = true;
                }
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                return SetsKt.emptySet();
            }
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/contracts/asset/Obligation$Lifecycle;", "", "(Ljava/lang/String;I)V", "NORMAL", "DEFAULTED", "finance_main"})
    public static final class Lifecycle
    extends Enum<Lifecycle> {
        public static final /* enum */ Lifecycle NORMAL;
        public static final /* enum */ Lifecycle DEFAULTED;
        private static final /* synthetic */ Lifecycle[] $VALUES;

        static {
            Lifecycle[] lifecycleArray = new Lifecycle[2];
            Lifecycle[] lifecycleArray2 = lifecycleArray;
            lifecycleArray[0] = NORMAL = new Lifecycle();
            lifecycleArray[1] = DEFAULTED = new Lifecycle();
            $VALUES = lifecycleArray;
        }

        public static Lifecycle[] values() {
            return (Lifecycle[])$VALUES.clone();
        }

        public static Lifecycle valueOf(String string) {
            return Enum.valueOf(Lifecycle.class, string);
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0002B9\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003JI\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00028\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lnet/corda/contracts/asset/Obligation$Terms;", "P", "", "acceptableContracts", "Lnet/corda/core/utilities/NonEmptySet;", "Lnet/corda/core/crypto/SecureHash;", "acceptableIssuedProducts", "Lnet/corda/core/contracts/Issued;", "dueBefore", "Ljava/time/Instant;", "timeTolerance", "Ljava/time/Duration;", "(Lnet/corda/core/utilities/NonEmptySet;Lnet/corda/core/utilities/NonEmptySet;Ljava/time/Instant;Ljava/time/Duration;)V", "getAcceptableContracts", "()Lnet/corda/core/utilities/NonEmptySet;", "getAcceptableIssuedProducts", "getDueBefore", "()Ljava/time/Instant;", "product", "getProduct", "()Ljava/lang/Object;", "getTimeTolerance", "()Ljava/time/Duration;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "finance_main"})
    public static final class Terms<P> {
        @NotNull
        private final NonEmptySet<SecureHash> acceptableContracts;
        @NotNull
        private final NonEmptySet<Issued<P>> acceptableIssuedProducts;
        @NotNull
        private final Instant dueBefore;
        @NotNull
        private final Duration timeTolerance;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final P getProduct() {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.acceptableIssuedProducts;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Issued issued = (Issued)item$iv$iv;
                Collection collection = destination$iv$iv;
                Object object = it.getProduct();
                collection.add(object);
            }
            return (P)CollectionsKt.single((Iterable)CollectionsKt.toSet((Iterable)((List)var3_3)));
        }

        @NotNull
        public final NonEmptySet<SecureHash> getAcceptableContracts() {
            return this.acceptableContracts;
        }

        @NotNull
        public final NonEmptySet<Issued<P>> getAcceptableIssuedProducts() {
            return this.acceptableIssuedProducts;
        }

        @NotNull
        public final Instant getDueBefore() {
            return this.dueBefore;
        }

        @NotNull
        public final Duration getTimeTolerance() {
            return this.timeTolerance;
        }

        public Terms(@NotNull NonEmptySet<SecureHash> acceptableContracts, @NotNull NonEmptySet<Issued<P>> acceptableIssuedProducts, @NotNull Instant dueBefore, @NotNull Duration timeTolerance) {
            Intrinsics.checkParameterIsNotNull(acceptableContracts, (String)"acceptableContracts");
            Intrinsics.checkParameterIsNotNull(acceptableIssuedProducts, (String)"acceptableIssuedProducts");
            Intrinsics.checkParameterIsNotNull((Object)dueBefore, (String)"dueBefore");
            Intrinsics.checkParameterIsNotNull((Object)timeTolerance, (String)"timeTolerance");
            this.acceptableContracts = acceptableContracts;
            this.acceptableIssuedProducts = acceptableIssuedProducts;
            this.dueBefore = dueBefore;
            this.timeTolerance = timeTolerance;
        }

        public /* synthetic */ Terms(NonEmptySet nonEmptySet, NonEmptySet nonEmptySet2, Instant instant, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                Duration duration2 = Duration.ofSeconds(30L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofSeconds(30)");
                duration = duration2;
            }
            this((NonEmptySet<SecureHash>)nonEmptySet, nonEmptySet2, instant, duration);
        }

        @NotNull
        public final NonEmptySet<SecureHash> component1() {
            return this.acceptableContracts;
        }

        @NotNull
        public final NonEmptySet<Issued<P>> component2() {
            return this.acceptableIssuedProducts;
        }

        @NotNull
        public final Instant component3() {
            return this.dueBefore;
        }

        @NotNull
        public final Duration component4() {
            return this.timeTolerance;
        }

        @NotNull
        public final Terms<P> copy(@NotNull NonEmptySet<SecureHash> acceptableContracts, @NotNull NonEmptySet<Issued<P>> acceptableIssuedProducts, @NotNull Instant dueBefore, @NotNull Duration timeTolerance) {
            Intrinsics.checkParameterIsNotNull(acceptableContracts, (String)"acceptableContracts");
            Intrinsics.checkParameterIsNotNull(acceptableIssuedProducts, (String)"acceptableIssuedProducts");
            Intrinsics.checkParameterIsNotNull((Object)dueBefore, (String)"dueBefore");
            Intrinsics.checkParameterIsNotNull((Object)timeTolerance, (String)"timeTolerance");
            return new Terms<P>(acceptableContracts, acceptableIssuedProducts, dueBefore, timeTolerance);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Terms copy$default(Terms terms, NonEmptySet nonEmptySet, NonEmptySet nonEmptySet2, Instant instant, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                nonEmptySet = terms.acceptableContracts;
            }
            if ((n & 2) != 0) {
                nonEmptySet2 = terms.acceptableIssuedProducts;
            }
            if ((n & 4) != 0) {
                instant = terms.dueBefore;
            }
            if ((n & 8) != 0) {
                duration = terms.timeTolerance;
            }
            return terms.copy(nonEmptySet, nonEmptySet2, instant, duration);
        }

        public String toString() {
            return "Terms(acceptableContracts=" + this.acceptableContracts + ", acceptableIssuedProducts=" + this.acceptableIssuedProducts + ", dueBefore=" + this.dueBefore + ", timeTolerance=" + this.timeTolerance + ")";
        }

        public int hashCode() {
            NonEmptySet<SecureHash> nonEmptySet = this.acceptableContracts;
            NonEmptySet<Issued<P>> nonEmptySet2 = this.acceptableIssuedProducts;
            Instant instant = this.dueBefore;
            Duration duration = this.timeTolerance;
            return (((nonEmptySet != null ? nonEmptySet.hashCode() : 0) * 31 + (nonEmptySet2 != null ? nonEmptySet2.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Terms)) break block3;
                    Terms terms = (Terms)object;
                    if (!Intrinsics.areEqual(this.acceptableContracts, terms.acceptableContracts) || !Intrinsics.areEqual(this.acceptableIssuedProducts, terms.acceptableIssuedProducts) || !Intrinsics.areEqual((Object)this.dueBefore, (Object)terms.dueBefore) || !Intrinsics.areEqual((Object)this.timeTolerance, (Object)terms.timeTolerance)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0005B7\b\u0016\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B5\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0011\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012J\t\u0010>\u001a\u00020\bH\u00c6\u0003J\t\u0010?\u001a\u00020\u0011H\u00c6\u0003J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0003J\t\u0010A\u001a\u00020\rH\u00c6\u0003J\t\u0010B\u001a\u00020\u000fH\u00c6\u0003JG\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00112\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010G\u001a\u00020HH\u00d6\u0001J0\u0010I\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0018\u0010J\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00150\u00142\u0006\u0010K\u001a\u00020\u000fH\u0016J\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010F\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\b\u0010M\u001a\u00020NH\u0016J\"\u0010O\u001a\u0014\u0012\u0004\u0012\u00020Q\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000P2\u0006\u0010K\u001a\u00020\u000fH\u0016R&\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u0010\t\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0019R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u000f07X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006R"}, d2={"Lnet/corda/contracts/asset/Obligation$State;", "P", "", "Lnet/corda/core/contracts/FungibleAsset;", "Lnet/corda/contracts/asset/Obligation$Terms;", "Lnet/corda/core/contracts/NettableState;", "Lnet/corda/contracts/clause/MultilateralNetState;", "lifecycle", "Lnet/corda/contracts/asset/Obligation$Lifecycle;", "obligor", "Lnet/corda/core/crypto/Party;", "template", "quantity", "", "beneficiary", "Lnet/corda/core/crypto/CompositeKey;", "(Lnet/corda/contracts/asset/Obligation$Lifecycle;Lnet/corda/core/crypto/Party;Lnet/corda/contracts/asset/Obligation$Terms;JLnet/corda/core/crypto/CompositeKey;)V", "Lnet/corda/core/crypto/AnonymousParty;", "(Lnet/corda/contracts/asset/Obligation$Lifecycle;Lnet/corda/core/crypto/AnonymousParty;Lnet/corda/contracts/asset/Obligation$Terms;JLnet/corda/core/crypto/CompositeKey;)V", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getBeneficiary", "()Lnet/corda/core/crypto/CompositeKey;", "bilateralNetState", "Lnet/corda/contracts/clause/BilateralNetState;", "getBilateralNetState", "()Lnet/corda/contracts/clause/BilateralNetState;", "contract", "Lnet/corda/contracts/asset/Obligation;", "Ljava/util/Currency;", "getContract", "()Lnet/corda/contracts/asset/Obligation;", "dueBefore", "Ljava/time/Instant;", "getDueBefore", "()Ljava/time/Instant;", "exitKeys", "", "getExitKeys", "()Ljava/util/Collection;", "getLifecycle", "()Lnet/corda/contracts/asset/Obligation$Lifecycle;", "setLifecycle", "(Lnet/corda/contracts/asset/Obligation$Lifecycle;)V", "multilateralNetState", "getMultilateralNetState", "()Lnet/corda/contracts/clause/MultilateralNetState;", "getObligor", "()Lnet/corda/core/crypto/AnonymousParty;", "owner", "getOwner", "participants", "", "getParticipants", "()Ljava/util/List;", "getQuantity", "()J", "getTemplate", "()Lnet/corda/contracts/asset/Obligation$Terms;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "move", "newAmount", "newOwner", "net", "toString", "", "withNewOwner", "Lkotlin/Pair;", "Lnet/corda/contracts/asset/Obligation$Commands$Move;", "finance_main"})
    public static final class State<P>
    implements FungibleAsset<Terms<P>>,
    NettableState<State<P>, MultilateralNetState<P>> {
        @NotNull
        private final Amount<Issued<Terms<P>>> amount;
        @NotNull
        private final Obligation<Currency> contract;
        @NotNull
        private final Collection<CompositeKey> exitKeys;
        @NotNull
        private final Instant dueBefore;
        @NotNull
        private final List<CompositeKey> participants;
        @NotNull
        private final CompositeKey owner;
        @NotNull
        private Lifecycle lifecycle;
        @NotNull
        private final AnonymousParty obligor;
        @NotNull
        private final Terms<P> template;
        private final long quantity;
        @NotNull
        private final CompositeKey beneficiary;

        @NotNull
        public Amount<Issued<Terms<P>>> getAmount() {
            return this.amount;
        }

        @NotNull
        public Obligation<Currency> getContract() {
            return this.contract;
        }

        @NotNull
        public Collection<CompositeKey> getExitKeys() {
            return this.exitKeys;
        }

        @NotNull
        public final Instant getDueBefore() {
            return this.dueBefore;
        }

        @NotNull
        public List<CompositeKey> getParticipants() {
            return this.participants;
        }

        @NotNull
        public CompositeKey getOwner() {
            return this.owner;
        }

        @NotNull
        public State<P> move(@NotNull Amount<Issued<Terms<P>>> newAmount, @NotNull CompositeKey newOwner) {
            Intrinsics.checkParameterIsNotNull(newAmount, (String)"newAmount");
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return State.copy$default(this, null, null, null, newAmount.getQuantity(), newOwner, 7, null);
        }

        @NotNull
        public String toString() {
            String string;
            switch (Obligation$State$WhenMappings.$EnumSwitchMapping$0[this.lifecycle.ordinal()]) {
                case 1: {
                    string = Emoji.INSTANCE.getBagOfCash() + "Debt(" + this.getAmount() + " due " + this.dueBefore + " to " + this.beneficiary + ")";
                    break;
                }
                case 2: {
                    string = Emoji.INSTANCE.getBagOfCash() + "Debt(" + this.getAmount() + " unpaid by " + this.dueBefore + " to " + this.beneficiary + ")";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @NotNull
        public BilateralNetState<P> getBilateralNetState() {
            boolean bl = Intrinsics.areEqual((Object)((Object)this.lifecycle), (Object)((Object)Lifecycle.NORMAL));
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return new BilateralNetState<P>(SetsKt.setOf((Object[])new CompositeKey[]{this.obligor.getOwningKey(), this.beneficiary}), this.template);
        }

        @NotNull
        public MultilateralNetState<P> getMultilateralNetState() {
            boolean bl = Intrinsics.areEqual((Object)((Object)this.lifecycle), (Object)((Object)Lifecycle.NORMAL));
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return new MultilateralNetState<P>(this.template);
        }

        @NotNull
        public State<P> net(@NotNull State<P> other) {
            Intrinsics.checkParameterIsNotNull(other, (String)"other");
            Object netA = this.getBilateralNetState();
            Object netB = other.getBilateralNetState();
            boolean bl = Intrinsics.areEqual((Object)netA, (Object)netB);
            if (!bl) {
                String string = "net substates of the two state objects must be identical";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (Intrinsics.areEqual((Object)this.obligor.getOwningKey(), (Object)other.obligor.getOwningKey())) {
                return State.copy$default(this, null, null, null, this.quantity + other.quantity, null, 23, null);
            }
            return State.copy$default(this, null, null, null, this.quantity - other.quantity, null, 23, null);
        }

        @NotNull
        public Pair<Commands.Move, State<P>> withNewOwner(@NotNull CompositeKey newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new Pair((Object)new Commands.Move(null, 1, null), (Object)State.copy$default(this, null, null, null, 0L, newOwner, 15, null));
        }

        @NotNull
        public final Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(@NotNull Lifecycle lifecycle) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"<set-?>");
            this.lifecycle = lifecycle;
        }

        @NotNull
        public final AnonymousParty getObligor() {
            return this.obligor;
        }

        @NotNull
        public final Terms<P> getTemplate() {
            return this.template;
        }

        public final long getQuantity() {
            return this.quantity;
        }

        @NotNull
        public final CompositeKey getBeneficiary() {
            return this.beneficiary;
        }

        public State(@NotNull Lifecycle lifecycle, @NotNull AnonymousParty obligor, @NotNull Terms<P> template, long quantity, @NotNull CompositeKey beneficiary) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)obligor, (String)"obligor");
            Intrinsics.checkParameterIsNotNull(template, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)beneficiary, (String)"beneficiary");
            this.lifecycle = lifecycle;
            this.obligor = obligor;
            this.template = template;
            this.quantity = quantity;
            this.beneficiary = beneficiary;
            this.amount = new Amount(this.quantity, (Object)new Issued(this.obligor.ref(new byte[]{0}), this.template));
            this.contract = ObligationKt.getOBLIGATION_PROGRAM_ID();
            this.exitKeys = SetsKt.setOf((Object)this.beneficiary);
            this.dueBefore = this.template.getDueBefore();
            this.participants = CollectionsKt.listOf((Object[])new CompositeKey[]{this.obligor.getOwningKey(), this.beneficiary});
            this.owner = this.beneficiary;
        }

        public /* synthetic */ State(Lifecycle lifecycle, AnonymousParty anonymousParty, Terms terms, long l, CompositeKey compositeKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                lifecycle = Lifecycle.NORMAL;
            }
            this(lifecycle, anonymousParty, terms, l, compositeKey);
        }

        public State(@NotNull Lifecycle lifecycle, @NotNull Party obligor, @NotNull Terms<P> template, long quantity, @NotNull CompositeKey beneficiary) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)obligor, (String)"obligor");
            Intrinsics.checkParameterIsNotNull(template, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)beneficiary, (String)"beneficiary");
            this(lifecycle, obligor.toAnonymous(), template, quantity, beneficiary);
        }

        public /* synthetic */ State(Lifecycle lifecycle, Party party, Terms terms, long l, CompositeKey compositeKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                lifecycle = Lifecycle.NORMAL;
            }
            this(lifecycle, party, terms, l, compositeKey);
        }

        @NotNull
        public final Lifecycle component1() {
            return this.lifecycle;
        }

        @NotNull
        public final AnonymousParty component2() {
            return this.obligor;
        }

        @NotNull
        public final Terms<P> component3() {
            return this.template;
        }

        public final long component4() {
            return this.quantity;
        }

        @NotNull
        public final CompositeKey component5() {
            return this.beneficiary;
        }

        @NotNull
        public final State<P> copy(@NotNull Lifecycle lifecycle, @NotNull AnonymousParty obligor, @NotNull Terms<P> template, long quantity, @NotNull CompositeKey beneficiary) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)obligor, (String)"obligor");
            Intrinsics.checkParameterIsNotNull(template, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)beneficiary, (String)"beneficiary");
            return new State<P>(lifecycle, obligor, template, quantity, beneficiary);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, Lifecycle lifecycle, AnonymousParty anonymousParty, Terms terms, long l, CompositeKey compositeKey, int n, Object object) {
            if ((n & 1) != 0) {
                lifecycle = state.lifecycle;
            }
            if ((n & 2) != 0) {
                anonymousParty = state.obligor;
            }
            if ((n & 4) != 0) {
                terms = state.template;
            }
            if ((n & 8) != 0) {
                l = state.quantity;
            }
            if ((n & 0x10) != 0) {
                compositeKey = state.beneficiary;
            }
            return state.copy(lifecycle, anonymousParty, terms, l, compositeKey);
        }

        public int hashCode() {
            Lifecycle lifecycle = this.lifecycle;
            AnonymousParty anonymousParty = this.obligor;
            Terms<P> terms = this.template;
            long l = this.quantity;
            CompositeKey compositeKey = this.beneficiary;
            return ((((lifecycle != null ? ((Object)((Object)lifecycle)).hashCode() : 0) * 31 + (anonymousParty != null ? anonymousParty.hashCode() : 0)) * 31 + (terms != null ? ((Object)terms).hashCode() : 0)) * 31 + (int)(l ^ l >>> 32)) * 31 + (compositeKey != null ? compositeKey.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.lifecycle), (Object)((Object)state.lifecycle)) || !Intrinsics.areEqual((Object)this.obligor, (Object)state.obligor) || !Intrinsics.areEqual(this.template, state.template) || !(this.quantity == state.quantity) || !Intrinsics.areEqual((Object)this.beneficiary, (Object)state.beneficiary)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bg\u0018\u00002\u00020\u0001:\u0006\u0002\u0003\u0004\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/core/contracts/FungibleAsset$Commands;", "Exit", "Issue", "Move", "Net", "SetLifecycle", "Settle", "finance_main"})
    public static interface Commands
    extends FungibleAsset.Commands {

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/contracts/asset/Obligation$Commands$Net;", "Lnet/corda/core/contracts/NetCommand;", "Lnet/corda/contracts/asset/Obligation$Commands;", "type", "Lnet/corda/core/contracts/NetType;", "(Lnet/corda/core/contracts/NetType;)V", "getType", "()Lnet/corda/core/contracts/NetType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Net
        implements NetCommand,
        Commands {
            @NotNull
            private final NetType type;

            @NotNull
            public NetType getType() {
                return this.type;
            }

            public Net(@NotNull NetType type) {
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                this.type = type;
            }

            @NotNull
            public final NetType component1() {
                return this.getType();
            }

            @NotNull
            public final Net copy(@NotNull NetType type) {
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                return new Net(type);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Net copy$default(Net net, NetType netType, int n, Object object) {
                if ((n & 1) != 0) {
                    netType = net.getType();
                }
                return net.copy(netType);
            }

            public String toString() {
                return "Net(type=" + this.getType() + ")";
            }

            public int hashCode() {
                NetType netType = this.getType();
                return netType != null ? netType.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Net)) break block3;
                        Net net = (Net)object;
                        if (!Intrinsics.areEqual((Object)this.getType(), (Object)net.getType())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/contracts/asset/Obligation$Commands$Move;", "Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Move;", "contractHash", "Lnet/corda/core/crypto/SecureHash;", "(Lnet/corda/core/crypto/SecureHash;)V", "getContractHash", "()Lnet/corda/core/crypto/SecureHash;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Move
        implements Commands,
        FungibleAsset.Commands.Move {
            @Nullable
            private final SecureHash contractHash;

            @Nullable
            public SecureHash getContractHash() {
                return this.contractHash;
            }

            public Move(@Nullable SecureHash contractHash) {
                this.contractHash = contractHash;
            }

            public /* synthetic */ Move(SecureHash secureHash, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    secureHash = null;
                }
                this(secureHash);
            }

            public Move() {
                this(null, 1, null);
            }

            @Nullable
            public final SecureHash component1() {
                return this.getContractHash();
            }

            @NotNull
            public final Move copy(@Nullable SecureHash contractHash) {
                return new Move(contractHash);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Move copy$default(Move move, SecureHash secureHash, int n, Object object) {
                if ((n & 1) != 0) {
                    secureHash = move.getContractHash();
                }
                return move.copy(secureHash);
            }

            public String toString() {
                return "Move(contractHash=" + this.getContractHash() + ")";
            }

            public int hashCode() {
                SecureHash secureHash = this.getContractHash();
                return secureHash != null ? secureHash.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Move)) break block3;
                        Move move = (Move)object;
                        if (!Intrinsics.areEqual((Object)this.getContractHash(), (Object)move.getContractHash())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/contracts/asset/Obligation$Commands$Issue;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Issue;", "Lnet/corda/contracts/asset/Obligation$Commands;", "nonce", "", "(J)V", "getNonce", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class Issue
        implements FungibleAsset.Commands.Issue,
        Commands {
            private final long nonce;

            public long getNonce() {
                return this.nonce;
            }

            public Issue(long nonce) {
                this.nonce = nonce;
            }

            public /* synthetic */ Issue(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    l = Utils.random63BitValue();
                }
                this(l);
            }

            public Issue() {
                this(0L, 1, null);
            }

            public final long component1() {
                return this.getNonce();
            }

            @NotNull
            public final Issue copy(long nonce) {
                return new Issue(nonce);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Issue copy$default(Issue issue, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = issue.getNonce();
                }
                return issue.copy(l);
            }

            public String toString() {
                return "Issue(nonce=" + this.getNonce() + ")";
            }

            public int hashCode() {
                long l = this.getNonce();
                return (int)(l ^ l >>> 32);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Issue)) break block3;
                        Issue issue = (Issue)object;
                        if (!(this.getNonce() == issue.getNonce())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005H\u00c6\u0003J+\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/contracts/asset/Obligation$Commands$Settle;", "P", "", "Lnet/corda/contracts/asset/Obligation$Commands;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/contracts/asset/Obligation$Terms;", "(Lnet/corda/core/contracts/Amount;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "finance_main"})
        public static final class Settle<P>
        implements Commands {
            @NotNull
            private final Amount<Issued<Terms<P>>> amount;

            @NotNull
            public final Amount<Issued<Terms<P>>> getAmount() {
                return this.amount;
            }

            public Settle(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                this.amount = amount;
            }

            @NotNull
            public final Amount<Issued<Terms<P>>> component1() {
                return this.amount;
            }

            @NotNull
            public final Settle<P> copy(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                return new Settle<P>(amount);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Settle copy$default(Settle settle, Amount amount, int n, Object object) {
                if ((n & 1) != 0) {
                    amount = settle.amount;
                }
                return settle.copy(amount);
            }

            public String toString() {
                return "Settle(amount=" + this.amount + ")";
            }

            public int hashCode() {
                Amount<Issued<Terms<P>>> amount = this.amount;
                return amount != null ? amount.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Settle)) break block3;
                        Settle settle = (Settle)object;
                        if (!Intrinsics.areEqual(this.amount, settle.amount)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lnet/corda/contracts/asset/Obligation$Commands$SetLifecycle;", "Lnet/corda/contracts/asset/Obligation$Commands;", "lifecycle", "Lnet/corda/contracts/asset/Obligation$Lifecycle;", "(Lnet/corda/contracts/asset/Obligation$Lifecycle;)V", "inverse", "getInverse", "()Lnet/corda/contracts/asset/Obligation$Lifecycle;", "getLifecycle", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "finance_main"})
        public static final class SetLifecycle
        implements Commands {
            @NotNull
            private final Lifecycle lifecycle;

            @NotNull
            public final Lifecycle getInverse() {
                Lifecycle lifecycle;
                switch (Obligation$Commands$SetLifecycle$WhenMappings.$EnumSwitchMapping$0[this.lifecycle.ordinal()]) {
                    case 1: {
                        lifecycle = Lifecycle.DEFAULTED;
                        break;
                    }
                    case 2: {
                        lifecycle = Lifecycle.NORMAL;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return lifecycle;
            }

            @NotNull
            public final Lifecycle getLifecycle() {
                return this.lifecycle;
            }

            public SetLifecycle(@NotNull Lifecycle lifecycle) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
                this.lifecycle = lifecycle;
            }

            @NotNull
            public final Lifecycle component1() {
                return this.lifecycle;
            }

            @NotNull
            public final SetLifecycle copy(@NotNull Lifecycle lifecycle) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
                return new SetLifecycle(lifecycle);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ SetLifecycle copy$default(SetLifecycle setLifecycle, Lifecycle lifecycle, int n, Object object) {
                if ((n & 1) != 0) {
                    lifecycle = setLifecycle.lifecycle;
                }
                return setLifecycle.copy(lifecycle);
            }

            public String toString() {
                return "SetLifecycle(lifecycle=" + (Object)((Object)this.lifecycle) + ")";
            }

            public int hashCode() {
                Lifecycle lifecycle = this.lifecycle;
                return lifecycle != null ? ((Object)((Object)lifecycle)).hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SetLifecycle)) break block3;
                        SetLifecycle setLifecycle = (SetLifecycle)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.lifecycle), (Object)((Object)setLifecycle.lifecycle))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0004B\u001f\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\b0\u0007H\u00c6\u0003J+\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\b0\u0007H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R&\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/corda/contracts/asset/Obligation$Commands$Exit;", "P", "", "Lnet/corda/contracts/asset/Obligation$Commands;", "Lnet/corda/core/contracts/FungibleAsset$Commands$Exit;", "Lnet/corda/contracts/asset/Obligation$Terms;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "(Lnet/corda/core/contracts/Amount;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "finance_main"})
        public static final class Exit<P>
        implements Commands,
        FungibleAsset.Commands.Exit<Terms<P>> {
            @NotNull
            private final Amount<Issued<Terms<P>>> amount;

            @NotNull
            public Amount<Issued<Terms<P>>> getAmount() {
                return this.amount;
            }

            public Exit(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                this.amount = amount;
            }

            @NotNull
            public final Amount<Issued<Terms<P>>> component1() {
                return this.getAmount();
            }

            @NotNull
            public final Exit<P> copy(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                return new Exit<P>(amount);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Exit copy$default(Exit exit, Amount amount, int n, Object object) {
                if ((n & 1) != 0) {
                    amount = exit.getAmount();
                }
                return exit.copy(amount);
            }

            public String toString() {
                return "Exit(amount=" + this.getAmount() + ")";
            }

            public int hashCode() {
                Amount<Issued<Terms<P>>> amount = this.getAmount();
                return amount != null ? amount.hashCode() : 0;
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Exit)) break block3;
                        Exit exit = (Exit)object;
                        if (!Intrinsics.areEqual(this.getAmount(), exit.getAmount())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

