/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import net.corda.contracts.ICommercialPaperState;
import net.corda.contracts.asset.CashKt;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.Command;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StructuresKt;
import net.corda.core.contracts.Timestamp;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionType;
import net.corda.core.contracts.clauses.AnyOf;
import net.corda.core.contracts.clauses.Clause;
import net.corda.core.contracts.clauses.ClauseVerifier;
import net.corda.core.contracts.clauses.GroupClauseVerifier;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.CryptoUtilities;
import net.corda.core.crypto.Party;
import net.corda.core.crypto.SecureHash;
import net.corda.core.node.services.VaultService;
import net.corda.core.transactions.TransactionBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCommercialPaper
implements Contract {
    private static final Contract JCP_PROGRAM_ID = new JavaCommercialPaper();

    @NotNull
    private List<AuthenticatedObject<Commands>> extractCommands(@NotNull TransactionForContract tx) {
        return tx.getCommands().stream().filter(command -> command.getValue() instanceof Commands).map(command -> new AuthenticatedObject(command.getSigners(), command.getSigningParties(), (Object)((Commands)command.getValue()))).collect(Collectors.toList());
    }

    public void verify(@NotNull TransactionForContract tx) throws IllegalArgumentException {
        ClauseVerifier.verifyClause((TransactionForContract)tx, (Clause)new Clauses.Group(), this.extractCommands(tx));
    }

    @NotNull
    public SecureHash getLegalContractReference() {
        return SecureHash.sha256((String)"https://en.wikipedia.org/wiki/Commercial_paper");
    }

    public TransactionBuilder generateIssue(@NotNull PartyAndReference issuance, @NotNull Amount<Issued<Currency>> faceValue, @Nullable Instant maturityDate, @NotNull Party notary, Integer encumbrance) {
        State state = new State(issuance, issuance.getParty().getOwningKey(), faceValue, maturityDate);
        TransactionState output = new TransactionState((ContractState)state, notary, encumbrance);
        return new TransactionType.General.Builder(notary).withItems(new Object[]{output, new Command((CommandData)new Commands.Issue(), issuance.getParty().getOwningKey())});
    }

    public TransactionBuilder generateIssue(@NotNull PartyAndReference issuance, @NotNull Amount<Issued<Currency>> faceValue, @Nullable Instant maturityDate, @NotNull Party notary) {
        return this.generateIssue(issuance, faceValue, maturityDate, notary, null);
    }

    public void generateRedeem(TransactionBuilder tx, StateAndRef<State> paper, VaultService vault) throws InsufficientBalanceException {
        vault.generateSpend(tx, StructuresKt.withoutIssuer(((State)paper.getState().getData()).getFaceValue()), ((State)paper.getState().getData()).getOwner(), null);
        tx.addInputState(paper);
        tx.addCommand(new Command((CommandData)new Commands.Redeem(), ((State)paper.getState().getData()).getOwner()));
    }

    public void generateMove(TransactionBuilder tx, StateAndRef<State> paper, CompositeKey newOwner) {
        tx.addInputState(paper);
        tx.addOutputState(new TransactionState((ContractState)new State(((State)paper.getState().getData()).getIssuance(), newOwner, ((State)paper.getState().getData()).getFaceValue(), ((State)paper.getState().getData()).getMaturityDate()), paper.getState().getNotary(), paper.getState().getEncumbrance()));
        tx.addCommand(new Command((CommandData)new Commands.Move(), ((State)paper.getState().getData()).getOwner()));
    }

    public static interface Commands
    extends CommandData {

        public static class Issue
        implements Commands {
            public boolean equals(Object obj) {
                return obj instanceof Issue;
            }
        }

        public static class Redeem
        implements Commands {
            public boolean equals(Object obj) {
                return obj instanceof Redeem;
            }
        }

        public static class Move
        implements Commands {
            public boolean equals(Object obj) {
                return obj instanceof Move;
            }
        }
    }

    public static interface Clauses {

        public static class Issue
        extends Clause<State, Commands, State> {
            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return Collections.singleton(Commands.Issue.class);
            }

            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<? extends State> inputs, @NotNull List<? extends State> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @NotNull State groupingKey) {
                AuthenticatedObject cmd = ContractsDSL.requireSingleCommand((Collection)tx.getCommands(), Commands.Issue.class);
                State output = (State)CollectionsKt.single(outputs);
                Timestamp timestampCommand = tx.getTimestamp();
                Instant time = null == timestampCommand ? null : timestampCommand.getBefore();
                ContractsDSL.requireThat(require -> {
                    require.by("output values sum to more than the inputs", inputs.isEmpty());
                    require.by("output values sum to more than the inputs", output.faceValue.getQuantity() > 0L);
                    require.by("must be timestamped", timestampCommand != null);
                    require.by("the maturity date is not in the past", time != null && time.isBefore(output.getMaturityDate()));
                    require.by("output states are issued by a command signer", cmd.getSigners().contains(output.issuance.getParty().getOwningKey()));
                    return Unit.INSTANCE;
                });
                return Collections.singleton(cmd.getValue());
            }
        }

        public static class Redeem
        extends Clause<State, Commands, State> {
            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return Collections.singleton(Commands.Redeem.class);
            }

            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<? extends State> inputs, @NotNull List<? extends State> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @NotNull State groupingKey) {
                AuthenticatedObject cmd = ContractsDSL.requireSingleCommand((Collection)tx.getCommands(), Commands.Redeem.class);
                State input = (State)CollectionsKt.single(inputs);
                if (!cmd.getSigners().contains(input.getOwner())) {
                    throw new IllegalStateException("Failed requirement: the transaction is signed by the owner of the CP");
                }
                Timestamp timestamp = tx.getTimestamp();
                Instant time = null == timestamp ? null : timestamp.getBefore();
                Amount<Issued<Currency>> received = CashKt.sumCashBy(tx.getOutputs(), input.getOwner());
                ContractsDSL.requireThat(require -> {
                    require.by("must be timestamped", timestamp != null);
                    require.by("received amount equals the face value: " + received + " vs " + input.getFaceValue(), received.equals(input.getFaceValue()));
                    require.by("the paper must have matured", time != null && !time.isBefore(input.getMaturityDate()));
                    require.by("the received amount equals the face value", input.getFaceValue().equals((Object)received));
                    require.by("the paper must be destroyed", outputs.isEmpty());
                    return Unit.INSTANCE;
                });
                return Collections.singleton(cmd.getValue());
            }
        }

        public static class Move
        extends Clause<State, Commands, State> {
            @NotNull
            public Set<Class<? extends CommandData>> getRequiredCommands() {
                return Collections.singleton(Commands.Move.class);
            }

            @NotNull
            public Set<Commands> verify(@NotNull TransactionForContract tx, @NotNull List<? extends State> inputs, @NotNull List<? extends State> outputs, @NotNull List<? extends AuthenticatedObject<? extends Commands>> commands, @NotNull State groupingKey) {
                AuthenticatedObject cmd = ContractsDSL.requireSingleCommand((Collection)tx.getCommands(), Commands.Move.class);
                State input = (State)CollectionsKt.single(inputs);
                if (!cmd.getSigners().contains(input.getOwner())) {
                    throw new IllegalStateException("Failed requirement: the transaction is signed by the owner of the CP");
                }
                if (outputs.size() != 1) {
                    throw new IllegalStateException("the state is propagated");
                }
                return Collections.singleton(cmd.getValue());
            }
        }

        public static class Group
        extends GroupClauseVerifier<State, Commands, State> {
            Group() {
                super((Clause)new AnyOf(new Clause[]{new Redeem(), new Move(), new Issue()}));
            }

            @NotNull
            public List<TransactionForContract.InOutGroup<State, State>> groupStates(@NotNull TransactionForContract tx) {
                return tx.groupStates(State.class, State::withoutOwner);
            }
        }
    }

    public static class State
    implements OwnableState,
    ICommercialPaperState {
        private PartyAndReference issuance;
        private CompositeKey owner;
        private Amount<Issued<Currency>> faceValue;
        private Instant maturityDate;

        public State() {
        }

        public State(PartyAndReference issuance, CompositeKey owner, Amount<Issued<Currency>> faceValue, Instant maturityDate) {
            this.issuance = issuance;
            this.owner = owner;
            this.faceValue = faceValue;
            this.maturityDate = maturityDate;
        }

        public State copy() {
            return new State(this.issuance, this.owner, this.faceValue, this.maturityDate);
        }

        @Override
        public ICommercialPaperState withOwner(CompositeKey newOwner) {
            return new State(this.issuance, newOwner, this.faceValue, this.maturityDate);
        }

        @NotNull
        public Pair<CommandData, OwnableState> withNewOwner(@NotNull CompositeKey newOwner) {
            return new Pair((Object)new Commands.Move(), (Object)new State(this.issuance, newOwner, this.faceValue, this.maturityDate));
        }

        @Override
        public ICommercialPaperState withIssuance(PartyAndReference newIssuance) {
            return new State(newIssuance, this.owner, this.faceValue, this.maturityDate);
        }

        @Override
        public ICommercialPaperState withFaceValue(Amount<Issued<Currency>> newFaceValue) {
            return new State(this.issuance, this.owner, newFaceValue, this.maturityDate);
        }

        @Override
        public ICommercialPaperState withMaturityDate(Instant newMaturityDate) {
            return new State(this.issuance, this.owner, this.faceValue, newMaturityDate);
        }

        public PartyAndReference getIssuance() {
            return this.issuance;
        }

        @NotNull
        public CompositeKey getOwner() {
            return this.owner;
        }

        public Amount<Issued<Currency>> getFaceValue() {
            return this.faceValue;
        }

        public Instant getMaturityDate() {
            return this.maturityDate;
        }

        @NotNull
        public Contract getContract() {
            return JCP_PROGRAM_ID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.issuance != null ? !this.issuance.equals((Object)state.issuance) : state.issuance != null) {
                return false;
            }
            if (this.owner != null ? !this.owner.equals(state.owner) : state.owner != null) {
                return false;
            }
            if (this.faceValue != null ? !this.faceValue.equals(state.faceValue) : state.faceValue != null) {
                return false;
            }
            return !(this.maturityDate == null ? state.maturityDate != null : !this.maturityDate.equals(state.maturityDate));
        }

        public int hashCode() {
            int result = this.issuance != null ? this.issuance.hashCode() : 0;
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (this.faceValue != null ? this.faceValue.hashCode() : 0);
            result = 31 * result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            return result;
        }

        public State withoutOwner() {
            return new State(this.issuance, CryptoUtilities.getNullCompositeKey(), this.faceValue, this.maturityDate);
        }

        @NotNull
        public List<CompositeKey> getParticipants() {
            return ImmutableList.of((Object)this.owner);
        }
    }
}

