/*
 * Decompiled with CFR 0.152.
 */
package net.corda.contracts;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.corda.contracts.CommercialPaperLegacyKt;
import net.corda.contracts.ICommercialPaperState;
import net.corda.contracts.asset.CashKt;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AuthenticatedObject;
import net.corda.core.contracts.Command;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.InsufficientBalanceException;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StructuresKt;
import net.corda.core.contracts.Timestamp;
import net.corda.core.contracts.TransactionForContract;
import net.corda.core.contracts.TypeOnlyCommandData;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.CryptoUtilities;
import net.corda.core.crypto.Party;
import net.corda.core.crypto.SecureHash;
import net.corda.core.node.services.VaultService;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.Emoji;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lnet/corda/contracts/CommercialPaperLegacy;", "Lnet/corda/core/contracts/Contract;", "()V", "legalContractReference", "Lnet/corda/core/crypto/SecureHash;", "getLegalContractReference", "()Lnet/corda/core/crypto/SecureHash;", "generateIssue", "Lnet/corda/core/transactions/TransactionBuilder;", "issuance", "Lnet/corda/core/contracts/PartyAndReference;", "faceValue", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "maturityDate", "Ljava/time/Instant;", "notary", "Lnet/corda/core/crypto/Party;", "generateMove", "", "tx", "paper", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/contracts/CommercialPaperLegacy$State;", "newOwner", "Lnet/corda/core/crypto/CompositeKey;", "generateRedeem", "vault", "Lnet/corda/core/node/services/VaultService;", "verify", "Lnet/corda/core/contracts/TransactionForContract;", "Commands", "State", "finance_main"})
public final class CommercialPaperLegacy
implements Contract {
    @NotNull
    private final SecureHash legalContractReference = (SecureHash)SecureHash.Companion.sha256("https://en.wikipedia.org/wiki/Commercial_paper");

    @NotNull
    public SecureHash getLegalContractReference() {
        return this.legalContractReference;
    }

    /*
     * WARNING - void declaration
     */
    public void verify(@NotNull TransactionForContract tx) {
        AuthenticatedObject it$iv$iv;
        Object key$iv$iv$iv;
        Object $receiver$iv$iv$iv$iv;
        void $receiver$iv$iv$iv5;
        Object p1;
        Object element$iv$iv$iv;
        void $receiver$iv$iv$iv2;
        Object element$iv$iv$iv22;
        void $receiver$iv$iv$iv3;
        void $receiver$iv$iv$iv4;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        TransactionForContract this_$iv = tx;
        Iterable iterable2 = $receiver$iv$iv = (Iterable)this_$iv.getInputs();
        Iterable destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv3 : $receiver$iv$iv$iv4) {
            if (!(element$iv$iv$iv3 instanceof State)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv3);
        }
        List inputs$iv = (List)destination$iv$iv$iv;
        Iterable $receiver$iv$iv2 = this_$iv.getOutputs();
        destination$iv$iv$iv = $receiver$iv$iv2;
        Iterable destination$iv$iv$iv2 = new ArrayList();
        for (Object element$iv$iv$iv22 : $receiver$iv$iv$iv3) {
            if (!(element$iv$iv$iv22 instanceof State)) continue;
            destination$iv$iv$iv2.add(element$iv$iv$iv22);
        }
        List outputs$iv = (List)destination$iv$iv$iv2;
        Iterable $receiver$iv$iv3 = inputs$iv;
        destination$iv$iv$iv2 = $receiver$iv$iv3;
        Object destination$iv$iv$iv3 = new LinkedHashMap();
        element$iv$iv$iv22 = $receiver$iv$iv$iv2.iterator();
        while (element$iv$iv$iv22.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv$iv2 = destination$iv$iv$iv3;
            element$iv$iv$iv = element$iv$iv$iv22.next();
            p1 = (State)element$iv$iv$iv;
            State key$iv$iv$iv2 = ((State)p1).withoutOwner();
            Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv2.get(key$iv$iv$iv2);
            if (value$iv$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv$iv2.put(key$iv$iv$iv2, answer$iv$iv$iv$iv);
                object = answer$iv$iv$iv$iv;
            } else {
                object = value$iv$iv$iv$iv;
            }
            List list$iv$iv$iv = (List)object;
            list$iv$iv$iv.add(element$iv$iv$iv);
        }
        Object inGroups$iv = destination$iv$iv$iv3;
        Iterable $receiver$iv$iv4 = outputs$iv;
        destination$iv$iv$iv3 = $receiver$iv$iv4;
        Object destination$iv$iv$iv4 = new LinkedHashMap();
        element$iv$iv$iv = $receiver$iv$iv$iv5.iterator();
        while (element$iv$iv$iv.hasNext()) {
            Object object;
            $receiver$iv$iv$iv$iv = destination$iv$iv$iv4;
            Object element$iv$iv$iv4 = element$iv$iv$iv.next();
            p1 = (State)element$iv$iv$iv4;
            key$iv$iv$iv = ((State)p1).withoutOwner();
            Object value$iv$iv$iv$iv = $receiver$iv$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv$iv);
                object = answer$iv$iv$iv$iv;
            } else {
                object = value$iv$iv$iv$iv;
            }
            List list$iv$iv$iv = (List)object;
            list$iv$iv$iv.add(element$iv$iv$iv4);
        }
        Map outGroups$iv = destination$iv$iv$iv4;
        List groups = this_$iv.groupStatesInternal((Map)inGroups$iv, outGroups$iv);
        Collection $receiver$iv = tx.getCommands();
        try {
            Iterable $receiver$iv$iv$iv$iv3;
            Party party$iv$iv;
            CompositeKey signer$iv$iv;
            inGroups$iv = $receiver$iv;
            outGroups$iv = null;
            $receiver$iv$iv4 = null;
            int $receiver$iv$iv$iv5 = 3;
            inputs$iv = null;
            if (($receiver$iv$iv$iv5 & 1) != 0) {
                signer$iv$iv = null;
            }
            if (($receiver$iv$iv$iv5 & 2) != 0) {
                party$iv$iv = null;
            }
            Iterable $receiver$iv$iv$iv6 = $receiver$iv$iv2;
            destination$iv$iv$iv4 = $receiver$iv$iv$iv6;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv3) {
                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                if (!(it$iv$iv.getValue() instanceof Commands)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv6 = (List)destination$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv3 = $receiver$iv$iv$iv6;
            destination$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv3) {
                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                if (!(signer$iv$iv == null ? true : it$iv$iv.getSigners().contains(signer$iv$iv))) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv6 = (List)destination$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv3 = $receiver$iv$iv$iv6;
            destination$iv$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv3) {
                it$iv$iv = (AuthenticatedObject)element$iv$iv$iv$iv;
                if (!(party$iv$iv == null ? true : it$iv$iv.getSigningParties().contains(party$iv$iv))) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            $receiver$iv$iv$iv6 = (List)destination$iv$iv$iv$iv;
            $receiver$iv$iv$iv$iv3 = $receiver$iv$iv$iv6;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv$iv6, (int)10));
            for (Object item$iv$iv$iv$iv : $receiver$iv$iv$iv$iv3) {
                it$iv$iv = (AuthenticatedObject)item$iv$iv$iv$iv;
                key$iv$iv$iv = destination$iv$iv$iv$iv;
                Object object = it$iv$iv.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.contracts.CommercialPaperLegacy.Commands");
                }
                $receiver$iv$iv$iv$iv = new AuthenticatedObject(it$iv$iv.getSigners(), it$iv$iv.getSigningParties(), (Object)((Commands)object));
                key$iv$iv$iv.add($receiver$iv$iv$iv$iv);
            }
            iterable2 = (AuthenticatedObject)CollectionsKt.single((List)((List)destination$iv$iv$iv$iv));
        }
        catch (NoSuchElementException e$iv) {
            throw (Throwable)new IllegalStateException("Required " + Reflection.getOrCreateKotlinClass(Commands.class).getQualifiedName() + " command");
        }
        Iterable command = iterable2;
        Timestamp timestamp = tx.getTimestamp();
        for (Iterable iterable2 : groups) {
            String $receiver;
            State input;
            List inputs = iterable2.component1();
            List outputs = iterable2.component2();
            State key = (State)iterable2.component3();
            Commands commands = (Commands)command.getValue();
            if (commands instanceof Commands.Move) {
                String $receiver$iv2;
                Object item$iv$iv$iv$iv;
                input = (State)CollectionsKt.single((List)inputs);
                Requirements $receiver2 = Requirements.INSTANCE;
                item$iv$iv$iv$iv = "the transaction is signed by the owner of the CP";
                it$iv$iv = $receiver2;
                boolean expr$iv = command.getSigners().contains(input.getOwner());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
                }
                $receiver$iv2 = "the state is propagated";
                Requirements this_$iv2 = $receiver2;
                expr$iv = outputs.size() == 1;
                if (expr$iv) continue;
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
            }
            if (commands instanceof Commands.Redeem) {
                String $receiver$iv3;
                boolean expr$iv;
                input = (State)CollectionsKt.single((List)inputs);
                Amount<Issued<Currency>> received = CashKt.sumCashBy(tx.getOutputs(), input.getOwner());
                Object object = timestamp;
                if (object == null || (object = object.getAfter()) == null) {
                    throw (Throwable)new IllegalArgumentException("Redemptions must be timestamped");
                }
                Object time = object;
                $receiver = Requirements.INSTANCE;
                String expr$iv2 = "the paper must have matured";
                String $i$f$by = $receiver;
                boolean bl = expr$iv = ((Instant)time).compareTo(input.getMaturityDate()) >= 0;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
                }
                $receiver$iv3 = "the received amount equals the face value";
                String this_$iv3 = $receiver;
                expr$iv = Intrinsics.areEqual(received, input.getFaceValue());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
                }
                $receiver$iv3 = "the paper must be destroyed";
                this_$iv3 = $receiver;
                expr$iv = outputs.isEmpty();
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
                }
                $receiver$iv3 = "the transaction is signed by the owner of the CP";
                this_$iv3 = $receiver;
                expr$iv = command.getSigners().contains(input.getOwner());
                if (expr$iv) continue;
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
            }
            if (commands instanceof Commands.Issue) {
                String $receiver$iv4;
                State output = (State)CollectionsKt.single((List)outputs);
                Object object = timestamp;
                if (object == null || (object = object.getBefore()) == null) {
                    throw (Throwable)new IllegalArgumentException("Issuances must be timestamped");
                }
                Object time = object;
                Requirements $receiver3 = Requirements.INSTANCE;
                $receiver = "output states are issued by a command signer";
                Requirements $receiver$iv5 = $receiver3;
                boolean expr$iv = command.getSigners().contains(output.getIssuance().getParty().getOwningKey());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
                }
                $receiver$iv4 = "output values sum to more than the inputs";
                Requirements this_$iv4 = $receiver3;
                boolean bl = expr$iv = output.getFaceValue().getQuantity() > (long)0;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
                }
                $receiver$iv4 = "the maturity date is not in the past";
                this_$iv4 = $receiver3;
                boolean bl2 = expr$iv = ((Instant)time).compareTo(output.getMaturityDate()) < 0;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
                }
                $receiver$iv4 = "output values sum to more than the inputs";
                this_$iv4 = $receiver3;
                expr$iv = inputs.isEmpty();
                if (expr$iv) continue;
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
            }
            throw (Throwable)new IllegalArgumentException("Unrecognised command");
        }
    }

    @NotNull
    public final TransactionBuilder generateIssue(@NotNull PartyAndReference issuance, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
        Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
        Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        State state = new State(issuance, issuance.getParty().getOwningKey(), faceValue, maturityDate);
        return new TransactionBuilder(null, notary, null, null, null, null, null, null, null, 509, null).withItems(new Object[]{state, new Command((CommandData)new Commands.Issue(), issuance.getParty().getOwningKey())});
    }

    public final void generateMove(@NotNull TransactionBuilder tx, @NotNull StateAndRef<State> paper, @NotNull CompositeKey newOwner) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(paper, (String)"paper");
        Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
        tx.addInputState(paper);
        tx.addOutputState((ContractState)((State)paper.getState().getData()).withOwner(newOwner));
        tx.addCommand(new Command((CommandData)new Commands.Move(), ((State)paper.getState().getData()).getOwner()));
    }

    public final void generateRedeem(@NotNull TransactionBuilder tx, @NotNull StateAndRef<State> paper, @NotNull VaultService vault) throws InsufficientBalanceException {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(paper, (String)"paper");
        Intrinsics.checkParameterIsNotNull((Object)vault, (String)"vault");
        VaultService.DefaultImpls.generateSpend$default((VaultService)vault, (TransactionBuilder)tx, (Amount)StructuresKt.withoutIssuer(((State)paper.getState().getData()).getFaceValue()), (CompositeKey)((State)paper.getState().getData()).getOwner(), null, (int)8, null);
        tx.addInputState(paper);
        tx.addCommand(new Command((CommandData)new Commands.Redeem(), ((State)paper.getState().getData()).getOwner()));
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J=\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\b\u0010)\u001a\u00020*H\u0016J\u001c\u0010+\u001a\u00020\u00022\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0004H\u0016J\u0010\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\fH\u0016J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u0000022\u0006\u00104\u001a\u00020\u0006H\u0016J\u0010\u00105\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u0006H\u0016J\u0006\u00106\u001a\u00020\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00067"}, d2={"Lnet/corda/contracts/CommercialPaperLegacy$State;", "Lnet/corda/core/contracts/OwnableState;", "Lnet/corda/contracts/ICommercialPaperState;", "issuance", "Lnet/corda/core/contracts/PartyAndReference;", "owner", "Lnet/corda/core/crypto/CompositeKey;", "faceValue", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "maturityDate", "Ljava/time/Instant;", "(Lnet/corda/core/contracts/PartyAndReference;Lnet/corda/core/crypto/CompositeKey;Lnet/corda/core/contracts/Amount;Ljava/time/Instant;)V", "contract", "Lnet/corda/contracts/CommercialPaperLegacy;", "getContract", "()Lnet/corda/contracts/CommercialPaperLegacy;", "getFaceValue", "()Lnet/corda/core/contracts/Amount;", "getIssuance", "()Lnet/corda/core/contracts/PartyAndReference;", "getMaturityDate", "()Ljava/time/Instant;", "getOwner", "()Lnet/corda/core/crypto/CompositeKey;", "participants", "", "getParticipants", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "withFaceValue", "newFaceValue", "withIssuance", "newIssuance", "withMaturityDate", "newMaturityDate", "withNewOwner", "Lkotlin/Pair;", "Lnet/corda/contracts/CommercialPaperLegacy$Commands$Move;", "newOwner", "withOwner", "withoutOwner", "finance_main"})
    public static final class State
    implements OwnableState,
    ICommercialPaperState {
        @NotNull
        private final CommercialPaperLegacy contract;
        @NotNull
        private final List<CompositeKey> participants;
        @NotNull
        private final PartyAndReference issuance;
        @NotNull
        private final CompositeKey owner;
        @NotNull
        private final Amount<Issued<Currency>> faceValue;
        @NotNull
        private final Instant maturityDate;

        @NotNull
        public CommercialPaperLegacy getContract() {
            return this.contract;
        }

        @NotNull
        public List<CompositeKey> getParticipants() {
            return this.participants;
        }

        @NotNull
        public final State withoutOwner() {
            return State.copy$default(this, null, CryptoUtilities.getNullCompositeKey(), null, null, 13, null);
        }

        @NotNull
        public Pair<Commands.Move, State> withNewOwner(@NotNull CompositeKey newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new Pair((Object)new Commands.Move(), (Object)State.copy$default(this, null, newOwner, null, null, 13, null));
        }

        @NotNull
        public String toString() {
            return Emoji.INSTANCE.getNewspaper() + "CommercialPaper(of " + this.faceValue + " redeemable on " + this.maturityDate + " by '" + this.issuance + "', owned by " + this.getOwner() + ")";
        }

        @Override
        @NotNull
        public ICommercialPaperState withOwner(@NotNull CompositeKey newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return State.copy$default(this, null, newOwner, null, null, 13, null);
        }

        @Override
        @NotNull
        public ICommercialPaperState withIssuance(@NotNull PartyAndReference newIssuance) {
            Intrinsics.checkParameterIsNotNull((Object)newIssuance, (String)"newIssuance");
            return State.copy$default(this, newIssuance, null, null, null, 14, null);
        }

        @Override
        @NotNull
        public ICommercialPaperState withFaceValue(@NotNull Amount<Issued<Currency>> newFaceValue) {
            Intrinsics.checkParameterIsNotNull(newFaceValue, (String)"newFaceValue");
            return State.copy$default(this, null, null, newFaceValue, null, 11, null);
        }

        @Override
        @NotNull
        public ICommercialPaperState withMaturityDate(@NotNull Instant newMaturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)newMaturityDate, (String)"newMaturityDate");
            return State.copy$default(this, null, null, null, newMaturityDate, 7, null);
        }

        @NotNull
        public final PartyAndReference getIssuance() {
            return this.issuance;
        }

        @NotNull
        public CompositeKey getOwner() {
            return this.owner;
        }

        @NotNull
        public final Amount<Issued<Currency>> getFaceValue() {
            return this.faceValue;
        }

        @NotNull
        public final Instant getMaturityDate() {
            return this.maturityDate;
        }

        public State(@NotNull PartyAndReference issuance, @NotNull CompositeKey owner, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            this.issuance = issuance;
            this.owner = owner;
            this.faceValue = faceValue;
            this.maturityDate = maturityDate;
            this.contract = CommercialPaperLegacyKt.getCP_LEGACY_PROGRAM_ID();
            this.participants = CollectionsKt.listOf((Object)this.getOwner());
        }

        @NotNull
        public final PartyAndReference component1() {
            return this.issuance;
        }

        @NotNull
        public final CompositeKey component2() {
            return this.getOwner();
        }

        @NotNull
        public final Amount<Issued<Currency>> component3() {
            return this.faceValue;
        }

        @NotNull
        public final Instant component4() {
            return this.maturityDate;
        }

        @NotNull
        public final State copy(@NotNull PartyAndReference issuance, @NotNull CompositeKey owner, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            return new State(issuance, owner, faceValue, maturityDate);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, PartyAndReference partyAndReference, CompositeKey compositeKey, Amount amount, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                partyAndReference = state.issuance;
            }
            if ((n & 2) != 0) {
                compositeKey = state.getOwner();
            }
            if ((n & 4) != 0) {
                amount = state.faceValue;
            }
            if ((n & 8) != 0) {
                instant = state.maturityDate;
            }
            return state.copy(partyAndReference, compositeKey, amount, instant);
        }

        public int hashCode() {
            PartyAndReference partyAndReference = this.issuance;
            CompositeKey compositeKey = this.getOwner();
            Amount<Issued<Currency>> amount = this.faceValue;
            Instant instant = this.maturityDate;
            return (((partyAndReference != null ? partyAndReference.hashCode() : 0) * 31 + (compositeKey != null ? compositeKey.hashCode() : 0)) * 31 + (amount != null ? amount.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual((Object)this.issuance, (Object)state.issuance) || !Intrinsics.areEqual((Object)this.getOwner(), (Object)state.getOwner()) || !Intrinsics.areEqual(this.faceValue, state.faceValue) || !Intrinsics.areEqual((Object)this.maturityDate, (Object)state.maturityDate)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/contracts/CommercialPaperLegacy$Commands;", "Lnet/corda/core/contracts/CommandData;", "Issue", "Move", "Redeem", "finance_main"})
    public static interface Commands
    extends CommandData {

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/contracts/CommercialPaperLegacy$Commands$Move;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "Lnet/corda/contracts/CommercialPaperLegacy$Commands;", "()V", "finance_main"})
        public static final class Move
        extends TypeOnlyCommandData
        implements Commands {
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/contracts/CommercialPaperLegacy$Commands$Redeem;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "Lnet/corda/contracts/CommercialPaperLegacy$Commands;", "()V", "finance_main"})
        public static final class Redeem
        extends TypeOnlyCommandData
        implements Commands {
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/contracts/CommercialPaperLegacy$Commands$Issue;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "Lnet/corda/contracts/CommercialPaperLegacy$Commands;", "()V", "finance_main"})
        public static final class Issue
        extends TypeOnlyCommandData
        implements Commands {
        }
    }
}

