/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.services;

import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.core.contracts.Attachment;
import net.corda.core.contracts.ContractAttachment;
import net.corda.core.crypto.SecureHash;
import net.corda.core.crypto.SecureHashKt;
import net.corda.core.internal.AbstractAttachment;
import net.corda.core.internal.AbstractAttachmentKt;
import net.corda.core.internal.InternalUtils;
import net.corda.core.node.services.AttachmentStorage;
import net.corda.core.node.services.vault.AttachmentQueryCriteria;
import net.corda.core.node.services.vault.AttachmentSort;
import net.corda.core.node.services.vault.Builder;
import net.corda.core.node.services.vault.ColumnPredicate;
import net.corda.core.node.services.vault.Sort;
import net.corda.core.serialization.SingletonSerializeAsToken;
import net.corda.nodeapi.internal.ContractsScanningKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u000289B\u0005\u00a2\u0006\u0002\u0010\u0003J+\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u0002H\u00132\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0019\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\"\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00190\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u00020\u00122\n\u0010#\u001a\u00060\u0007j\u0002`\u0019H\u0016J\u0014\u0010$\u001a\u00060\u0007j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010$\u001a\u00060\u0007j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u001fH\u0016JT\u0010'\u001a\u00060\u0007j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001f2\u0014\b\u0002\u0010(\u001a\u000e\u0012\b\u0012\u00060\u001fj\u0002`)\u0018\u00010\u001d2\u0010\b\u0002\u0010#\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u00192\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001dH\u0002JP\u0010,\u001a\u00060\u0007j\u0002`\u00192\u0010\u0010(\u001a\f\u0012\b\u0012\u00060\u001fj\u0002`)0\u001d2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0010\b\u0002\u0010#\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u00192\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001dH\u0007J\u001a\u0010,\u001a\u00020-2\n\u0010#\u001a\u00060\u0007j\u0002`\u00192\u0006\u0010.\u001a\u00020/J\u0014\u00100\u001a\u00060\u0007j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u000b2\u0006\u00102\u001a\u00020\u0007H\u0016J$\u00103\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00190\u001d2\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\t\u001a6\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u0005j\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006:"}, d2={"Lnet/corda/testing/services/MockAttachmentStorage;", "Lnet/corda/core/node/services/AttachmentStorage;", "Lnet/corda/core/serialization/SingletonSerializeAsToken;", "()V", "_contractClasses", "Ljava/util/HashMap;", "Lnet/corda/testing/services/MockAttachmentStorage$ContractAttachmentMetadata;", "Lnet/corda/core/crypto/SecureHash;", "Lkotlin/collections/HashMap;", "_files", "Lkotlin/Pair;", "Lnet/corda/core/contracts/Attachment;", "", "files", "", "getFiles", "()Ljava/util/Map;", "criteriaFilter", "", "C", "metadata", "predicate", "Lnet/corda/core/node/services/vault/ColumnPredicate;", "(Ljava/lang/Object;Lnet/corda/core/node/services/vault/ColumnPredicate;)Z", "getAttachmentIdAndBytes", "Lnet/corda/core/node/services/AttachmentId;", "jar", "Ljava/io/InputStream;", "getLatestContractAttachments", "", "contractClassName", "", "minContractVersion", "", "hasAttachment", "attachmentId", "importAttachment", "uploader", "filename", "importAttachmentInternal", "contractClassNames", "Lnet/corda/core/contracts/ContractClassName;", "signers", "Ljava/security/PublicKey;", "importContractAttachment", "", "contractAttachment", "Lnet/corda/core/contracts/ContractAttachment;", "importOrGetAttachment", "openAttachment", "id", "queryAttachments", "criteria", "Lnet/corda/core/node/services/vault/AttachmentQueryCriteria;", "sorting", "Lnet/corda/core/node/services/vault/AttachmentSort;", "ContractAttachmentMetadata", "MockAttachment", "test-utils"})
@SourceDebugExtension(value={"SMAP\nMockAttachmentStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockAttachmentStorage.kt\nnet/corda/testing/services/MockAttachmentStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1747#2,3:136\n1549#2:147\n1620#2,3:148\n478#3,7:139\n1#4:146\n*S KotlinDebug\n*F\n+ 1 MockAttachmentStorage.kt\nnet/corda/testing/services/MockAttachmentStorage\n*L\n59#1:136,3\n118#1:147\n118#1:148,3\n80#1:139,7\n*E\n"})
public final class MockAttachmentStorage
extends SingletonSerializeAsToken
implements AttachmentStorage {
    @NotNull
    private final HashMap<SecureHash, Pair<Attachment, byte[]>> _files = new HashMap();
    @NotNull
    private final HashMap<ContractAttachmentMetadata, SecureHash> _contractClasses = new HashMap();

    @NotNull
    public final Map<SecureHash, Pair<Attachment, byte[]>> getFiles() {
        return this._files;
    }

    @NotNull
    public SecureHash importAttachment(@NotNull InputStream jar) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        return this.importAttachment(jar, "unknown", null);
    }

    @NotNull
    public SecureHash importAttachment(@NotNull InputStream jar, @NotNull String uploader, @Nullable String filename) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
        return (SecureHash)ContractsScanningKt.withContractsInJar((InputStream)jar, (Function2)((Function2)new Function2<List<? extends String>, InputStream, SecureHash>(this, uploader){
            final /* synthetic */ MockAttachmentStorage this$0;
            final /* synthetic */ String $uploader;
            {
                this.this$0 = $receiver;
                this.$uploader = $uploader;
                super(2);
            }

            @NotNull
            public final SecureHash invoke(@NotNull List<String> contractClassNames, @NotNull InputStream inputStream) {
                Intrinsics.checkNotNullParameter(contractClassNames, (String)"contractClassNames");
                Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                return MockAttachmentStorage.importAttachmentInternal$default(this.this$0, inputStream, this.$uploader, contractClassNames, null, null, 24, null);
            }
        }));
    }

    @Nullable
    public Attachment openAttachment(@NotNull SecureHash id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Pair<Attachment, byte[]> pair = this.getFiles().get(id);
        return pair != null ? (Attachment)pair.getFirst() : null;
    }

    private final <C> boolean criteriaFilter(C metadata, ColumnPredicate<C> predicate) {
        boolean bl;
        block7: {
            ColumnPredicate<C> columnPredicate = predicate;
            if (columnPredicate instanceof ColumnPredicate.EqualityComparison) {
                Object rightLiteral = ((ColumnPredicate.EqualityComparison)predicate).getRightLiteral();
                if (rightLiteral instanceof Collection) {
                    Iterable $this$any$iv = (Iterable)rightLiteral;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv;
                            Object value = element$iv = iterator.next();
                            boolean bl2 = false;
                            Intrinsics.checkNotNull(metadata, (String)"null cannot be cast to non-null type kotlin.collections.Collection<*>");
                            if (!CollectionsKt.contains((Iterable)((Collection)metadata), value)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                } else {
                    bl = Intrinsics.areEqual((Object)rightLiteral, metadata);
                }
            } else {
                bl = columnPredicate instanceof ColumnPredicate.CollectionExpression ? ((ColumnPredicate.CollectionExpression)predicate).getRightLiteral().contains(metadata) : true;
            }
        }
        return bl;
    }

    @NotNull
    public List<SecureHash> queryAttachments(@NotNull AttachmentQueryCriteria criteria, @Nullable AttachmentSort sorting) {
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        AttachmentQueryCriteria.AttachmentsQueryCriteria cfr_ignored_0 = (AttachmentQueryCriteria.AttachmentsQueryCriteria)criteria;
        Function1 metadataFilter2 = (Function1)new Function1<ContractAttachmentMetadata, Boolean>(this, criteria){
            final /* synthetic */ MockAttachmentStorage this$0;
            final /* synthetic */ AttachmentQueryCriteria $criteria;
            {
                this.this$0 = $receiver;
                this.$criteria = $criteria;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ContractAttachmentMetadata metadata) {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                return MockAttachmentStorage.access$criteriaFilter(this.this$0, CollectionsKt.listOf((Object)metadata.getName()), ((AttachmentQueryCriteria.AttachmentsQueryCriteria)this.$criteria).getContractClassNamesCondition()) && MockAttachmentStorage.access$criteriaFilter(this.this$0, metadata.getSigners(), ((AttachmentQueryCriteria.AttachmentsQueryCriteria)this.$criteria).getSignersCondition()) && MockAttachmentStorage.access$criteriaFilter(this.this$0, metadata.isSigned(), ((AttachmentQueryCriteria.AttachmentsQueryCriteria)this.$criteria).isSignedCondition()) && MockAttachmentStorage.access$criteriaFilter(this.this$0, metadata.getVersion(), ((AttachmentQueryCriteria.AttachmentsQueryCriteria)this.$criteria).getVersionCondition()) && MockAttachmentStorage.access$criteriaFilter(this.this$0, metadata.getUploader(), ((AttachmentQueryCriteria.AttachmentsQueryCriteria)this.$criteria).getUploaderCondition());
            }
        };
        Map $this$filterKeys$iv = this._contractClasses;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            ContractAttachmentMetadata it = (ContractAttachmentMetadata)entry$iv.getKey();
            boolean bl = false;
            if (!((Boolean)metadataFilter2.invoke((Object)it)).booleanValue()) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)((Map)result$iv).values());
    }

    public boolean hasAttachment(@NotNull SecureHash attachmentId) {
        Intrinsics.checkNotNullParameter((Object)attachmentId, (String)"attachmentId");
        return this.getFiles().containsKey(attachmentId);
    }

    @NotNull
    public SecureHash importOrGetAttachment(@NotNull InputStream jar) {
        SecureHash secureHash;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        try {
            secureHash = this.importAttachment(jar, "unknown", null);
        }
        catch (FileAlreadyExistsException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            secureHash = SecureHash.Companion.create(string);
        }
        return secureHash;
    }

    @JvmOverloads
    @NotNull
    public final SecureHash importContractAttachment(@NotNull List<String> contractClassNames, @NotNull String uploader, @NotNull InputStream jar, @Nullable SecureHash attachmentId, @NotNull List<? extends PublicKey> signers) {
        Intrinsics.checkNotNullParameter(contractClassNames, (String)"contractClassNames");
        Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter(signers, (String)"signers");
        return this.importAttachmentInternal(jar, uploader, contractClassNames, attachmentId, signers);
    }

    public static /* synthetic */ SecureHash importContractAttachment$default(MockAttachmentStorage mockAttachmentStorage, List list, String string, InputStream inputStream, SecureHash secureHash, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            secureHash = null;
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return mockAttachmentStorage.importContractAttachment(list, string, inputStream, secureHash, list2);
    }

    public final void importContractAttachment(@NotNull SecureHash attachmentId, @NotNull ContractAttachment contractAttachment) {
        Intrinsics.checkNotNullParameter((Object)attachmentId, (String)"attachmentId");
        Intrinsics.checkNotNullParameter((Object)contractAttachment, (String)"contractAttachment");
        ((Map)this._files).put(attachmentId, new Pair((Object)contractAttachment, (Object)new byte[1]));
    }

    @NotNull
    public final Pair<SecureHash, byte[]> getAttachmentIdAndBytes(@NotNull InputStream jar) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        byte[] bytes = InternalUtils.readFully((InputStream)jar);
        boolean bl = false;
        return new Pair((Object)SecureHashKt.sha256((byte[])bytes), (Object)bytes);
    }

    /*
     * WARNING - void declaration
     */
    private final SecureHash importAttachmentInternal(InputStream jar, String uploader, List<String> contractClassNames, SecureHash attachmentId, List<? extends PublicKey> signers) {
        SecureHash sha256;
        if (!(!(jar instanceof JarInputStream))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] bytes = InternalUtils.readFully((InputStream)jar);
        SecureHash secureHash = attachmentId;
        if (secureHash == null) {
            secureHash = sha256 = (SecureHash)SecureHashKt.sha256((byte[])bytes);
        }
        if (!this.getFiles().keySet().contains(sha256)) {
            Attachment attachment;
            int n;
            MockAttachment baseAttachment2 = new MockAttachment((Function0<byte[]>)((Function0)new Function0<byte[]>(bytes){
                final /* synthetic */ byte[] $bytes;
                {
                    this.$bytes = $bytes;
                    super(0);
                }

                @NotNull
                public final byte[] invoke() {
                    return this.$bytes;
                }
            }), sha256, signers, uploader);
            try {
                Cloneable cloneable = baseAttachment2.openAsJAR().getManifest();
                n = Integer.parseInt(cloneable != null && (cloneable = ((Manifest)cloneable).getMainAttributes()) != null ? ((Attributes)cloneable).getValue(Attributes.Name.IMPLEMENTATION_VERSION) : null);
            }
            catch (Exception e) {
                n = 1;
            }
            int version = n;
            Collection e = contractClassNames;
            if (e == null || e.isEmpty()) {
                attachment = (Attachment)baseAttachment2;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = contractClassNames;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void contractClassName;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ContractAttachmentMetadata contractClassMetadata = new ContractAttachmentMetadata((String)contractClassName, version, !((Collection)signers).isEmpty(), signers, uploader);
                    ((Map)this._contractClasses).put(contractClassMetadata, sha256);
                    collection.add(Unit.INSTANCE);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                attachment = (Attachment)ContractAttachment.Companion.create((Attachment)baseAttachment2, (String)CollectionsKt.first(contractClassNames), CollectionsKt.toSet((Iterable)contractClassNames), uploader, signers, version);
            }
            Attachment attachment2 = attachment;
            ((Map)this._files).put(sha256, new Pair((Object)attachment2, (Object)bytes));
        }
        return sha256;
    }

    static /* synthetic */ SecureHash importAttachmentInternal$default(MockAttachmentStorage mockAttachmentStorage, InputStream inputStream, String string, List list, SecureHash secureHash, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            secureHash = null;
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return mockAttachmentStorage.importAttachmentInternal(inputStream, string, list, secureHash, list2);
    }

    @NotNull
    public List<SecureHash> getLatestContractAttachments(@NotNull String contractClassName, int minContractVersion) {
        Intrinsics.checkNotNullParameter((Object)contractClassName, (String)"contractClassName");
        ColumnPredicate.EqualityComparison equalityComparison = Builder.equal$default((Builder)Builder.INSTANCE, (Object)CollectionsKt.listOf((Object)contractClassName), (boolean)false, (int)2, null);
        ColumnPredicate.BinaryComparison binaryComparison = Builder.INSTANCE.greaterThanOrEqual((Comparable)Integer.valueOf(minContractVersion));
        ColumnPredicate.CollectionExpression collectionExpression = Builder.in$default((Builder)Builder.INSTANCE, (Collection)AbstractAttachmentKt.getTRUSTED_UPLOADERS(), (boolean)false, (int)2, null);
        AttachmentQueryCriteria.AttachmentsQueryCriteria attachmentQueryCriteria = new AttachmentQueryCriteria.AttachmentsQueryCriteria((ColumnPredicate)collectionExpression, null, null, (ColumnPredicate)equalityComparison, null, null, (ColumnPredicate)binaryComparison, 54, null);
        AttachmentSort attachmentSort = new AttachmentSort((Collection)CollectionsKt.listOf((Object)new AttachmentSort.AttachmentSortColumn(AttachmentSort.AttachmentSortAttribute.VERSION, Sort.Direction.DESC)));
        return this.queryAttachments((AttachmentQueryCriteria)attachmentQueryCriteria, attachmentSort);
    }

    @JvmOverloads
    @NotNull
    public final SecureHash importContractAttachment(@NotNull List<String> contractClassNames, @NotNull String uploader, @NotNull InputStream jar, @Nullable SecureHash attachmentId) {
        Intrinsics.checkNotNullParameter(contractClassNames, (String)"contractClassNames");
        Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        return MockAttachmentStorage.importContractAttachment$default(this, contractClassNames, uploader, jar, attachmentId, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SecureHash importContractAttachment(@NotNull List<String> contractClassNames, @NotNull String uploader, @NotNull InputStream jar) {
        Intrinsics.checkNotNullParameter(contractClassNames, (String)"contractClassNames");
        Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        return MockAttachmentStorage.importContractAttachment$default(this, contractClassNames, uploader, jar, null, null, 24, null);
    }

    public static final /* synthetic */ boolean access$criteriaFilter(MockAttachmentStorage $this, Object metadata, ColumnPredicate predicate) {
        return $this.criteriaFilter(metadata, predicate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0016\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lnet/corda/testing/services/MockAttachmentStorage$ContractAttachmentMetadata;", "", "name", "", "Lnet/corda/core/contracts/ContractClassName;", "version", "", "isSigned", "", "signers", "", "Ljava/security/PublicKey;", "uploader", "(Ljava/lang/String;IZLjava/util/List;Ljava/lang/String;)V", "()Z", "getName", "()Ljava/lang/String;", "getSigners", "()Ljava/util/List;", "getUploader", "getVersion", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "test-utils"})
    private static final class ContractAttachmentMetadata {
        @NotNull
        private final String name;
        private final int version;
        private final boolean isSigned;
        @NotNull
        private final List<PublicKey> signers;
        @NotNull
        private final String uploader;

        public ContractAttachmentMetadata(@NotNull String name, int version, boolean isSigned, @NotNull List<? extends PublicKey> signers, @NotNull String uploader) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(signers, (String)"signers");
            Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
            this.name = name;
            this.version = version;
            this.isSigned = isSigned;
            this.signers = signers;
            this.uploader = uploader;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getVersion() {
            return this.version;
        }

        public final boolean isSigned() {
            return this.isSigned;
        }

        @NotNull
        public final List<PublicKey> getSigners() {
            return this.signers;
        }

        @NotNull
        public final String getUploader() {
            return this.uploader;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.version;
        }

        public final boolean component3() {
            return this.isSigned;
        }

        @NotNull
        public final List<PublicKey> component4() {
            return this.signers;
        }

        @NotNull
        public final String component5() {
            return this.uploader;
        }

        @NotNull
        public final ContractAttachmentMetadata copy(@NotNull String name, int version, boolean isSigned, @NotNull List<? extends PublicKey> signers, @NotNull String uploader) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(signers, (String)"signers");
            Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
            return new ContractAttachmentMetadata(name, version, isSigned, signers, uploader);
        }

        public static /* synthetic */ ContractAttachmentMetadata copy$default(ContractAttachmentMetadata contractAttachmentMetadata, String string, int n, boolean bl, List list, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = contractAttachmentMetadata.name;
            }
            if ((n2 & 2) != 0) {
                n = contractAttachmentMetadata.version;
            }
            if ((n2 & 4) != 0) {
                bl = contractAttachmentMetadata.isSigned;
            }
            if ((n2 & 8) != 0) {
                list = contractAttachmentMetadata.signers;
            }
            if ((n2 & 0x10) != 0) {
                string2 = contractAttachmentMetadata.uploader;
            }
            return contractAttachmentMetadata.copy(string, n, bl, list, string2);
        }

        @NotNull
        public String toString() {
            return "ContractAttachmentMetadata(name=" + this.name + ", version=" + this.version + ", isSigned=" + this.isSigned + ", signers=" + this.signers + ", uploader=" + this.uploader + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.version);
            result = result * 31 + Boolean.hashCode(this.isSigned);
            result = result * 31 + ((Object)this.signers).hashCode();
            result = result * 31 + this.uploader.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContractAttachmentMetadata)) {
                return false;
            }
            ContractAttachmentMetadata contractAttachmentMetadata = (ContractAttachmentMetadata)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)contractAttachmentMetadata.name)) {
                return false;
            }
            if (this.version != contractAttachmentMetadata.version) {
                return false;
            }
            if (this.isSigned != contractAttachmentMetadata.isSigned) {
                return false;
            }
            if (!Intrinsics.areEqual(this.signers, contractAttachmentMetadata.signers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uploader, (Object)contractAttachmentMetadata.uploader);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/corda/testing/services/MockAttachmentStorage$MockAttachment;", "Lnet/corda/core/internal/AbstractAttachment;", "dataLoader", "Lkotlin/Function0;", "", "id", "Lnet/corda/core/crypto/SecureHash;", "signerKeys", "", "Ljava/security/PublicKey;", "uploader", "", "(Lkotlin/jvm/functions/Function0;Lnet/corda/core/crypto/SecureHash;Ljava/util/List;Ljava/lang/String;)V", "getId", "()Lnet/corda/core/crypto/SecureHash;", "getSignerKeys", "()Ljava/util/List;", "test-utils"})
    private static final class MockAttachment
    extends AbstractAttachment {
        @NotNull
        private final SecureHash id;
        @NotNull
        private final List<PublicKey> signerKeys;

        public MockAttachment(@NotNull Function0<byte[]> dataLoader, @NotNull SecureHash id, @NotNull List<? extends PublicKey> signerKeys, @NotNull String uploader) {
            Intrinsics.checkNotNullParameter(dataLoader, (String)"dataLoader");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(signerKeys, (String)"signerKeys");
            Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
            super(dataLoader, uploader);
            this.id = id;
            this.signerKeys = signerKeys;
        }

        @NotNull
        public SecureHash getId() {
            return this.id;
        }

        @NotNull
        public List<PublicKey> getSignerKeys() {
            return this.signerKeys;
        }
    }
}

