/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.internal.vault;

import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.core.Utils;
import net.corda.core.concurrent.CordaFuture;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.AttachmentConstraint;
import net.corda.core.contracts.AutomaticPlaceholderConstraint;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.LinearState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.UniqueIdentifier;
import net.corda.core.crypto.Crypto;
import net.corda.core.crypto.SignatureMetadata;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.AnonymousParty;
import net.corda.core.identity.Party;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.ServiceHub;
import net.corda.core.node.StatesToRecord;
import net.corda.core.node.services.Vault;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.finance.contracts.Commodity;
import net.corda.finance.contracts.DealState;
import net.corda.finance.contracts.asset.Cash;
import net.corda.finance.contracts.asset.Obligation;
import net.corda.finance.contracts.asset.OnLedgerAsset;
import net.corda.finance.workflows.asset.CashUtils;
import net.corda.testing.contracts.DummyState;
import net.corda.testing.core.TestConstants;
import net.corda.testing.core.TestIdentity;
import net.corda.testing.core.TestUtils;
import net.corda.testing.internal.InternalTestUtilsKt;
import net.corda.testing.internal.vault.CommodityState;
import net.corda.testing.internal.vault.DummyDealContract;
import net.corda.testing.internal.vault.DummyLinearContract;
import net.corda.testing.internal.vault.VaultFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.Observable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 Y2\u00020\u0001:\u0001YB1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ&\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00120\u0011H\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0002J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\r2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00120\u0011J\u001a\u0010\u001f\u001a\u00020\r2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011J\u0018\u0010!\u001a\u00020\r2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\"J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J\u001a\u0010%\u001a\u00020\r2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011J`\u0010*\u001a\b\u0012\u0004\u0012\u00020+0'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\n2\b\b\u0002\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020/H\u0007J*\u00107\u001a\b\u0012\u0004\u0012\u0002080'2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002090\u00182\u0006\u0010-\u001a\u00020\u00032\u0006\u00100\u001a\u000201J@\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0'2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u00112\b\b\u0002\u0010-\u001a\u00020\u00032\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\b\b\u0002\u0010=\u001a\u00020>H\u0007JZ\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00160'2\u0006\u0010@\u001a\u00020/2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010<2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\b\b\u0002\u0010B\u001a\u00020<2\b\b\u0002\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020>2\b\b\u0002\u0010F\u001a\u00020GH\u0007Jz\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000f0'2\u0006\u0010@\u001a\u00020/2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010<2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\n\b\u0002\u0010I\u001a\u0004\u0018\u00010J2\b\b\u0002\u0010B\u001a\u00020<2\b\b\u0002\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020>2\b\b\u0002\u0010F\u001a\u00020G2\b\b\u0002\u0010K\u001a\u00020L2\b\b\u0002\u0010=\u001a\u00020>H\u0007J\u00ab\u0001\u0010M\u001a\b\u0012\u0004\u0012\u0002H\u000e0'\"\b\b\u0000\u0010\u000e*\u00020\u00162\b\b\u0002\u0010@\u001a\u00020/2\b\b\u0002\u0010N\u001a\u00020/2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\b\b\u0002\u0010K\u001a\u00020L2\b\b\u0002\u0010=\u001a\u00020>2\b\b\u0002\u0010\u0002\u001a\u00020\u00032Q\u0010O\u001aM\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001b0\u0011\u00a2\u0006\f\bQ\u0012\b\bR\u0012\u0004\b\b(S\u0012\u0013\u0012\u00110/\u00a2\u0006\f\bQ\u0012\b\bR\u0012\u0004\b\b(T\u0012\u0013\u0012\u00110/\u00a2\u0006\f\bQ\u0012\b\bR\u0012\u0004\b\b(U\u0012\u0004\u0012\u0002H\u000e0PJ0\u0010V\u001a\b\u0012\u0004\u0012\u0002H\u000e0'\"\b\b\u0000\u0010\u000e*\u00020\u00162\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\"2\b\b\u0002\u00104\u001a\u000205H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lnet/corda/testing/internal/vault/VaultFiller;", "", "services", "Lnet/corda/core/node/ServiceHub;", "defaultNotary", "Lnet/corda/testing/core/TestIdentity;", "altNotary", "Lnet/corda/core/identity/Party;", "rngFactory", "Lkotlin/Function0;", "Ljava/util/Random;", "(Lnet/corda/core/node/ServiceHub;Lnet/corda/testing/core/TestIdentity;Lnet/corda/core/identity/Party;Lkotlin/jvm/functions/Function0;)V", "consumeAndProduce", "", "T", "Lnet/corda/core/contracts/LinearState;", "states", "", "Lnet/corda/core/contracts/StateAndRef;", "stateAndRef", "consumeCash", "Lnet/corda/core/node/services/Vault$Update;", "Lnet/corda/core/contracts/ContractState;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "to", "Lnet/corda/core/identity/AbstractParty;", "consumeDeals", "dealStates", "Lnet/corda/finance/contracts/DealState;", "consumeLinearStates", "linearStates", "consumeStates", "", "evolveLinearState", "linearState", "evolveLinearStates", "fillWithDummyState", "Lnet/corda/core/node/services/Vault;", "Lnet/corda/testing/contracts/DummyState;", "participants", "fillWithSomeTestCash", "Lnet/corda/finance/contracts/asset/Cash$State;", "howMuch", "issuerServices", "atLeastThisManyStates", "", "issuedBy", "Lnet/corda/core/contracts/PartyAndReference;", "owner", "rng", "statesToRecord", "Lnet/corda/core/node/StatesToRecord;", "atMostThisManyStates", "fillWithSomeTestCommodity", "Lnet/corda/testing/internal/vault/CommodityState;", "Lnet/corda/finance/contracts/Commodity;", "fillWithSomeTestDeals", "dealIds", "", "includeMe", "", "fillWithSomeTestLinearAndDealStates", "txCount", "externalId", "linearString", "linearNumber", "", "linearBoolean", "linearTimestamp", "Ljava/time/Instant;", "fillWithSomeTestLinearStates", "uniqueIdentifier", "Lnet/corda/core/contracts/UniqueIdentifier;", "constraint", "Lnet/corda/core/contracts/AttachmentConstraint;", "fillWithTestStates", "statesPerTx", "genOutputState", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "participantsToUse", "txIndex", "stateIndex", "recordTransactions", "transactions", "Lnet/corda/core/transactions/SignedTransaction;", "Companion", "test-utils"})
@SourceDebugExtension(value={"SMAP\nVaultFiller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VaultFiller.kt\nnet/corda/testing/internal/vault/VaultFiller\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n11105#2:330\n11440#2,3:331\n1855#3,2:334\n1855#3,2:336\n1360#3:338\n1446#3,2:339\n1549#3:341\n1620#3,3:342\n1448#3,3:345\n*S KotlinDebug\n*F\n+ 1 VaultFiller.kt\nnet/corda/testing/internal/vault/VaultFiller\n*L\n171#1:330\n171#1:331,3\n239#1:334,2\n269#1:336,2\n299#1:338\n299#1:339,2\n300#1:341\n300#1:342,3\n299#1:345,3\n*E\n"})
public final class VaultFiller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServiceHub services;
    @NotNull
    private final TestIdentity defaultNotary;
    @NotNull
    private final Party altNotary;
    @NotNull
    private final Function0<Random> rngFactory;

    @JvmOverloads
    public VaultFiller(@NotNull ServiceHub services2, @NotNull TestIdentity defaultNotary, @NotNull Party altNotary, @NotNull Function0<? extends Random> rngFactory) {
        Intrinsics.checkNotNullParameter((Object)services2, (String)"services");
        Intrinsics.checkNotNullParameter((Object)defaultNotary, (String)"defaultNotary");
        Intrinsics.checkNotNullParameter((Object)altNotary, (String)"altNotary");
        Intrinsics.checkNotNullParameter(rngFactory, (String)"rngFactory");
        this.services = services2;
        this.defaultNotary = defaultNotary;
        this.altNotary = altNotary;
        this.rngFactory = rngFactory;
    }

    public /* synthetic */ VaultFiller(ServiceHub serviceHub, TestIdentity testIdentity, Party party, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            party = testIdentity.getParty();
        }
        if ((n & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        this(serviceHub, testIdentity, party, (Function0<? extends Random>)function0);
    }

    @JvmOverloads
    @NotNull
    public final Vault<DealState> fillWithSomeTestDeals(@NotNull List<String> dealIds, @NotNull ServiceHub issuerServices, @NotNull List<? extends AbstractParty> participants, boolean includeMe) {
        Intrinsics.checkNotNullParameter(dealIds, (String)"dealIds");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return VaultFiller.fillWithTestStates$default(this, dealIds.size(), 0, participants, null, includeMe, issuerServices, (Function3)new Function3<List<? extends AbstractParty>, Integer, Integer, DummyDealContract.State>(dealIds){
            final /* synthetic */ List<String> $dealIds;
            {
                this.$dealIds = $dealIds;
                super(3);
            }

            @NotNull
            public final DummyDealContract.State invoke(@NotNull List<? extends AbstractParty> participantsToUse, int txIndex, int n) {
                Intrinsics.checkNotNullParameter(participantsToUse, (String)"participantsToUse");
                String string = this.$dealIds.get(txIndex);
                return new DummyDealContract.State(participantsToUse, string);
            }
        }, 10, null);
    }

    public static /* synthetic */ Vault fillWithSomeTestDeals$default(VaultFiller vaultFiller, List list, ServiceHub serviceHub, List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            serviceHub = vaultFiller.services;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return vaultFiller.fillWithSomeTestDeals(list, serviceHub, list2, bl);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @Nullable UniqueIdentifier uniqueIdentifier, @NotNull String linearString, long linearNumber, boolean linearBoolean, @NotNull Instant linearTimestamp, @NotNull AttachmentConstraint constraint, boolean includeMe) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        Intrinsics.checkNotNullParameter((Object)linearTimestamp, (String)"linearTimestamp");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        return VaultFiller.fillWithTestStates$default(this, txCount, 1, participants, constraint, includeMe, null, (Function3)new Function3<List<? extends AbstractParty>, Integer, Integer, DummyLinearContract.State>(uniqueIdentifier, externalId, linearString, linearNumber, linearTimestamp, linearBoolean){
            final /* synthetic */ UniqueIdentifier $uniqueIdentifier;
            final /* synthetic */ String $externalId;
            final /* synthetic */ String $linearString;
            final /* synthetic */ long $linearNumber;
            final /* synthetic */ Instant $linearTimestamp;
            final /* synthetic */ boolean $linearBoolean;
            {
                this.$uniqueIdentifier = $uniqueIdentifier;
                this.$externalId = $externalId;
                this.$linearString = $linearString;
                this.$linearNumber = $linearNumber;
                this.$linearTimestamp = $linearTimestamp;
                this.$linearBoolean = $linearBoolean;
                super(3);
            }

            @NotNull
            public final DummyLinearContract.State invoke(@NotNull List<? extends AbstractParty> participantsToUse, int n, int n2) {
                Intrinsics.checkNotNullParameter(participantsToUse, (String)"participantsToUse");
                UniqueIdentifier uniqueIdentifier = this.$uniqueIdentifier;
                if (uniqueIdentifier == null) {
                    uniqueIdentifier = new UniqueIdentifier(this.$externalId, null, 2, null);
                }
                UniqueIdentifier uniqueIdentifier2 = uniqueIdentifier;
                return new DummyLinearContract.State(uniqueIdentifier2, participantsToUse, this.$linearString, this.$linearNumber, this.$linearTimestamp, this.$linearBoolean, null, 64, null);
            }
        }, 32, null);
    }

    public static /* synthetic */ Vault fillWithSomeTestLinearStates$default(VaultFiller vaultFiller, int n, String string, List list, UniqueIdentifier uniqueIdentifier, String string2, long l, boolean bl, Instant instant, AttachmentConstraint attachmentConstraint, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            uniqueIdentifier = null;
        }
        if ((n2 & 0x10) != 0) {
            string2 = "";
        }
        if ((n2 & 0x20) != 0) {
            l = 0L;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        if ((n2 & 0x80) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        if ((n2 & 0x100) != 0) {
            attachmentConstraint = (AttachmentConstraint)AutomaticPlaceholderConstraint.INSTANCE;
        }
        if ((n2 & 0x200) != 0) {
            bl2 = true;
        }
        return vaultFiller.fillWithSomeTestLinearStates(n, string, list, uniqueIdentifier, string2, l, bl, instant, attachmentConstraint, bl2);
    }

    @JvmOverloads
    @NotNull
    public final Vault<ContractState> fillWithSomeTestLinearAndDealStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @NotNull String linearString, long linearNumber, boolean linearBoolean, @NotNull Instant linearTimestamp) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        Intrinsics.checkNotNullParameter((Object)linearTimestamp, (String)"linearTimestamp");
        return VaultFiller.fillWithTestStates$default(this, txCount, 2, participants, null, false, null, (Function3)new Function3<List<? extends AbstractParty>, Integer, Integer, ContractState>(externalId, linearString, linearNumber, linearTimestamp, linearBoolean){
            final /* synthetic */ String $externalId;
            final /* synthetic */ String $linearString;
            final /* synthetic */ long $linearNumber;
            final /* synthetic */ Instant $linearTimestamp;
            final /* synthetic */ boolean $linearBoolean;
            {
                this.$externalId = $externalId;
                this.$linearString = $linearString;
                this.$linearNumber = $linearNumber;
                this.$linearTimestamp = $linearTimestamp;
                this.$linearBoolean = $linearBoolean;
                super(3);
            }

            @NotNull
            public final ContractState invoke(@NotNull List<? extends AbstractParty> participantsToUse, int n, int stateIndex) {
                ContractState contractState;
                Intrinsics.checkNotNullParameter(participantsToUse, (String)"participantsToUse");
                if (stateIndex == 0) {
                    UniqueIdentifier uniqueIdentifier = new UniqueIdentifier(this.$externalId, null, 2, null);
                    contractState = (ContractState)new DummyLinearContract.State(uniqueIdentifier, participantsToUse, this.$linearString, this.$linearNumber, this.$linearTimestamp, this.$linearBoolean, null, 64, null);
                } else {
                    contractState = (ContractState)new DummyDealContract.State(participantsToUse, "test ref");
                }
                return contractState;
            }
        }, 56, null);
    }

    public static /* synthetic */ Vault fillWithSomeTestLinearAndDealStates$default(VaultFiller vaultFiller, int n, String string, List list, String string2, long l, boolean bl, Instant instant, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            string2 = "";
        }
        if ((n2 & 0x10) != 0) {
            l = 0L;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        if ((n2 & 0x40) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        return vaultFiller.fillWithSomeTestLinearAndDealStates(n, string, list, string2, l, bl, instant);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Vault<Cash.State> fillWithSomeTestCash(@NotNull Amount<Currency> howMuch, @NotNull ServiceHub issuerServices, int atLeastThisManyStates, @NotNull PartyAndReference issuedBy, @Nullable AbstractParty owner, @Nullable Random rng, @NotNull StatesToRecord statesToRecord, int atMostThisManyStates) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(howMuch, (String)"howMuch");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter((Object)issuedBy, (String)"issuedBy");
        Intrinsics.checkNotNullParameter((Object)statesToRecord, (String)"statesToRecord");
        Random random = rng;
        if (random == null) {
            random = (Random)this.rngFactory.invoke();
        }
        long[] amounts = Companion.calculateRandomlySizedAmounts(howMuch, atLeastThisManyStates, atMostThisManyStates, random);
        Cash cash = new Cash();
        long[] $this$map$iv = amounts;
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void pennies;
            void item$iv$iv;
            void var21_19 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TransactionBuilder issuance = new TransactionBuilder(null, null, null, null, null, null, null, null, 254, null);
            Amount amount = new Amount((long)pennies, (Object)new Issued(issuedBy, howMuch.getToken()));
            AbstractParty abstractParty = owner;
            if (abstractParty == null) {
                abstractParty = (AbstractParty)TestUtils.singleIdentity((NodeInfo)this.services.getMyInfo());
            }
            cash.generateIssue(issuance, amount, abstractParty, this.altNotary);
            collection.add(issuerServices.signInitialTransaction(issuance, issuedBy.getParty().getOwningKey()));
        }
        List transactions = (List)destination$iv$iv;
        return this.recordTransactions(transactions, statesToRecord);
    }

    public static /* synthetic */ Vault fillWithSomeTestCash$default(VaultFiller vaultFiller, Amount amount, ServiceHub serviceHub, int n, PartyAndReference partyAndReference, AbstractParty abstractParty, Random random, StatesToRecord statesToRecord, int n2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            abstractParty = null;
        }
        if ((n3 & 0x20) != 0) {
            random = null;
        }
        if ((n3 & 0x40) != 0) {
            statesToRecord = StatesToRecord.ONLY_RELEVANT;
        }
        if ((n3 & 0x80) != 0) {
            n2 = n;
        }
        return vaultFiller.fillWithSomeTestCash((Amount<Currency>)amount, serviceHub, n, partyAndReference, abstractParty, random, statesToRecord, n2);
    }

    @NotNull
    public final Vault<DummyState> fillWithDummyState(@NotNull List<? extends AbstractParty> participants) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return VaultFiller.fillWithTestStates$default(this, 0, 0, participants, null, false, null, fillWithDummyState.1.INSTANCE, 59, null);
    }

    public static /* synthetic */ Vault fillWithDummyState$default(VaultFiller vaultFiller, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.listOf((Object)TestUtils.singleIdentity((NodeInfo)vaultFiller.services.getMyInfo()));
        }
        return vaultFiller.fillWithDummyState(list);
    }

    @NotNull
    public final <T extends ContractState> Vault<T> fillWithTestStates(int txCount, int statesPerTx, @NotNull List<? extends AbstractParty> participants, @NotNull AttachmentConstraint constraint, boolean includeMe, @NotNull ServiceHub services2, @NotNull Function3<? super List<? extends AbstractParty>, ? super Integer, ? super Integer, ? extends T> genOutputState) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter((Object)services2, (String)"services");
        Intrinsics.checkNotNullParameter(genOutputState, (String)"genOutputState");
        KeyPair issuerKey = this.defaultNotary.getKeyPair();
        int n = services2.getMyInfo().getPlatformVersion();
        PublicKey publicKey = issuerKey.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        SignatureMetadata signatureMetadata = new SignatureMetadata(n, Crypto.findSignatureScheme((PublicKey)publicKey).getSchemeNumberID());
        List participantsToUse = includeMe ? CollectionsKt.plus((Collection)participants, (Object)new AnonymousParty(InternalTestUtilsKt.chooseIdentity(this.services.getMyInfo()).getOwningKey())) : participants;
        Object[] objectArray = new SignedTransaction[txCount];
        for (int i = 0; i < txCount; ++i) {
            int n2 = i;
            TransactionBuilder builder = new TransactionBuilder(this.defaultNotary.getParty());
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            int n4 = 0;
            while (n4 < statesPerTx) {
                int stateIndex = n4++;
                boolean bl = false;
                builder.addOutputState((ContractState)genOutputState.invoke((Object)participantsToUse, (Object)n2, (Object)stateIndex), constraint);
            }
            builder.addCommand(TestConstants.dummyCommand$default(null, (int)1, null));
            objectArray2[n3] = services2.signInitialTransaction(builder).withAdditionalSignature(issuerKey, signatureMetadata);
        }
        Object[] transactions = objectArray;
        StatesToRecord statesToRecord = includeMe ? StatesToRecord.ONLY_RELEVANT : StatesToRecord.ALL_VISIBLE;
        return this.recordTransactions(ArraysKt.asList((Object[])transactions), statesToRecord);
    }

    public static /* synthetic */ Vault fillWithTestStates$default(VaultFiller vaultFiller, int n, int n2, List list, AttachmentConstraint attachmentConstraint, boolean bl, ServiceHub serviceHub, Function3 function3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        if ((n3 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            attachmentConstraint = (AttachmentConstraint)AutomaticPlaceholderConstraint.INSTANCE;
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        if ((n3 & 0x20) != 0) {
            serviceHub = vaultFiller.services;
        }
        return vaultFiller.fillWithTestStates(n, n2, list, attachmentConstraint, bl, serviceHub, function3);
    }

    @NotNull
    public final Vault<CommodityState> fillWithSomeTestCommodity(@NotNull Amount<Commodity> amount, @NotNull ServiceHub issuerServices, @NotNull PartyAndReference issuedBy) {
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter((Object)issuedBy, (String)"issuedBy");
        PublicKey myKey = InternalTestUtilsKt.chooseIdentity(this.services.getMyInfo()).getOwningKey();
        AnonymousParty me = new AnonymousParty(myKey);
        TransactionBuilder issuance = new TransactionBuilder(null, null, null, null, null, null, null, null, 254, null);
        OnLedgerAsset.Companion.generateIssue(issuance, new TransactionState((ContractState)new CommodityState((Amount<Issued<Commodity>>)new Amount(amount.getQuantity(), (Object)new Issued(issuedBy, amount.getToken())), (AbstractParty)me), "net.corda.finance.contracts.asset.Obligation", this.altNotary, null, null, 24, null), (CommandData)new Obligation.Commands.Issue());
        SignedTransaction transaction2 = issuerServices.signInitialTransaction(issuance, issuedBy.getParty().getOwningKey());
        return VaultFiller.recordTransactions$default(this, CollectionsKt.listOf((Object)transaction2), null, 2, null);
    }

    public final void consumeStates(@NotNull Iterable<? extends StateAndRef<?>> states) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        Iterable<StateAndRef<?>> $this$forEach$iv = states;
        boolean $i$f$forEach = false;
        Iterator<StateAndRef<?>> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            TransactionBuilder transactionBuilder;
            StateAndRef<?> element$iv;
            StateAndRef<?> it = element$iv = iterator.next();
            boolean bl = false;
            TransactionBuilder $this$consumeStates_u24lambda_u243_u24lambda_u242 = transactionBuilder = new TransactionBuilder(this.altNotary);
            boolean bl2 = false;
            $this$consumeStates_u24lambda_u243_u24lambda_u242.addInputState(it);
            PublicKey[] publicKeyArray = new PublicKey[]{this.altNotary.getOwningKey()};
            $this$consumeStates_u24lambda_u243_u24lambda_u242.addCommand(TestConstants.dummyCommand((PublicKey[])publicKeyArray));
            TransactionBuilder builder = transactionBuilder;
            SignedTransaction consumedTx = this.services.signInitialTransaction(builder, this.altNotary.getOwningKey());
            this.services.recordTransactions(consumedTx, new SignedTransaction[0]);
        }
    }

    private final <T extends LinearState> StateAndRef<T> consumeAndProduce(StateAndRef<? extends T> stateAndRef) {
        TransactionBuilder transactionBuilder;
        TransactionBuilder $this$consumeAndProduce_u24lambda_u244 = transactionBuilder = new TransactionBuilder(this.altNotary);
        boolean bl = false;
        $this$consumeAndProduce_u24lambda_u244.addInputState(stateAndRef);
        PublicKey[] publicKeyArray = new PublicKey[]{this.altNotary.getOwningKey()};
        $this$consumeAndProduce_u24lambda_u244.addCommand(TestConstants.dummyCommand((PublicKey[])publicKeyArray));
        TransactionBuilder builder = transactionBuilder;
        SignedTransaction consumedTx = this.services.signInitialTransaction(builder, this.altNotary.getOwningKey());
        this.services.recordTransactions(consumedTx, new SignedTransaction[0]);
        TransactionBuilder $this$consumeAndProduce_u24lambda_u245 = $this$consumeAndProduce_u24lambda_u244 = new TransactionBuilder(this.altNotary);
        boolean bl2 = false;
        TransactionBuilder.addOutputState$default((TransactionBuilder)$this$consumeAndProduce_u24lambda_u245, (ContractState)((ContractState)new DummyLinearContract.State(((LinearState)stateAndRef.getState().getData()).getLinearId(), ((LinearState)stateAndRef.getState().getData()).getParticipants(), null, 0L, null, false, null, 124, null)), (String)"net.corda.testing.internal.vault.DummyLinearContract", null, (int)4, null);
        PublicKey[] publicKeyArray2 = new PublicKey[]{this.altNotary.getOwningKey()};
        $this$consumeAndProduce_u24lambda_u245.addCommand(TestConstants.dummyCommand((PublicKey[])publicKeyArray2));
        builder = $this$consumeAndProduce_u24lambda_u244;
        SignedTransaction producedTx = this.services.signInitialTransaction(builder, this.altNotary.getOwningKey());
        this.services.recordTransactions(producedTx, new SignedTransaction[0]);
        return producedTx.getTx().outRef(0);
    }

    private final <T extends LinearState> void consumeAndProduce(List<? extends StateAndRef<? extends T>> states) {
        Iterable $this$forEach$iv = states;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateAndRef it = (StateAndRef)element$iv;
            boolean bl = false;
            this.consumeAndProduce(it);
        }
    }

    public final void consumeDeals(@NotNull List<? extends StateAndRef<? extends DealState>> dealStates) {
        Intrinsics.checkNotNullParameter(dealStates, (String)"dealStates");
        this.consumeStates((Iterable)dealStates);
    }

    public final void consumeLinearStates(@NotNull List<? extends StateAndRef<? extends LinearState>> linearStates) {
        Intrinsics.checkNotNullParameter(linearStates, (String)"linearStates");
        this.consumeStates((Iterable)linearStates);
    }

    public final void evolveLinearStates(@NotNull List<? extends StateAndRef<? extends LinearState>> linearStates) {
        Intrinsics.checkNotNullParameter(linearStates, (String)"linearStates");
        this.consumeAndProduce(linearStates);
    }

    @NotNull
    public final StateAndRef<LinearState> evolveLinearState(@NotNull StateAndRef<? extends LinearState> linearState) {
        Intrinsics.checkNotNullParameter(linearState, (String)"linearState");
        return this.consumeAndProduce(linearState);
    }

    @NotNull
    public final Vault.Update<ContractState> consumeCash(@NotNull Amount<Currency> amount, @NotNull AbstractParty to) {
        TransactionBuilder transactionBuilder;
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        PartyAndCertificate ourIdentity = InternalTestUtilsKt.chooseIdentityAndCert(this.services.getMyInfo());
        CordaFuture update = Utils.toFuture((Observable)this.services.getVaultService().getRawUpdates());
        TransactionBuilder $this$consumeCash_u24lambda_u247 = transactionBuilder = new TransactionBuilder(this.altNotary);
        boolean bl = false;
        CashUtils.generateSpend$default((ServiceHub)this.services, (TransactionBuilder)$this$consumeCash_u24lambda_u247, amount, (PartyAndCertificate)ourIdentity, (AbstractParty)to, null, (boolean)false, (int)96, null);
        TransactionBuilder builder = transactionBuilder;
        SignedTransaction spendTx = this.services.signInitialTransaction(builder, this.altNotary.getOwningKey());
        this.services.recordTransactions(spendTx, new SignedTransaction[0]);
        return (Vault.Update)KotlinUtilsKt.getOrThrow((Future)((Future)update), (Duration)Duration.ofSeconds(3L));
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends ContractState> Vault<T> recordTransactions(Iterable<SignedTransaction> transactions, StatesToRecord statesToRecord) {
        void $this$flatMapTo$iv$iv;
        this.services.recordTransactions(statesToRecord, transactions);
        Iterable<SignedTransaction> $this$flatMap$iv = transactions;
        boolean $i$f$flatMap = false;
        Iterable<SignedTransaction> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            SignedTransaction stx = (SignedTransaction)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)stx.getTx().getOutputs());
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(stx.getTx().outRef((int)i));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List states = (List)destination$iv$iv;
        return new Vault((Iterable)states);
    }

    static /* synthetic */ Vault recordTransactions$default(VaultFiller vaultFiller, Iterable iterable, StatesToRecord statesToRecord, int n, Object object) {
        if ((n & 2) != 0) {
            statesToRecord = StatesToRecord.ONLY_RELEVANT;
        }
        return vaultFiller.recordTransactions(iterable, statesToRecord);
    }

    @JvmOverloads
    public VaultFiller(@NotNull ServiceHub services2, @NotNull TestIdentity defaultNotary, @NotNull Party altNotary) {
        Intrinsics.checkNotNullParameter((Object)services2, (String)"services");
        Intrinsics.checkNotNullParameter((Object)defaultNotary, (String)"defaultNotary");
        Intrinsics.checkNotNullParameter((Object)altNotary, (String)"altNotary");
        this(services2, defaultNotary, altNotary, null, 8, null);
    }

    @JvmOverloads
    public VaultFiller(@NotNull ServiceHub services2, @NotNull TestIdentity defaultNotary) {
        Intrinsics.checkNotNullParameter((Object)services2, (String)"services");
        Intrinsics.checkNotNullParameter((Object)defaultNotary, (String)"defaultNotary");
        this(services2, defaultNotary, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<DealState> fillWithSomeTestDeals(@NotNull List<String> dealIds, @NotNull ServiceHub issuerServices, @NotNull List<? extends AbstractParty> participants) {
        Intrinsics.checkNotNullParameter(dealIds, (String)"dealIds");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return VaultFiller.fillWithSomeTestDeals$default(this, dealIds, issuerServices, participants, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<DealState> fillWithSomeTestDeals(@NotNull List<String> dealIds, @NotNull ServiceHub issuerServices) {
        Intrinsics.checkNotNullParameter(dealIds, (String)"dealIds");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        return VaultFiller.fillWithSomeTestDeals$default(this, dealIds, issuerServices, null, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<DealState> fillWithSomeTestDeals(@NotNull List<String> dealIds) {
        Intrinsics.checkNotNullParameter(dealIds, (String)"dealIds");
        return VaultFiller.fillWithSomeTestDeals$default(this, dealIds, null, null, false, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @Nullable UniqueIdentifier uniqueIdentifier, @NotNull String linearString, long linearNumber, boolean linearBoolean, @NotNull Instant linearTimestamp, @NotNull AttachmentConstraint constraint) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        Intrinsics.checkNotNullParameter((Object)linearTimestamp, (String)"linearTimestamp");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, participants, uniqueIdentifier, linearString, linearNumber, linearBoolean, linearTimestamp, constraint, false, 512, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @Nullable UniqueIdentifier uniqueIdentifier, @NotNull String linearString, long linearNumber, boolean linearBoolean, @NotNull Instant linearTimestamp) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        Intrinsics.checkNotNullParameter((Object)linearTimestamp, (String)"linearTimestamp");
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, participants, uniqueIdentifier, linearString, linearNumber, linearBoolean, linearTimestamp, null, false, 768, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @Nullable UniqueIdentifier uniqueIdentifier, @NotNull String linearString, long linearNumber, boolean linearBoolean) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, participants, uniqueIdentifier, linearString, linearNumber, linearBoolean, null, null, false, 896, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @Nullable UniqueIdentifier uniqueIdentifier, @NotNull String linearString, long linearNumber) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, participants, uniqueIdentifier, linearString, linearNumber, false, null, null, false, 960, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @Nullable UniqueIdentifier uniqueIdentifier, @NotNull String linearString) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, participants, uniqueIdentifier, linearString, 0L, false, null, null, false, 992, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @Nullable UniqueIdentifier uniqueIdentifier) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, participants, uniqueIdentifier, null, 0L, false, null, null, false, 1008, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, participants, null, null, 0L, false, null, null, false, 1016, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount, @Nullable String externalId) {
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, externalId, null, null, null, 0L, false, null, null, false, 1020, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<LinearState> fillWithSomeTestLinearStates(int txCount) {
        return VaultFiller.fillWithSomeTestLinearStates$default(this, txCount, null, null, null, null, 0L, false, null, null, false, 1022, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<ContractState> fillWithSomeTestLinearAndDealStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @NotNull String linearString, long linearNumber, boolean linearBoolean) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        return VaultFiller.fillWithSomeTestLinearAndDealStates$default(this, txCount, externalId, participants, linearString, linearNumber, linearBoolean, null, 64, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<ContractState> fillWithSomeTestLinearAndDealStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @NotNull String linearString, long linearNumber) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        return VaultFiller.fillWithSomeTestLinearAndDealStates$default(this, txCount, externalId, participants, linearString, linearNumber, false, null, 96, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<ContractState> fillWithSomeTestLinearAndDealStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants, @NotNull String linearString) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
        return VaultFiller.fillWithSomeTestLinearAndDealStates$default(this, txCount, externalId, participants, linearString, 0L, false, null, 112, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<ContractState> fillWithSomeTestLinearAndDealStates(int txCount, @Nullable String externalId, @NotNull List<? extends AbstractParty> participants) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return VaultFiller.fillWithSomeTestLinearAndDealStates$default(this, txCount, externalId, participants, null, 0L, false, null, 120, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<ContractState> fillWithSomeTestLinearAndDealStates(int txCount, @Nullable String externalId) {
        return VaultFiller.fillWithSomeTestLinearAndDealStates$default(this, txCount, externalId, null, null, 0L, false, null, 124, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<ContractState> fillWithSomeTestLinearAndDealStates(int txCount) {
        return VaultFiller.fillWithSomeTestLinearAndDealStates$default(this, txCount, null, null, null, 0L, false, null, 126, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<Cash.State> fillWithSomeTestCash(@NotNull Amount<Currency> howMuch, @NotNull ServiceHub issuerServices, int atLeastThisManyStates, @NotNull PartyAndReference issuedBy, @Nullable AbstractParty owner, @Nullable Random rng, @NotNull StatesToRecord statesToRecord) {
        Intrinsics.checkNotNullParameter(howMuch, (String)"howMuch");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter((Object)issuedBy, (String)"issuedBy");
        Intrinsics.checkNotNullParameter((Object)statesToRecord, (String)"statesToRecord");
        return VaultFiller.fillWithSomeTestCash$default(this, howMuch, issuerServices, atLeastThisManyStates, issuedBy, owner, rng, statesToRecord, 0, 128, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<Cash.State> fillWithSomeTestCash(@NotNull Amount<Currency> howMuch, @NotNull ServiceHub issuerServices, int atLeastThisManyStates, @NotNull PartyAndReference issuedBy, @Nullable AbstractParty owner, @Nullable Random rng) {
        Intrinsics.checkNotNullParameter(howMuch, (String)"howMuch");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter((Object)issuedBy, (String)"issuedBy");
        return VaultFiller.fillWithSomeTestCash$default(this, howMuch, issuerServices, atLeastThisManyStates, issuedBy, owner, rng, null, 0, 192, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<Cash.State> fillWithSomeTestCash(@NotNull Amount<Currency> howMuch, @NotNull ServiceHub issuerServices, int atLeastThisManyStates, @NotNull PartyAndReference issuedBy, @Nullable AbstractParty owner) {
        Intrinsics.checkNotNullParameter(howMuch, (String)"howMuch");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter((Object)issuedBy, (String)"issuedBy");
        return VaultFiller.fillWithSomeTestCash$default(this, howMuch, issuerServices, atLeastThisManyStates, issuedBy, owner, null, null, 0, 224, null);
    }

    @JvmOverloads
    @NotNull
    public final Vault<Cash.State> fillWithSomeTestCash(@NotNull Amount<Currency> howMuch, @NotNull ServiceHub issuerServices, int atLeastThisManyStates, @NotNull PartyAndReference issuedBy) {
        Intrinsics.checkNotNullParameter(howMuch, (String)"howMuch");
        Intrinsics.checkNotNullParameter((Object)issuerServices, (String)"issuerServices");
        Intrinsics.checkNotNullParameter((Object)issuedBy, (String)"issuedBy");
        return VaultFiller.fillWithSomeTestCash$default(this, howMuch, issuerServices, atLeastThisManyStates, issuedBy, null, null, null, 0, 240, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lnet/corda/testing/internal/vault/VaultFiller$Companion;", "", "()V", "calculateRandomlySizedAmounts", "", "howMuch", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "min", "", "max", "rng", "Ljava/util/Random;", "test-utils"})
    @SourceDebugExtension(value={"SMAP\nVaultFiller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VaultFiller.kt\nnet/corda/testing/internal/vault/VaultFiller$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1#2:330\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final long[] calculateRandomlySizedAmounts(@NotNull Amount<Currency> howMuch, int min, int max, @NotNull Random rng) {
            Intrinsics.checkNotNullParameter(howMuch, (String)"howMuch");
            Intrinsics.checkNotNullParameter((Object)rng, (String)"rng");
            int numSlots = min + (int)Math.floor(rng.nextDouble() * (double)(max - min));
            long baseSize = howMuch.getQuantity() / (long)numSlots;
            if (!(baseSize > 0L)) {
                boolean $i$a$-check-VaultFiller$Companion$calculateRandomlySizedAmounts$22 = false;
                Long $i$a$-check-VaultFiller$Companion$calculateRandomlySizedAmounts$22 = baseSize;
                throw new IllegalStateException(((Object)$i$a$-check-VaultFiller$Companion$calculateRandomlySizedAmounts$22).toString());
            }
            int $i$a$-check-VaultFiller$Companion$calculateRandomlySizedAmounts$22 = 0;
            long[] lArray = new long[numSlots];
            while ($i$a$-check-VaultFiller$Companion$calculateRandomlySizedAmounts$22 < numSlots) {
                int n = $i$a$-check-VaultFiller$Companion$calculateRandomlySizedAmounts$22++;
                lArray[n] = baseSize;
            }
            long[] amounts = lArray;
            long distanceFromGoal = 0L;
            double maxAdjust = 1.0 / (double)numSlots;
            int n = amounts.length;
            for (int i = 0; i < n; ++i) {
                if (i != ArraysKt.getLastIndex((long[])amounts)) {
                    long adjustTo;
                    double adjustBy = rng.nextDouble() * maxAdjust - maxAdjust / (double)2;
                    double adjustment = 1.0 + adjustBy;
                    amounts[i] = adjustTo = (long)((double)amounts[i] * adjustment);
                    distanceFromGoal += baseSize - adjustTo;
                    continue;
                }
                int n2 = i;
                amounts[n2] = amounts[n2] + distanceFromGoal;
            }
            amounts[0] = amounts[0] + (howMuch.getQuantity() - ArraysKt.sum((long[])amounts));
            return amounts;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

