/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.internal.vault;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.LinearState;
import net.corda.core.contracts.UniqueIdentifier;
import net.corda.core.identity.AbstractParty;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.schemas.QueryableState;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.testing.internal.vault.UniqueDummyLinearStateSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnet/corda/testing/internal/vault/UniqueDummyLinearContract;", "Lnet/corda/core/contracts/Contract;", "()V", "verify", "", "tx", "Lnet/corda/core/transactions/LedgerTransaction;", "State", "test-utils"})
public final class UniqueDummyLinearContract
implements Contract {
    public void verify(@NotNull LedgerTransaction tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0016\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\nH\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0016J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lnet/corda/testing/internal/vault/UniqueDummyLinearContract$State;", "Lnet/corda/core/contracts/LinearState;", "Lnet/corda/core/schemas/QueryableState;", "participants", "", "Lnet/corda/core/identity/AbstractParty;", "ref", "", "(Ljava/util/List;Ljava/lang/String;)V", "linearId", "Lnet/corda/core/contracts/UniqueIdentifier;", "(Ljava/util/List;Lnet/corda/core/contracts/UniqueIdentifier;)V", "getLinearId", "()Lnet/corda/core/contracts/UniqueIdentifier;", "getParticipants", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "generateMappedObject", "Lnet/corda/core/schemas/PersistentState;", "schema", "Lnet/corda/core/schemas/MappedSchema;", "hashCode", "", "supportedSchemas", "", "toString", "test-utils"})
    public static final class State
    implements LinearState,
    QueryableState {
        @NotNull
        private final List<AbstractParty> participants;
        @NotNull
        private final UniqueIdentifier linearId;

        public State(@NotNull List<? extends AbstractParty> participants, @NotNull UniqueIdentifier linearId) {
            Intrinsics.checkNotNullParameter(participants, (String)"participants");
            Intrinsics.checkNotNullParameter((Object)linearId, (String)"linearId");
            this.participants = participants;
            this.linearId = linearId;
        }

        @NotNull
        public List<AbstractParty> getParticipants() {
            return this.participants;
        }

        @NotNull
        public UniqueIdentifier getLinearId() {
            return this.linearId;
        }

        public State(@NotNull List<? extends AbstractParty> participants, @NotNull String ref) {
            Intrinsics.checkNotNullParameter(participants, (String)"participants");
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            this(participants, new UniqueIdentifier(ref, null, 2, null));
        }

        public /* synthetic */ State(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this((List<? extends AbstractParty>)list, string);
        }

        @NotNull
        public Iterable<MappedSchema> supportedSchemas() {
            return CollectionsKt.listOf((Object)((Object)UniqueDummyLinearStateSchema.INSTANCE));
        }

        @NotNull
        public PersistentState generateMappedObject(@NotNull MappedSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            String string = this.getLinearId().getExternalId();
            Intrinsics.checkNotNull((Object)string);
            return new UniqueDummyLinearStateSchema.UniquePersistentLinearDummyState(string);
        }

        @NotNull
        public final List<AbstractParty> component1() {
            return this.participants;
        }

        @NotNull
        public final UniqueIdentifier component2() {
            return this.linearId;
        }

        @NotNull
        public final State copy(@NotNull List<? extends AbstractParty> participants, @NotNull UniqueIdentifier linearId) {
            Intrinsics.checkNotNullParameter(participants, (String)"participants");
            Intrinsics.checkNotNullParameter((Object)linearId, (String)"linearId");
            return new State(participants, linearId);
        }

        public static /* synthetic */ State copy$default(State state, List list, UniqueIdentifier uniqueIdentifier, int n, Object object) {
            if ((n & 1) != 0) {
                list = state.participants;
            }
            if ((n & 2) != 0) {
                uniqueIdentifier = state.linearId;
            }
            return state.copy(list, uniqueIdentifier);
        }

        @NotNull
        public String toString() {
            return "State(participants=" + this.participants + ", linearId=" + this.linearId + ")";
        }

        public int hashCode() {
            int result = ((Object)this.participants).hashCode();
            result = result * 31 + this.linearId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.participants, state.participants)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.linearId, (Object)state.linearId);
        }
    }
}

