/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.internal.vault;

import java.security.PublicKey;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.CommandAndState;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.OwnableState;
import net.corda.core.identity.AbstractParty;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.schemas.QueryableState;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.testing.core.DummyCommandData;
import net.corda.testing.internal.vault.UniqueDummyFungibleStateSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnet/corda/testing/internal/vault/UniqueDummyFungibleContract;", "Lnet/corda/core/contracts/Contract;", "()V", "verify", "", "tx", "Lnet/corda/core/transactions/LedgerTransaction;", "State", "test-utils"})
public final class UniqueDummyFungibleContract
implements Contract {
    public void verify(@NotNull LedgerTransaction tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B!\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0016J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\bH\u0016J*\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u00052\u0006\u0010*\u001a\u00020\bH\u0016R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006-"}, d2={"Lnet/corda/testing/internal/vault/UniqueDummyFungibleContract$State;", "Lnet/corda/core/contracts/FungibleAsset;", "Ljava/util/Currency;", "Lnet/corda/core/schemas/QueryableState;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "owner", "Lnet/corda/core/identity/AbstractParty;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/AbstractParty;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "exitKeys", "", "Ljava/security/PublicKey;", "getExitKeys", "()Ljava/util/Set;", "getOwner", "()Lnet/corda/core/identity/AbstractParty;", "participants", "", "getParticipants", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "generateMappedObject", "Lnet/corda/core/schemas/PersistentState;", "schema", "Lnet/corda/core/schemas/MappedSchema;", "hashCode", "", "supportedSchemas", "", "toString", "", "withNewOwner", "Lnet/corda/core/contracts/CommandAndState;", "newOwner", "withNewOwnerAndAmount", "newAmount", "test-utils"})
    public static final class State
    implements FungibleAsset<Currency>,
    QueryableState {
        @NotNull
        private final Amount<Issued<Currency>> amount;
        @NotNull
        private final AbstractParty owner;
        @NotNull
        private final Set<PublicKey> exitKeys;
        @NotNull
        private final List<AbstractParty> participants;

        public State(@NotNull Amount<Issued<Currency>> amount, @NotNull AbstractParty owner) {
            Intrinsics.checkNotNullParameter(amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.amount = amount;
            this.owner = owner;
            Object[] objectArray = new PublicKey[]{this.getOwner().getOwningKey(), ((Issued)this.getAmount().getToken()).getIssuer().getParty().getOwningKey()};
            this.exitKeys = SetsKt.setOf((Object[])objectArray);
            this.participants = CollectionsKt.listOf((Object)this.getOwner());
        }

        @NotNull
        public Amount<Issued<Currency>> getAmount() {
            return this.amount;
        }

        @NotNull
        public AbstractParty getOwner() {
            return this.owner;
        }

        @NotNull
        public Set<PublicKey> getExitKeys() {
            return this.exitKeys;
        }

        @NotNull
        public List<AbstractParty> getParticipants() {
            return this.participants;
        }

        @NotNull
        public FungibleAsset<Currency> withNewOwnerAndAmount(@NotNull Amount<Issued<Currency>> newAmount, @NotNull AbstractParty newOwner) {
            Intrinsics.checkNotNullParameter(newAmount, (String)"newAmount");
            Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
            return this.copy((Amount<Issued<Currency>>)Amount.copy$default(this.getAmount(), (long)newAmount.getQuantity(), null, null, (int)6, null), newOwner);
        }

        @NotNull
        public CommandAndState withNewOwner(@NotNull AbstractParty newOwner) {
            Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
            return new CommandAndState((CommandData)DummyCommandData.INSTANCE, (OwnableState)State.copy$default(this, null, newOwner, 1, null));
        }

        @NotNull
        public Iterable<MappedSchema> supportedSchemas() {
            return CollectionsKt.listOf((Object)((Object)UniqueDummyFungibleStateSchema.INSTANCE));
        }

        @NotNull
        public PersistentState generateMappedObject(@NotNull MappedSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            String string = ((Currency)((Issued)this.getAmount().getToken()).getProduct()).getCurrencyCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
            return new UniqueDummyFungibleStateSchema.UniquePersistentDummyFungibleState(string);
        }

        @NotNull
        public final Amount<Issued<Currency>> component1() {
            return this.amount;
        }

        @NotNull
        public final AbstractParty component2() {
            return this.owner;
        }

        @NotNull
        public final State copy(@NotNull Amount<Issued<Currency>> amount, @NotNull AbstractParty owner) {
            Intrinsics.checkNotNullParameter(amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new State(amount, owner);
        }

        public static /* synthetic */ State copy$default(State state, Amount amount, AbstractParty abstractParty, int n, Object object) {
            if ((n & 1) != 0) {
                amount = state.amount;
            }
            if ((n & 2) != 0) {
                abstractParty = state.owner;
            }
            return state.copy(amount, abstractParty);
        }

        @NotNull
        public String toString() {
            return "State(amount=" + this.amount + ", owner=" + this.owner + ")";
        }

        public int hashCode() {
            int result = this.amount.hashCode();
            result = result * 31 + this.owner.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.amount, state.amount)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.owner, (Object)state.owner);
        }
    }
}

