/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.internal.vault;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.LinearState;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.UniqueIdentifier;
import net.corda.core.crypto.SecureHash;
import net.corda.core.identity.AbstractParty;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.schemas.QueryableState;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.testing.internal.vault.DummyLinearStateSchemaV1;
import net.corda.testing.internal.vault.DummyLinearStateSchemaV2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnet/corda/testing/internal/vault/DummyLinearContract;", "Lnet/corda/core/contracts/Contract;", "()V", "verify", "", "tx", "Lnet/corda/core/transactions/LedgerTransaction;", "State", "test-utils"})
@SourceDebugExtension(value={"SMAP\nDummyLinearContract.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DummyLinearContract.kt\nnet/corda/testing/internal/vault/DummyLinearContract\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ContractsDSL.kt\nnet/corda/core/contracts/ContractsDSL\n+ 4 ContractsDSL.kt\nnet/corda/core/contracts/Requirements\n*L\n1#1,63:1\n1549#2:64\n1620#2,3:65\n800#2,11:68\n1549#2:79\n1620#2,3:80\n800#2,11:83\n1549#2:94\n1620#2,3:95\n1549#2:98\n1620#2,3:99\n27#3:102\n23#4,2:103\n23#4,2:105\n*S KotlinDebug\n*F\n+ 1 DummyLinearContract.kt\nnet/corda/testing/internal/vault/DummyLinearContract\n*L\n20#1:64\n20#1:65,3\n20#1:68,11\n21#1:79\n21#1:80,3\n21#1:83,11\n23#1:94\n23#1:95,3\n24#1:98\n24#1:99,3\n25#1:102\n26#1:103,2\n27#1:105,2\n*E\n"})
public final class DummyLinearContract
implements Contract {
    /*
     * WARNING - void declaration
     */
    public void verify(@NotNull LedgerTransaction tx) {
        String $this$using$iv;
        boolean expr$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$mapTo$iv$iv3;
        void $this$filterIsInstanceTo$iv$iv2;
        Collection collection;
        Iterable $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Iterable $this$map$iv = tx.getInputs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            StateAndRef stateAndRef = (StateAndRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getState().getData());
        }
        Iterable $this$filterIsInstance$iv2 = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv4 = $this$filterIsInstance$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof State)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inputs = (List)destination$iv$iv;
        Iterable $this$map$iv2 = tx.getOutputs();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            TransactionState bl = (TransactionState)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getData());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filterIsInstance2 = false;
        $this$mapTo$iv$iv3 = $this$filterIsInstance$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof State)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List outputs = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = inputs;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            State bl2 = (State)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getLinearId());
        }
        List inputIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv3));
        Iterable $this$map$iv4 = outputs;
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State bl = (State)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl3 = false;
            collection.add(it.getLinearId());
        }
        List outputIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
        boolean $i$f$requireThat = false;
        Requirements $this$verify_u24lambda_u244 = Requirements.INSTANCE;
        boolean bl = false;
        destination$iv$iv4 = $this$verify_u24lambda_u244;
        String $i$f$mapTo222 = "LinearStates are not merged";
        boolean item$iv$iv = ((Collection)inputIds).size() == ((Collection)inputs).size();
        boolean $i$f$using = false;
        if (!expr$iv) {
            throw new IllegalArgumentException("Failed requirement: " + $this$using$iv);
        }
        Requirements this_$iv = $this$verify_u24lambda_u244;
        $this$using$iv = "LinearStates are not split";
        expr$iv = ((Collection)outputIds).size() == ((Collection)outputs).size();
        $i$f$using = false;
        if (!expr$iv) {
            throw new IllegalArgumentException("Failed requirement: " + $this$using$iv);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002BQ\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J\t\u0010%\u001a\u00020\rH\u00c6\u0003J\t\u0010&\u001a\u00020\u000fH\u00c6\u0003J\t\u0010'\u001a\u00020\u0011H\u00c6\u0003JU\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u000f2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u000201H\u00d6\u0001J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020/03H\u0016J\t\u00104\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lnet/corda/testing/internal/vault/DummyLinearContract$State;", "Lnet/corda/core/contracts/LinearState;", "Lnet/corda/core/schemas/QueryableState;", "linearId", "Lnet/corda/core/contracts/UniqueIdentifier;", "participants", "", "Lnet/corda/core/identity/AbstractParty;", "linearString", "", "linearNumber", "", "linearTimestamp", "Ljava/time/Instant;", "linearBoolean", "", "nonce", "Lnet/corda/core/crypto/SecureHash;", "(Lnet/corda/core/contracts/UniqueIdentifier;Ljava/util/List;Ljava/lang/String;JLjava/time/Instant;ZLnet/corda/core/crypto/SecureHash;)V", "getLinearBoolean", "()Z", "getLinearId", "()Lnet/corda/core/contracts/UniqueIdentifier;", "getLinearNumber", "()J", "getLinearString", "()Ljava/lang/String;", "getLinearTimestamp", "()Ljava/time/Instant;", "getNonce", "()Lnet/corda/core/crypto/SecureHash;", "getParticipants", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "generateMappedObject", "Lnet/corda/core/schemas/PersistentState;", "schema", "Lnet/corda/core/schemas/MappedSchema;", "hashCode", "", "supportedSchemas", "", "toString", "test-utils"})
    public static final class State
    implements LinearState,
    QueryableState {
        @NotNull
        private final UniqueIdentifier linearId;
        @NotNull
        private final List<AbstractParty> participants;
        @NotNull
        private final String linearString;
        private final long linearNumber;
        @NotNull
        private final Instant linearTimestamp;
        private final boolean linearBoolean;
        @NotNull
        private final SecureHash nonce;

        public State(@NotNull UniqueIdentifier linearId, @NotNull List<? extends AbstractParty> participants, @NotNull String linearString, long linearNumber, @NotNull Instant linearTimestamp, boolean linearBoolean, @NotNull SecureHash nonce) {
            Intrinsics.checkNotNullParameter((Object)linearId, (String)"linearId");
            Intrinsics.checkNotNullParameter(participants, (String)"participants");
            Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
            Intrinsics.checkNotNullParameter((Object)linearTimestamp, (String)"linearTimestamp");
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            this.linearId = linearId;
            this.participants = participants;
            this.linearString = linearString;
            this.linearNumber = linearNumber;
            this.linearTimestamp = linearTimestamp;
            this.linearBoolean = linearBoolean;
            this.nonce = nonce;
        }

        public /* synthetic */ State(UniqueIdentifier uniqueIdentifier, List list, String string, long l, Instant instant, boolean bl, SecureHash secureHash, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                uniqueIdentifier = new UniqueIdentifier(null, null, 3, null);
            }
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                string = "ABC";
            }
            if ((n & 8) != 0) {
                l = 123L;
            }
            if ((n & 0x10) != 0) {
                Instant instant2 = LocalDateTime.now().toInstant(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"toInstant(...)");
                instant = instant2;
            }
            if ((n & 0x20) != 0) {
                bl = true;
            }
            if ((n & 0x40) != 0) {
                secureHash = (SecureHash)SecureHash.Companion.randomSHA256();
            }
            this(uniqueIdentifier, list, string, l, instant, bl, secureHash);
        }

        @NotNull
        public UniqueIdentifier getLinearId() {
            return this.linearId;
        }

        @NotNull
        public List<AbstractParty> getParticipants() {
            return this.participants;
        }

        @NotNull
        public final String getLinearString() {
            return this.linearString;
        }

        public final long getLinearNumber() {
            return this.linearNumber;
        }

        @NotNull
        public final Instant getLinearTimestamp() {
            return this.linearTimestamp;
        }

        public final boolean getLinearBoolean() {
            return this.linearBoolean;
        }

        @NotNull
        public final SecureHash getNonce() {
            return this.nonce;
        }

        @NotNull
        public Iterable<MappedSchema> supportedSchemas() {
            Object[] objectArray = new MappedSchema[]{DummyLinearStateSchemaV1.INSTANCE, DummyLinearStateSchemaV2.INSTANCE};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public PersistentState generateMappedObject(@NotNull MappedSchema schema) {
            PersistentState persistentState;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            MappedSchema mappedSchema = schema;
            if (mappedSchema instanceof DummyLinearStateSchemaV1) {
                persistentState = new DummyLinearStateSchemaV1.PersistentDummyLinearState(CollectionsKt.toMutableSet((Iterable)this.getParticipants()), this.getLinearId().getExternalId(), this.getLinearId().getId(), this.linearString, this.linearNumber, this.linearTimestamp, this.linearBoolean);
            } else if (mappedSchema instanceof DummyLinearStateSchemaV2) {
                Set set = CollectionsKt.toMutableSet((Iterable)this.getParticipants());
                UniqueIdentifier uniqueIdentifier = this.getLinearId();
                String string = this.linearString;
                long l = this.linearNumber;
                Instant instant = this.linearTimestamp;
                boolean bl = this.linearBoolean;
                persistentState = (PersistentState)new DummyLinearStateSchemaV2.PersistentDummyLinearState(set, string, l, instant, bl, uniqueIdentifier);
            } else {
                throw new IllegalArgumentException("Unrecognised schema " + schema);
            }
            return persistentState;
        }

        @NotNull
        public final UniqueIdentifier component1() {
            return this.linearId;
        }

        @NotNull
        public final List<AbstractParty> component2() {
            return this.participants;
        }

        @NotNull
        public final String component3() {
            return this.linearString;
        }

        public final long component4() {
            return this.linearNumber;
        }

        @NotNull
        public final Instant component5() {
            return this.linearTimestamp;
        }

        public final boolean component6() {
            return this.linearBoolean;
        }

        @NotNull
        public final SecureHash component7() {
            return this.nonce;
        }

        @NotNull
        public final State copy(@NotNull UniqueIdentifier linearId, @NotNull List<? extends AbstractParty> participants, @NotNull String linearString, long linearNumber, @NotNull Instant linearTimestamp, boolean linearBoolean, @NotNull SecureHash nonce) {
            Intrinsics.checkNotNullParameter((Object)linearId, (String)"linearId");
            Intrinsics.checkNotNullParameter(participants, (String)"participants");
            Intrinsics.checkNotNullParameter((Object)linearString, (String)"linearString");
            Intrinsics.checkNotNullParameter((Object)linearTimestamp, (String)"linearTimestamp");
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            return new State(linearId, participants, linearString, linearNumber, linearTimestamp, linearBoolean, nonce);
        }

        public static /* synthetic */ State copy$default(State state, UniqueIdentifier uniqueIdentifier, List list, String string, long l, Instant instant, boolean bl, SecureHash secureHash, int n, Object object) {
            if ((n & 1) != 0) {
                uniqueIdentifier = state.linearId;
            }
            if ((n & 2) != 0) {
                list = state.participants;
            }
            if ((n & 4) != 0) {
                string = state.linearString;
            }
            if ((n & 8) != 0) {
                l = state.linearNumber;
            }
            if ((n & 0x10) != 0) {
                instant = state.linearTimestamp;
            }
            if ((n & 0x20) != 0) {
                bl = state.linearBoolean;
            }
            if ((n & 0x40) != 0) {
                secureHash = state.nonce;
            }
            return state.copy(uniqueIdentifier, list, string, l, instant, bl, secureHash);
        }

        @NotNull
        public String toString() {
            return "State(linearId=" + this.linearId + ", participants=" + this.participants + ", linearString=" + this.linearString + ", linearNumber=" + this.linearNumber + ", linearTimestamp=" + this.linearTimestamp + ", linearBoolean=" + this.linearBoolean + ", nonce=" + this.nonce + ")";
        }

        public int hashCode() {
            int result = this.linearId.hashCode();
            result = result * 31 + ((Object)this.participants).hashCode();
            result = result * 31 + this.linearString.hashCode();
            result = result * 31 + Long.hashCode(this.linearNumber);
            result = result * 31 + this.linearTimestamp.hashCode();
            result = result * 31 + Boolean.hashCode(this.linearBoolean);
            result = result * 31 + this.nonce.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual((Object)this.linearId, (Object)state.linearId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.participants, state.participants)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.linearString, (Object)state.linearString)) {
                return false;
            }
            if (this.linearNumber != state.linearNumber) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.linearTimestamp, (Object)state.linearTimestamp)) {
                return false;
            }
            if (this.linearBoolean != state.linearBoolean) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.nonce, (Object)state.nonce);
        }

        public State() {
            this(null, null, null, 0L, null, false, null, 127, null);
        }
    }
}

