/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.internal.vault;

import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.BelongsToContract;
import net.corda.core.contracts.CommandAndState;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.identity.AbstractParty;
import net.corda.finance.contracts.Commodity;
import net.corda.finance.contracts.asset.Obligation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BelongsToContract(value=Obligation.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB!\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J)\u0010\u001b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bH\u0016J*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00062\u0006\u0010&\u001a\u00020\bH\u0016R \u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lnet/corda/testing/internal/vault/CommodityState;", "Lnet/corda/core/contracts/FungibleAsset;", "Lnet/corda/finance/contracts/Commodity;", "deposit", "Lnet/corda/core/contracts/PartyAndReference;", "amount", "Lnet/corda/core/contracts/Amount;", "owner", "Lnet/corda/core/identity/AbstractParty;", "(Lnet/corda/core/contracts/PartyAndReference;Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/AbstractParty;)V", "Lnet/corda/core/contracts/Issued;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/AbstractParty;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "exitKeys", "", "Ljava/security/PublicKey;", "getExitKeys", "()Ljava/util/Set;", "getOwner", "()Lnet/corda/core/identity/AbstractParty;", "participants", "", "getParticipants", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "withNewOwner", "Lnet/corda/core/contracts/CommandAndState;", "newOwner", "withNewOwnerAndAmount", "newAmount", "test-utils"})
public final class CommodityState
implements FungibleAsset<Commodity> {
    @NotNull
    private final Amount<Issued<Commodity>> amount;
    @NotNull
    private final AbstractParty owner;
    @NotNull
    private final Set<PublicKey> exitKeys;
    @NotNull
    private final List<AbstractParty> participants;

    public CommodityState(@NotNull Amount<Issued<Commodity>> amount, @NotNull AbstractParty owner) {
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.amount = amount;
        this.owner = owner;
        Set<PublicKey> set = Collections.singleton(this.getOwner().getOwningKey());
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        this.exitKeys = set;
        this.participants = CollectionsKt.listOf((Object)this.getOwner());
    }

    @NotNull
    public Amount<Issued<Commodity>> getAmount() {
        return this.amount;
    }

    @NotNull
    public AbstractParty getOwner() {
        return this.owner;
    }

    public CommodityState(@NotNull PartyAndReference deposit, @NotNull Amount<Commodity> amount, @NotNull AbstractParty owner) {
        Intrinsics.checkNotNullParameter((Object)deposit, (String)"deposit");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this((Amount<Issued<Commodity>>)new Amount(amount.getQuantity(), (Object)new Issued(deposit, amount.getToken())), owner);
    }

    @NotNull
    public Set<PublicKey> getExitKeys() {
        return this.exitKeys;
    }

    @NotNull
    public List<AbstractParty> getParticipants() {
        return this.participants;
    }

    @NotNull
    public FungibleAsset<Commodity> withNewOwnerAndAmount(@NotNull Amount<Issued<Commodity>> newAmount, @NotNull AbstractParty newOwner) {
        Intrinsics.checkNotNullParameter(newAmount, (String)"newAmount");
        Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
        return this.copy((Amount<Issued<Commodity>>)Amount.copy$default(this.getAmount(), (long)newAmount.getQuantity(), null, null, (int)6, null), newOwner);
    }

    @NotNull
    public String toString() {
        return "Commodity(" + this.getAmount() + " at " + ((Issued)this.getAmount().getToken()).getIssuer() + " owned by " + this.getOwner() + ")";
    }

    @NotNull
    public CommandAndState withNewOwner(@NotNull AbstractParty newOwner) {
        Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
        return new CommandAndState((CommandData)new Obligation.Commands.Move(null, 1, null), (OwnableState)CommodityState.copy$default(this, null, newOwner, 1, null));
    }

    @NotNull
    public final Amount<Issued<Commodity>> component1() {
        return this.amount;
    }

    @NotNull
    public final AbstractParty component2() {
        return this.owner;
    }

    @NotNull
    public final CommodityState copy(@NotNull Amount<Issued<Commodity>> amount, @NotNull AbstractParty owner) {
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return new CommodityState(amount, owner);
    }

    public static /* synthetic */ CommodityState copy$default(CommodityState commodityState, Amount amount, AbstractParty abstractParty, int n, Object object) {
        if ((n & 1) != 0) {
            amount = commodityState.amount;
        }
        if ((n & 2) != 0) {
            abstractParty = commodityState.owner;
        }
        return commodityState.copy(amount, abstractParty);
    }

    public int hashCode() {
        int result = this.amount.hashCode();
        result = result * 31 + this.owner.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommodityState)) {
            return false;
        }
        CommodityState commodityState = (CommodityState)other;
        if (!Intrinsics.areEqual(this.amount, commodityState.amount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.owner, (Object)commodityState.owner);
    }
}

