/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import net.corda.core.internal.InternalUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\u0003\u001a\u00020\u00042\u001a\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\u0006\"\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\f\u001a\u00020\u00042\u001a\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\u0006\"\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J5\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"Lnet/corda/testing/internal/LogHelper;", "", "()V", "reset", "", "names", "", "", "([Ljava/lang/String;)V", "classes", "Lkotlin/reflect/KClass;", "([Lkotlin/reflect/KClass;)V", "setLevel", "loggerNames", "name", "level", "Lorg/apache/logging/log4j/Level;", "withLevel", "T", "logName", "levelName", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "test-utils"})
@SourceDebugExtension(value={"SMAP\nLogHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHelper.kt\nnet/corda/testing/internal/LogHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,66:1\n11065#2:67\n11400#2,3:68\n13309#2,2:73\n11065#2:75\n11400#2,3:76\n37#3,2:71\n37#3,2:79\n*S KotlinDebug\n*F\n+ 1 LogHelper.kt\nnet/corda/testing/internal/LogHelper\n*L\n29#1:67\n29#1:68,3\n35#1:73,2\n39#1:75\n39#1:76,3\n29#1:71,2\n39#1:79,2\n*E\n"})
public final class LogHelper {
    @NotNull
    public static final LogHelper INSTANCE = new LogHelper();

    private LogHelper() {
    }

    public final void setLevel(String ... loggerNames) {
        Intrinsics.checkNotNullParameter((Object)loggerNames, (String)"loggerNames");
        for (String spec : loggerNames) {
            Pair pair;
            char c = spec.charAt(0);
            if (c == '+') {
                String string = spec.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pair = TuplesKt.to((Object)string, (Object)Level.ALL);
            } else if (c == '-') {
                String string = spec.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pair = TuplesKt.to((Object)string, (Object)Level.OFF);
            } else {
                pair = TuplesKt.to((Object)spec, (Object)Level.ALL);
            }
            Pair pair2 = pair;
            String name = (String)pair2.component1();
            Level level = (Level)pair2.component2();
            Intrinsics.checkNotNull((Object)level);
            this.setLevel(name, level);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setLevel(KClass<?> ... classes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        KClass<?>[] kClassArray = classes;
        LogHelper logHelper = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("+" + InternalUtils.getPackageName((KClass)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        logHelper.setLevel(Arrays.copyOf(stringArray, stringArray.length));
    }

    public final void reset(String ... names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        Intrinsics.checkNotNull((Object)loggerContext, (String)"null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
        LoggerContext loggerContext2 = (LoggerContext)loggerContext;
        Configuration config = loggerContext2.getConfiguration();
        String[] $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            config.removeLogger(it);
        }
        loggerContext2.updateLoggers(config);
    }

    /*
     * WARNING - void declaration
     */
    public final void reset(KClass<?> ... classes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        KClass<?>[] kClassArray = classes;
        LogHelper logHelper = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InternalUtils.getPackageName((KClass)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        logHelper.reset(Arrays.copyOf(stringArray, stringArray.length));
    }

    private final void setLevel(String name, Level level) {
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        Intrinsics.checkNotNull((Object)loggerContext, (String)"null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
        LoggerContext loggerContext2 = (LoggerContext)loggerContext;
        Configuration config = loggerContext2.getConfiguration();
        LoggerConfig loggerConfig = new LoggerConfig(name, level, false);
        loggerConfig.addAppender((Appender)config.getAppenders().get("Console-Appender"), null, null);
        config.removeLogger(name);
        config.addLogger(name, loggerConfig);
        loggerContext2.updateLoggers(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLevel(@NotNull String logName, @NotNull String levelName, @NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logName, (String)"logName");
        Intrinsics.checkNotNullParameter((Object)levelName, (String)"levelName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withLevel = false;
        LogHelper $this$withLevel_u24lambda_u243 = this;
        boolean bl = false;
        Level level = Level.valueOf((String)levelName);
        Level oldLevel = LogManager.getLogger((String)logName).getLevel();
        Configurator.setLevel((String)logName, (Level)level);
        try {
            object = block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Configurator.setLevel((String)logName, (Level)oldLevel);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }
}

