/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.internal;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.Stack;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.io.serialization.ByteArraySerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Closeable;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.client.jackson.JacksonSupport;
import net.corda.core.flows.FlowLogic;
import net.corda.core.flows.FlowStackSnapshot;
import net.corda.core.flows.StackFrameDataToken;
import net.corda.core.flows.StateMachineRunId;
import net.corda.core.internal.FlowStateMachine;
import net.corda.core.serialization.SerializeAsToken;
import net.corda.node.services.statemachine.FlowStackSnapshotFactory;
import net.corda.testing.internal.FlowStackSnapshotKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J6\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u001c\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0017J,\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lnet/corda/testing/internal/FlowStackSnapshotFactoryImpl;", "Lnet/corda/node/services/statemachine/FlowStackSnapshotFactory;", "()V", "instrumentedAnnotation", "", "Ljava/lang/StackTraceElement;", "getInstrumentedAnnotation", "(Ljava/lang/StackTraceElement;)Ljava/lang/annotation/Annotation;", "createFile", "Ljava/nio/file/Path;", "baseDir", "flowId", "Lnet/corda/core/flows/StateMachineRunId;", "extractStackSnapshotFromFiber", "Lnet/corda/core/flows/FlowStackSnapshot;", "fiber", "Lco/paralleluniverse/fibers/Fiber;", "stackTrace", "", "flowClass", "Ljava/lang/Class;", "Lnet/corda/core/flows/FlowLogic;", "filterOutStackDump", "flowStackSnapshot", "getFlowStackSnapshot", "persistAsJsonFile", "", "removeConstructorStackTraceElements", "Companion", "ThreadLocalIndex", "test-utils"})
@SourceDebugExtension(value={"SMAP\nFlowStackSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowStackSnapshot.kt\nnet/corda/testing/internal/FlowStackSnapshotFactoryImpl\n+ 2 PathUtils.kt\nnet/corda/core/internal/PathUtilsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,208:1\n77#2:209\n78#2,5:211\n26#3:210\n1549#4:216\n1620#4,3:217\n1549#4:220\n1620#4,3:221\n1549#4:224\n1620#4,3:225\n766#4:230\n857#4,2:231\n1549#4:233\n1620#4,2:234\n1549#4:236\n1620#4,3:237\n1622#4:240\n13309#5,2:228\n*S KotlinDebug\n*F\n+ 1 FlowStackSnapshot.kt\nnet/corda/testing/internal/FlowStackSnapshotFactoryImpl\n*L\n67#1:209\n67#1:211,5\n67#1:210\n76#1:216\n76#1:217,3\n82#1:220\n82#1:221,3\n87#1:224\n87#1:225,3\n126#1:230\n126#1:231,2\n129#1:233\n129#1:234,2\n130#1:236\n130#1:237,3\n129#1:240\n102#1:228,2\n*E\n"})
public final class FlowStackSnapshotFactoryImpl
implements FlowStackSnapshotFactory {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private static final String QUASAR_0_7_INSTRUMENTED_CLASS_NAME = "co.paralleluniverse.fibers.Instrumented";
    @NotNull
    private static final String QUASAR_0_8_INSTRUMENTED_CLASS_NAME = "co.paralleluniverse.fibers.suspend.Instrumented";
    @NotNull
    private static final Class<? extends Annotation> instrumentedAnnotationClass;
    private static final Method methodOptimized;

    @Suspendable
    @NotNull
    public FlowStackSnapshot getFlowStackSnapshot(@NotNull Class<? extends FlowLogic<?>> flowClass) {
        Intrinsics.checkNotNullParameter(flowClass, (String)"flowClass");
        Ref.ObjectRef snapshot = new Ref.ObjectRef();
        StackTraceElement[] stackTrace = Fiber.currentFiber().getStackTrace();
        Fiber.parkAndSerialize((arg_0, arg_1) -> FlowStackSnapshotFactoryImpl.getFlowStackSnapshot$lambda$0(snapshot, this, stackTrace, flowClass, arg_0, arg_1));
        FlowStackSnapshot temporarySnapshot = (FlowStackSnapshot)snapshot.element;
        snapshot.element = null;
        FlowStackSnapshot flowStackSnapshot = temporarySnapshot;
        Intrinsics.checkNotNull((Object)flowStackSnapshot);
        return flowStackSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void persistAsJsonFile(@NotNull Class<? extends FlowLogic<?>> flowClass, @NotNull Path baseDir, @NotNull StateMachineRunId flowId) {
        void $this$write_u24default$iv;
        ObjectMapper objectMapper;
        Intrinsics.checkNotNullParameter(flowClass, (String)"flowClass");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
        FlowStackSnapshot flowStackSnapshot = this.getFlowStackSnapshot(flowClass);
        Object $this$persistAsJsonFile_u24lambda_u241 = objectMapper = JacksonSupport.createNonRpcMapper$default(null, (boolean)false, (int)3, null);
        boolean bl = false;
        $this$persistAsJsonFile_u24lambda_u241.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        $this$persistAsJsonFile_u24lambda_u241.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ObjectMapper mapper = objectMapper;
        Path file = this.createFile(baseDir, flowId);
        $this$persistAsJsonFile_u24lambda_u241 = file;
        boolean createDirs$iv = true;
        boolean $i$f$emptyArray = false;
        OpenOption[] options$iv = new OpenOption[]{};
        boolean $i$f$write = false;
        Path path = $this$write_u24default$iv.normalize().getParent();
        if (path != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            v3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
        } else {
            v3 = null;
        }
        OpenOption[] openOptionArray = Arrays.copyOf(options$iv, options$iv.length);
        OutputStream outputStream = Files.newOutputStream((Path)$this$write_u24default$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl2 = false;
            mapper.writeValue(it, (Object)this.filterOutStackDump(flowStackSnapshot));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FlowStackSnapshot extractStackSnapshotFromFiber(Fiber<?> fiber, List<StackTraceElement> stackTrace, Class<? extends FlowLogic<?>> flowClass) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Stack stack = FlowStackSnapshotKt.access$getFiberStack(fiber);
        List objectStack = ArraysKt.toList((Object[])FlowStackSnapshotKt.access$getObjectStack(stack));
        List frameOffsets = FlowStackSnapshotKt.access$getFrameOffsets(stack);
        Iterable $this$map$iv = frameOffsets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            int frameOffset = ((Number)pair.component1()).intValue();
            int frameSize = ((Number)pair.component2()).intValue();
            collection.add(CollectionsKt.toList((Iterable)objectStack.subList(frameOffset + 1, frameOffset + frameSize + 1)));
        }
        List frameObjects = (List)destination$iv$iv;
        List relevantStackTrace = CollectionsKt.drop((Iterable)this.removeConstructorStackTraceElements(stackTrace), (int)1);
        Iterable $this$map$iv2 = relevantStackTrace;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            StackTraceElement frameOffset = (StackTraceElement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            StackTraceElement element = new StackTraceElement(it.getClassName(), it.getMethodName(), it.getFileName(), it.getLineNumber());
            collection.add(TuplesKt.to((Object)element, (Object)this.getInstrumentedAnnotation(element)));
        }
        List stackTraceToAnnotation = (List)destination$iv$iv2;
        ListIterator frameObjectsIterator = frameObjects.listIterator();
        Iterable $this$map$iv3 = CollectionsKt.reversed((Iterable)stackTraceToAnnotation);
        boolean $i$f$map3 = false;
        Iterable $i$f$mapTo32 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            StackTraceElement element = (StackTraceElement)pair.component1();
            Annotation annotation = (Annotation)pair.component2();
            List stackObjects = frameObjectsIterator.hasNext() && (annotation == null || !FlowStackSnapshotFactoryImpl.Companion.isMethodOptimized(annotation)) ? (List)frameObjectsIterator.next() : CollectionsKt.emptyList();
            collection.add(new FlowStackSnapshot.Frame(element, stackObjects));
        }
        List frames = (List)destination$iv$iv3;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        String string = flowClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new FlowStackSnapshot(instant, string, frames);
    }

    private final Annotation getInstrumentedAnnotation(StackTraceElement $this$instrumentedAnnotation) {
        Method[] methodArray = Class.forName($this$instrumentedAnnotation.getClassName(), false, $this$instrumentedAnnotation.getClass().getClassLoader()).getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$forEach$iv = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$instrumentedAnnotation.getMethodName()) || !it.isAnnotationPresent(instrumentedAnnotationClass)) continue;
            return it.getAnnotation(instrumentedAnnotationClass);
        }
        return null;
    }

    private final List<StackTraceElement> removeConstructorStackTraceElements(List<StackTraceElement> stackTrace) {
        ArrayList<StackTraceElement> newStackTrace = new ArrayList<StackTraceElement>();
        StackTraceElement previousElement = null;
        for (StackTraceElement element : stackTrace) {
            StackTraceElement stackTraceElement = previousElement;
            if (Intrinsics.areEqual((Object)element.getMethodName(), (Object)(stackTraceElement != null ? stackTraceElement.getMethodName() : null))) {
                StackTraceElement stackTraceElement2 = previousElement;
                if (Intrinsics.areEqual((Object)element.getClassName(), (Object)(stackTraceElement2 != null ? stackTraceElement2.getClassName() : null))) {
                    StackTraceElement stackTraceElement3 = previousElement;
                    if (Intrinsics.areEqual((Object)element.getFileName(), (Object)(stackTraceElement3 != null ? stackTraceElement3.getFileName() : null))) continue;
                }
            }
            newStackTrace.add(element);
            previousElement = element;
        }
        return newStackTrace;
    }

    /*
     * WARNING - void declaration
     */
    private final FlowStackSnapshot filterOutStackDump(FlowStackSnapshot flowStackSnapshot) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = flowStackSnapshot.getStackFrames();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FlowStackSnapshot.Frame it = (FlowStackSnapshot.Frame)element$iv$iv;
            boolean bl = false;
            if (!(!FlowStateMachine.class.isAssignableFrom(Class.forName(it.getStackTraceElement().getClassName(), false, this.getClass().getClassLoader())))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List framesFilteredByStackTraceElement = (List)destination$iv$iv;
        Iterable $this$map$iv = framesFilteredByStackTraceElement;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<void> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            FlowStackSnapshot.Frame bl = (FlowStackSnapshot.Frame)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            Iterable iterable2 = it.getStackObjects();
            StackTraceElement stackTraceElement = null;
            void var15_20 = it;
            boolean $i$f$map2 = false;
            void var17_22 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                StackFrameDataToken stackFrameDataToken;
                void it2;
                Object item$iv$iv2;
                Object t = item$iv$iv2 = iterator.next();
                collection = destination$iv$iv3;
                boolean bl3 = false;
                if (it2 != null && (it2 instanceof FlowLogic || it2 instanceof FlowStateMachine || it2 instanceof Fiber || it2 instanceof SerializeAsToken)) {
                    String string = it2.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    stackFrameDataToken = new StackFrameDataToken(string);
                } else {
                    stackFrameDataToken = it2;
                }
                collection.add((void)stackFrameDataToken);
            }
            collection = (List)destination$iv$iv3;
            collection2.add(FlowStackSnapshot.Frame.copy$default((FlowStackSnapshot.Frame)var15_20, stackTraceElement, (List)collection, (int)1, null));
        }
        List framesFilteredByObjects = (List)destination$iv$iv2;
        return FlowStackSnapshot.copy$default((FlowStackSnapshot)flowStackSnapshot, null, null, (List)framesFilteredByObjects, (int)3, null);
    }

    private final Path createFile(Path baseDir, StateMachineRunId flowId) {
        Path path;
        Integer index;
        Path path2 = baseDir.resolve("flowStackSnapshots");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2;
        String string = LocalDate.now().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Path path4 = path3.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        path3 = path4;
        String string2 = flowId.getUuid().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Path path5 = path3.resolve(string2);
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        Path dir = path5;
        Integer n = index = ThreadLocalIndex.Companion.getCurrentIndex().get();
        if (n != null && n == 0) {
            Path path6 = dir.resolve("flowStackSnapshot.json");
            path = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        } else {
            Path path7 = dir.resolve("flowStackSnapshot-" + index + ".json");
            path = path7;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        }
        Path file = path;
        ThreadLocalIndex.Companion.getCurrentIndex().set(index + 1);
        return file;
    }

    private static final void getFlowStackSnapshot$lambda$0(Ref.ObjectRef $snapshot, FlowStackSnapshotFactoryImpl this$0, StackTraceElement[] $stackTrace, Class $flowClass, Fiber fiber, ByteArraySerializer byteArraySerializer) {
        Intrinsics.checkNotNullParameter((Object)$snapshot, (String)"$snapshot");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$flowClass, (String)"$flowClass");
        Intrinsics.checkNotNull((Object)fiber);
        Intrinsics.checkNotNull((Object)$stackTrace);
        $snapshot.element = this$0.extractStackSnapshotFromFiber(fiber, ArraysKt.toList((Object[])$stackTrace), $flowClass);
        Fiber.unparkDeserialized((Fiber)fiber, (FiberScheduler)fiber.getScheduler());
    }

    static {
        Class<?> clazz;
        Companion = new Companion(null);
        try {
            clazz = Class.forName(QUASAR_0_7_INSTRUMENTED_CLASS_NAME, false, Companion.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Class.forName(QUASAR_0_8_INSTRUMENTED_CLASS_NAME, false, Companion.getClass().getClassLoader());
        }
        Class<?> clazz2 = clazz;
        Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<out kotlin.Annotation>");
        instrumentedAnnotationClass = clazz2;
        methodOptimized = instrumentedAnnotationClass.getMethod("methodOptimized", new Class[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/corda/testing/internal/FlowStackSnapshotFactoryImpl$Companion;", "", "()V", "QUASAR_0_7_INSTRUMENTED_CLASS_NAME", "", "QUASAR_0_8_INSTRUMENTED_CLASS_NAME", "instrumentedAnnotationClass", "Ljava/lang/Class;", "", "getInstrumentedAnnotationClass$annotations", "methodOptimized", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "isMethodOptimized", "", "annotation", "test-utils"})
    private static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getInstrumentedAnnotationClass$annotations() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isMethodOptimized(Annotation annotation) {
            if (!instrumentedAnnotationClass.isInstance(annotation)) return false;
            Object object = methodOptimized.invoke((Object)annotation, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            if ((Boolean)object == false) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/testing/internal/FlowStackSnapshotFactoryImpl$ThreadLocalIndex;", "", "()V", "Companion", "test-utils"})
    private static final class ThreadLocalIndex {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final ThreadLocal<Integer> currentIndex = new ThreadLocal<Integer>(){

            @NotNull
            protected Integer initialValue() {
                return 0;
            }
        };

        private ThreadLocalIndex() {
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/testing/internal/FlowStackSnapshotFactoryImpl$ThreadLocalIndex$Companion;", "", "()V", "currentIndex", "Ljava/lang/ThreadLocal;", "", "getCurrentIndex", "()Ljava/lang/ThreadLocal;", "test-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ThreadLocal<Integer> getCurrentIndex() {
                return currentIndex;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

