/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.testing.http.HttpUtils;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u000e\u001a\u0002H\u000f\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0014J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0014R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lnet/corda/testing/http/HttpUtils;", "", "()V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "defaultMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDefaultMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "defaultMapper$delegate", "getJson", "T", "url", "Ljava/net/URL;", "params", "", "", "mapper", "(Ljava/net/URL;Ljava/util/Map;Lcom/fasterxml/jackson/databind/ObjectMapper;)Ljava/lang/Object;", "makeRequest", "", "request", "Lokhttp3/Request;", "postJson", "data", "postPlain", "putJson", "test-utils"})
@SourceDebugExtension(value={"SMAP\nHttpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUtils.kt\nnet/corda/testing/http/HttpUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,54:1\n125#2:55\n152#2,3:56\n*S KotlinDebug\n*F\n+ 1 HttpUtils.kt\nnet/corda/testing/http/HttpUtils\n*L\n42#1:55\n42#1:56,3\n*E\n"})
public final class HttpUtils {
    @NotNull
    public static final HttpUtils INSTANCE = new HttpUtils();
    @NotNull
    private static final Lazy client$delegate = LazyKt.lazy((Function0)client.2.INSTANCE);
    @NotNull
    private static final Lazy defaultMapper$delegate = LazyKt.lazy((Function0)defaultMapper.2.INSTANCE);

    private HttpUtils() {
    }

    private final OkHttpClient getClient() {
        Lazy lazy = client$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @NotNull
    public final ObjectMapper getDefaultMapper() {
        Lazy lazy = defaultMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    public final void putJson(@NotNull URL url, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        RequestBody body = RequestBody.Companion.create(data, MediaType.Companion.parse("application/json; charset=utf-8"));
        this.makeRequest(new Request.Builder().url(url).header("Content-Type", "application/json").put(body).build());
    }

    public final void postJson(@NotNull URL url, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        RequestBody body = RequestBody.Companion.create(data, MediaType.Companion.parse("application/json; charset=utf-8"));
        this.makeRequest(new Request.Builder().url(url).header("Content-Type", "application/json").post(body).build());
    }

    public final void postPlain(@NotNull URL url, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        RequestBody body = RequestBody.Companion.create(data, MediaType.Companion.parse("text/plain; charset=utf-8"));
        this.makeRequest(new Request.Builder().url(url).post(body).build());
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> T getJson(URL url, Map<String, String> params, ObjectMapper mapper) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        boolean $i$f$getJson = false;
        if (params.isEmpty()) {
            object = "";
        } else {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = params;
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey() + "=" + it.getValue());
            }
            object = "?" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }
        String paramString = object;
        URL parameterisedUrl = new URL(url.toExternalForm() + paramString);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object2 = mapper.readValue(parameterisedUrl, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"readValue(...)");
        return (T)object2;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Object getJson$default(HttpUtils $this, URL url, Map params, ObjectMapper mapper, int n, Object object) {
        Object object2;
        if ((n & 2) != 0) {
            params = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            mapper = $this.getDefaultMapper();
        }
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        boolean $i$f$getJson = false;
        if (params.isEmpty()) {
            object2 = "";
        } else {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = params;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey() + "=" + it.getValue());
            }
            object2 = "?" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }
        String paramString = object2;
        URL parameterisedUrl = new URL(url.toExternalForm() + paramString);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object3 = mapper.readValue(parameterisedUrl, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"readValue(...)");
        return object3;
    }

    private final void makeRequest(Request request) {
        Response response = this.getClient().newCall(request).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            throw new IOException(request.method() + " to " + request.url() + " returned a " + response.code() + ": " + (responseBody != null ? responseBody.string() : null));
        }
    }
}

