/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.testing.http.HttpApi;
import net.corda.testing.http.HttpUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u000b\u001a\u0002H\f\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0001J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u000eJ\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0001J\u0018\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u0019\u001a\u00020\u0001H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lnet/corda/testing/http/HttpApi;", "", "root", "Ljava/net/URL;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/net/URL;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getRoot", "()Ljava/net/URL;", "getJson", "T", "path", "", "params", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "postJson", "", "data", "postPlain", "putJson", "toJson", "kotlin.jvm.PlatformType", "any", "Companion", "test-utils"})
@SourceDebugExtension(value={"SMAP\nHttpApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpApi.kt\nnet/corda/testing/http/HttpApi\n+ 2 HttpUtils.kt\nnet/corda/testing/http/HttpUtils\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,47:1\n42#2:48\n43#2,2:53\n125#3:49\n152#3,3:50\n*S KotlinDebug\n*F\n+ 1 HttpApi.kt\nnet/corda/testing/http/HttpApi\n*L\n34#1:48\n34#1:53,2\n34#1:49\n34#1:50,3\n*E\n"})
public final class HttpApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL root;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private static final Lazy<ObjectMapper> defaultMapper$delegate = LazyKt.lazy((Function0)Companion.defaultMapper.2.INSTANCE);

    public HttpApi(@NotNull URL root, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.root = root;
        this.mapper = mapper;
    }

    public /* synthetic */ HttpApi(URL uRL, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            objectMapper = HttpApi.Companion.getDefaultMapper();
        }
        this(uRL, objectMapper);
    }

    @NotNull
    public final URL getRoot() {
        return this.root;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    public final void putJson(@NotNull String path, @NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        URL uRL = new URL(this.root, path);
        String string = this.toJson(data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        HttpUtils.INSTANCE.putJson(uRL, string);
    }

    public static /* synthetic */ void putJson$default(HttpApi httpApi, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = Unit.INSTANCE;
        }
        httpApi.putJson(string, object);
    }

    public final void postJson(@NotNull String path, @NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        URL uRL = new URL(this.root, path);
        String string = this.toJson(data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        HttpUtils.INSTANCE.postJson(uRL, string);
    }

    public static /* synthetic */ void postJson$default(HttpApi httpApi, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = Unit.INSTANCE;
        }
        httpApi.postJson(string, object);
    }

    public final void postPlain(@NotNull String path, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        HttpUtils.INSTANCE.postPlain(new URL(this.root, path), data);
    }

    public static /* synthetic */ void postPlain$default(HttpApi httpApi, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        httpApi.postPlain(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> T getJson(String path, Map<String, String> params) {
        void url$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        boolean $i$f$getJson = false;
        HttpUtils httpUtils = HttpUtils.INSTANCE;
        URL uRL = new URL(this.getRoot(), path);
        ObjectMapper mapper$iv = this.getMapper();
        boolean $i$f$getJson2 = false;
        if (params.isEmpty()) {
            object = "";
        } else {
            void $this$mapTo$iv$iv$iv;
            Map<String, String> $this$map$iv$iv = params;
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it$iv;
                Map.Entry item$iv$iv$iv;
                Map.Entry entry = item$iv$iv$iv = iterator.next();
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                collection.add(it$iv.getKey() + "=" + it$iv.getValue());
            }
            object = "?" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }
        String paramString$iv = object;
        URL parameterisedUrl$iv = new URL(url$iv.toExternalForm() + paramString$iv);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object2 = mapper$iv.readValue(parameterisedUrl$iv, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"readValue(...)");
        return (T)object2;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Object getJson$default(HttpApi $this, String path, Map params, int n, Object object) {
        void url$iv;
        Object object2;
        if ((n & 2) != 0) {
            params = MapsKt.emptyMap();
        }
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        boolean $i$f$getJson = false;
        object = HttpUtils.INSTANCE;
        URL uRL = new URL($this.getRoot(), path);
        ObjectMapper mapper$iv = $this.getMapper();
        boolean $i$f$getJson2 = false;
        if (params.isEmpty()) {
            object2 = "";
        } else {
            void $this$mapTo$iv$iv$iv;
            Map $this$map$iv$iv = params;
            boolean $i$f$map = false;
            Map map = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it$iv;
                Map.Entry item$iv$iv$iv;
                Map.Entry entry = item$iv$iv$iv = iterator.next();
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                collection.add(it$iv.getKey() + "=" + it$iv.getValue());
            }
            object2 = "?" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }
        String paramString$iv = object2;
        URL parameterisedUrl$iv = new URL(url$iv.toExternalForm() + paramString$iv);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object3 = mapper$iv.readValue(parameterisedUrl$iv, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"readValue(...)");
        return object3;
    }

    private final String toJson(Object any) {
        String string = any instanceof String ? (String)any : null;
        if (string == null) {
            string = HttpUtils.INSTANCE.getDefaultMapper().writeValueAsString(any);
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0004R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/testing/http/HttpApi$Companion;", "", "()V", "defaultMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getDefaultMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "defaultMapper$delegate", "Lkotlin/Lazy;", "fromHostAndPort", "Lnet/corda/testing/http/HttpApi;", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "base", "", "protocol", "mapper", "test-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpApi fromHostAndPort(@NotNull NetworkHostAndPort hostAndPort, @NotNull String base, @NotNull String protocol, @NotNull ObjectMapper mapper) {
            Intrinsics.checkNotNullParameter((Object)hostAndPort, (String)"hostAndPort");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
            return new HttpApi(new URL(protocol + "://" + hostAndPort + "/" + base + "/"), mapper);
        }

        public static /* synthetic */ HttpApi fromHostAndPort$default(Companion companion, NetworkHostAndPort networkHostAndPort, String string, String string2, ObjectMapper objectMapper, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "http";
            }
            if ((n & 8) != 0) {
                objectMapper = companion.getDefaultMapper();
            }
            return companion.fromHostAndPort(networkHostAndPort, string, string2, objectMapper);
        }

        private final ObjectMapper getDefaultMapper() {
            Lazy lazy = defaultMapper$delegate;
            return (ObjectMapper)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

