/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.dsl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.corda.core.contracts.Attachment;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.StateAndRef;
import net.corda.core.contracts.StateRef;
import net.corda.core.contracts.TransactionResolutionException;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TransactionVerificationException;
import net.corda.core.crypto.NullKeys;
import net.corda.core.crypto.SecureHash;
import net.corda.core.internal.InternalUtils;
import net.corda.core.node.ServiceHub;
import net.corda.core.node.ServicesForResolution;
import net.corda.core.node.services.TransactionStorage;
import net.corda.core.transactions.CoreTransaction;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.core.transactions.WireTransaction;
import net.corda.node.services.api.WritableTransactionStorage;
import net.corda.testing.core.TestConstants;
import net.corda.testing.dsl.AttachmentResolutionException;
import net.corda.testing.dsl.DoubleSpentInputs;
import net.corda.testing.dsl.DuplicateOutputLabel;
import net.corda.testing.dsl.EnforceVerifyOrFail;
import net.corda.testing.dsl.LedgerDSLInterpreter;
import net.corda.testing.dsl.TestTransactionDSLInterpreter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u0000 T2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004TUVWB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005BW\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007\u0012\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u001d\u001a\u00020\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\u0002\b$H\u0016J'\u0010%\u001a\u00020&2\u001d\u0010!\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u0004\u0012\u00020&0\"\u00a2\u0006\u0002\b$H\u0016J3\u0010'\u001a\u00020\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020&0\"\u00a2\u0006\u0002\b$H\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0016J\t\u0010*\u001a\u00020\u0004H\u00c6\u0003J \u0010+\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u00c0\u0003\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007H\u00c2\u0003J\u0015\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007H\u00c2\u0003J\r\u0010/\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b0J[\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00072\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007H\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\u0010\u00105\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0017\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b9J\t\u0010:\u001a\u00020;H\u00d6\u0001J/\u0010<\u001a\u00020\u0002\"\u0004\b\u0000\u0010=2\u0006\u0010\u001f\u001a\u00020 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H=0\"\u00a2\u0006\u0002\b$H\u0002J\u0010\u0010>\u001a\u0004\u0018\u00010\b2\u0006\u0010?\u001a\u00020\nJW\u0010@\u001a\u00020\u0016\"\u0004\b\u0000\u0010=2\b\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H=0\"\u00a2\u0006\u0002\b$2\u0014\b\u0002\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00072\u0006\u00105\u001a\u000202H\u0002J\u0015\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bEJ(\u0010F\u001a\b\u0012\u0004\u0012\u0002HH0G\"\n\b\u0000\u0010H\u0018\u0001*\u00020\n2\u0006\u0010I\u001a\u00020JH\u0080\b\u00a2\u0006\u0002\bKJ.\u0010L\u001a\b\u0012\u0004\u0012\u0002HH0\t\"\b\b\u0000\u0010H*\u00020\n2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HH0N2\u0006\u0010O\u001a\u00020\bH\u0016J\t\u0010P\u001a\u00020\bH\u00d6\u0001J\u0010\u0010Q\u001a\u0004\u0018\u00010\b2\u0006\u0010R\u001a\u00020\fJ\b\u0010S\u001a\u00020#H\u0016R&\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\u00a8\u0006X"}, d2={"Lnet/corda/testing/dsl/TestLedgerDSLInterpreter;", "Lnet/corda/testing/dsl/LedgerDSLInterpreter;", "Lnet/corda/testing/dsl/TestTransactionDSLInterpreter;", "services", "Lnet/corda/core/node/ServiceHub;", "(Lnet/corda/core/node/ServiceHub;)V", "labelToOutputStateAndRefs", "Ljava/util/HashMap;", "", "Lnet/corda/core/contracts/StateAndRef;", "Lnet/corda/core/contracts/ContractState;", "transactionWithLocations", "Lnet/corda/core/crypto/SecureHash;", "Lnet/corda/testing/dsl/TestLedgerDSLInterpreter$WireTransactionWithLocation;", "nonVerifiedTransactionWithLocations", "(Lnet/corda/core/node/ServiceHub;Ljava/util/HashMap;Ljava/util/HashMap;Ljava/util/HashMap;)V", "getLabelToOutputStateAndRefs$test_utils", "()Ljava/util/HashMap;", "getServices", "()Lnet/corda/core/node/ServiceHub;", "transactionsToVerify", "", "Lnet/corda/core/transactions/WireTransaction;", "getTransactionsToVerify", "()Ljava/util/List;", "transactionsUnverified", "getTransactionsUnverified", "wireTransactions", "getWireTransactions", "_transaction", "transactionLabel", "transactionBuilder", "Lnet/corda/core/transactions/TransactionBuilder;", "dsl", "Lkotlin/Function1;", "Lnet/corda/testing/dsl/EnforceVerifyOrFail;", "Lkotlin/ExtensionFunctionType;", "_tweak", "", "_unverifiedTransaction", "attachment", "Ljava/io/InputStream;", "component1", "component2", "component2$test_utils", "component3", "component4", "copy", "copy$test_utils", "equals", "", "other", "", "fillTransaction", "getTransaction", "Lnet/corda/core/transactions/SignedTransaction;", "id", "getTransaction$test_utils", "hashCode", "", "interpretTransactionDsl", "R", "outputToLabel", "state", "recordTransactionWithTransactionMap", "transactionMap", "resolveAttachment", "Lnet/corda/core/contracts/Attachment;", "attachmentId", "resolveAttachment$test_utils", "resolveStateRef", "Lnet/corda/core/contracts/TransactionState;", "S", "stateRef", "Lnet/corda/core/contracts/StateRef;", "resolveStateRef$test_utils", "retrieveOutputStateAndRef", "clazz", "Ljava/lang/Class;", "label", "toString", "transactionName", "transactionHash", "verifies", "Companion", "TypeMismatch", "VerifiesFailed", "WireTransactionWithLocation", "test-utils"})
@SourceDebugExtension(value={"SMAP\nTestDSL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestDSL.kt\nnet/corda/testing/dsl/TestLedgerDSLInterpreter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,421:1\n1549#2:422\n1620#2,3:423\n1549#2:434\n1620#2,3:435\n1620#2,3:438\n1549#2:441\n1620#2,3:442\n1549#2:445\n1620#2,3:446\n1#3:426\n526#4:427\n511#4,6:428\n*S KotlinDebug\n*F\n+ 1 TestDSL.kt\nnet/corda/testing/dsl/TestLedgerDSLInterpreter\n*L\n239#1:422\n239#1:423,3\n381#1:434\n381#1:435,3\n393#1:438,3\n418#1:441\n418#1:442,3\n419#1:445\n419#1:446,3\n316#1:427\n316#1:428,6\n*E\n"})
public final class TestLedgerDSLInterpreter
implements LedgerDSLInterpreter<TestTransactionDSLInterpreter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServiceHub services;
    @NotNull
    private final HashMap<String, StateAndRef<ContractState>> labelToOutputStateAndRefs;
    @NotNull
    private final HashMap<SecureHash, WireTransactionWithLocation> transactionWithLocations;
    @NotNull
    private final HashMap<SecureHash, WireTransactionWithLocation> nonVerifiedTransactionWithLocations;

    private TestLedgerDSLInterpreter(ServiceHub services2, HashMap<String, StateAndRef<ContractState>> labelToOutputStateAndRefs, HashMap<SecureHash, WireTransactionWithLocation> transactionWithLocations, HashMap<SecureHash, WireTransactionWithLocation> nonVerifiedTransactionWithLocations) {
        this.services = services2;
        this.labelToOutputStateAndRefs = labelToOutputStateAndRefs;
        this.transactionWithLocations = transactionWithLocations;
        this.nonVerifiedTransactionWithLocations = nonVerifiedTransactionWithLocations;
    }

    /* synthetic */ TestLedgerDSLInterpreter(ServiceHub serviceHub, HashMap hashMap, HashMap hashMap2, HashMap hashMap3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            hashMap = new HashMap<String, StateAndRef<ContractState>>();
        }
        if ((n & 4) != 0) {
            hashMap2 = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            hashMap3 = new HashMap<SecureHash, WireTransactionWithLocation>();
        }
        this(serviceHub, hashMap, hashMap2, hashMap3);
    }

    @NotNull
    public final ServiceHub getServices() {
        return this.services;
    }

    @NotNull
    public final HashMap<String, StateAndRef<ContractState>> getLabelToOutputStateAndRefs$test_utils() {
        return this.labelToOutputStateAndRefs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WireTransaction> getWireTransactions() {
        void $this$mapTo$iv$iv;
        Collection<WireTransactionWithLocation> collection = this.transactionWithLocations.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WireTransactionWithLocation wireTransactionWithLocation = (WireTransactionWithLocation)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getTransaction());
        }
        return (List)destination$iv$iv;
    }

    public TestLedgerDSLInterpreter(@NotNull ServiceHub services2) {
        Intrinsics.checkNotNullParameter((Object)services2, (String)"services");
        this(services2, new HashMap(), null, null, 12, null);
    }

    @NotNull
    public final TestLedgerDSLInterpreter copy$test_utils() {
        return new TestLedgerDSLInterpreter(this.services, new HashMap<String, StateAndRef<ContractState>>((Map)this.labelToOutputStateAndRefs), new HashMap<SecureHash, WireTransactionWithLocation>((Map)this.transactionWithLocations), new HashMap<SecureHash, WireTransactionWithLocation>((Map)this.nonVerifiedTransactionWithLocations));
    }

    @Nullable
    public final SignedTransaction getTransaction$test_utils(@NotNull SecureHash id) {
        SignedTransaction signedTransaction;
        WireTransactionWithLocation tx;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        WireTransactionWithLocation wireTransactionWithLocation = this.transactionWithLocations.get(id);
        if (wireTransactionWithLocation == null) {
            wireTransactionWithLocation = this.nonVerifiedTransactionWithLocations.get(id);
        }
        WireTransactionWithLocation wireTransactionWithLocation2 = tx = wireTransactionWithLocation;
        if (wireTransactionWithLocation2 != null) {
            WireTransactionWithLocation it = wireTransactionWithLocation2;
            boolean bl = false;
            signedTransaction = new SignedTransaction((CoreTransaction)it.getTransaction(), CollectionsKt.listOf((Object)NullKeys.INSTANCE.getNULL_SIGNATURE()));
        } else {
            signedTransaction = null;
        }
        return signedTransaction;
    }

    public final /* synthetic */ <S extends ContractState> TransactionState<S> resolveStateRef$test_utils(StateRef stateRef) {
        Intrinsics.checkNotNullParameter((Object)stateRef, (String)"stateRef");
        boolean $i$f$resolveStateRef$test_utils = false;
        WireTransactionWithLocation wireTransactionWithLocation = (WireTransactionWithLocation)this.transactionWithLocations.get(stateRef.getTxhash());
        if (wireTransactionWithLocation == null && (wireTransactionWithLocation = (WireTransactionWithLocation)this.nonVerifiedTransactionWithLocations.get(stateRef.getTxhash())) == null) {
            throw new TransactionResolutionException(stateRef.getTxhash(), null, 2, null);
        }
        WireTransactionWithLocation transactionWithLocation = wireTransactionWithLocation;
        TransactionState output = (TransactionState)transactionWithLocation.getTransaction().getOutputs().get(stateRef.getIndex());
        Intrinsics.reifiedOperationMarker((int)4, (String)"S");
        if (!ContractState.class.isAssignableFrom(output.getData().getClass())) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"S");
            throw new TypeMismatch(ContractState.class, output.getData().getClass());
        }
        return (TransactionState)InternalUtils.uncheckedCast((Object)output);
    }

    @NotNull
    public final Attachment resolveAttachment$test_utils(@NotNull SecureHash attachmentId) {
        Intrinsics.checkNotNullParameter((Object)attachmentId, (String)"attachmentId");
        Attachment attachment = this.services.getAttachments().openAttachment(attachmentId);
        if (attachment == null) {
            throw new AttachmentResolutionException(attachmentId);
        }
        return attachment;
    }

    private final <R> TestTransactionDSLInterpreter interpretTransactionDsl(TransactionBuilder transactionBuilder, Function1<? super TestTransactionDSLInterpreter, ? extends R> dsl) {
        TestTransactionDSLInterpreter testTransactionDSLInterpreter;
        TestTransactionDSLInterpreter $this$interpretTransactionDsl_u24lambda_u242 = testTransactionDSLInterpreter = new TestTransactionDSLInterpreter(this, transactionBuilder);
        boolean bl = false;
        dsl.invoke((Object)$this$interpretTransactionDsl_u24lambda_u242);
        return testTransactionDSLInterpreter;
    }

    @Nullable
    public final String transactionName(@NotNull SecureHash transactionHash) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)transactionHash, (String)"transactionHash");
        WireTransactionWithLocation transactionWithLocation = this.transactionWithLocations.get(transactionHash);
        if (transactionWithLocation != null) {
            object = transactionWithLocation.getLabel();
            if (object == null) {
                object = "TX[" + transactionWithLocation.getLocation() + "]";
            }
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String outputToLabel(@NotNull ContractState state) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map $this$filter$iv = this.labelToOutputStateAndRefs;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((StateAndRef)it.getValue()).getState().getData(), (Object)state)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return (String)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.keySet());
    }

    private final <R> WireTransaction recordTransactionWithTransactionMap(String transactionLabel, TransactionBuilder transactionBuilder, Function1<? super TestTransactionDSLInterpreter, ? extends R> dsl, HashMap<SecureHash, WireTransactionWithLocation> transactionMap, boolean fillTransaction) {
        WireTransaction wireTransaction;
        String transactionLocation = TestLedgerDSLInterpreter.Companion.getCallerLocation();
        TestTransactionDSLInterpreter transactionInterpreter = this.interpretTransactionDsl(transactionBuilder, dsl);
        if (fillTransaction) {
            this.fillTransaction(transactionBuilder);
        }
        try {
            wireTransaction = transactionInterpreter.toWireTransaction$test_utils();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("A transaction-DSL block that is part of a test ledger must return a valid transaction.", e);
        }
        WireTransaction wireTransaction2 = wireTransaction;
        transactionInterpreter.getLabelToIndexMap$test_utils().forEach((arg_0, arg_1) -> TestLedgerDSLInterpreter.recordTransactionWithTransactionMap$lambda$4((Function2)new Function2<String, Integer, Unit>(this, wireTransaction2){
            final /* synthetic */ TestLedgerDSLInterpreter this$0;
            final /* synthetic */ WireTransaction $wireTransaction;
            {
                this.this$0 = $receiver;
                this.$wireTransaction = $wireTransaction;
                super(2);
            }

            public final void invoke(@NotNull String label, @NotNull Integer index) {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                if (((Map)this.this$0.getLabelToOutputStateAndRefs$test_utils()).containsKey(label)) {
                    throw new DuplicateOutputLabel(label);
                }
                ((Map)this.this$0.getLabelToOutputStateAndRefs$test_utils()).put(label, this.$wireTransaction.outRef(index.intValue()));
            }
        }, arg_0, arg_1));
        ((Map)transactionMap).put(wireTransaction2.getId(), new WireTransactionWithLocation(transactionLabel, wireTransaction2, transactionLocation));
        return wireTransaction2;
    }

    static /* synthetic */ WireTransaction recordTransactionWithTransactionMap$default(TestLedgerDSLInterpreter testLedgerDSLInterpreter, String string, TransactionBuilder transactionBuilder, Function1 function1, HashMap hashMap, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            hashMap = new HashMap<SecureHash, WireTransactionWithLocation>();
        }
        return testLedgerDSLInterpreter.recordTransactionWithTransactionMap(string, transactionBuilder, function1, hashMap, bl);
    }

    private final void fillTransaction(TransactionBuilder transactionBuilder) {
        if (transactionBuilder.commands().isEmpty()) {
            transactionBuilder.addCommand(TestConstants.dummyCommand$default(null, (int)1, null));
        }
    }

    @Override
    @NotNull
    public WireTransaction _transaction(@Nullable String transactionLabel, @NotNull TransactionBuilder transactionBuilder, @NotNull Function1<? super TestTransactionDSLInterpreter, ? extends EnforceVerifyOrFail> dsl) {
        Intrinsics.checkNotNullParameter((Object)transactionBuilder, (String)"transactionBuilder");
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        return this.recordTransactionWithTransactionMap(transactionLabel, transactionBuilder, dsl, this.transactionWithLocations, false);
    }

    @Override
    @NotNull
    public WireTransaction _unverifiedTransaction(@Nullable String transactionLabel, @NotNull TransactionBuilder transactionBuilder, @NotNull Function1<? super TestTransactionDSLInterpreter, Unit> dsl) {
        Intrinsics.checkNotNullParameter((Object)transactionBuilder, (String)"transactionBuilder");
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        return this.recordTransactionWithTransactionMap(transactionLabel, transactionBuilder, dsl, this.nonVerifiedTransactionWithLocations, true);
    }

    @Override
    public void _tweak(@NotNull Function1<? super LedgerDSLInterpreter<TestTransactionDSLInterpreter>, Unit> dsl) {
        Intrinsics.checkNotNullParameter(dsl, (String)"dsl");
        dsl.invoke((Object)this.copy$test_utils());
    }

    @Override
    @NotNull
    public SecureHash attachment(@NotNull InputStream attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        return this.services.getAttachments().importAttachment(attachment, "TestDSL", null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EnforceVerifyOrFail verifies() {
        try {
            Collection collection;
            void $this$mapTo$iv$iv;
            Set usedInputs = new LinkedHashSet();
            Object $this$map$iv = this.getTransactionsUnverified();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WireTransaction wireTransaction = (WireTransaction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                TransactionStorage transactionStorage = this.services.getValidatedTransactions();
                Intrinsics.checkNotNull((Object)transactionStorage, (String)"null cannot be cast to non-null type net.corda.node.services.api.WritableTransactionStorage");
                collection.add(((WritableTransactionStorage)transactionStorage).addTransaction(new SignedTransaction((CoreTransaction)it, CollectionsKt.listOf((Object)NullKeys.INSTANCE.getNULL_SIGNATURE()))));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            $this$map$iv = ((Map)this.transactionWithLocations).entrySet().iterator();
            while ($this$map$iv.hasNext()) {
                WireTransactionWithLocation value = (WireTransactionWithLocation)((Map.Entry)$this$map$iv.next()).getValue();
                WireTransaction wtx = value.getTransaction();
                LedgerTransaction ltx = wtx.toLedgerTransaction((ServicesForResolution)this.services);
                ltx.verify();
                Set allInputs = CollectionsKt.union((Iterable)wtx.getInputs(), (Iterable)wtx.getReferences());
                Set doubleSpend = CollectionsKt.intersect((Iterable)allInputs, (Iterable)usedInputs);
                if (!doubleSpend.isEmpty()) {
                    Object[] bl = new SecureHash[]{wtx.getId()};
                    List txIds = CollectionsKt.mutableListOf((Object[])bl);
                    Iterable $this$mapTo$iv = doubleSpend;
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        StateRef stateRef = (StateRef)item$iv;
                        collection = txIds;
                        boolean bl2 = false;
                        collection.add(it.getTxhash());
                    }
                    throw new DoubleSpentInputs(txIds);
                }
                usedInputs.addAll(wtx.getInputs());
                TransactionStorage transactionStorage = this.services.getValidatedTransactions();
                Intrinsics.checkNotNull((Object)transactionStorage, (String)"null cannot be cast to non-null type net.corda.node.services.api.WritableTransactionStorage");
                ((WritableTransactionStorage)transactionStorage).addTransaction(new SignedTransaction((CoreTransaction)wtx, CollectionsKt.listOf((Object)NullKeys.INSTANCE.getNULL_SIGNATURE())));
            }
            return EnforceVerifyOrFail.Token.INSTANCE;
        }
        catch (TransactionVerificationException exception) {
            WireTransactionWithLocation transactionWithLocation = this.transactionWithLocations.get(exception.getTxId());
            Object object = transactionWithLocation;
            if (object == null || (object = ((WireTransactionWithLocation)object).getLabel()) == null) {
                WireTransactionWithLocation wireTransactionWithLocation = transactionWithLocation;
                object = wireTransactionWithLocation != null ? wireTransactionWithLocation.getLocation() : null;
                if (object == null) {
                    object = "<unknown>";
                }
            }
            Object transactionName = object;
            throw new VerifiesFailed((String)transactionName, exception);
        }
    }

    @Override
    @NotNull
    public <S extends ContractState> StateAndRef<S> retrieveOutputStateAndRef(@NotNull Class<S> clazz, @NotNull String label) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        StateAndRef<ContractState> stateAndRef = this.labelToOutputStateAndRefs.get(label);
        if (stateAndRef == null) {
            throw new IllegalArgumentException("State with label '" + label + "' was not found");
        }
        if (!clazz.isAssignableFrom(stateAndRef.getState().getData().getClass())) {
            throw new TypeMismatch(clazz, stateAndRef.getState().getData().getClass());
        }
        return (StateAndRef)InternalUtils.uncheckedCast(stateAndRef);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WireTransaction> getTransactionsToVerify() {
        void $this$mapTo$iv$iv;
        Collection<WireTransactionWithLocation> collection = this.transactionWithLocations.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WireTransactionWithLocation wireTransactionWithLocation = (WireTransactionWithLocation)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getTransaction());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WireTransaction> getTransactionsUnverified() {
        void $this$mapTo$iv$iv;
        Collection<WireTransactionWithLocation> collection = this.nonVerifiedTransactionWithLocations.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WireTransactionWithLocation wireTransactionWithLocation = (WireTransactionWithLocation)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getTransaction());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ServiceHub component1() {
        return this.services;
    }

    @NotNull
    public final HashMap<String, StateAndRef<ContractState>> component2$test_utils() {
        return this.labelToOutputStateAndRefs;
    }

    private final HashMap<SecureHash, WireTransactionWithLocation> component3() {
        return this.transactionWithLocations;
    }

    private final HashMap<SecureHash, WireTransactionWithLocation> component4() {
        return this.nonVerifiedTransactionWithLocations;
    }

    @NotNull
    public final TestLedgerDSLInterpreter copy(@NotNull ServiceHub services2, @NotNull HashMap<String, StateAndRef<ContractState>> labelToOutputStateAndRefs, @NotNull HashMap<SecureHash, WireTransactionWithLocation> transactionWithLocations, @NotNull HashMap<SecureHash, WireTransactionWithLocation> nonVerifiedTransactionWithLocations) {
        Intrinsics.checkNotNullParameter((Object)services2, (String)"services");
        Intrinsics.checkNotNullParameter(labelToOutputStateAndRefs, (String)"labelToOutputStateAndRefs");
        Intrinsics.checkNotNullParameter(transactionWithLocations, (String)"transactionWithLocations");
        Intrinsics.checkNotNullParameter(nonVerifiedTransactionWithLocations, (String)"nonVerifiedTransactionWithLocations");
        return new TestLedgerDSLInterpreter(services2, labelToOutputStateAndRefs, transactionWithLocations, nonVerifiedTransactionWithLocations);
    }

    public static /* synthetic */ TestLedgerDSLInterpreter copy$default(TestLedgerDSLInterpreter testLedgerDSLInterpreter, ServiceHub serviceHub, HashMap hashMap, HashMap hashMap2, HashMap hashMap3, int n, Object object) {
        if ((n & 1) != 0) {
            serviceHub = testLedgerDSLInterpreter.services;
        }
        if ((n & 2) != 0) {
            hashMap = testLedgerDSLInterpreter.labelToOutputStateAndRefs;
        }
        if ((n & 4) != 0) {
            hashMap2 = testLedgerDSLInterpreter.transactionWithLocations;
        }
        if ((n & 8) != 0) {
            hashMap3 = testLedgerDSLInterpreter.nonVerifiedTransactionWithLocations;
        }
        return testLedgerDSLInterpreter.copy(serviceHub, hashMap, hashMap2, hashMap3);
    }

    @NotNull
    public String toString() {
        return "TestLedgerDSLInterpreter(services=" + this.services + ", labelToOutputStateAndRefs=" + this.labelToOutputStateAndRefs + ", transactionWithLocations=" + this.transactionWithLocations + ", nonVerifiedTransactionWithLocations=" + this.nonVerifiedTransactionWithLocations + ")";
    }

    public int hashCode() {
        int result = this.services.hashCode();
        result = result * 31 + this.labelToOutputStateAndRefs.hashCode();
        result = result * 31 + this.transactionWithLocations.hashCode();
        result = result * 31 + this.nonVerifiedTransactionWithLocations.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TestLedgerDSLInterpreter)) {
            return false;
        }
        TestLedgerDSLInterpreter testLedgerDSLInterpreter = (TestLedgerDSLInterpreter)other;
        if (!Intrinsics.areEqual((Object)this.services, (Object)testLedgerDSLInterpreter.services)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.labelToOutputStateAndRefs, testLedgerDSLInterpreter.labelToOutputStateAndRefs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.transactionWithLocations, testLedgerDSLInterpreter.transactionWithLocations)) {
            return false;
        }
        return Intrinsics.areEqual(this.nonVerifiedTransactionWithLocations, testLedgerDSLInterpreter.nonVerifiedTransactionWithLocations);
    }

    private static final void recordTransactionWithTransactionMap$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lnet/corda/testing/dsl/TestLedgerDSLInterpreter$Companion;", "", "()V", "getCallerLocation", "", "test-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final String getCallerLocation() {
            int i = 1;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int n = stackTrace.length;
            if (i <= n) {
                while (true) {
                    StackTraceElement stackTraceElement = stackTrace[i];
                    String string = stackTraceElement.getFileName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"DSL", (boolean)false, (int)2, null)) {
                        return stackTraceElement.toString();
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/testing/dsl/TestLedgerDSLInterpreter$TypeMismatch;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "requested", "Ljava/lang/Class;", "actual", "(Ljava/lang/Class;Ljava/lang/Class;)V", "test-utils"})
    public static final class TypeMismatch
    extends Exception {
        public TypeMismatch(@NotNull Class<?> requested, @NotNull Class<?> actual) {
            Intrinsics.checkNotNullParameter(requested, (String)"requested");
            Intrinsics.checkNotNullParameter(actual, (String)"actual");
            super("Actual type " + actual + " is not a subtype of requested type " + requested);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/testing/dsl/TestLedgerDSLInterpreter$VerifiesFailed;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "transactionName", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "test-utils"})
    public static final class VerifiesFailed
    extends Exception {
        public VerifiesFailed(@NotNull String transactionName, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)transactionName, (String)"transactionName");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super("Transaction (" + transactionName + ") didn't verify: " + cause, cause);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lnet/corda/testing/dsl/TestLedgerDSLInterpreter$WireTransactionWithLocation;", "", "label", "", "transaction", "Lnet/corda/core/transactions/WireTransaction;", "location", "(Ljava/lang/String;Lnet/corda/core/transactions/WireTransaction;Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "getLocation", "getTransaction", "()Lnet/corda/core/transactions/WireTransaction;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "test-utils"})
    public static final class WireTransactionWithLocation {
        @Nullable
        private final String label;
        @NotNull
        private final WireTransaction transaction;
        @Nullable
        private final String location;

        public WireTransactionWithLocation(@Nullable String label, @NotNull WireTransaction transaction2, @Nullable String location) {
            Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
            this.label = label;
            this.transaction = transaction2;
            this.location = location;
        }

        @Nullable
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final WireTransaction getTransaction() {
            return this.transaction;
        }

        @Nullable
        public final String getLocation() {
            return this.location;
        }

        @Nullable
        public final String component1() {
            return this.label;
        }

        @NotNull
        public final WireTransaction component2() {
            return this.transaction;
        }

        @Nullable
        public final String component3() {
            return this.location;
        }

        @NotNull
        public final WireTransactionWithLocation copy(@Nullable String label, @NotNull WireTransaction transaction2, @Nullable String location) {
            Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
            return new WireTransactionWithLocation(label, transaction2, location);
        }

        public static /* synthetic */ WireTransactionWithLocation copy$default(WireTransactionWithLocation wireTransactionWithLocation, String string, WireTransaction wireTransaction, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = wireTransactionWithLocation.label;
            }
            if ((n & 2) != 0) {
                wireTransaction = wireTransactionWithLocation.transaction;
            }
            if ((n & 4) != 0) {
                string2 = wireTransactionWithLocation.location;
            }
            return wireTransactionWithLocation.copy(string, wireTransaction, string2);
        }

        @NotNull
        public String toString() {
            return "WireTransactionWithLocation(label=" + this.label + ", transaction=" + this.transaction + ", location=" + this.location + ")";
        }

        public int hashCode() {
            int result = this.label == null ? 0 : this.label.hashCode();
            result = result * 31 + this.transaction.hashCode();
            result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WireTransactionWithLocation)) {
                return false;
            }
            WireTransactionWithLocation wireTransactionWithLocation = (WireTransactionWithLocation)other;
            if (!Intrinsics.areEqual((Object)this.label, (Object)wireTransactionWithLocation.label)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.transaction, (Object)wireTransactionWithLocation.transaction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.location, (Object)wireTransactionWithLocation.location);
        }
    }
}

