/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.test;

import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.identity.AbstractParty;
import net.corda.core.schemas.CommonSchemaV1;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.finance.test.CashSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/finance/test/SampleCashSchemaV2;", "Lnet/corda/core/schemas/MappedSchema;", "()V", "PersistentCashState", "test-utils"})
public final class SampleCashSchemaV2
extends MappedSchema {
    @NotNull
    public static final SampleCashSchemaV2 INSTANCE = new SampleCashSchemaV2();

    private SampleCashSchemaV2() {
        super(CashSchema.INSTANCE.getClass(), 2, (Iterable)CollectionsKt.listOf(PersistentCashState.class));
    }

    @Entity
    @Table(name="cash_states_v2", indexes={@Index(name="ccy_code_idx2", columnList="ccy_code")})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00128\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lnet/corda/finance/test/SampleCashSchemaV2$PersistentCashState;", "Lnet/corda/core/schemas/CommonSchemaV1$FungibleState;", "currency", "", "participants", "", "Lnet/corda/core/identity/AbstractParty;", "owner", "quantity", "", "issuerParty", "issuerRef", "Lnet/corda/core/utilities/OpaqueBytes;", "(Ljava/lang/String;Ljava/util/Set;Lnet/corda/core/identity/AbstractParty;JLnet/corda/core/identity/AbstractParty;Lnet/corda/core/utilities/OpaqueBytes;)V", "getCurrency", "()Ljava/lang/String;", "setCurrency", "(Ljava/lang/String;)V", "", "getParticipants", "()Ljava/util/Set;", "setParticipants", "(Ljava/util/Set;)V", "test-utils"})
    public static class PersistentCashState
    extends CommonSchemaV1.FungibleState {
        @Column(name="ccy_code", nullable=false, length=3)
        @NotNull
        private String currency;
        @ElementCollection
        @Column(name="participants", nullable=true)
        @CollectionTable(name="cash_states_v2_participants", joinColumns={@JoinColumn(name="output_index", referencedColumnName="output_index"), @JoinColumn(name="transaction_id", referencedColumnName="transaction_id")})
        @Nullable
        private Set<AbstractParty> participants;

        public PersistentCashState(@NotNull String currency, @NotNull Set<? extends AbstractParty> participants, @NotNull AbstractParty owner, long quantity, @NotNull AbstractParty issuerParty, @NotNull OpaqueBytes issuerRef) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter(participants, (String)"participants");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)issuerParty, (String)"issuerParty");
            Intrinsics.checkNotNullParameter((Object)issuerRef, (String)"issuerRef");
            super(CollectionsKt.toMutableSet((Iterable)participants), owner, quantity, issuerParty, issuerRef.getBytes());
            this.currency = currency;
        }

        @NotNull
        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.currency = string;
        }

        @Nullable
        public Set<AbstractParty> getParticipants() {
            return this.participants;
        }

        public void setParticipants(@Nullable Set<AbstractParty> set) {
            this.participants = set;
        }

        public PersistentCashState() {
        }
    }
}

