/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.test;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.finance.test.CashSchema;
import org.hibernate.annotations.Type;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/finance/test/SampleCashSchemaV1;", "Lnet/corda/core/schemas/MappedSchema;", "()V", "PersistentCashState", "test-utils"})
public final class SampleCashSchemaV1
extends MappedSchema {
    @NotNull
    public static final SampleCashSchemaV1 INSTANCE = new SampleCashSchemaV1();

    private SampleCashSchemaV1() {
        super(CashSchema.INSTANCE.getClass(), 1, (Iterable)CollectionsKt.listOf(PersistentCashState.class));
    }

    @Entity
    @Table(name="contract_cash_states_v1", indexes={@Index(name="ccy_code_idx1", columnList="ccy_code"), @Index(name="pennies_idx1", columnList="pennies")})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0012\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u001e\u0010\u0006\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0007\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001e\u0010\b\u001a\u00020\t8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR\u001e\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lnet/corda/finance/test/SampleCashSchemaV1$PersistentCashState;", "Lnet/corda/core/schemas/PersistentState;", "ownerHash", "", "pennies", "", "currency", "issuerPartyHash", "issuerRef", "", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;[B)V", "getCurrency", "()Ljava/lang/String;", "setCurrency", "(Ljava/lang/String;)V", "getIssuerPartyHash", "setIssuerPartyHash", "getIssuerRef", "()[B", "setIssuerRef", "([B)V", "getOwnerHash", "setOwnerHash", "getPennies", "()J", "setPennies", "(J)V", "test-utils"})
    public static class PersistentCashState
    extends PersistentState {
        @Column(name="owner_key_hash", nullable=false, length=130)
        @NotNull
        private String ownerHash;
        @Column(name="pennies", nullable=false)
        private long pennies;
        @Column(name="ccy_code", nullable=false, length=3)
        @NotNull
        private String currency;
        @Column(name="issuer_key_hash", nullable=false, length=130)
        @NotNull
        private String issuerPartyHash;
        @Column(name="issuer_ref", nullable=false, length=512)
        @Type(type="corda-wrapper-binary")
        @NotNull
        private byte[] issuerRef;

        public PersistentCashState(@NotNull String ownerHash, long pennies, @NotNull String currency, @NotNull String issuerPartyHash, @NotNull byte[] issuerRef) {
            Intrinsics.checkNotNullParameter((Object)ownerHash, (String)"ownerHash");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)issuerPartyHash, (String)"issuerPartyHash");
            Intrinsics.checkNotNullParameter((Object)issuerRef, (String)"issuerRef");
            super(null, 1, null);
            this.ownerHash = ownerHash;
            this.pennies = pennies;
            this.currency = currency;
            this.issuerPartyHash = issuerPartyHash;
            this.issuerRef = issuerRef;
        }

        @NotNull
        public String getOwnerHash() {
            return this.ownerHash;
        }

        public void setOwnerHash(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.ownerHash = string;
        }

        public long getPennies() {
            return this.pennies;
        }

        public void setPennies(long l) {
            this.pennies = l;
        }

        @NotNull
        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.currency = string;
        }

        @NotNull
        public String getIssuerPartyHash() {
            return this.issuerPartyHash;
        }

        public void setIssuerPartyHash(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.issuerPartyHash = string;
        }

        @NotNull
        public byte[] getIssuerRef() {
            return this.issuerRef;
        }

        public void setIssuerRef(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.issuerRef = byArray;
        }

        public PersistentCashState() {
            super(null, 1, null);
        }
    }
}

