/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.common.internal;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001aC\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u001a%\u0010\t\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\f"}, d2={"eventually", "R", "duration", "Ljava/time/Duration;", "waitBetween", "waitBefore", "test", "Lkotlin/Function0;", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "succeeds", "action", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "test-common"})
public final class EventuallyKt {
    public static final <R> R eventually(@NotNull Duration duration, @NotNull Duration waitBetween, @NotNull Duration waitBefore, @NotNull Function0<? extends R> test) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)waitBetween, (String)"waitBetween");
        Intrinsics.checkNotNullParameter((Object)waitBefore, (String)"waitBefore");
        Intrinsics.checkNotNullParameter(test, (String)"test");
        boolean $i$f$eventually = false;
        long end = System.nanoTime() + duration.toNanos();
        int times = 0;
        Object lastFailure = null;
        if (!waitBefore.isZero()) {
            Thread.sleep(waitBefore.toMillis());
        }
        while (System.nanoTime() < end) {
            try {
                return (R)test.invoke();
            }
            catch (AssertionError e) {
                if (!waitBetween.isZero()) {
                    Thread.sleep(waitBetween.toMillis());
                }
                lastFailure = e;
                ++times;
            }
        }
        Throwable throwable = lastFailure;
        throw new AssertionError((Object)("Test failed with \"" + (throwable != null ? throwable.getMessage() : null) + "\" after " + duration + "; attempted " + times + " times"));
    }

    public static /* synthetic */ Object eventually$default(Duration duration, Duration waitBetween, Duration waitBefore, Function0 test, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 2) != 0) {
            Duration duration3 = Duration.ofMillis(100L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(...)");
            waitBetween = duration3;
        }
        if ((n & 4) != 0) {
            waitBefore = waitBetween;
        }
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)waitBetween, (String)"waitBetween");
        Intrinsics.checkNotNullParameter((Object)waitBefore, (String)"waitBefore");
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        boolean $i$f$eventually = false;
        long end = System.nanoTime() + duration.toNanos();
        int times = 0;
        Object lastFailure = null;
        if (!waitBefore.isZero()) {
            Thread.sleep(waitBefore.toMillis());
        }
        while (System.nanoTime() < end) {
            try {
                return test.invoke();
            }
            catch (AssertionError e) {
                if (!waitBetween.isZero()) {
                    Thread.sleep(waitBetween.toMillis());
                }
                lastFailure = e;
                ++times;
            }
        }
        Throwable throwable = lastFailure;
        throw new AssertionError((Object)("Test failed with \"" + (throwable != null ? throwable.getMessage() : null) + "\" after " + duration + "; attempted " + times + " times"));
    }

    public static final <R> R succeeds(@NotNull Function0<? extends R> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$succeeds = false;
        try {
            object = action.invoke();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e.getMessage());
        }
        return (R)object;
    }
}

