/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.model;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.serialization.internal.model.BaseLocalTypes;
import net.corda.serialization.internal.model.DefaultCacheProvider;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.LocalTypeLookup;
import net.corda.serialization.internal.model.LocalTypeModel;
import net.corda.serialization.internal.model.LocalTypeModelConfiguration;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/corda/serialization/internal/model/ConfigurableLocalTypeModel;", "Lnet/corda/serialization/internal/model/LocalTypeModel;", "typeModelConfiguration", "Lnet/corda/serialization/internal/model/LocalTypeModelConfiguration;", "(Lnet/corda/serialization/internal/model/LocalTypeModelConfiguration;)V", "typeInformationCache", "", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "inspect", "type", "Ljava/lang/reflect/Type;", "BuilderLookup", "serialization"})
public final class ConfigurableLocalTypeModel
implements LocalTypeModel {
    private final Map<TypeIdentifier, LocalTypeInformation> typeInformationCache;
    private final LocalTypeModelConfiguration typeModelConfiguration;

    @Override
    @NotNull
    public LocalTypeInformation inspect(@NotNull Type type) {
        LocalTypeInformation localTypeInformation;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        TypeIdentifier typeIdentifier = TypeIdentifier.Companion.forGenericType$default(TypeIdentifier.Companion, type, null, 2, null);
        Map<TypeIdentifier, LocalTypeInformation> $receiver$iv = this.typeInformationCache;
        LocalTypeInformation value$iv = $receiver$iv.get(typeIdentifier);
        if (value$iv == null) {
            BuilderLookup lookup = new BuilderLookup(this.typeInformationCache, this.typeModelConfiguration);
            LocalTypeInformation result = LocalTypeInformation.Companion.forType(type, typeIdentifier, lookup);
            lookup.merge();
            LocalTypeInformation answer$iv = result;
            $receiver$iv.put(typeIdentifier, answer$iv);
            localTypeInformation = answer$iv;
        } else {
            localTypeInformation = value$iv;
        }
        return localTypeInformation;
    }

    public ConfigurableLocalTypeModel(@NotNull LocalTypeModelConfiguration typeModelConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)typeModelConfiguration, (String)"typeModelConfiguration");
        this.typeModelConfiguration = typeModelConfiguration;
        this.typeInformationCache = DefaultCacheProvider.INSTANCE.createCache();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/corda/serialization/internal/model/ConfigurableLocalTypeModel$BuilderLookup;", "Lnet/corda/serialization/internal/model/LocalTypeLookup;", "globalCache", "", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "typeModelConfiguration", "Lnet/corda/serialization/internal/model/LocalTypeModelConfiguration;", "(Ljava/util/Map;Lnet/corda/serialization/internal/model/LocalTypeModelConfiguration;)V", "baseTypes", "Lnet/corda/serialization/internal/model/BaseLocalTypes;", "getBaseTypes", "()Lnet/corda/serialization/internal/model/BaseLocalTypes;", "localCache", "findOrBuild", "type", "Ljava/lang/reflect/Type;", "typeIdentifier", "builder", "Lkotlin/Function1;", "", "isExcluded", "merge", "", "serialization"})
    private static final class BuilderLookup
    implements LocalTypeLookup {
        private final Map<TypeIdentifier, LocalTypeInformation> localCache;
        @NotNull
        private final BaseLocalTypes baseTypes;
        private final Map<TypeIdentifier, LocalTypeInformation> globalCache;
        private final LocalTypeModelConfiguration typeModelConfiguration;

        @Override
        @NotNull
        public LocalTypeInformation findOrBuild(@NotNull Type type, @NotNull TypeIdentifier typeIdentifier, @NotNull Function1<? super Boolean, ? extends LocalTypeInformation> builder) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)typeIdentifier, (String)"typeIdentifier");
            Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
            LocalTypeInformation localTypeInformation = this.globalCache.get(typeIdentifier);
            if (localTypeInformation == null) {
                LocalTypeInformation localTypeInformation2;
                Map<TypeIdentifier, LocalTypeInformation> $receiver$iv = this.localCache;
                LocalTypeInformation value$iv = $receiver$iv.get(typeIdentifier);
                if (value$iv == null) {
                    LocalTypeInformation answer$iv = (LocalTypeInformation)builder.invoke((Object)this.typeModelConfiguration.isOpaque(type));
                    $receiver$iv.put(typeIdentifier, answer$iv);
                    localTypeInformation2 = answer$iv;
                } else {
                    localTypeInformation2 = value$iv;
                }
                localTypeInformation = localTypeInformation2;
            }
            return localTypeInformation;
        }

        @Override
        public boolean isExcluded(@NotNull Type type) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return this.typeModelConfiguration.isExcluded(type);
        }

        @Override
        @NotNull
        public BaseLocalTypes getBaseTypes() {
            return this.baseTypes;
        }

        public final void merge() {
            Map<TypeIdentifier, LocalTypeInformation> $receiver$iv;
            Map<TypeIdentifier, LocalTypeInformation> map = $receiver$iv = this.localCache;
            Iterator<Map.Entry<TypeIdentifier, LocalTypeInformation>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TypeIdentifier, LocalTypeInformation> element$iv;
                Map.Entry<TypeIdentifier, LocalTypeInformation> $identifier_information;
                Map.Entry<TypeIdentifier, LocalTypeInformation> entry = $identifier_information = (element$iv = iterator.next());
                TypeIdentifier identifier = entry.getKey();
                entry = $identifier_information;
                LocalTypeInformation information = entry.getValue();
                this.globalCache.putIfAbsent(identifier, information);
            }
        }

        public BuilderLookup(@NotNull Map<TypeIdentifier, LocalTypeInformation> globalCache, @NotNull LocalTypeModelConfiguration typeModelConfiguration) {
            Map map;
            Intrinsics.checkParameterIsNotNull(globalCache, (String)"globalCache");
            Intrinsics.checkParameterIsNotNull((Object)typeModelConfiguration, (String)"typeModelConfiguration");
            this.globalCache = globalCache;
            this.typeModelConfiguration = typeModelConfiguration;
            BuilderLookup builderLookup = this;
            builderLookup.localCache = map = (Map)new LinkedHashMap();
            this.baseTypes = this.typeModelConfiguration.getBaseTypes();
        }
    }
}

