/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.time.YearMonth;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/custom/YearMonthSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Ljava/time/YearMonth;", "Lnet/corda/serialization/internal/amqp/custom/YearMonthSerializer$YearMonthProxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "YearMonthProxy", "serialization"})
public final class YearMonthSerializer
extends CustomSerializer.Proxy<YearMonth, YearMonthProxy> {
    @Override
    @NotNull
    protected YearMonthProxy toProxy(@NotNull YearMonth obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return new YearMonthProxy(obj.getYear(), (byte)obj.getMonthValue());
    }

    @Override
    @NotNull
    protected YearMonth fromProxy(@NotNull YearMonthProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        YearMonth yearMonth = YearMonth.of(proxy.getYear(), proxy.getMonth());
        Intrinsics.checkExpressionValueIsNotNull((Object)yearMonth, (String)"YearMonth.of(proxy.year, proxy.month.toInt())");
        return yearMonth;
    }

    public YearMonthSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(YearMonth.class, YearMonthProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/serialization/internal/amqp/custom/YearMonthSerializer$YearMonthProxy;", "", "year", "", "month", "", "(IB)V", "getMonth", "()B", "getYear", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "serialization"})
    @KeepForDJVM
    public static final class YearMonthProxy {
        private final int year;
        private final byte month;

        public final int getYear() {
            return this.year;
        }

        public final byte getMonth() {
            return this.month;
        }

        public YearMonthProxy(int year, byte month) {
            this.year = year;
            this.month = month;
        }

        public final int component1() {
            return this.year;
        }

        public final byte component2() {
            return this.month;
        }

        @NotNull
        public final YearMonthProxy copy(int year, byte month) {
            return new YearMonthProxy(year, month);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ YearMonthProxy copy$default(YearMonthProxy yearMonthProxy, int n, byte by, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = yearMonthProxy.year;
            }
            if ((n2 & 2) != 0) {
                by = yearMonthProxy.month;
            }
            return yearMonthProxy.copy(n, by);
        }

        @NotNull
        public String toString() {
            return "YearMonthProxy(year=" + this.year + ", month=" + this.month + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.year) * 31 + Byte.hashCode(this.month);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof YearMonthProxy)) break block3;
                    YearMonthProxy yearMonthProxy = (YearMonthProxy)object;
                    if (!(this.year == yearMonthProxy.year) || !(this.month == yearMonthProxy.month)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

