/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.core.internal.InternalUtils;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.MapSerializer;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.custom.ClassSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0014\u0010\u0012\u001a\u00020\u00032\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0014R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lnet/corda/serialization/internal/amqp/custom/EnumSetSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Ljava/util/EnumSet;", "Lnet/corda/serialization/internal/amqp/custom/EnumSetSerializer$EnumSetProxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "additionalSerializers", "", "Lnet/corda/serialization/internal/amqp/CustomSerializer;", "", "getAdditionalSerializers", "()Ljava/lang/Iterable;", "elementType", "Ljava/lang/Class;", "set", "fromProxy", "proxy", "toProxy", "obj", "EnumSetProxy", "serialization"})
public final class EnumSetSerializer
extends CustomSerializer.Proxy<EnumSet<?>, EnumSetProxy> {
    @NotNull
    private final Iterable<CustomSerializer<? extends Object>> additionalSerializers;

    @Override
    @NotNull
    public Iterable<CustomSerializer<? extends Object>> getAdditionalSerializers() {
        return this.additionalSerializers;
    }

    @Override
    @NotNull
    protected EnumSetProxy toProxy(@NotNull EnumSet<?> obj) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        return new EnumSetProxy(this.elementType(obj), CollectionsKt.toList((Iterable)obj));
    }

    private final Class<?> elementType(EnumSet<?> set) {
        Class<?> clazz;
        if (set.isEmpty()) {
            EnumSet enumSet = EnumSet.complementOf((EnumSet)InternalUtils.uncheckedCast(set));
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.complementOf(unc\u2026ustUsedForCasting>>(set))");
            clazz = ((Object)((Object)((MapSerializer.EnumJustUsedForCasting)((Object)CollectionsKt.first((Iterable)enumSet))))).getClass();
        } else {
            clazz = ((Enum)CollectionsKt.first((Iterable)set)).getClass();
        }
        return clazz;
    }

    @Override
    @NotNull
    protected EnumSet<?> fromProxy(@NotNull EnumSetProxy proxy) {
        EnumSet enumSet;
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        if (proxy.getElements().isEmpty()) {
            EnumSet enumSet2 = EnumSet.noneOf((Class)InternalUtils.uncheckedCast(proxy.getClazz()));
            enumSet = enumSet2;
            Intrinsics.checkExpressionValueIsNotNull(enumSet2, (String)"EnumSet.noneOf(unchecked\u2026orCasting>>(proxy.clazz))");
        } else {
            EnumSet enumSet3 = EnumSet.copyOf((Collection)InternalUtils.uncheckedCast(proxy.getElements()));
            enumSet = enumSet3;
            Intrinsics.checkExpressionValueIsNotNull(enumSet3, (String)"EnumSet.copyOf(unchecked\u2026asting>>(proxy.elements))");
        }
        return enumSet;
    }

    public EnumSetSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(EnumSet.class, EnumSetProxy.class, factory, false, 8, null);
        this.additionalSerializers = CollectionsKt.listOf((Object)new ClassSerializer(factory));
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J'\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/serialization/internal/amqp/custom/EnumSetSerializer$EnumSetProxy;", "", "clazz", "Ljava/lang/Class;", "elements", "", "(Ljava/lang/Class;Ljava/util/List;)V", "getClazz", "()Ljava/lang/Class;", "getElements", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    @KeepForDJVM
    public static final class EnumSetProxy {
        @NotNull
        private final Class<?> clazz;
        @NotNull
        private final List<Object> elements;

        @NotNull
        public final Class<?> getClazz() {
            return this.clazz;
        }

        @NotNull
        public final List<Object> getElements() {
            return this.elements;
        }

        public EnumSetProxy(@NotNull Class<?> clazz, @NotNull List<? extends Object> elements) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            this.clazz = clazz;
            this.elements = elements;
        }

        @NotNull
        public final Class<?> component1() {
            return this.clazz;
        }

        @NotNull
        public final List<Object> component2() {
            return this.elements;
        }

        @NotNull
        public final EnumSetProxy copy(@NotNull Class<?> clazz, @NotNull List<? extends Object> elements) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return new EnumSetProxy(clazz, elements);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ EnumSetProxy copy$default(EnumSetProxy enumSetProxy, Class clazz, List list, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = enumSetProxy.clazz;
            }
            if ((n & 2) != 0) {
                list = enumSetProxy.elements;
            }
            return enumSetProxy.copy(clazz, list);
        }

        @NotNull
        public String toString() {
            return "EnumSetProxy(clazz=" + this.clazz + ", elements=" + this.elements + ")";
        }

        public int hashCode() {
            Class<?> clazz = this.clazz;
            List<Object> list = this.elements;
            return (clazz != null ? clazz.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EnumSetProxy)) break block3;
                    EnumSetProxy enumSetProxy = (EnumSetProxy)object;
                    if (!Intrinsics.areEqual(this.clazz, enumSetProxy.clazz) || !Intrinsics.areEqual(this.elements, enumSetProxy.elements)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

