/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.util.Arrays;
import net.corda.core.KeepForDJVM;
import org.jetbrains.annotations.NotNull;

@KeepForDJVM
final class CacheKey {
    private final byte[] bytes;
    private final int hashValue;

    CacheKey(@NotNull byte[] bytes) {
        this.bytes = bytes;
        this.hashValue = Arrays.hashCode(bytes);
    }

    @NotNull
    byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CacheKey && Arrays.equals(this.bytes, ((CacheKey)other).bytes);
    }

    public int hashCode() {
        return this.hashValue;
    }
}

