/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.amqp.WhitelistBasedTypeModelConfigurationKt;
import net.corda.serialization.internal.model.BaseLocalTypes;
import net.corda.serialization.internal.model.LocalTypeModelConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/amqp/WhitelistBasedTypeModelConfiguration;", "Lnet/corda/serialization/internal/model/LocalTypeModelConfiguration;", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "customSerializerRegistry", "Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;", "(Lnet/corda/core/serialization/ClassWhitelist;Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;)V", "baseTypes", "Lnet/corda/serialization/internal/model/BaseLocalTypes;", "(Lnet/corda/core/serialization/ClassWhitelist;Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;Lnet/corda/serialization/internal/model/BaseLocalTypes;)V", "getBaseTypes", "()Lnet/corda/serialization/internal/model/BaseLocalTypes;", "isExcluded", "", "type", "Ljava/lang/reflect/Type;", "isOpaque", "serialization"})
public final class WhitelistBasedTypeModelConfiguration
implements LocalTypeModelConfiguration {
    private final ClassWhitelist whitelist;
    private final CustomSerializerRegistry customSerializerRegistry;
    @NotNull
    private final BaseLocalTypes baseTypes;

    @Override
    public boolean isExcluded(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return SerializationHelperKt.isNotWhitelisted(this.whitelist, SerializationHelperKt.asClass(type));
    }

    @Override
    public boolean isOpaque(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return WhitelistBasedTypeModelConfigurationKt.access$getOpaqueTypes$p().contains(Primitives.unwrap(SerializationHelperKt.asClass(type))) || this.customSerializerRegistry.findCustomSerializer(SerializationHelperKt.asClass(type), type) != null;
    }

    @Override
    @NotNull
    public BaseLocalTypes getBaseTypes() {
        return this.baseTypes;
    }

    public WhitelistBasedTypeModelConfiguration(@NotNull ClassWhitelist whitelist, @NotNull CustomSerializerRegistry customSerializerRegistry, @NotNull BaseLocalTypes baseTypes) {
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull((Object)customSerializerRegistry, (String)"customSerializerRegistry");
        Intrinsics.checkParameterIsNotNull((Object)baseTypes, (String)"baseTypes");
        this.whitelist = whitelist;
        this.customSerializerRegistry = customSerializerRegistry;
        this.baseTypes = baseTypes;
    }

    public WhitelistBasedTypeModelConfiguration(@NotNull ClassWhitelist whitelist, @NotNull CustomSerializerRegistry customSerializerRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull((Object)customSerializerRegistry, (String)"customSerializerRegistry");
        this(whitelist, customSerializerRegistry, WhitelistBasedTypeModelConfigurationKt.access$getDEFAULT_BASE_TYPES$p());
    }
}

