/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/SetterCaller;", "Lkotlin/Function2;", "", "", "target", "value", "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)V", "Ljava/lang/reflect/Method;", "setter", "<init>", "(Ljava/lang/reflect/Method;)V", "serialization"})
final class SetterCaller
implements Function2<Object, Object, Unit> {
    @NotNull
    private final Method setter;

    public void invoke(@NotNull Object target, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        try {
            this.setter.invoke(target, value);
        }
        catch (InvocationTargetException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Setter ").append(this.setter.getDeclaringClass()).append('.').append(this.setter.getName()).append(" (isAccessible=").append(this.setter.isAccessible()).append(' ').append("failed when called with parameter ").append(value).append(": ");
            Throwable throwable = e.getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new NotSerializableException(stringBuilder.append(throwable.getMessage()).toString());
        }
        catch (IllegalAccessException e) {
            throw (Throwable)new NotSerializableException("Setter " + this.setter.getDeclaringClass() + '.' + this.setter.getName() + " (isAccessible=" + this.setter.isAccessible() + ' ' + "not accessible: " + e.getMessage());
        }
    }

    public SetterCaller(@NotNull Method setter) {
        Intrinsics.checkParameterIsNotNull((Object)setter, (String)"setter");
        this.setter = setter;
    }
}

