/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import net.corda.core.KeepForDJVM;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.serialization.internal.amqp.AMQPRemoteTypeModel;
import net.corda.serialization.internal.amqp.CachingCustomSerializerRegistry;
import net.corda.serialization.internal.amqp.ComposedSerializerFactory;
import net.corda.serialization.internal.amqp.DefaultDescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.DefaultEvolutionSerializerFactory;
import net.corda.serialization.internal.amqp.DefaultLocalSerializerFactory;
import net.corda.serialization.internal.amqp.DefaultRemoteSerializerFactory;
import net.corda.serialization.internal.amqp.DescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.EvolutionSerializerFactory;
import net.corda.serialization.internal.amqp.NoEvolutionSerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryBuilder;
import net.corda.serialization.internal.amqp.WhitelistBasedTypeModelConfiguration;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.model.ClassCarpentingTypeLoader;
import net.corda.serialization.internal.model.ConfigurableLocalTypeModel;
import net.corda.serialization.internal.model.FingerPrinter;
import net.corda.serialization.internal.model.SchemaBuildingRemoteTypeCarpenter;
import net.corda.serialization.internal.model.TypeLoader;
import net.corda.serialization.internal.model.TypeModellingFingerPrinter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJI\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R0\u0010\u0015\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00138\u0002@\u0003X\u0083\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u0012\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lnet/corda/serialization/internal/amqp/SerializerFactoryBuilder;", "", "Lnet/corda/core/serialization/ClassWhitelist;", "whitelist", "Lnet/corda/serialization/internal/carpenter/ClassCarpenter;", "classCarpenter", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "build", "(Lnet/corda/core/serialization/ClassWhitelist;Lnet/corda/serialization/internal/carpenter/ClassCarpenter;)Lnet/corda/serialization/internal/amqp/SerializerFactory;", "Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;", "descriptorBasedSerializerRegistry", "", "allowEvolution", "Lnet/corda/serialization/internal/model/FingerPrinter;", "overrideFingerPrinter", "onlyCustomSerializers", "mustPreserveDataWhenEvolving", "makeFactory", "(Lnet/corda/core/serialization/ClassWhitelist;Lnet/corda/serialization/internal/carpenter/ClassCarpenter;Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;ZLnet/corda/serialization/internal/model/FingerPrinter;ZZ)Lnet/corda/serialization/internal/amqp/SerializerFactory;", "", "Ljava/lang/Class;", "javaPrimitiveTypes", "Ljava/util/Map;", "javaPrimitiveTypes$annotations", "()V", "<init>", "serialization"})
@KeepForDJVM
public final class SerializerFactoryBuilder {
    private static final Map<Class<?>, Class<?>> javaPrimitiveTypes;
    public static final SerializerFactoryBuilder INSTANCE;

    private static /* synthetic */ void javaPrimitiveTypes$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final SerializerFactory build(@NotNull ClassWhitelist whitelist, @NotNull ClassCarpenter classCarpenter) {
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull((Object)classCarpenter, (String)"classCarpenter");
        return INSTANCE.makeFactory(whitelist, classCarpenter, new DefaultDescriptorBasedSerializerRegistry(), true, null, false, false);
    }

    private final SerializerFactory makeFactory(ClassWhitelist whitelist, ClassCarpenter classCarpenter, DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry, boolean allowEvolution, FingerPrinter overrideFingerPrinter, boolean onlyCustomSerializers, boolean mustPreserveDataWhenEvolving) {
        CachingCustomSerializerRegistry customSerializerRegistry = new CachingCustomSerializerRegistry(descriptorBasedSerializerRegistry);
        WhitelistBasedTypeModelConfiguration typeModelConfiguration = new WhitelistBasedTypeModelConfiguration(whitelist, customSerializerRegistry);
        ConfigurableLocalTypeModel localTypeModel = new ConfigurableLocalTypeModel(typeModelConfiguration);
        FingerPrinter fingerPrinter = overrideFingerPrinter;
        if (fingerPrinter == null) {
            fingerPrinter = new TypeModellingFingerPrinter(customSerializerRegistry, classCarpenter.getClassloader(), false, 4, null);
        }
        FingerPrinter fingerPrinter2 = fingerPrinter;
        DefaultLocalSerializerFactory localSerializerFactory2 = new DefaultLocalSerializerFactory(whitelist, localTypeModel, fingerPrinter2, classCarpenter.getClassloader(), descriptorBasedSerializerRegistry, makeFactory.localSerializerFactory.1.INSTANCE, makeFactory.localSerializerFactory.2.INSTANCE, customSerializerRegistry, onlyCustomSerializers);
        TypeLoader typeLoader = new ClassCarpentingTypeLoader(new SchemaBuildingRemoteTypeCarpenter(classCarpenter), classCarpenter.getClassloader());
        EvolutionSerializerFactory evolutionSerializerFactory = allowEvolution ? (EvolutionSerializerFactory)new DefaultEvolutionSerializerFactory(localSerializerFactory2, classCarpenter.getClassloader(), mustPreserveDataWhenEvolving, javaPrimitiveTypes, typeModelConfiguration.getBaseTypes()) : (EvolutionSerializerFactory)NoEvolutionSerializerFactory.INSTANCE;
        DefaultRemoteSerializerFactory remoteSerializerFactory = new DefaultRemoteSerializerFactory(evolutionSerializerFactory, descriptorBasedSerializerRegistry, new AMQPRemoteTypeModel(), localTypeModel, typeLoader, localSerializerFactory2);
        return new ComposedSerializerFactory(localSerializerFactory2, remoteSerializerFactory, customSerializerRegistry);
    }

    private SerializerFactoryBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $receiver$iv$iv;
        SerializerFactoryBuilder serializerFactoryBuilder;
        INSTANCE = serializerFactoryBuilder = new SerializerFactoryBuilder();
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new KClass[]{Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Character.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE), Reflection.getOrCreateKotlinClass(Void.class)});
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv;
            KClass klazz = (KClass)element$iv$iv;
            Pair pair = TuplesKt.to((Object)JvmClassMappingKt.getJavaObjectType((KClass)klazz), (Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)klazz));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = Collections.unmodifiableMap(destination$iv$iv);
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<java.lang.Class<*>, java.lang.Class<*>>");
        }
        javaPrimitiveTypes = map;
    }
}

