/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.CordaSerializable;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.Descriptor;
import net.corda.serialization.internal.amqp.ReferencedObject;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u001a\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0003*\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0000\u001a\u0010\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003*\u00020\u0005H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0005H\u0000\u001a\f\u0010\r\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0005H\u0000\u001a\u0016\u0010\u000f\u001a\u00020\u0001*\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0013\u001a\u00020\u0001*\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0005\u001a+\u0010\u0016\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u001b\u00a2\u0006\u0002\b\u001c\u001a#\u0010\u001d\u001a\u00020\u0015*\u00020\u00172\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u001b\u00a2\u0006\u0002\b\u001c\u001a\u0012\u0010\u001e\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"hasCordaSerializable", "", "type", "Ljava/lang/Class;", "resolveTypeVariables", "Ljava/lang/reflect/Type;", "actualType", "contextType", "arrayClass", "asArray", "asClass", "asParameterizedType", "Ljava/lang/reflect/ParameterizedType;", "componentType", "isArray", "isNotWhitelisted", "Lnet/corda/core/serialization/ClassWhitelist;", "clazz", "isSubClassOf", "isWhitelisted", "requireWhitelisted", "", "withDescribed", "Lorg/apache/qpid/proton/codec/Data;", "descriptor", "Lnet/corda/serialization/internal/amqp/Descriptor;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withList", "writeReferencedObject", "refObject", "Lnet/corda/serialization/internal/amqp/ReferencedObject;", "serialization"})
public final class SerializationHelperKt {
    public static final void withDescribed(@NotNull Data $receiver, @NotNull Descriptor descriptor, @NotNull Function1<? super Data, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $receiver.putDescribed();
        $receiver.enter();
        UnsignedLong unsignedLong = descriptor.getCode();
        if (unsignedLong == null) {
            unsignedLong = descriptor.getName();
        }
        $receiver.putObject((Object)unsignedLong);
        block.invoke((Object)$receiver);
        $receiver.exit();
    }

    public static final void withList(@NotNull Data $receiver, @NotNull Function1<? super Data, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $receiver.putList();
        $receiver.enter();
        block.invoke((Object)$receiver);
        $receiver.exit();
    }

    public static final void writeReferencedObject(@NotNull Data $receiver, @NotNull ReferencedObject refObject) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)refObject, (String)"refObject");
        $receiver.putDescribed();
        $receiver.enter();
        $receiver.putObject(refObject.getDescriptor());
        $receiver.putUnsignedInteger(refObject.getDescribed());
        $receiver.exit();
    }

    @NotNull
    public static final Type resolveTypeVariables(@NotNull Type actualType, @Nullable Type contextType) {
        Type resolvedType;
        Type type;
        Intrinsics.checkParameterIsNotNull((Object)actualType, (String)"actualType");
        if (contextType != null) {
            TypeToken typeToken = TypeToken.of((Type)contextType).resolveType(actualType);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeToken, (String)"TypeToken.of(contextType).resolveType(actualType)");
            type = typeToken.getType();
        } else {
            type = resolvedType = actualType;
        }
        if (resolvedType instanceof TypeVariable) {
            Type type2;
            Type[] bounds = ((TypeVariable)resolvedType).getBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"bounds");
            Type[] typeArray = bounds;
            if (typeArray.length == 0) {
                type2 = TypeIdentifier.getLocalType$default(TypeIdentifier.UnknownType.INSTANCE, null, 1, null);
            } else if (bounds.length == 1) {
                Type type3 = bounds[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"bounds[0]");
                type2 = SerializationHelperKt.resolveTypeVariables(type3, contextType);
            } else {
                throw (Throwable)new AMQPNotSerializableException(actualType, "Got bounded type " + actualType + " but only support single bound.", null, null, 12, null);
            }
            return type2;
        }
        Type type4 = resolvedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"resolvedType");
        return type4;
    }

    @NotNull
    public static final Class<?> asClass(@NotNull Type $receiver) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Type type = $receiver;
        if (type instanceof Class) {
            clazz = (Class<?>)$receiver;
        } else if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)$receiver).getRawType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"this.rawType");
            clazz = SerializationHelperKt.asClass(type2);
        } else if (type instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)$receiver).getGenericComponentType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"this.genericComponentType");
            clazz = SerializationHelperKt.arrayClass(SerializationHelperKt.asClass(type3));
        } else if (type instanceof TypeVariable) {
            Object[] objectArray = ((TypeVariable)$receiver).getBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"this.bounds");
            Object object = ArraysKt.first((Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.bounds.first()");
            clazz = SerializationHelperKt.asClass((Type)object);
        } else if (type instanceof WildcardType) {
            Object[] objectArray = ((WildcardType)$receiver).getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"this.upperBounds");
            Object object = ArraysKt.first((Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.upperBounds.first()");
            clazz = SerializationHelperKt.asClass((Type)object);
        } else {
            throw (Throwable)new UnsupportedOperationException("Cannot convert " + $receiver + " to class");
        }
        return clazz;
    }

    @Nullable
    public static final Type asArray(@NotNull Type $receiver) {
        Type type;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Type type2 = $receiver;
        if (type2 instanceof Class || type2 instanceof ParameterizedType) {
            TypeIdentifier.ArrayOf arrayOf = new TypeIdentifier.ArrayOf(TypeIdentifier.Companion.forGenericType$default(TypeIdentifier.Companion, $receiver, null, 2, null));
            ClassLoader classLoader = $receiver.getClass().getClassLoader();
            if (classLoader == null) {
                ClassLoader classLoader2 = TypeIdentifier.class.getClassLoader();
                classLoader = classLoader2;
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"TypeIdentifier::class.java.classLoader");
            }
            type = arrayOf.getLocalType(classLoader);
        } else {
            type = null;
        }
        return type;
    }

    @NotNull
    public static final Class<?> arrayClass(@NotNull Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Array.newInstance($receiver, 0).getClass();
    }

    public static final boolean isArray(@NotNull Type $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof Class && ((Class)$receiver).isArray() || $receiver instanceof GenericArrayType;
    }

    @NotNull
    public static final Type componentType(@NotNull Type $receiver) {
        Type type;
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = SerializationHelperKt.isArray($receiver);
        if (!bl) {
            String string = $receiver + " is not an array type.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Type type2 = $receiver;
        if (!(type2 instanceof Class)) {
            type2 = null;
        }
        if ((clazz = (Class<?>)type2) != null && (clazz = clazz.getComponentType()) != null) {
            type = clazz;
        } else {
            Type type3 = ((GenericArrayType)$receiver).getGenericComponentType();
            type = type3;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"(this as GenericArrayType).genericComponentType");
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ParameterizedType asParameterizedType(@NotNull Class<?> $receiver) {
        void var3_4;
        Collection<TypeIdentifier> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        String string = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.name");
        TypeIdentifier.Erased erased = new TypeIdentifier.Erased(string, $receiver.getTypeParameters().length);
        TypeVariable<Class<?>>[] typeVariableArray = $receiver.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(typeVariableArray, (String)"this.typeParameters");
        TypeVariable<Class<?>>[] typeVariableArray2 = typeVariableArray;
        TypeIdentifier.Erased erased2 = erased;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var7_8 = item$iv$iv = $receiver$iv$iv[i];
            collection = destination$iv$iv;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            TypeIdentifier typeIdentifier = TypeIdentifier.Companion.forGenericType$default(TypeIdentifier.Companion, (Type)v3, null, 2, null);
            collection.add(typeIdentifier);
        }
        collection = (List)var3_4;
        TypeIdentifier typeIdentifier = erased2.toParameterized((List<? extends TypeIdentifier>)collection);
        ClassLoader classLoader = $receiver.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = TypeIdentifier.class.getClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"TypeIdentifier::class.java.classLoader");
        }
        Type type = typeIdentifier.getLocalType(classLoader);
        if (type == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        return (ParameterizedType)type;
    }

    @NotNull
    public static final ParameterizedType asParameterizedType(@NotNull Type $receiver) {
        ParameterizedType parameterizedType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Type type = $receiver;
        if (type instanceof Class) {
            parameterizedType = SerializationHelperKt.asParameterizedType((Class)$receiver);
        } else if (type instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)$receiver;
        } else {
            throw (Throwable)new AMQPNotSerializableException($receiver, "Don't know how to convert to ParameterizedType", null, null, 12, null);
        }
        return parameterizedType;
    }

    public static final boolean isSubClassOf(@NotNull Type $receiver, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        TypeToken typeToken = TypeToken.of((Type)$receiver);
        TypeToken typeToken2 = TypeToken.of((Type)type);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeToken2, (String)"TypeToken.of(type)");
        return typeToken.isSubtypeOf((Type)typeToken2.getRawType());
    }

    public static final void requireWhitelisted(@NotNull ClassWhitelist $receiver, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (!SerializationHelperKt.isWhitelisted($receiver, SerializationHelperKt.asClass(type)) && Intrinsics.areEqual(SerializationHelperKt.asClass(type), Comparable.class) ^ true) {
            throw (Throwable)new AMQPNotSerializableException(type, "Class \"" + type + "\" is not on the whitelist or annotated with @CordaSerializable.", null, null, 12, null);
        }
    }

    public static final boolean isWhitelisted(@NotNull ClassWhitelist $receiver, @NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return $receiver.hasListed(clazz) || SerializationHelperKt.hasCordaSerializable(clazz);
    }

    public static final boolean isNotWhitelisted(@NotNull ClassWhitelist $receiver, @NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return !SerializationHelperKt.isWhitelisted($receiver, clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasCordaSerializable(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (type.isAnnotationPresent(CordaSerializable.class)) return true;
        Class<?>[] classArray = type.getInterfaces();
        Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"type.interfaces");
        for (Class<?> element$iv : classArray) {
            Class<?> p1 = element$iv;
            if (!SerializationHelperKt.hasCordaSerializable(p1)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (type.getSuperclass() == null) return false;
        Class<?> clazz = type.getSuperclass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.superclass");
        if (!SerializationHelperKt.hasCordaSerializable(clazz)) return false;
        return true;
    }
}

