/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.corda.serialization.internal.amqp.MethodClassifier;
import net.corda.serialization.internal.amqp.PropertyDescriptor;
import net.corda.serialization.internal.amqp.PropertyDescriptorKt;
import net.corda.serialization.internal.amqp.PropertyDescriptorKt$WhenMappings;
import net.corda.serialization.internal.amqp.PropertyNamedMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a1\u0010\u000b\u001a\u00020\n2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002\u001a&\u0010\u0016\u001a\u0016\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0012\u0004\u0012\u00020\u00190\u0017*\b\u0012\u0004\u0012\u00020\u00190\u001aH\u0002\u001a8\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u00170\u0017*\b\u0012\u0004\u0012\u00020\b0\u001a2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0002\u001a\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u0017*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u0014H\u0000\u001a$\u0010 \u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00190\u00190\u001a*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001aH\u0002\u001a$\u0010!\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\n0\n0\u001a*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001aH\u0002\u001a\u0014\u0010\"\u001a\u00020\u0013*\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002\u001a4\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0%*\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0%2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a,\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u0017*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f0\u00142\b\b\u0002\u0010(\u001a\u00020\u0013H\u0000\u001a\u001a\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001a*\u0006\u0012\u0002\b\u00030\u0014H\u0002\u001a\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\u001a*\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002\u001a\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u001a*\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002\u001a\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u001a*\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002\u001a\u001e\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u0017*\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002\u001aD\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u0017*\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u00170\u00172\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0017H\u0002\u001a$\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u0017*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u0017H\u0002\u001a \u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001a*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001aH\u0002\u001a\u0018\u00102\u001a\b\u0012\u0004\u0012\u00020\b0\u001a*\b\u0012\u0004\u0012\u00020\b0\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"propertyMethodRegex", "Lkotlin/text/Regex;", "getPropertyName", "", "propertyName", "fieldNames", "", "getPropertyNamedMethod", "Lnet/corda/serialization/internal/amqp/PropertyNamedMethod;", "method", "Ljava/lang/reflect/Method;", "leastGenericBy", "feature", "Lkotlin/Function1;", "Ljava/lang/reflect/Type;", "Lkotlin/ExtensionFunctionType;", "first", "second", "boxesOrIsAssignableFrom", "", "Ljava/lang/Class;", "other", "byFieldName", "", "kotlin.jvm.PlatformType", "Ljava/lang/reflect/Field;", "Lkotlin/sequences/Sequence;", "byNameAndClassifier", "Lnet/corda/serialization/internal/amqp/MethodClassifier;", "calculatedPropertyDescriptors", "Lnet/corda/serialization/internal/amqp/PropertyDescriptor;", "", "declaredFields", "declaredMethods", "isSupertypeOf", "that", "merge", "Ljava/util/EnumMap;", "classifier", "propertyDescriptors", "validateProperties", "superclassChain", "thatAreCalculated", "thatArePropertyMethods", "thatArePublic", "toCalculatedProperties", "toClassProperties", "fieldMap", "validated", "withInterfaces", "withValidSignature", "serialization"})
public final class PropertyDescriptorKt {
    private static final Regex propertyMethodRegex = new Regex("(?<type>get|set|is)(?<var>\\p{Lu}.*)");

    private static final boolean boxesOrIsAssignableFrom(@NotNull Class<?> $receiver, Class<?> other) {
        return $receiver.isAssignableFrom(other) || Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)JvmClassMappingKt.getKotlinClass($receiver)), other);
    }

    private static final boolean isSupertypeOf(@NotNull Type $receiver, Type that) {
        return TypeToken.of((Type)$receiver).isSupertypeOf(that);
    }

    @NotNull
    public static final Map<String, PropertyDescriptor> propertyDescriptors(@NotNull Class<? extends Object> $receiver, boolean validateProperties) {
        Map<String, PropertyDescriptor> map;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Map<String, Field> fieldProperties = PropertyDescriptorKt.byFieldName(PropertyDescriptorKt.declaredFields(PropertyDescriptorKt.superclassChain($receiver)));
        Map<String, PropertyDescriptor> $receiver2 = map = PropertyDescriptorKt.toClassProperties(PropertyDescriptorKt.byNameAndClassifier(PropertyDescriptorKt.withValidSignature(PropertyDescriptorKt.thatArePropertyMethods(PropertyDescriptorKt.thatArePublic(PropertyDescriptorKt.declaredMethods(PropertyDescriptorKt.superclassChain($receiver))))), fieldProperties.keySet()), fieldProperties);
        return validateProperties ? PropertyDescriptorKt.validated($receiver2) : $receiver2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Map propertyDescriptors$default(Class clazz, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return PropertyDescriptorKt.propertyDescriptors(clazz, bl);
    }

    @NotNull
    public static final Map<String, PropertyDescriptor> calculatedPropertyDescriptors(@NotNull Class<? extends Object> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return PropertyDescriptorKt.toCalculatedProperties(PropertyDescriptorKt.thatAreCalculated(PropertyDescriptorKt.thatArePublic(PropertyDescriptorKt.declaredMethods(PropertyDescriptorKt.withInterfaces(PropertyDescriptorKt.superclassChain($receiver))))));
    }

    private static final Sequence<Class<?>> superclassChain(@NotNull Class<?> $receiver) {
        return SequencesKt.generateSequence($receiver, (Function1)superclassChain.1.INSTANCE);
    }

    private static final Sequence<Class<?>> withInterfaces(@NotNull Sequence<? extends Class<?>> $receiver) {
        return SequencesKt.flatMap($receiver, (Function1)withInterfaces.1.INSTANCE);
    }

    private static final Sequence<Field> declaredFields(@NotNull Sequence<? extends Class<?>> $receiver) {
        return SequencesKt.flatMap($receiver, (Function1)declaredFields.1.INSTANCE);
    }

    private static final Sequence<Method> declaredMethods(@NotNull Sequence<? extends Class<?>> $receiver) {
        return SequencesKt.flatMap($receiver, (Function1)declaredMethods.1.INSTANCE);
    }

    private static final Map<String, Field> byFieldName(@NotNull Sequence<Field> $receiver) {
        return MapsKt.toMap((Sequence)SequencesKt.map($receiver, (Function1)byFieldName.1.INSTANCE));
    }

    private static final Sequence<Method> thatArePublic(@NotNull Sequence<Method> $receiver) {
        return SequencesKt.filter($receiver, (Function1)thatArePublic.1.INSTANCE);
    }

    private static final Sequence<Method> thatAreCalculated(@NotNull Sequence<Method> $receiver) {
        return SequencesKt.filter($receiver, (Function1)thatAreCalculated.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, PropertyDescriptor> toCalculatedProperties(@NotNull Sequence<Method> $receiver) {
        void $receiver$iv$iv;
        Map methodsByName = new LinkedHashMap();
        for (Method method : $receiver) {
            PropertyNamedMethod propertyNamedMethod;
            if (PropertyDescriptorKt.getPropertyNamedMethod(method) == null) {
                throw (Throwable)new IllegalArgumentException("Calculated property method must have a name beginning with 'get' or 'is'");
            }
            boolean bl = propertyNamedMethod.hasValidSignature();
            if (!bl) {
                String string = "Calculated property name must have no parameters, and a non-void return type";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String propertyName = StringsKt.decapitalize((String)propertyNamedMethod.getFieldName());
            methodsByName.compute(propertyName, (BiFunction)new BiFunction<String, Method, Method>(method){
                final /* synthetic */ Method $method;

                @Nullable
                public final Method apply(@NotNull String $noName_0, @Nullable Method existingMethod) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    return existingMethod == null ? this.$method : PropertyDescriptorKt.access$leastGenericBy(toCalculatedProperties.1.INSTANCE, existingMethod, this.$method);
                }
                {
                    this.$method = method;
                }
            });
        }
        Map $receiver$iv = methodsByName;
        Map map = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $$_$_method;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            void var12_14 = $$_$_method;
            Method method = (Method)var12_14.getValue();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(null, null, method);
            map3.put(k2, propertyDescriptor);
        }
        return destination$iv$iv;
    }

    private static final Sequence<PropertyNamedMethod> thatArePropertyMethods(@NotNull Sequence<Method> $receiver) {
        return SequencesKt.mapNotNull($receiver, (Function1)thatArePropertyMethods.1.INSTANCE);
    }

    private static final PropertyNamedMethod getPropertyNamedMethod(Method method) {
        PropertyNamedMethod propertyNamedMethod;
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        MatchResult matchResult = Regex.find$default((Regex)propertyMethodRegex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult != null) {
            PropertyNamedMethod propertyNamedMethod2;
            MatchResult matchResult2;
            MatchResult result = matchResult2 = matchResult;
            MatchGroup matchGroup = result.getGroups().get(2);
            if (matchGroup == null) {
                Intrinsics.throwNpe();
            }
            String string2 = matchGroup.getValue();
            MatchGroup matchGroup2 = result.getGroups().get(1);
            if (matchGroup2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = matchGroup2.getValue();
            String string4 = string2;
            PropertyNamedMethod propertyNamedMethod3 = propertyNamedMethod2;
            PropertyNamedMethod propertyNamedMethod4 = propertyNamedMethod2;
            String string5 = string3;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
            String string7 = string6;
            propertyNamedMethod = propertyNamedMethod4;
            propertyNamedMethod3(string4, MethodClassifier.valueOf(string7), method);
        } else {
            propertyNamedMethod = null;
        }
        return propertyNamedMethod;
    }

    private static final Sequence<PropertyNamedMethod> withValidSignature(@NotNull Sequence<PropertyNamedMethod> $receiver) {
        return SequencesKt.filter($receiver, (Function1)withValidSignature.1.INSTANCE);
    }

    private static final Map<String, Map<MethodClassifier, Method>> byNameAndClassifier(@NotNull Sequence<PropertyNamedMethod> $receiver, Set<String> fieldNames) {
        Map result = new LinkedHashMap();
        Sequence<PropertyNamedMethod> $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            PropertyNamedMethod $fieldName_classifier_method = (PropertyNamedMethod)element$iv;
            String fieldName = $fieldName_classifier_method.component1();
            MethodClassifier classifier = $fieldName_classifier_method.component2();
            Method method = $fieldName_classifier_method.component3();
            result.compute(PropertyDescriptorKt.getPropertyName(fieldName, fieldNames), (BiFunction)new BiFunction<String, EnumMap<MethodClassifier, Method>, EnumMap<MethodClassifier, Method>>(classifier, method){
                final /* synthetic */ MethodClassifier $classifier;
                final /* synthetic */ Method $method;

                @NotNull
                public final EnumMap<MethodClassifier, Method> apply(@NotNull String $noName_0, @Nullable EnumMap<MethodClassifier, Method> byClassifier) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    EnumMap<MethodClassifier, V> enumMap = byClassifier;
                    if (enumMap == null) {
                        enumMap = new EnumMap<MethodClassifier, V>(MethodClassifier.class);
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)enumMap, (String)"(byClassifier ?: EnumMap\u2026dClassifier::class.java))");
                    return PropertyDescriptorKt.access$merge(enumMap, this.$classifier, this.$method);
                }
                {
                    this.$classifier = methodClassifier;
                    this.$method = method;
                }
            });
        }
        return result;
    }

    private static final EnumMap<MethodClassifier, Method> merge(@NotNull EnumMap<MethodClassifier, Method> $receiver, MethodClassifier classifier, Method method) {
        $receiver.compute(classifier, new BiFunction<MethodClassifier, Method, Method>(method, classifier){
            final /* synthetic */ Method $method;
            final /* synthetic */ MethodClassifier $classifier;

            @Nullable
            public final Method apply(MethodClassifier $noName_0, @Nullable Method existingMethod) {
                Method method;
                if (existingMethod == null) {
                    method = this.$method;
                } else {
                    switch (PropertyDescriptorKt$WhenMappings.$EnumSwitchMapping$0[this.$classifier.ordinal()]) {
                        case 1: {
                            method = existingMethod;
                            break;
                        }
                        case 2: {
                            method = PropertyDescriptorKt.access$leastGenericBy(merge.1.INSTANCE, existingMethod, this.$method);
                            break;
                        }
                        case 3: {
                            method = PropertyDescriptorKt.access$leastGenericBy(merge.2.INSTANCE, existingMethod, this.$method);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                return method;
            }
            {
                this.$method = method;
                this.$classifier = methodClassifier;
            }
        });
        return $receiver;
    }

    private static final String getPropertyName(String propertyName, Set<String> fieldNames) {
        return fieldNames.contains(StringsKt.decapitalize((String)propertyName)) ? StringsKt.decapitalize((String)propertyName) : propertyName;
    }

    private static final Map<String, PropertyDescriptor> toClassProperties(@NotNull Map<String, ? extends Map<MethodClassifier, Method>> $receiver, Map<String, Field> fieldMap) {
        PropertyDescriptor propertyDescriptor;
        Object name;
        Object object;
        Map result = new LinkedHashMap();
        Map<String, Field> map = fieldMap;
        for (Map.Entry<String, Field> entry : map.entrySet()) {
            object = entry;
            name = object.getKey();
            object = entry;
            Field field = object.getValue();
            if ($receiver.keySet().contains(name)) continue;
            object = result;
            propertyDescriptor = new PropertyDescriptor(field, null, null);
            object.put(name, propertyDescriptor);
        }
        name = $receiver;
        for (Map.Entry<String, Object> entry : name.entrySet()) {
            object = entry;
            name = object.getKey();
            object = entry;
            Map methodMap = (Map)object.getValue();
            object = result;
            Method method = (Method)methodMap.get((Object)MethodClassifier.SET);
            Method method2 = (Method)methodMap.get((Object)MethodClassifier.GET);
            if (method2 == null) {
                method2 = (Method)methodMap.get((Object)MethodClassifier.IS);
            }
            propertyDescriptor = new PropertyDescriptor(fieldMap.get(name), method, method2);
            object.put(name, propertyDescriptor);
        }
        return result;
    }

    private static final Method leastGenericBy(Function1<? super Method, ? extends Type> feature, Method first, Method second) {
        return PropertyDescriptorKt.isSupertypeOf((Type)feature.invoke((Object)first), (Type)feature.invoke((Object)second)) ? second : first;
    }

    private static final Map<String, PropertyDescriptor> validated(@NotNull Map<String, PropertyDescriptor> $receiver) {
        Map<String, PropertyDescriptor> map;
        Map<String, PropertyDescriptor> $receiver2 = map = $receiver;
        $receiver2.forEach(validated.1.1.INSTANCE);
        return map;
    }

    public static final /* synthetic */ boolean access$boxesOrIsAssignableFrom(@NotNull Class $receiver, @NotNull Class other) {
        return PropertyDescriptorKt.boxesOrIsAssignableFrom($receiver, other);
    }

    @NotNull
    public static final /* synthetic */ Method access$leastGenericBy(@NotNull Function1 feature, @NotNull Method first, @NotNull Method second) {
        return PropertyDescriptorKt.leastGenericBy((Function1<? super Method, ? extends Type>)feature, first, second);
    }

    @Nullable
    public static final /* synthetic */ PropertyNamedMethod access$getPropertyNamedMethod(@NotNull Method method) {
        return PropertyDescriptorKt.getPropertyNamedMethod(method);
    }

    @NotNull
    public static final /* synthetic */ EnumMap access$merge(@NotNull EnumMap $receiver, @NotNull MethodClassifier classifier, @NotNull Method method) {
        return PropertyDescriptorKt.merge($receiver, classifier, method);
    }
}

