/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.model.BaseLocalTypes;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J8\u0010!\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lnet/corda/serialization/internal/amqp/EnumEvolutionSerializer;", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "type", "Ljava/lang/reflect/Type;", "factory", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "baseLocalTypes", "Lnet/corda/serialization/internal/model/BaseLocalTypes;", "conversions", "", "", "ordinals", "", "(Ljava/lang/reflect/Type;Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;Lnet/corda/serialization/internal/model/BaseLocalTypes;Ljava/util/Map;Ljava/util/Map;)V", "getType", "()Ljava/lang/reflect/Type;", "typeDescriptor", "Lorg/apache/qpid/proton/amqp/Symbol;", "getTypeDescriptor", "()Lorg/apache/qpid/proton/amqp/Symbol;", "readObject", "obj", "schemas", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "input", "Lnet/corda/serialization/internal/amqp/DeserializationInput;", "context", "Lnet/corda/core/serialization/SerializationContext;", "writeClassInfo", "", "output", "Lnet/corda/serialization/internal/amqp/SerializationOutput;", "writeObject", "data", "Lorg/apache/qpid/proton/codec/Data;", "debugIndent", "serialization"})
public final class EnumEvolutionSerializer
implements AMQPSerializer<Object> {
    @NotNull
    private final Symbol typeDescriptor;
    @NotNull
    private final Type type;
    private final BaseLocalTypes baseLocalTypes;
    private final Map<String, String> conversions;
    private final Map<String, Integer> ordinals;

    @Override
    @NotNull
    public Symbol getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    @NotNull
    public Object readObject(@NotNull Object obj, @NotNull SerializationSchemas schemas, @NotNull DeserializationInput input, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object e = ((List)obj).get(0);
        if (e == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String enumName = (String)e;
        String string = this.conversions.get(enumName);
        if (string == null) {
            throw (Throwable)new AMQPNotSerializableException(this.getType(), "No rule to evolve enum constant " + this.getType() + "::" + enumName, null, null, 12, null);
        }
        String converted = string;
        Integer n = this.ordinals.get(converted);
        if (n == null) {
            throw (Throwable)new AMQPNotSerializableException(this.getType(), "Ordinal not found for enum value " + this.getType() + "::" + converted, null, null, 12, null);
        }
        int ordinal = n;
        return this.baseLocalTypes.getEnumConstants().apply(SerializationHelperKt.asClass(this.getType()))[ordinal];
    }

    @Override
    public void writeClassInfo(@NotNull SerializationOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        throw (Throwable)new UnsupportedOperationException("It should be impossible to write an evolution serializer");
    }

    @Override
    public void writeObject(@NotNull Object obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationOutput output, @NotNull SerializationContext context, int debugIndent) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        throw (Throwable)new UnsupportedOperationException("It should be impossible to write an evolution serializer");
    }

    @Override
    @NotNull
    public Type getType() {
        return this.type;
    }

    public EnumEvolutionSerializer(@NotNull Type type, @NotNull LocalSerializerFactory factory, @NotNull BaseLocalTypes baseLocalTypes, @NotNull Map<String, String> conversions, @NotNull Map<String, Integer> ordinals) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)baseLocalTypes, (String)"baseLocalTypes");
        Intrinsics.checkParameterIsNotNull(conversions, (String)"conversions");
        Intrinsics.checkParameterIsNotNull(ordinals, (String)"ordinals");
        this.type = type;
        this.baseLocalTypes = baseLocalTypes;
        this.conversions = conversions;
        this.ordinals = ordinals;
        this.typeDescriptor = factory.createDescriptor(this.getType());
    }
}

