/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPExceptionsKt;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.PropertyReadStrategy;
import net.corda.serialization.internal.amqp.SchemaKt;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/amqp/DescribedTypeReadStrategy;", "Lnet/corda/serialization/internal/amqp/PropertyReadStrategy;", "name", "", "typeIdentifier", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "type", "Ljava/lang/reflect/Type;", "(Ljava/lang/String;Lnet/corda/serialization/internal/model/TypeIdentifier;Ljava/lang/reflect/Type;)V", "nameForDebug", "readProperty", "", "obj", "schemas", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "input", "Lnet/corda/serialization/internal/amqp/DeserializationInput;", "context", "Lnet/corda/core/serialization/SerializationContext;", "serialization"})
public final class DescribedTypeReadStrategy
implements PropertyReadStrategy {
    private final String nameForDebug;
    private final Type type;

    @Override
    @Nullable
    public Object readProperty(@Nullable Object obj, @NotNull SerializationSchemas schemas, @NotNull DeserializationInput input, @NotNull SerializationContext context) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            object = input.readObjectOrNull(SchemaKt.redescribe(obj, this.type), schemas, this.type, context);
        }
        catch (Throwable th$iv) {
            Throwable throwable = th$iv;
            if (throwable instanceof AMQPNotSerializableException) {
                List<String> list = ((AMQPNotSerializableException)th$iv).getClassHierarchy();
                String string = this.nameForDebug;
                list.add(string);
            } else if (!(throwable instanceof ClassNotFoundException) && !(throwable instanceof NoClassDefFoundError)) {
                StringBuilder stringBuilder = new StringBuilder();
                Throwable throwable2 = th$iv;
                String string = this.nameForDebug;
                AMQPExceptionsKt.access$setMessage(throwable2, stringBuilder.append(string).append(" -> ").append(th$iv.getMessage()).toString());
            }
            throw th$iv;
        }
        return object;
    }

    public DescribedTypeReadStrategy(@NotNull String name, @NotNull TypeIdentifier typeIdentifier, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)typeIdentifier, (String)"typeIdentifier");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.type = type;
        this.nameForDebug = name + '(' + typeIdentifier.prettyPrint(false) + ')';
    }
}

