/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/amqp/ConstructorCaller;", "Lkotlin/Function1;", "", "", "javaConstructor", "Ljava/lang/reflect/Constructor;", "(Ljava/lang/reflect/Constructor;)V", "invoke", "parameters", "([Ljava/lang/Object;)Ljava/lang/Object;", "serialization"})
final class ConstructorCaller
implements Function1<Object[], Object> {
    private final Constructor<Object> javaConstructor;

    @NotNull
    public Object invoke(@NotNull Object[] parameters) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Object object2 = this.javaConstructor.newInstance(Arrays.copyOf(parameters, parameters.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"javaConstructor.newInstance(*parameters)");
            object = object2;
        }
        catch (InvocationTargetException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Constructor for ").append(this.javaConstructor.getDeclaringClass()).append(" (isAccessible=").append(this.javaConstructor.isAccessible()).append(") ").append("failed when called with parameters ").append(ArraysKt.toList((Object[])parameters)).append(": ");
            Throwable throwable = e.getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new NotSerializableException(stringBuilder.append(throwable.getMessage()).toString());
        }
        catch (IllegalAccessException e) {
            throw (Throwable)new NotSerializableException("Constructor for " + this.javaConstructor.getDeclaringClass() + " (isAccessible=" + this.javaConstructor.isAccessible() + ") " + "not accessible: " + e.getMessage());
        }
        return object;
    }

    public ConstructorCaller(@NotNull Constructor<Object> javaConstructor) {
        Intrinsics.checkParameterIsNotNull(javaConstructor, (String)"javaConstructor");
        this.javaConstructor = javaConstructor;
    }
}

