/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.CachingCustomSerializerRegistry;
import net.corda.serialization.internal.amqp.CorDappCustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.RemoteSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.model.LocalTypeInformation;
import org.apache.qpid.proton.amqp.Symbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0001J%\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!H\u0096\u0001J#\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!H\u0096\u0001J\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0001J+\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\n\u0010$\u001a\u00060\u0010j\u0002`%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0096\u0001J\u0011\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020!H\u0096\u0001J\u0013\u0010*\u001a\u0004\u0018\u00010\u001a2\u0006\u0010,\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020!H\u0096\u0001J\u0019\u0010/\u001a\u0002002\u000e\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d02H\u0096\u0001J\u0011\u00103\u001a\u0002002\u0006\u00101\u001a\u000204H\u0096\u0001R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00065"}, d2={"Lnet/corda/serialization/internal/amqp/ComposedSerializerFactory;", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "Lnet/corda/serialization/internal/amqp/RemoteSerializerFactory;", "Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;", "localSerializerFactory", "remoteSerializerFactory", "customSerializerRegistry", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry;", "(Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;Lnet/corda/serialization/internal/amqp/RemoteSerializerFactory;Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry;)V", "classloader", "Ljava/lang/ClassLoader;", "getClassloader", "()Ljava/lang/ClassLoader;", "customSerializerNames", "", "", "getCustomSerializerNames", "()Ljava/util/List;", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "getWhitelist", "()Lnet/corda/core/serialization/ClassWhitelist;", "createDescriptor", "Lorg/apache/qpid/proton/amqp/Symbol;", "typeInformation", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "findCustomSerializer", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "clazz", "Ljava/lang/Class;", "declaredType", "Ljava/lang/reflect/Type;", "get", "actualClass", "typeDescriptor", "Lnet/corda/serialization/internal/model/TypeDescriptor;", "schema", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "context", "Lnet/corda/core/serialization/SerializationContext;", "getTypeInformation", "type", "typeName", "isSuitableForObjectReference", "", "register", "", "customSerializer", "Lnet/corda/serialization/internal/amqp/CustomSerializer;", "registerExternal", "Lnet/corda/serialization/internal/amqp/CorDappCustomSerializer;", "serialization"})
public final class ComposedSerializerFactory
implements CustomSerializerRegistry,
LocalSerializerFactory,
RemoteSerializerFactory,
SerializerFactory {
    private final LocalSerializerFactory localSerializerFactory;
    private final RemoteSerializerFactory remoteSerializerFactory;
    private final CachingCustomSerializerRegistry customSerializerRegistry;

    @Override
    @NotNull
    public List<String> getCustomSerializerNames() {
        return this.customSerializerRegistry.getCustomSerializerNames();
    }

    public ComposedSerializerFactory(@NotNull LocalSerializerFactory localSerializerFactory2, @NotNull RemoteSerializerFactory remoteSerializerFactory, @NotNull CachingCustomSerializerRegistry customSerializerRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)localSerializerFactory2, (String)"localSerializerFactory");
        Intrinsics.checkParameterIsNotNull((Object)remoteSerializerFactory, (String)"remoteSerializerFactory");
        Intrinsics.checkParameterIsNotNull((Object)customSerializerRegistry, (String)"customSerializerRegistry");
        this.localSerializerFactory = localSerializerFactory2;
        this.remoteSerializerFactory = remoteSerializerFactory;
        this.customSerializerRegistry = customSerializerRegistry;
    }

    @Override
    @NotNull
    public ClassLoader getClassloader() {
        return this.localSerializerFactory.getClassloader();
    }

    @Override
    @NotNull
    public ClassWhitelist getWhitelist() {
        return this.localSerializerFactory.getWhitelist();
    }

    @Override
    @NotNull
    public Symbol createDescriptor(@NotNull LocalTypeInformation typeInformation) {
        Intrinsics.checkParameterIsNotNull((Object)typeInformation, (String)"typeInformation");
        return this.localSerializerFactory.createDescriptor(typeInformation);
    }

    @Override
    @NotNull
    public AMQPSerializer<Object> get(@NotNull Class<?> actualClass, @NotNull Type declaredType) {
        Intrinsics.checkParameterIsNotNull(actualClass, (String)"actualClass");
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        return this.localSerializerFactory.get(actualClass, declaredType);
    }

    @Override
    @NotNull
    public AMQPSerializer<Object> get(@NotNull LocalTypeInformation typeInformation) {
        Intrinsics.checkParameterIsNotNull((Object)typeInformation, (String)"typeInformation");
        return this.localSerializerFactory.get(typeInformation);
    }

    @Override
    @NotNull
    public LocalTypeInformation getTypeInformation(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.localSerializerFactory.getTypeInformation(type);
    }

    @Override
    @Nullable
    public LocalTypeInformation getTypeInformation(@NotNull String typeName2) {
        Intrinsics.checkParameterIsNotNull((Object)typeName2, (String)"typeName");
        return this.localSerializerFactory.getTypeInformation(typeName2);
    }

    @Override
    public boolean isSuitableForObjectReference(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.localSerializerFactory.isSuitableForObjectReference(type);
    }

    @Override
    @NotNull
    public AMQPSerializer<Object> get(@NotNull String typeDescriptor2, @NotNull SerializationSchemas schema, @NotNull SerializationContext context) throws NotSerializableException, ClassNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)typeDescriptor2, (String)"typeDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.remoteSerializerFactory.get(typeDescriptor2, schema, context);
    }

    @Override
    @Nullable
    public AMQPSerializer<Object> findCustomSerializer(@NotNull Class<?> clazz, @NotNull Type declaredType) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        return this.customSerializerRegistry.findCustomSerializer(clazz, declaredType);
    }

    @Override
    public void register(@NotNull CustomSerializer<? extends Object> customSerializer) {
        Intrinsics.checkParameterIsNotNull(customSerializer, (String)"customSerializer");
        this.customSerializerRegistry.register(customSerializer);
    }

    @Override
    public void registerExternal(@NotNull CorDappCustomSerializer customSerializer) {
        Intrinsics.checkParameterIsNotNull((Object)customSerializer, (String)"customSerializer");
        this.customSerializerRegistry.registerExternal(customSerializer);
    }
}

