/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"checkUseCase", "", "allowedUseCases", "Ljava/util/EnumSet;", "Lnet/corda/core/serialization/SerializationContext$UseCase;", "allowedUseCase", "serialization"})
@KeepForDJVM
public final class UseCaseAwarenessKt {
    public static final void checkUseCase(@NotNull EnumSet<SerializationContext.UseCase> allowedUseCases) {
        Intrinsics.checkParameterIsNotNull(allowedUseCases, (String)"allowedUseCases");
        SerializationFactory serializationFactory = SerializationFactory.Companion.getCurrentFactory();
        if (serializationFactory == null || (serializationFactory = serializationFactory.getCurrentContext()) == null) {
            throw (Throwable)new IllegalStateException("Current context is not set");
        }
        SerializationFactory currentContext = serializationFactory;
        if (!allowedUseCases.contains(currentContext.getUseCase())) {
            throw (Throwable)new IllegalStateException("UseCase '" + currentContext.getUseCase() + "' is not within '" + allowedUseCases + '\'');
        }
    }

    public static final void checkUseCase(@NotNull SerializationContext.UseCase allowedUseCase) {
        Intrinsics.checkParameterIsNotNull((Object)allowedUseCase, (String)"allowedUseCase");
        SerializationFactory serializationFactory = SerializationFactory.Companion.getCurrentFactory();
        if (serializationFactory == null || (serializationFactory = serializationFactory.getCurrentContext()) == null) {
            throw (Throwable)new IllegalStateException("Current context is not set");
        }
        SerializationFactory currentContext = serializationFactory;
        if (allowedUseCase != currentContext.getUseCase()) {
            throw (Throwable)new IllegalStateException("UseCase '" + currentContext.getUseCase() + "' is not '" + allowedUseCase + '\'');
        }
    }
}

