/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.ObjectWithCompatibleContext;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.serialization.internal.CustomSerializationSchemeUtils;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.CordaSerializationMagic;
import net.corda.serialization.internal.SerializationFactoryImpl;
import net.corda.serialization.internal.SerializationScheme;
import net.corda.serialization.internal.amqp.SchemaKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0006\b\u0017\u0018\u0000 :2\u00020\u0001:\u0001:B'\u0012\u001e\u00106\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001e0 \u0012\u0004\u0012\u00020\u001405\u00a2\u0006\u0004\b8\u00109J7\u0010\n\u001a\u00028\u0000\"\b\b\u0000\u0010\u0003*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ=\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f\"\b\b\u0000\u0010\u0003*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ+\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\"\u0010#J/\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000%\"\b\b\u0000\u0010\u0003*\u00020\u00022\u0006\u0010$\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*R\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001e\u00101\u001a\n 0*\u0004\u0018\u00010/0/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R.\u00106\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001e0 \u0012\u0004\u0012\u00020\u0014058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u0006;"}, d2={"Lnet/corda/serialization/internal/SerializationFactoryImpl;", "Lnet/corda/core/serialization/SerializationFactory;", "", "T", "Lnet/corda/core/utilities/ByteSequence;", "byteSequence", "Ljava/lang/Class;", "clazz", "Lnet/corda/core/serialization/SerializationContext;", "context", "deserialize", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "Lnet/corda/core/serialization/ObjectWithCompatibleContext;", "deserializeWithCompatibleContext", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/ObjectWithCompatibleContext;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "Lnet/corda/serialization/internal/SerializationScheme;", "getRegisteredSchemes", "()Ljava/util/Collection;", "", "hashCode", "()I", "scheme", "", "registerScheme", "(Lnet/corda/serialization/internal/SerializationScheme;)V", "Lnet/corda/core/serialization/SerializationContext$UseCase;", "target", "Lkotlin/Pair;", "Lnet/corda/serialization/internal/CordaSerializationMagic;", "schemeFor", "(Lnet/corda/core/utilities/ByteSequence;Lnet/corda/core/serialization/SerializationContext$UseCase;)Lkotlin/Pair;", "obj", "Lnet/corda/core/serialization/SerializedBytes;", "serialize", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/SerializedBytes;", "", "toString", "()Ljava/lang/String;", "", "Ljava/lang/StackTraceElement;", "creator", "Ljava/util/List;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "registeredSchemes", "Ljava/util/Collection;", "", "schemes", "Ljava/util/Map;", "<init>", "(Ljava/util/Map;)V", "Companion", "serialization"})
@KeepForDJVM
public class SerializationFactoryImpl
extends SerializationFactory {
    private final List<StackTraceElement> creator;
    private final Collection<SerializationScheme> registeredSchemes;
    private final Logger logger;
    private final Map<Pair<CordaSerializationMagic, SerializationContext.UseCase>, SerializationScheme> schemes;
    private static final int magicSize;
    public static final Companion Companion;

    @NotNull
    public final Collection<SerializationScheme> getRegisteredSchemes() {
        return this.registeredSchemes;
    }

    private final Pair<SerializationScheme, CordaSerializationMagic> schemeFor(ByteSequence byteSequence, SerializationContext.UseCase target) {
        CordaSerializationMagic magic = new CordaSerializationMagic(InternalUtils.copyBytes((ByteBuffer)ByteSequence.slice$default((ByteSequence)byteSequence, (int)0, (int)magicSize, (int)1, null)));
        Pair lookupKey = TuplesKt.to((Object)((Object)magic), (Object)target);
        SerializationScheme serializationScheme = this.schemes.get(lookupKey);
        if (serializationScheme == null) {
            SerializationScheme serializationScheme2 = this.schemes.computeIfAbsent((Pair<CordaSerializationMagic, SerializationContext.UseCase>)lookupKey, (Function<Pair<CordaSerializationMagic, SerializationContext.UseCase>, SerializationScheme>)new Function<Pair<? extends CordaSerializationMagic, ? extends SerializationContext.UseCase>, SerializationScheme>(this, magic, target, lookupKey){
                final /* synthetic */ SerializationFactoryImpl this$0;
                final /* synthetic */ CordaSerializationMagic $magic;
                final /* synthetic */ SerializationContext.UseCase $target;
                final /* synthetic */ Pair $lookupKey;

                @NotNull
                public final SerializationScheme apply(@NotNull Pair<CordaSerializationMagic, ? extends SerializationContext.UseCase> it) {
                    Object v0;
                    block3: {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        Iterable $receiver$iv = SerializationFactoryImpl.access$getRegisteredSchemes$p(this.this$0);
                        for (T element$iv : $receiver$iv) {
                            SerializationScheme it2 = (SerializationScheme)element$iv;
                            if (!it2.canDeserializeVersion(this.$magic, this.$target)) continue;
                            v0 = element$iv;
                            break block3;
                        }
                        v0 = null;
                    }
                    SerializationScheme serializationScheme = v0;
                    if (serializationScheme == null) {
                        SerializationFactoryImpl serializationFactoryImpl;
                        SerializationFactoryImpl $receiver = serializationFactoryImpl = this.this$0;
                        SerializationFactoryImpl.access$getLogger$p($receiver).warn("Cannot find serialization scheme for: [" + this.$lookupKey + ", " + (Intrinsics.areEqual((Object)((Object)this.$magic), (Object)((Object)SchemaKt.getAmqpMagic())) ? "AMQP" : "UNKNOWN MAGIC") + "] registeredSchemes are: " + SerializationFactoryImpl.access$getRegisteredSchemes$p($receiver));
                        Integer n = CustomSerializationSchemeUtils.Companion.getSchemeIdIfCustomSerializationMagic((ByteSequence)this.$magic);
                        if (n == null) {
                            throw (Throwable)new UnsupportedOperationException("Serialization scheme" + ' ' + this.$lookupKey + " not supported.");
                        }
                        int schemeId = n;
                        throw (Throwable)new UnsupportedOperationException("Could not find custom serialization scheme with SchemeId = " + schemeId + '.');
                    }
                    return serializationScheme;
                }
                {
                    this.this$0 = serializationFactoryImpl;
                    this.$magic = cordaSerializationMagic;
                    this.$target = useCase;
                    this.$lookupKey = pair;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)serializationScheme2, (String)"schemes.computeIfAbsent(\u2026)\n            }\n        }");
            serializationScheme = serializationScheme2;
        }
        return TuplesKt.to((Object)serializationScheme, (Object)((Object)magic));
    }

    @NotNull
    public <T> T deserialize(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (T)this.asCurrent(new Function1<SerializationFactory, T>(this, context, byteSequence, clazz){
            final /* synthetic */ SerializationFactoryImpl this$0;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ ByteSequence $byteSequence;
            final /* synthetic */ Class $clazz;

            @NotNull
            public final T invoke(@NotNull SerializationFactory $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (T)$receiver.withCurrentContext(this.$context, (Function0)new Function0<T>(this){
                    final /* synthetic */ deserialize.1 this$0;

                    @NotNull
                    public final T invoke() {
                        return ((SerializationScheme)SerializationFactoryImpl.access$schemeFor(this.this$0.this$0, this.this$0.$byteSequence, this.this$0.$context.getUseCase()).getFirst()).deserialize(this.this$0.$byteSequence, this.this$0.$clazz, this.this$0.$context);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = serializationFactoryImpl;
                this.$context = serializationContext;
                this.$byteSequence = byteSequence;
                this.$clazz = clazz;
                super(1);
            }
        });
    }

    @NotNull
    public <T> ObjectWithCompatibleContext<T> deserializeWithCompatibleContext(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (ObjectWithCompatibleContext)this.asCurrent(new Function1<SerializationFactory, ObjectWithCompatibleContext<? extends T>>(this, context, byteSequence, clazz){
            final /* synthetic */ SerializationFactoryImpl this$0;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ ByteSequence $byteSequence;
            final /* synthetic */ Class $clazz;

            @NotNull
            public final ObjectWithCompatibleContext<T> invoke(@NotNull SerializationFactory $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (ObjectWithCompatibleContext)$receiver.withCurrentContext(this.$context, (Function0)new Function0<ObjectWithCompatibleContext<? extends T>>(this){
                    final /* synthetic */ deserializeWithCompatibleContext.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final ObjectWithCompatibleContext<T> invoke() {
                        void scheme;
                        Pair pair = SerializationFactoryImpl.access$schemeFor(this.this$0.this$0, this.this$0.$byteSequence, this.this$0.$context.getUseCase());
                        SerializationScheme serializationScheme = (SerializationScheme)pair.component1();
                        CordaSerializationMagic magic = (CordaSerializationMagic)((Object)pair.component2());
                        T deserializedObject = scheme.deserialize(this.this$0.$byteSequence, this.this$0.$clazz, this.this$0.$context);
                        return new ObjectWithCompatibleContext(deserializedObject, this.this$0.$context.withPreferredSerializationVersion((ByteSequence)magic));
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = serializationFactoryImpl;
                this.$context = serializationContext;
                this.$byteSequence = byteSequence;
                this.$clazz = clazz;
                super(1);
            }
        });
    }

    @NotNull
    public <T> SerializedBytes<T> serialize(@NotNull T obj, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (SerializedBytes)this.asCurrent(new Function1<SerializationFactory, SerializedBytes<T>>(this, context, obj){
            final /* synthetic */ SerializationFactoryImpl this$0;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ Object $obj;

            @NotNull
            public final SerializedBytes<T> invoke(@NotNull SerializationFactory $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (SerializedBytes)$receiver.withCurrentContext(this.$context, (Function0)new Function0<SerializedBytes<T>>(this){
                    final /* synthetic */ serialize.1 this$0;

                    @NotNull
                    public final SerializedBytes<T> invoke() {
                        return ((SerializationScheme)SerializationFactoryImpl.access$schemeFor(this.this$0.this$0, this.this$0.$context.getPreferredSerializationVersion(), this.this$0.$context.getUseCase()).getFirst()).serialize(this.this$0.$obj, this.this$0.$context);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = serializationFactoryImpl;
                this.$context = serializationContext;
                this.$obj = object;
                super(1);
            }
        });
    }

    public final void registerScheme(@NotNull SerializationScheme scheme) {
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        boolean bl = this.schemes.isEmpty();
        if (!bl) {
            String string = "All serialization schemes must be registered before any scheme is used.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Collection<SerializationScheme> collection = this.registeredSchemes;
        collection.add(scheme);
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " registeredSchemes=" + this.registeredSchemes + ' ' + CollectionsKt.joinToString$default((Iterable)this.creator, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof SerializationFactoryImpl && Intrinsics.areEqual(((SerializationFactoryImpl)((Object)other)).registeredSchemes, this.registeredSchemes);
    }

    public int hashCode() {
        return ((Object)this.registeredSchemes).hashCode();
    }

    public SerializationFactoryImpl(@NotNull Map<Pair<CordaSerializationMagic, SerializationContext.UseCase>, SerializationScheme> schemes) {
        Intrinsics.checkParameterIsNotNull(schemes, (String)"schemes");
        this.schemes = schemes;
        Object[] objectArray = new Exception().getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Exception().stackTrace");
        this.creator = ArraysKt.asList((Object[])objectArray);
        SerializationFactoryImpl serializationFactoryImpl = this;
        List list = new ArrayList();
        Collection collection = Collections.synchronizedCollection(list);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"Collections.synchronized\u2026llection(mutableListOf())");
        serializationFactoryImpl.registeredSchemes = collection;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    static {
        Companion = new Companion(null);
        magicSize = SchemaKt.getAmqpMagic().getSize();
    }

    @NotNull
    public static final /* synthetic */ Collection access$getRegisteredSchemes$p(SerializationFactoryImpl $this) {
        return $this.registeredSchemes;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SerializationFactoryImpl $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ Pair access$schemeFor(SerializationFactoryImpl $this, @NotNull ByteSequence byteSequence, @NotNull SerializationContext.UseCase target) {
        return $this.schemeFor(byteSequence, target);
    }

    public static final /* synthetic */ int access$getMagicSize$cp() {
        return magicSize;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/serialization/internal/SerializationFactoryImpl$Companion;", "", "<init>", "()V", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

