/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.core.crypto.SecureHash;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.EncodingWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationCustomSerializer;
import net.corda.core.serialization.SerializationEncoding;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.SnappyEncodingWhitelist;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u0091\u0001\b\u0007\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\r\u0012\b\b\u0002\u0010\u0015\u001a\u00020\r\u0012\b\b\u0002\u0010\u0016\u001a\u00020\r\u0012\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u0018\u00a2\u0006\u0002\u0010\u001aJ\r\u00100\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u00101\u001a\u00020\rH\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\u0017\u00103\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u0018H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J\u0015\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u00107\u001a\u00020\rH\u00c6\u0003J\t\u00108\u001a\u00020\u000fH\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\t\u0010:\u001a\u00020\u0013H\u00c6\u0003J\t\u0010;\u001a\u00020\rH\u00c6\u0003J\u00a1\u0001\u0010<\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\r2\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u0018H\u00c6\u0001J\u0013\u0010=\u001a\u00020\r2\b\u0010>\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010?\u001a\u00020@H\u00d6\u0001J\t\u0010A\u001a\u00020BH\u00d6\u0001J\u0016\u0010C\u001a\u00020\u00012\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0016J\u0010\u0010G\u001a\u00020\u00012\u0006\u0010H\u001a\u00020\u0006H\u0016J\u001e\u0010I\u001a\u00020\u00002\u0014\u0010J\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u0018H\u0016J\u0012\u0010K\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010L\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010M\u001a\u00020\u0001H\u0016J\u0014\u0010N\u001a\u00020\u00002\n\u0010O\u001a\u00060\u0003j\u0002`\u0004H\u0016J\b\u0010P\u001a\u00020\u0001H\u0016J\u001c\u0010Q\u001a\u00020\u00012\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010S\u001a\u00020\u00012\u0006\u0010T\u001a\u00020\u000b2\u0006\u0010U\u001a\u00020\u000bH\u0016J\u0014\u0010V\u001a\u00020\u00012\n\u0010W\u001a\u0006\u0012\u0002\b\u00030XH\u0016J\b\u0010Y\u001a\u00020\u0001H\u0016J\b\u0010Z\u001a\u00020\u0001H\u0016R\u0014\u0010\u0015\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0014\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001cR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\u0016\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001cR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006["}, d2={"Lnet/corda/serialization/internal/SerializationContextImpl;", "Lnet/corda/core/serialization/SerializationContext;", "preferredSerializationVersion", "Lnet/corda/core/utilities/ByteSequence;", "Lnet/corda/core/serialization/SerializationMagic;", "deserializationClassLoader", "Ljava/lang/ClassLoader;", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "properties", "", "", "objectReferencesEnabled", "", "useCase", "Lnet/corda/core/serialization/SerializationContext$UseCase;", "encoding", "Lnet/corda/core/serialization/SerializationEncoding;", "encodingWhitelist", "Lnet/corda/core/serialization/EncodingWhitelist;", "lenientCarpenterEnabled", "carpenterDisabled", "preventDataLoss", "customSerializers", "", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/ClassLoader;Lnet/corda/core/serialization/ClassWhitelist;Ljava/util/Map;ZLnet/corda/core/serialization/SerializationContext$UseCase;Lnet/corda/core/serialization/SerializationEncoding;Lnet/corda/core/serialization/EncodingWhitelist;ZZZLjava/util/Set;)V", "getCarpenterDisabled", "()Z", "getCustomSerializers", "()Ljava/util/Set;", "getDeserializationClassLoader", "()Ljava/lang/ClassLoader;", "getEncoding", "()Lnet/corda/core/serialization/SerializationEncoding;", "getEncodingWhitelist", "()Lnet/corda/core/serialization/EncodingWhitelist;", "getLenientCarpenterEnabled", "getObjectReferencesEnabled", "getPreferredSerializationVersion", "()Lnet/corda/core/utilities/ByteSequence;", "getPreventDataLoss", "getProperties", "()Ljava/util/Map;", "getUseCase", "()Lnet/corda/core/serialization/SerializationContext$UseCase;", "getWhitelist", "()Lnet/corda/core/serialization/ClassWhitelist;", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "", "withAttachmentsClassLoader", "attachmentHashes", "", "Lnet/corda/core/crypto/SecureHash;", "withClassLoader", "classLoader", "withCustomSerializers", "serializers", "withEncoding", "withEncodingWhitelist", "withLenientCarpenter", "withPreferredSerializationVersion", "magic", "withPreventDataLoss", "withProperties", "extraProperties", "withProperty", "property", "value", "withWhitelisted", "clazz", "Ljava/lang/Class;", "withoutCarpenter", "withoutReferences", "serialization"})
@KeepForDJVM
public final class SerializationContextImpl
implements SerializationContext {
    @NotNull
    private final ByteSequence preferredSerializationVersion;
    @NotNull
    private final ClassLoader deserializationClassLoader;
    @NotNull
    private final ClassWhitelist whitelist;
    @NotNull
    private final Map<Object, Object> properties;
    private final boolean objectReferencesEnabled;
    @NotNull
    private final SerializationContext.UseCase useCase;
    @Nullable
    private final SerializationEncoding encoding;
    @NotNull
    private final EncodingWhitelist encodingWhitelist;
    private final boolean lenientCarpenterEnabled;
    private final boolean carpenterDisabled;
    private final boolean preventDataLoss;
    @NotNull
    private final Set<SerializationCustomSerializer<?, ?>> customSerializers;

    @NotNull
    public SerializationContext withAttachmentsClassLoader(@NotNull List<? extends SecureHash> attachmentHashes) {
        Intrinsics.checkParameterIsNotNull(attachmentHashes, (String)"attachmentHashes");
        return this;
    }

    @NotNull
    public SerializationContext withProperty(@NotNull Object property, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return SerializationContextImpl.copy$default(this, null, null, null, MapsKt.plus(this.getProperties(), (Pair)TuplesKt.to((Object)property, (Object)value)), false, null, null, null, false, false, false, null, 4087, null);
    }

    @NotNull
    public SerializationContext withProperties(@NotNull Map<Object, ? extends Object> extraProperties) {
        Intrinsics.checkParameterIsNotNull(extraProperties, (String)"extraProperties");
        return SerializationContextImpl.copy$default(this, null, null, null, MapsKt.plus(this.getProperties(), extraProperties), false, null, null, null, false, false, false, null, 4087, null);
    }

    @NotNull
    public SerializationContext withoutReferences() {
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, null, null, false, false, false, null, 4079, null);
    }

    @NotNull
    public SerializationContext withLenientCarpenter() {
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, null, null, true, false, false, null, 3839, null);
    }

    @NotNull
    public SerializationContext withoutCarpenter() {
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, null, null, false, true, false, null, 3583, null);
    }

    @NotNull
    public SerializationContext withPreventDataLoss() {
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, null, null, false, false, true, null, 3071, null);
    }

    @NotNull
    public SerializationContext withClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        return SerializationContextImpl.copy$default(this, null, classLoader, null, null, false, null, null, null, false, false, false, null, 4093, null);
    }

    @NotNull
    public SerializationContext withWhitelisted(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return SerializationContextImpl.copy$default(this, null, null, new ClassWhitelist(this, clazz){
            final /* synthetic */ SerializationContextImpl this$0;
            final /* synthetic */ Class $clazz;

            public boolean hasListed(@NotNull Class<?> type) {
                Intrinsics.checkParameterIsNotNull(type, (String)"type");
                return this.this$0.getWhitelist().hasListed(type) || Intrinsics.areEqual((Object)type.getName(), (Object)this.$clazz.getName());
            }
            {
                this.this$0 = $outer;
                this.$clazz = $captured_local_variable$1;
            }
        }, null, false, null, null, null, false, false, false, null, 4091, null);
    }

    @NotNull
    public SerializationContextImpl withCustomSerializers(@NotNull Set<? extends SerializationCustomSerializer<?, ?>> serializers) {
        Intrinsics.checkParameterIsNotNull(serializers, (String)"serializers");
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, null, null, false, false, false, CollectionsKt.union((Iterable)this.getCustomSerializers(), (Iterable)serializers), 2047, null);
    }

    @NotNull
    public SerializationContextImpl withPreferredSerializationVersion(@NotNull ByteSequence magic) {
        Intrinsics.checkParameterIsNotNull((Object)magic, (String)"magic");
        return SerializationContextImpl.copy$default(this, magic, null, null, null, false, null, null, null, false, false, false, null, 4094, null);
    }

    @NotNull
    public SerializationContextImpl withEncoding(@Nullable SerializationEncoding encoding) {
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, encoding, null, false, false, false, null, 4031, null);
    }

    @NotNull
    public SerializationContextImpl withEncodingWhitelist(@NotNull EncodingWhitelist encodingWhitelist) {
        Intrinsics.checkParameterIsNotNull((Object)encodingWhitelist, (String)"encodingWhitelist");
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, null, encodingWhitelist, false, false, false, null, 3967, null);
    }

    @NotNull
    public ByteSequence getPreferredSerializationVersion() {
        return this.preferredSerializationVersion;
    }

    @NotNull
    public ClassLoader getDeserializationClassLoader() {
        return this.deserializationClassLoader;
    }

    @NotNull
    public ClassWhitelist getWhitelist() {
        return this.whitelist;
    }

    @NotNull
    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public boolean getObjectReferencesEnabled() {
        return this.objectReferencesEnabled;
    }

    @NotNull
    public SerializationContext.UseCase getUseCase() {
        return this.useCase;
    }

    @Nullable
    public SerializationEncoding getEncoding() {
        return this.encoding;
    }

    @NotNull
    public EncodingWhitelist getEncodingWhitelist() {
        return this.encodingWhitelist;
    }

    public boolean getLenientCarpenterEnabled() {
        return this.lenientCarpenterEnabled;
    }

    public boolean getCarpenterDisabled() {
        return this.carpenterDisabled;
    }

    public boolean getPreventDataLoss() {
        return this.preventDataLoss;
    }

    @NotNull
    public Set<SerializationCustomSerializer<?, ?>> getCustomSerializers() {
        return this.customSerializers;
    }

    @JvmOverloads
    public SerializationContextImpl(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties2, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase, @Nullable SerializationEncoding encoding, @NotNull EncodingWhitelist encodingWhitelist, boolean lenientCarpenterEnabled, boolean carpenterDisabled, boolean preventDataLoss, @NotNull Set<? extends SerializationCustomSerializer<?, ?>> customSerializers) {
        Intrinsics.checkParameterIsNotNull((Object)preferredSerializationVersion, (String)"preferredSerializationVersion");
        Intrinsics.checkParameterIsNotNull((Object)deserializationClassLoader, (String)"deserializationClassLoader");
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull(properties2, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
        Intrinsics.checkParameterIsNotNull((Object)encodingWhitelist, (String)"encodingWhitelist");
        Intrinsics.checkParameterIsNotNull(customSerializers, (String)"customSerializers");
        this.preferredSerializationVersion = preferredSerializationVersion;
        this.deserializationClassLoader = deserializationClassLoader;
        this.whitelist = whitelist;
        this.properties = properties2;
        this.objectReferencesEnabled = objectReferencesEnabled;
        this.useCase = useCase;
        this.encoding = encoding;
        this.encodingWhitelist = encodingWhitelist;
        this.lenientCarpenterEnabled = lenientCarpenterEnabled;
        this.carpenterDisabled = carpenterDisabled;
        this.preventDataLoss = preventDataLoss;
        this.customSerializers = customSerializers;
    }

    @JvmOverloads
    public /* synthetic */ SerializationContextImpl(ByteSequence byteSequence, ClassLoader classLoader, ClassWhitelist classWhitelist, Map map, boolean bl, SerializationContext.UseCase useCase, SerializationEncoding serializationEncoding, EncodingWhitelist encodingWhitelist, boolean bl2, boolean bl3, boolean bl4, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            encodingWhitelist = SnappyEncodingWhitelist.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        if ((n & 0x200) != 0) {
            bl3 = false;
        }
        if ((n & 0x400) != 0) {
            bl4 = false;
        }
        if ((n & 0x800) != 0) {
            set = SetsKt.emptySet();
        }
        this(byteSequence, classLoader, classWhitelist, map, bl, useCase, serializationEncoding, encodingWhitelist, bl2, bl3, bl4, set);
    }

    @JvmOverloads
    public SerializationContextImpl(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties2, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase, @Nullable SerializationEncoding encoding, @NotNull EncodingWhitelist encodingWhitelist, boolean lenientCarpenterEnabled, boolean carpenterDisabled, boolean preventDataLoss) {
        this(preferredSerializationVersion, deserializationClassLoader, whitelist, properties2, objectReferencesEnabled, useCase, encoding, encodingWhitelist, lenientCarpenterEnabled, carpenterDisabled, preventDataLoss, null, 2048, null);
    }

    @JvmOverloads
    public SerializationContextImpl(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties2, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase, @Nullable SerializationEncoding encoding, @NotNull EncodingWhitelist encodingWhitelist, boolean lenientCarpenterEnabled, boolean carpenterDisabled) {
        this(preferredSerializationVersion, deserializationClassLoader, whitelist, properties2, objectReferencesEnabled, useCase, encoding, encodingWhitelist, lenientCarpenterEnabled, carpenterDisabled, false, null, 3072, null);
    }

    @JvmOverloads
    public SerializationContextImpl(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties2, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase, @Nullable SerializationEncoding encoding, @NotNull EncodingWhitelist encodingWhitelist, boolean lenientCarpenterEnabled) {
        this(preferredSerializationVersion, deserializationClassLoader, whitelist, properties2, objectReferencesEnabled, useCase, encoding, encodingWhitelist, lenientCarpenterEnabled, false, false, null, 3584, null);
    }

    @JvmOverloads
    public SerializationContextImpl(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties2, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase, @Nullable SerializationEncoding encoding, @NotNull EncodingWhitelist encodingWhitelist) {
        this(preferredSerializationVersion, deserializationClassLoader, whitelist, properties2, objectReferencesEnabled, useCase, encoding, encodingWhitelist, false, false, false, null, 3840, null);
    }

    @JvmOverloads
    public SerializationContextImpl(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties2, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase, @Nullable SerializationEncoding encoding) {
        this(preferredSerializationVersion, deserializationClassLoader, whitelist, properties2, objectReferencesEnabled, useCase, encoding, null, false, false, false, null, 3968, null);
    }

    @NotNull
    public final ByteSequence component1() {
        return this.getPreferredSerializationVersion();
    }

    @NotNull
    public final ClassLoader component2() {
        return this.getDeserializationClassLoader();
    }

    @NotNull
    public final ClassWhitelist component3() {
        return this.getWhitelist();
    }

    @NotNull
    public final Map<Object, Object> component4() {
        return this.getProperties();
    }

    public final boolean component5() {
        return this.getObjectReferencesEnabled();
    }

    @NotNull
    public final SerializationContext.UseCase component6() {
        return this.getUseCase();
    }

    @Nullable
    public final SerializationEncoding component7() {
        return this.getEncoding();
    }

    @NotNull
    public final EncodingWhitelist component8() {
        return this.getEncodingWhitelist();
    }

    public final boolean component9() {
        return this.getLenientCarpenterEnabled();
    }

    public final boolean component10() {
        return this.getCarpenterDisabled();
    }

    public final boolean component11() {
        return this.getPreventDataLoss();
    }

    @NotNull
    public final Set<SerializationCustomSerializer<?, ?>> component12() {
        return this.getCustomSerializers();
    }

    @NotNull
    public final SerializationContextImpl copy(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties2, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase, @Nullable SerializationEncoding encoding, @NotNull EncodingWhitelist encodingWhitelist, boolean lenientCarpenterEnabled, boolean carpenterDisabled, boolean preventDataLoss, @NotNull Set<? extends SerializationCustomSerializer<?, ?>> customSerializers) {
        Intrinsics.checkParameterIsNotNull((Object)preferredSerializationVersion, (String)"preferredSerializationVersion");
        Intrinsics.checkParameterIsNotNull((Object)deserializationClassLoader, (String)"deserializationClassLoader");
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull(properties2, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
        Intrinsics.checkParameterIsNotNull((Object)encodingWhitelist, (String)"encodingWhitelist");
        Intrinsics.checkParameterIsNotNull(customSerializers, (String)"customSerializers");
        return new SerializationContextImpl(preferredSerializationVersion, deserializationClassLoader, whitelist, properties2, objectReferencesEnabled, useCase, encoding, encodingWhitelist, lenientCarpenterEnabled, carpenterDisabled, preventDataLoss, customSerializers);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SerializationContextImpl copy$default(SerializationContextImpl serializationContextImpl, ByteSequence byteSequence, ClassLoader classLoader, ClassWhitelist classWhitelist, Map map, boolean bl, SerializationContext.UseCase useCase, SerializationEncoding serializationEncoding, EncodingWhitelist encodingWhitelist, boolean bl2, boolean bl3, boolean bl4, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            byteSequence = serializationContextImpl.getPreferredSerializationVersion();
        }
        if ((n & 2) != 0) {
            classLoader = serializationContextImpl.getDeserializationClassLoader();
        }
        if ((n & 4) != 0) {
            classWhitelist = serializationContextImpl.getWhitelist();
        }
        if ((n & 8) != 0) {
            map = serializationContextImpl.getProperties();
        }
        if ((n & 0x10) != 0) {
            bl = serializationContextImpl.getObjectReferencesEnabled();
        }
        if ((n & 0x20) != 0) {
            useCase = serializationContextImpl.getUseCase();
        }
        if ((n & 0x40) != 0) {
            serializationEncoding = serializationContextImpl.getEncoding();
        }
        if ((n & 0x80) != 0) {
            encodingWhitelist = serializationContextImpl.getEncodingWhitelist();
        }
        if ((n & 0x100) != 0) {
            bl2 = serializationContextImpl.getLenientCarpenterEnabled();
        }
        if ((n & 0x200) != 0) {
            bl3 = serializationContextImpl.getCarpenterDisabled();
        }
        if ((n & 0x400) != 0) {
            bl4 = serializationContextImpl.getPreventDataLoss();
        }
        if ((n & 0x800) != 0) {
            set = serializationContextImpl.getCustomSerializers();
        }
        return serializationContextImpl.copy(byteSequence, classLoader, classWhitelist, map, bl, useCase, serializationEncoding, encodingWhitelist, bl2, bl3, bl4, set);
    }

    @NotNull
    public String toString() {
        return "SerializationContextImpl(preferredSerializationVersion=" + this.getPreferredSerializationVersion() + ", deserializationClassLoader=" + this.getDeserializationClassLoader() + ", whitelist=" + this.getWhitelist() + ", properties=" + this.getProperties() + ", objectReferencesEnabled=" + this.getObjectReferencesEnabled() + ", useCase=" + this.getUseCase() + ", encoding=" + this.getEncoding() + ", encodingWhitelist=" + this.getEncodingWhitelist() + ", lenientCarpenterEnabled=" + this.getLenientCarpenterEnabled() + ", carpenterDisabled=" + this.getCarpenterDisabled() + ", preventDataLoss=" + this.getPreventDataLoss() + ", customSerializers=" + this.getCustomSerializers() + ")";
    }

    public int hashCode() {
        ByteSequence byteSequence = this.getPreferredSerializationVersion();
        ClassLoader classLoader = this.getDeserializationClassLoader();
        ClassWhitelist classWhitelist = this.getWhitelist();
        Map<Object, Object> map = this.getProperties();
        int n = ((((byteSequence != null ? byteSequence.hashCode() : 0) * 31 + (classLoader != null ? classLoader.hashCode() : 0)) * 31 + (classWhitelist != null ? classWhitelist.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31;
        int n2 = this.getObjectReferencesEnabled() ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        SerializationContext.UseCase useCase = this.getUseCase();
        SerializationEncoding serializationEncoding = this.getEncoding();
        EncodingWhitelist encodingWhitelist = this.getEncodingWhitelist();
        int n3 = ((((n + n2) * 31 + (useCase != null ? useCase.hashCode() : 0)) * 31 + (serializationEncoding != null ? serializationEncoding.hashCode() : 0)) * 31 + (encodingWhitelist != null ? encodingWhitelist.hashCode() : 0)) * 31;
        int n4 = this.getLenientCarpenterEnabled() ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        int n5 = (n3 + n4) * 31;
        int n6 = this.getCarpenterDisabled() ? 1 : 0;
        if (n6 != 0) {
            n6 = 1;
        }
        int n7 = (n5 + n6) * 31;
        int n8 = this.getPreventDataLoss() ? 1 : 0;
        if (n8 != 0) {
            n8 = 1;
        }
        Set<SerializationCustomSerializer<?, ?>> set = this.getCustomSerializers();
        return (n7 + n8) * 31 + (set != null ? ((Object)set).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SerializationContextImpl)) break block3;
                SerializationContextImpl serializationContextImpl = (SerializationContextImpl)object;
                if (!Intrinsics.areEqual((Object)this.getPreferredSerializationVersion(), (Object)serializationContextImpl.getPreferredSerializationVersion()) || !Intrinsics.areEqual((Object)this.getDeserializationClassLoader(), (Object)serializationContextImpl.getDeserializationClassLoader()) || !Intrinsics.areEqual((Object)this.getWhitelist(), (Object)serializationContextImpl.getWhitelist()) || !Intrinsics.areEqual(this.getProperties(), serializationContextImpl.getProperties()) || !(this.getObjectReferencesEnabled() == serializationContextImpl.getObjectReferencesEnabled()) || !Intrinsics.areEqual((Object)this.getUseCase(), (Object)serializationContextImpl.getUseCase()) || !Intrinsics.areEqual((Object)this.getEncoding(), (Object)serializationContextImpl.getEncoding()) || !Intrinsics.areEqual((Object)this.getEncodingWhitelist(), (Object)serializationContextImpl.getEncodingWhitelist()) || !(this.getLenientCarpenterEnabled() == serializationContextImpl.getLenientCarpenterEnabled()) || !(this.getCarpenterDisabled() == serializationContextImpl.getCarpenterDisabled()) || !(this.getPreventDataLoss() == serializationContextImpl.getPreventDataLoss()) || !Intrinsics.areEqual(this.getCustomSerializers(), serializationContextImpl.getCustomSerializers())) break block3;
            }
            return true;
        }
        return false;
    }
}

