/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lnet/corda/serialization/internal/ByteBufferInputStream;", "Ljava/io/InputStream;", "byteBuffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "read", "", "b", "", "offset", "length", "serialization"})
@KeepForDJVM
public final class ByteBufferInputStream
extends InputStream {
    @NotNull
    private final ByteBuffer byteBuffer;

    @Override
    public int read() throws IOException {
        return this.byteBuffer.hasRemaining() ? (int)this.byteBuffer.get() : -1;
    }

    @Override
    public int read(@NotNull byte[] b, int offset, int length) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (offset < 0 || length < 0 || length > b.length - offset) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        int n = this.byteBuffer.remaining();
        int size = Math.min(length, n);
        this.byteBuffer.get(b, offset, size);
        return size;
    }

    @NotNull
    public final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ByteBufferInputStream(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)byteBuffer, (String)"byteBuffer");
        this.byteBuffer = byteBuffer;
    }
}

