/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.rpc.ConnectionFailureException;
import net.corda.client.rpc.internal.ReconnectingCordaRPCOps;
import net.corda.core.messaging.DataFeed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\rB9\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u00060\b\u00a2\u0006\u0002\u0010\tB\u0015\b\u0002\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Lnet/corda/client/rpc/internal/ReconnectingObservable;", "T", "Lrx/Observable;", "reconnectingRPCConnection", "Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps$ReconnectingRPCConnection;", "initialDataFeed", "Lnet/corda/core/messaging/DataFeed;", "createDataFeed", "Lkotlin/Function0;", "(Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps$ReconnectingRPCConnection;Lnet/corda/core/messaging/DataFeed;Lkotlin/jvm/functions/Function0;)V", "subscriber", "Lnet/corda/client/rpc/internal/ReconnectingObservable$ReconnectingSubscriber;", "(Lnet/corda/client/rpc/internal/ReconnectingObservable$ReconnectingSubscriber;)V", "ReconnectingSubscriber", "rpc"})
public final class ReconnectingObservable<T>
extends Observable<T> {
    private ReconnectingObservable(ReconnectingSubscriber<T> subscriber) {
        super((Observable.OnSubscribe)subscriber);
    }

    public ReconnectingObservable(@NotNull ReconnectingCordaRPCOps.ReconnectingRPCConnection reconnectingRPCConnection, @NotNull DataFeed<?, T> initialDataFeed, @NotNull Function0<? extends DataFeed<?, T>> createDataFeed) {
        Intrinsics.checkNotNullParameter((Object)reconnectingRPCConnection, (String)"reconnectingRPCConnection");
        Intrinsics.checkNotNullParameter(initialDataFeed, (String)"initialDataFeed");
        Intrinsics.checkNotNullParameter(createDataFeed, (String)"createDataFeed");
        this(new ReconnectingSubscriber<T>(reconnectingRPCConnection, initialDataFeed, createDataFeed));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00122\u0010\u0010\u0018\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/client/rpc/internal/ReconnectingObservable$ReconnectingSubscriber;", "T", "Lrx/Observable$OnSubscribe;", "Lrx/Subscription;", "reconnectingRPCConnection", "Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps$ReconnectingRPCConnection;", "initialDataFeed", "Lnet/corda/core/messaging/DataFeed;", "createDataFeed", "Lkotlin/Function0;", "(Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps$ReconnectingRPCConnection;Lnet/corda/core/messaging/DataFeed;Lkotlin/jvm/functions/Function0;)V", "backingSubscription", "subscriber", "Ljava/util/concurrent/atomic/AtomicReference;", "Lrx/Subscriber;", "unsubscribed", "", "call", "", "isUnsubscribed", "scheduleResubscribe", "error", "", "subscribeImmediately", "dataFeed", "unsubscribe", "rpc"})
    private static final class ReconnectingSubscriber<T>
    implements Observable.OnSubscribe<T>,
    Subscription {
        @NotNull
        private final ReconnectingCordaRPCOps.ReconnectingRPCConnection reconnectingRPCConnection;
        @NotNull
        private final DataFeed<?, T> initialDataFeed;
        @NotNull
        private final Function0<DataFeed<?, T>> createDataFeed;
        @NotNull
        private final AtomicReference<Subscriber<? super T>> subscriber;
        @Nullable
        private volatile Subscription backingSubscription;
        private volatile boolean unsubscribed;

        public ReconnectingSubscriber(@NotNull ReconnectingCordaRPCOps.ReconnectingRPCConnection reconnectingRPCConnection, @NotNull DataFeed<?, T> initialDataFeed, @NotNull Function0<? extends DataFeed<?, T>> createDataFeed) {
            Intrinsics.checkNotNullParameter((Object)reconnectingRPCConnection, (String)"reconnectingRPCConnection");
            Intrinsics.checkNotNullParameter(initialDataFeed, (String)"initialDataFeed");
            Intrinsics.checkNotNullParameter(createDataFeed, (String)"createDataFeed");
            this.reconnectingRPCConnection = reconnectingRPCConnection;
            this.initialDataFeed = initialDataFeed;
            this.createDataFeed = createDataFeed;
            this.subscriber = new AtomicReference();
        }

        public void unsubscribe() {
            Subscription subscription = this.backingSubscription;
            if (subscription != null) {
                subscription.unsubscribe();
            }
            this.unsubscribed = true;
        }

        public boolean isUnsubscribed() {
            return this.unsubscribed;
        }

        public void call(@NotNull Subscriber<? super T> subscriber) {
            Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
            if (this.subscriber.compareAndSet(null, subscriber)) {
                subscriber.add((Subscription)this);
                this.subscribeImmediately(this.initialDataFeed);
            } else {
                subscriber.onError((Throwable)new IllegalStateException("Only a single subscriber is allowed"));
            }
        }

        private final void subscribeImmediately(DataFeed<?, T> dataFeed) {
            if (this.unsubscribed) {
                return;
            }
            Subscriber<? super T> subscriber = this.subscriber.get();
            if (subscriber == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Subscriber<? super T> subscriber2 = subscriber;
            try {
                Subscription previousSubscription = this.backingSubscription;
                this.backingSubscription = dataFeed.getUpdates().subscribe(arg_0 -> ReconnectingSubscriber.subscribeImmediately$lambda$0((Function1)new Function1<T, Unit>(subscriber2){

                    public final void invoke(T p0) {
                        ((Subscriber)this.receiver).onNext(p0);
                    }
                }, arg_0), this::scheduleResubscribe, () -> subscriber2.onCompleted());
                Subscription subscription = previousSubscription;
                if (subscription != null) {
                    subscription.unsubscribe();
                }
            }
            catch (Exception e) {
                this.scheduleResubscribe(e);
            }
        }

        private final void scheduleResubscribe(Throwable error) {
            if (this.unsubscribed) {
                return;
            }
            if (error instanceof ConnectionFailureException) {
                this.reconnectingRPCConnection.getObserversPool().execute(() -> ReconnectingSubscriber.scheduleResubscribe$lambda$1(this, error));
            } else {
                Subscriber<? super T> subscriber = this.subscriber.get();
                if (subscriber == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                Subscriber<? super T> subscriber2 = subscriber;
                subscriber2.onError(error);
            }
        }

        private static final void subscribeImmediately$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void scheduleResubscribe$lambda$1(ReconnectingSubscriber this$0, Throwable $error) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
            if (this$0.unsubscribed || this$0.reconnectingRPCConnection.isClosed()) {
                return;
            }
            this$0.reconnectingRPCConnection.reconnectOnError($error);
            if (this$0.unsubscribed || this$0.reconnectingRPCConnection.isClosed()) {
                return;
            }
            DataFeed newDataFeed = (DataFeed)this$0.createDataFeed.invoke();
            this$0.subscribeImmediately(newDataFeed);
        }
    }
}

