/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.telemetry.SimpleLogTelemetryComponent;
import net.corda.core.internal.telemetry.TelemetryComponent;
import net.corda.core.internal.telemetry.TelemetryServiceImpl;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.telemetry.OpenTelemetryComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ!\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lnet/corda/client/rpc/internal/RPCClientTelemetry;", "", "serviceName", "", "openTelemetryEnabled", "", "simpleLogTelemetryEnabled", "spanStartEndEventsEnabled", "copyBaggageToTags", "(Ljava/lang/String;ZZZZ)V", "getCopyBaggageToTags", "()Z", "getOpenTelemetryEnabled", "getSimpleLogTelemetryEnabled", "getSpanStartEndEventsEnabled", "telemetryService", "Lnet/corda/core/internal/telemetry/TelemetryServiceImpl;", "getTelemetryService", "()Lnet/corda/core/internal/telemetry/TelemetryServiceImpl;", "getTelemetryHandle", "T", "telemetryClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "Companion", "rpc"})
public final class RPCClientTelemetry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean openTelemetryEnabled;
    private final boolean simpleLogTelemetryEnabled;
    private final boolean spanStartEndEventsEnabled;
    private final boolean copyBaggageToTags;
    @NotNull
    private final TelemetryServiceImpl telemetryService;
    @NotNull
    private static final Logger log = KotlinUtilsKt.contextLogger((Object)Companion);

    public RPCClientTelemetry(@NotNull String serviceName, boolean openTelemetryEnabled, boolean simpleLogTelemetryEnabled, boolean spanStartEndEventsEnabled, boolean copyBaggageToTags) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        this.openTelemetryEnabled = openTelemetryEnabled;
        this.simpleLogTelemetryEnabled = simpleLogTelemetryEnabled;
        this.spanStartEndEventsEnabled = spanStartEndEventsEnabled;
        this.copyBaggageToTags = copyBaggageToTags;
        this.telemetryService = new TelemetryServiceImpl();
        if (this.openTelemetryEnabled) {
            try {
                OpenTelemetryComponent openTelemetryComponent = new OpenTelemetryComponent(serviceName, this.spanStartEndEventsEnabled, this.copyBaggageToTags);
                if (openTelemetryComponent.isEnabled()) {
                    this.telemetryService.addTelemetryComponent((TelemetryComponent)openTelemetryComponent);
                    log.debug("OpenTelemetry enabled");
                }
            }
            catch (NoClassDefFoundError ex) {
                log.debug("OpenTelemetry not enabled, api or sdk not found on classpath");
            }
        }
        if (this.simpleLogTelemetryEnabled) {
            SimpleLogTelemetryComponent simpleLogTelemetryComponent = new SimpleLogTelemetryComponent();
            this.telemetryService.addTelemetryComponent((TelemetryComponent)simpleLogTelemetryComponent);
            log.debug("SimpleLogTelemetry enabled");
        }
    }

    public final boolean getOpenTelemetryEnabled() {
        return this.openTelemetryEnabled;
    }

    public final boolean getSimpleLogTelemetryEnabled() {
        return this.simpleLogTelemetryEnabled;
    }

    public final boolean getSpanStartEndEventsEnabled() {
        return this.spanStartEndEventsEnabled;
    }

    public final boolean getCopyBaggageToTags() {
        return this.copyBaggageToTags;
    }

    @NotNull
    public final TelemetryServiceImpl getTelemetryService() {
        return this.telemetryService;
    }

    @Nullable
    public final <T> T getTelemetryHandle(@NotNull Class<T> telemetryClass) {
        Intrinsics.checkNotNullParameter(telemetryClass, (String)"telemetryClass");
        return (T)this.telemetryService.getTelemetryHandle(telemetryClass);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/client/rpc/internal/RPCClientTelemetry$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "rpc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

