/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import net.corda.client.rpc.ConnectionFailureException;
import net.corda.client.rpc.CordaRPCClientConfiguration;
import net.corda.client.rpc.RPCException;
import net.corda.client.rpc.RPCSinceVersion;
import net.corda.client.rpc.internal.ClientCacheFactory;
import net.corda.client.rpc.internal.DistributionMux;
import net.corda.client.rpc.internal.RPCClientProxyHandler;
import net.corda.client.rpc.internal.RPCClientTelemetry;
import net.corda.client.rpc.internal.RPCUtils;
import net.corda.core.context.Actor;
import net.corda.core.context.Trace;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.LazyStickyPool;
import net.corda.core.internal.LifeCycle;
import net.corda.core.internal.NamedCacheFactory;
import net.corda.core.internal.ThreadBox;
import net.corda.core.internal.telemetry.TelemetryId;
import net.corda.core.internal.telemetry.TelemetryServiceImpl;
import net.corda.core.internal.telemetry.TelemetryStatusCode;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.messaging.RPCOps;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.core.utilities.Try;
import net.corda.nodeapi.RPCApi;
import net.corda.nodeapi.internal.DeduplicationChecker;
import net.corda.nodeapi.internal.rpc.client.CallSite;
import net.corda.nodeapi.internal.rpc.client.ObservableContext;
import net.corda.nodeapi.internal.rpc.client.RpcClientObservableDeSerializer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import rx.Notification;
import rx.exceptions.OnErrorNotImplementedException;
import rx.subjects.UnicastSubject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bf\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n*\u00016\b\u0000\u0018\u0000 {2\u00020\u0001:\u0003{|}B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0002J\b\u0010W\u001a\u00020TH\u0002J\u0010\u0010X\u001a\u00020T2\u0006\u0010Y\u001a\u00020ZH\u0002J\b\u0010[\u001a\u00020TH\u0002J\u0012\u0010\\\u001a\u00020T2\b\b\u0002\u0010]\u001a\u00020^H\u0002J\"\u0010_\u001a\u001c\u0012\u0004\u0012\u00020\u001f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0a0`j\u0002`cH\u0002J\u0013\u0010d\u001a\u00020^2\b\u0010e\u001a\u0004\u0018\u00010HH\u0096\u0002J\u0006\u0010f\u001a\u00020TJ\b\u0010g\u001a\u00020OH\u0016J\b\u0010h\u001a\u00020TH\u0002J4\u0010i\u001a\u0004\u0018\u00010H2\u0006\u0010j\u001a\u00020H2\u0006\u0010k\u001a\u00020Z2\u0012\u0010l\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010H\u0018\u00010mH\u0096\u0002\u00a2\u0006\u0002\u0010nJ\u0006\u0010o\u001a\u00020TJ\u0010\u0010p\u001a\u00020\u00052\u0006\u0010k\u001a\u00020ZH\u0002J\u0012\u0010q\u001a\u00020T2\b\b\u0002\u0010]\u001a\u00020^H\u0002J\b\u0010r\u001a\u00020TH\u0002J\u0010\u0010s\u001a\u00020T2\u0006\u0010U\u001a\u00020tH\u0002J\u0015\u0010u\u001a\u00020T2\u0006\u0010v\u001a\u00020OH\u0000\u00a2\u0006\u0002\bwJ\u0006\u0010x\u001a\u00020TJ\b\u0010y\u001a\u00020TH\u0002J\b\u0010z\u001a\u00020\u0005H\u0016R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001ej\u0004\u0018\u0001`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020605X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\u0010\u0012\f\u0012\n :*\u0004\u0018\u0001090908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\n :*\u0004\u0018\u00010<0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u0004\u0018\u00010EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010F\u001a\u001a\u0012\u0004\u0012\u00020\u001f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010H0G0\u001ej\u0002`IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010N\u001a\u0004\u0018\u00010OX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010PR\u0010\u0010Q\u001a\u0004\u0018\u00010RX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler;", "Ljava/lang/reflect/InvocationHandler;", "rpcConfiguration", "Lnet/corda/client/rpc/CordaRPCClientConfiguration;", "rpcUsername", "", "rpcPassword", "serverLocator", "Lorg/apache/activemq/artemis/api/core/client/ServerLocator;", "rpcOpsClass", "Ljava/lang/Class;", "Lnet/corda/core/messaging/RPCOps;", "serializationContext", "Lnet/corda/core/serialization/SerializationContext;", "sessionId", "Lnet/corda/core/context/Trace$SessionId;", "externalTrace", "Lnet/corda/core/context/Trace;", "impersonatedActor", "Lnet/corda/core/context/Actor;", "targetLegalIdentity", "Lnet/corda/core/identity/CordaX500Name;", "notificationDistributionMux", "Lnet/corda/client/rpc/internal/DistributionMux;", "rpcClientTelemetry", "Lnet/corda/client/rpc/internal/RPCClientTelemetry;", "cacheFactory", "Lnet/corda/core/internal/NamedCacheFactory;", "(Lnet/corda/client/rpc/CordaRPCClientConfiguration;Ljava/lang/String;Ljava/lang/String;Lorg/apache/activemq/artemis/api/core/client/ServerLocator;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;Lnet/corda/core/context/Trace$SessionId;Lnet/corda/core/context/Trace;Lnet/corda/core/context/Actor;Lnet/corda/core/identity/CordaX500Name;Lnet/corda/client/rpc/internal/DistributionMux;Lnet/corda/client/rpc/internal/RPCClientTelemetry;Lnet/corda/core/internal/NamedCacheFactory;)V", "callSiteMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/corda/core/context/Trace$InvocationId;", "Lnet/corda/nodeapi/internal/rpc/client/CallSite;", "Lnet/corda/nodeapi/internal/rpc/client/CallSiteMap;", "clientAddress", "Lorg/apache/activemq/artemis/api/core/SimpleString;", "consumerSession", "Lorg/apache/activemq/artemis/api/core/client/ClientSession;", "deduplicationChecker", "Lnet/corda/nodeapi/internal/DeduplicationChecker;", "deduplicationSequenceNumber", "Ljava/util/concurrent/atomic/AtomicLong;", "defaultFailoverHandler", "Lnet/corda/client/rpc/internal/RPCClientProxyHandler$FailoverHandler;", "haFailoverHandler", "haFailoverThread", "Ljava/lang/Thread;", "lifeCycle", "Lnet/corda/core/internal/LifeCycle;", "Lnet/corda/client/rpc/internal/RPCClientProxyHandler$State;", "observableContext", "Lnet/corda/nodeapi/internal/rpc/client/ObservableContext;", "observablesToReap", "Lnet/corda/core/internal/ThreadBox;", "net/corda/client/rpc/internal/RPCClientProxyHandler$observablesToReap$1", "observationExecutorPool", "Lnet/corda/core/internal/LazyStickyPool;", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "observationExecutorThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "producerSession", "reaperExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "reaperScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "rpcConsumer", "Lorg/apache/activemq/artemis/api/core/client/ClientConsumer;", "rpcProducer", "Lorg/apache/activemq/artemis/api/core/client/ClientProducer;", "rpcReplyMap", "Lcom/google/common/util/concurrent/SettableFuture;", "", "Lnet/corda/client/rpc/internal/RpcReplyMap;", "sendExecutor", "sendingEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serializationContextWithObservableContext", "serverProtocolVersion", "", "Ljava/lang/Integer;", "sessionFactory", "Lorg/apache/activemq/artemis/api/core/client/ClientSessionFactory;", "artemisMessageHandler", "", "message", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "attemptReconnect", "checkProtocolVersion", "calledMethod", "Ljava/lang/reflect/Method;", "cleanUpOnConnectionLoss", "close", "notify", "", "createRpcObservableMap", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lrx/subjects/UnicastSubject;", "Lrx/Notification;", "Lnet/corda/nodeapi/internal/rpc/client/RpcObservableMap;", "equals", "other", "forceClose", "hashCode", "initSessions", "invoke", "proxy", "method", "arguments", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "notifyServerAndClose", "produceMethodFullyQualifiedName", "reapObservables", "reapObservablesAndNotify", "sendMessage", "Lnet/corda/nodeapi/RPCApi$ClientToServer;", "setServerProtocolVersion", "version", "setServerProtocolVersion$rpc", "start", "startSessions", "toString", "Companion", "FailoverHandler", "State", "rpc"})
@SourceDebugExtension(value={"SMAP\nRPCClientProxyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCClientProxyHandler.kt\nnet/corda/client/rpc/internal/RPCClientProxyHandler\n+ 2 KotlinUtils.kt\nnet/corda/core/utilities/KotlinUtilsKt\n+ 3 LazyStickyPool.kt\nnet/corda/core/internal/LazyStickyPool\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ThreadBox.kt\nnet/corda/core/internal/ThreadBox\n*L\n1#1,722:1\n50#2,2:723\n50#2,2:725\n50#2,2:753\n50#2,2:755\n50#2,2:757\n50#2,2:759\n50#2,2:761\n50#2,2:763\n50#2,2:778\n50#2,2:780\n50#2,2:784\n61#3,9:727\n61#3,7:737\n69#3:745\n61#3,9:766\n215#4:736\n216#4:746\n215#4,2:747\n215#4,2:776\n1#5:744\n1#5:752\n1#5:783\n1855#6,2:749\n1855#6:765\n1856#6:775\n25#7:751\n25#7:782\n*S KotlinDebug\n*F\n+ 1 RPCClientProxyHandler.kt\nnet/corda/client/rpc/internal/RPCClientProxyHandler\n*L\n431#1:723,2\n450#1:725,2\n590#1:753,2\n602#1:755,2\n613#1:757,2\n619#1:759,2\n632#1:761,2\n656#1:763,2\n688#1:778,2\n690#1:780,2\n396#1:784,2\n457#1:727,9\n523#1:737,7\n523#1:745\n674#1:766,9\n522#1:736\n522#1:746\n528#1:747,2\n684#1:776,2\n580#1:752\n218#1:783\n541#1:749,2\n673#1:765\n673#1:775\n580#1:751\n218#1:782\n*E\n"})
public final class RPCClientProxyHandler
implements InvocationHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CordaRPCClientConfiguration rpcConfiguration;
    @NotNull
    private final String rpcUsername;
    @NotNull
    private final String rpcPassword;
    @NotNull
    private final ServerLocator serverLocator;
    @NotNull
    private final Class<? extends RPCOps> rpcOpsClass;
    @NotNull
    private final Trace.SessionId sessionId;
    @Nullable
    private final Trace externalTrace;
    @Nullable
    private final Actor impersonatedActor;
    @Nullable
    private final CordaX500Name targetLegalIdentity;
    @NotNull
    private final DistributionMux<? extends RPCOps> notificationDistributionMux;
    @NotNull
    private final RPCClientTelemetry rpcClientTelemetry;
    @NotNull
    private final NamedCacheFactory cacheFactory;
    @NotNull
    private final LifeCycle<State> lifeCycle;
    @Nullable
    private ScheduledExecutorService reaperExecutor;
    @Nullable
    private ExecutorService sendExecutor;
    private final ThreadFactory observationExecutorThreadFactory;
    @NotNull
    private final LazyStickyPool<ExecutorService> observationExecutorPool;
    @NotNull
    private final ConcurrentHashMap<Trace.InvocationId, SettableFuture<Object>> rpcReplyMap;
    @Nullable
    private final ConcurrentHashMap<Trace.InvocationId, CallSite> callSiteMap;
    @NotNull
    private final ObservableContext observableContext;
    @Nullable
    private ScheduledFuture<?> reaperScheduledFuture;
    @Nullable
    private Integer serverProtocolVersion;
    @NotNull
    private final ThreadBox<observablesToReap.1> observablesToReap;
    @NotNull
    private final SerializationContext serializationContextWithObservableContext;
    @Nullable
    private SimpleString clientAddress;
    @Nullable
    private ClientSessionFactory sessionFactory;
    @Nullable
    private ClientSession producerSession;
    @Nullable
    private ClientSession consumerSession;
    @Nullable
    private ClientProducer rpcProducer;
    @Nullable
    private ClientConsumer rpcConsumer;
    @NotNull
    private final DeduplicationChecker deduplicationChecker;
    @NotNull
    private final AtomicLong deduplicationSequenceNumber;
    @NotNull
    private final AtomicBoolean sendingEnabled;
    @Nullable
    private Thread haFailoverThread;
    @NotNull
    private final FailoverHandler haFailoverHandler;
    @NotNull
    private final FailoverHandler defaultFailoverHandler;
    @NotNull
    private static final Logger log = KotlinUtilsKt.contextLogger((Object)Companion);
    @NotNull
    private static final Method toStringMethod;
    @NotNull
    private static final Method equalsMethod;
    @NotNull
    private static final Method hashCodeMethod;
    private static boolean terminating;

    public RPCClientProxyHandler(@NotNull CordaRPCClientConfiguration rpcConfiguration, @NotNull String rpcUsername, @NotNull String rpcPassword, @NotNull ServerLocator serverLocator, @NotNull Class<? extends RPCOps> rpcOpsClass, @NotNull SerializationContext serializationContext, @NotNull Trace.SessionId sessionId, @Nullable Trace externalTrace, @Nullable Actor impersonatedActor, @Nullable CordaX500Name targetLegalIdentity, @NotNull DistributionMux<? extends RPCOps> notificationDistributionMux, @NotNull RPCClientTelemetry rpcClientTelemetry, @NotNull NamedCacheFactory cacheFactory) {
        Intrinsics.checkNotNullParameter((Object)rpcConfiguration, (String)"rpcConfiguration");
        Intrinsics.checkNotNullParameter((Object)rpcUsername, (String)"rpcUsername");
        Intrinsics.checkNotNullParameter((Object)rpcPassword, (String)"rpcPassword");
        Intrinsics.checkNotNullParameter((Object)serverLocator, (String)"serverLocator");
        Intrinsics.checkNotNullParameter(rpcOpsClass, (String)"rpcOpsClass");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter(notificationDistributionMux, (String)"notificationDistributionMux");
        Intrinsics.checkNotNullParameter((Object)rpcClientTelemetry, (String)"rpcClientTelemetry");
        Intrinsics.checkNotNullParameter((Object)cacheFactory, (String)"cacheFactory");
        this.rpcConfiguration = rpcConfiguration;
        this.rpcUsername = rpcUsername;
        this.rpcPassword = rpcPassword;
        this.serverLocator = serverLocator;
        this.rpcOpsClass = rpcOpsClass;
        this.sessionId = sessionId;
        this.externalTrace = externalTrace;
        this.impersonatedActor = impersonatedActor;
        this.targetLegalIdentity = targetLegalIdentity;
        this.notificationDistributionMux = notificationDistributionMux;
        this.rpcClientTelemetry = rpcClientTelemetry;
        this.cacheFactory = cacheFactory;
        this.lifeCycle = new LifeCycle((Enum)State.UNSTARTED);
        this.observationExecutorThreadFactory = new ThreadFactoryBuilder().setNameFormat("rpc-client-observation-pool-%d").setDaemon(true).build();
        this.observationExecutorPool = new LazyStickyPool(this.rpcConfiguration.getObservationExecutorPoolSize(), (Function0)new Function0<ExecutorService>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ExecutorService invoke() {
                return Executors.newFixedThreadPool(1, RPCClientProxyHandler.access$getObservationExecutorThreadFactory$p(this.this$0));
            }
        });
        this.rpcReplyMap = new ConcurrentHashMap();
        this.callSiteMap = this.rpcConfiguration.getTrackRpcCallSites() ? new ConcurrentHashMap() : null;
        Cache<Trace.InvocationId, UnicastSubject<Notification<?>>> cache = this.createRpcObservableMap();
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.observableContext = new ObservableContext(this.callSiteMap, cache, set);
        this.observablesToReap = new ThreadBox(new Object(){
            @NotNull
            private ArrayList<Trace.InvocationId> observables;
            {
                this.observables = new ArrayList<E>();
            }

            @NotNull
            public final ArrayList<Trace.InvocationId> getObservables() {
                return this.observables;
            }

            public final void setObservables(@NotNull ArrayList<Trace.InvocationId> arrayList) {
                Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
                this.observables = arrayList;
            }
        }, null, 2, null);
        this.serializationContextWithObservableContext = RpcClientObservableDeSerializer.INSTANCE.createContext(serializationContext, this.observableContext);
        this.deduplicationChecker = new DeduplicationChecker(this.rpcConfiguration.getDeduplicationCacheExpiry(), null, this.cacheFactory, 2, null);
        this.deduplicationSequenceNumber = new AtomicLong(0L);
        this.sendingEnabled = new AtomicBoolean(true);
        this.haFailoverHandler = new FailoverHandler((Function0)new Function0<Unit>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RPCClientProxyHandler.access$getLog$cp().warn("Connection failure. Attempting to reconnect using back-up addresses.");
                RPCClientProxyHandler.access$cleanUpOnConnectionLoss(this.this$0);
                ClientSessionFactory clientSessionFactory = RPCClientProxyHandler.access$getSessionFactory$p(this.this$0);
                if (clientSessionFactory != null) {
                    ClientSessionFactory clientSessionFactory2;
                    ClientSessionFactory $this$invoke_u24lambda_u240 = clientSessionFactory2 = clientSessionFactory;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.getConnection().destroy();
                    $this$invoke_u24lambda_u240.cleanup();
                    $this$invoke_u24lambda_u240.close();
                }
                RPCClientProxyHandler.access$setHaFailoverThread$p(this.this$0, Thread.currentThread());
                RPCClientProxyHandler.access$attemptReconnect(this.this$0);
            }
        }, null, null, 6, null);
        this.defaultFailoverHandler = new FailoverHandler((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RPCClientProxyHandler.access$cleanUpOnConnectionLoss(this.this$0);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RPCClientProxyHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RPCClientProxyHandler.access$getSendingEnabled$p(this.this$0).set(true);
                RPCClientProxyHandler.access$getLog$cp().info("RPC server available.");
            }
        }), (Function0<Unit>)((Function0)defaultFailoverHandler.3.INSTANCE));
    }

    public /* synthetic */ RPCClientProxyHandler(CordaRPCClientConfiguration cordaRPCClientConfiguration, String string, String string2, ServerLocator serverLocator, Class clazz, SerializationContext serializationContext, Trace.SessionId sessionId, Trace trace, Actor actor, CordaX500Name cordaX500Name, DistributionMux distributionMux, RPCClientTelemetry rPCClientTelemetry, NamedCacheFactory namedCacheFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x1000) != 0) {
            namedCacheFactory = new ClientCacheFactory();
        }
        this(cordaRPCClientConfiguration, string, string2, serverLocator, clazz, serializationContext, sessionId, trace, actor, cordaX500Name, distributionMux, rPCClientTelemetry, namedCacheFactory);
    }

    private final Cache<Trace.InvocationId, UnicastSubject<Notification<?>>> createRpcObservableMap() {
        RemovalListener onObservableRemove = (arg_0, arg_1, arg_2) -> RPCClientProxyHandler.createRpcObservableMap$lambda$1(this, arg_0, arg_1, arg_2);
        Caffeine caffeine = Caffeine.newBuilder().weakValues().removalListener(onObservableRemove).executor(MoreExecutors.directExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)caffeine, (String)"executor(...)");
        return this.cacheFactory.buildNamed(caffeine, "RpcClientProxyHandler_rpcObservable");
    }

    public final void start() {
        this.lifeCycle.requireState((Enum)State.UNSTARTED);
        this.reaperExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("rpc-client-reaper-%d").setDaemon(true).build());
        this.sendExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("rpc-client-sender-%d").setDaemon(true).build());
        ScheduledExecutorService scheduledExecutorService = this.reaperExecutor;
        Intrinsics.checkNotNull((Object)scheduledExecutorService);
        this.reaperScheduledFuture = scheduledExecutorService.scheduleAtFixedRate(this::reapObservablesAndNotify, this.rpcConfiguration.getReapInterval().toMillis(), this.rpcConfiguration.getReapInterval().toMillis(), TimeUnit.MILLISECONDS);
        try {
            this.sessionFactory = this.serverLocator.createSessionFactory();
        }
        catch (ActiveMQNotConnectedException e) {
            throw new RPCException("Cannot connect to server(s). Tried with all available servers.", e);
        }
        if (this.serverLocator.getStaticTransportConfigurations().length == 1) {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            Intrinsics.checkNotNull((Object)clientSessionFactory);
            clientSessionFactory.addFailoverListener((FailoverEventListener)this.defaultFailoverHandler);
        } else {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            Intrinsics.checkNotNull((Object)clientSessionFactory);
            clientSessionFactory.addFailoverListener((FailoverEventListener)this.haFailoverHandler);
        }
        this.initSessions();
        this.lifeCycle.transition((Enum)State.UNSTARTED, (Enum)State.SERVER_VERSION_NOT_SET);
        this.startSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] arguments) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        LifeCycle.requireState$default(this.lifeCycle, null, (Function1)invoke.1.INSTANCE, (int)1, null);
        this.checkProtocolVersion(method);
        if (Intrinsics.areEqual((Object)method, (Object)toStringMethod)) {
            return this.toString();
        }
        if (Intrinsics.areEqual((Object)method, (Object)equalsMethod)) {
            return this.equals(arguments != null ? ArraysKt.getOrNull((Object[])arguments, (int)0) : null);
        }
        if (Intrinsics.areEqual((Object)method, (Object)hashCodeMethod)) {
            return this.hashCode();
        }
        ClientSession clientSession = this.consumerSession;
        Intrinsics.checkNotNull((Object)clientSession);
        if (clientSession.isClosed()) {
            throw new RPCException("RPC Proxy is closed");
        }
        if (!this.sendingEnabled.get()) {
            throw new RPCException("RPC server is not available.");
        }
        Trace.InvocationId replyId = Trace.InvocationId.Companion.newInstance$default((Trace.InvocationId.Companion)Trace.InvocationId.Companion, null, null, (int)3, null);
        String methodFqn = this.produceMethodFullyQualifiedName(method);
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
        if (concurrentHashMap != null) {
            ((Map)concurrentHashMap).put(replyId, new CallSite(methodFqn));
        }
        TelemetryId telemetryId = TelemetryServiceImpl.startSpanForFlow$default((TelemetryServiceImpl)this.rpcClientTelemetry.getTelemetryService(), (String)("client-" + methodFqn), (Map)MapsKt.emptyMap(), null, null, (int)12, null);
        try {
            Object object = arguments;
            if (arguments == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
            SerializedBytes serialisedArguments = SerializationAPIKt.serialize$default((Object)object, null, (SerializationContext)this.serializationContextWithObservableContext, (int)1, null);
            SimpleString simpleString = this.clientAddress;
            Intrinsics.checkNotNull((Object)simpleString);
            RPCApi.ClientToServer.RpcRequest request = new RPCApi.ClientToServer.RpcRequest(simpleString, methodFqn, (OpaqueBytes)serialisedArguments, replyId, this.sessionId, this.externalTrace, this.impersonatedActor, this.rpcClientTelemetry.getTelemetryService().getCurrentTelemetryData());
            SettableFuture replyFuture = SettableFuture.create();
            if (!(this.rpcReplyMap.put(replyId, (SettableFuture<Object>)replyFuture) == null)) {
                boolean bl = false;
                String string = "Generated several RPC requests with same ID " + replyId;
                throw new IllegalArgumentException(string.toString());
            }
            if (RPCUtils.INSTANCE.isShutdownCmd(request)) {
                terminating = true;
            }
            this.sendMessage((RPCApi.ClientToServer)request);
            Intrinsics.checkNotNull((Object)replyFuture);
            Object object2 = KotlinUtilsKt.getOrThrow$default((Future)((Future)replyFuture), null, (int)1, null);
            return object2;
        }
        catch (RuntimeException e) {
            this.rpcClientTelemetry.getTelemetryService().recordException(telemetryId, (Throwable)e);
            TelemetryServiceImpl telemetryServiceImpl = this.rpcClientTelemetry.getTelemetryService();
            String string = e.getMessage();
            if (string == null) {
                string = "RuntimeException occurred";
            }
            telemetryServiceImpl.setStatus(telemetryId, TelemetryStatusCode.ERROR, string);
            throw e;
        }
        catch (Exception e) {
            this.rpcClientTelemetry.getTelemetryService().recordException(telemetryId, (Throwable)e);
            TelemetryServiceImpl telemetryServiceImpl = this.rpcClientTelemetry.getTelemetryService();
            String string = e.getMessage();
            if (string == null) {
                string = "Exception occurred";
            }
            telemetryServiceImpl.setStatus(telemetryId, TelemetryStatusCode.ERROR, string);
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            throw new RPCException(string2, e);
        }
        finally {
            ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap2 = this.callSiteMap;
            if (concurrentHashMap2 != null) {
                concurrentHashMap2.remove(replyId);
            }
            this.rpcClientTelemetry.getTelemetryService().endSpanForFlow(telemetryId);
        }
    }

    private final String produceMethodFullyQualifiedName(Method method) {
        Object object;
        if (Intrinsics.areEqual(CordaRPCOps.class, this.rpcOpsClass)) {
            String string = method.getName();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else {
            object = this.rpcOpsClass.getName() + "#" + method.getName();
        }
        return object;
    }

    private final void sendMessage(RPCApi.ClientToServer message) {
        ClientSession clientSession = this.producerSession;
        Intrinsics.checkNotNull((Object)clientSession);
        ClientMessage artemisMessage = clientSession.createMessage(false);
        Intrinsics.checkNotNull((Object)artemisMessage);
        message.writeToClientMessage(artemisMessage);
        CordaX500Name cordaX500Name = this.targetLegalIdentity;
        if (cordaX500Name != null) {
            CordaX500Name it = cordaX500Name;
            boolean bl = false;
            artemisMessage.putStringProperty("rpc-target-legal-identity", it.toString());
        }
        ExecutorService executorService = this.sendExecutor;
        Intrinsics.checkNotNull((Object)executorService);
        Future<?> future = executorService.submit(() -> RPCClientProxyHandler.sendMessage$lambda$6(artemisMessage, this, message));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        Future<?> future2 = future;
        KotlinUtilsKt.getOrThrow$default(future2, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void artemisMessageHandler(ClientMessage message) {
        block20: {
            try {
                void this_$iv;
                Logger logger;
                RPCApi.ServerToClient serverToClient;
                try {
                    serverToClient = RPCApi.ServerToClient.Companion.fromClientMessage(this.serializationContextWithObservableContext, message);
                }
                catch (RPCApi.ServerToClient.FailedToDeserializeReply e) {
                    log.error("Failed to deserialize RPC body", (Throwable)e);
                    RPCClientProxyHandler.artemisMessageHandler$completeExceptionally(this, e.getId(), e, this.rpcReplyMap.remove(e.getId()));
                    message.acknowledge();
                    return;
                }
                RPCApi.ServerToClient serverToClient2 = serverToClient;
                Long deduplicationSequenceNumber = message.getLongProperty("deduplication-sequence-number");
                String string = serverToClient2.getDeduplicationIdentity();
                Intrinsics.checkNotNull((Object)deduplicationSequenceNumber);
                if (this.deduplicationChecker.checkDuplicateMessageId((Object)string, deduplicationSequenceNumber.longValue())) {
                    log.info("Message duplication detected, discarding message");
                    return;
                }
                Logger $this$debug$iv = log;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    logger = $this$debug$iv;
                    boolean bl = false;
                    logger.debug("Got message from RPC server " + serverToClient2);
                }
                RPCApi.ServerToClient serverToClient3 = serverToClient2;
                if (serverToClient3 instanceof RPCApi.ServerToClient.RpcReply) {
                    SettableFuture<Object> replyFuture = this.rpcReplyMap.remove(((RPCApi.ServerToClient.RpcReply)serverToClient2).getId());
                    if (replyFuture == null) {
                        log.error("RPC reply arrived to unknown RPC ID " + ((RPCApi.ServerToClient.RpcReply)serverToClient2).getId() + ", this indicates an internal RPC error.");
                    } else {
                        Try result = ((RPCApi.ServerToClient.RpcReply)serverToClient2).getResult();
                        Try try_ = result;
                        if (try_ instanceof Try.Success) {
                            replyFuture.set(((Try.Success)result).getValue());
                        } else if (try_ instanceof Try.Failure) {
                            RPCClientProxyHandler.artemisMessageHandler$completeExceptionally(this, ((RPCApi.ServerToClient.RpcReply)serverToClient2).getId(), ((Try.Failure)result).getException(), replyFuture);
                        }
                    }
                    break block20;
                }
                if (!(serverToClient3 instanceof RPCApi.ServerToClient.Observation)) break block20;
                UnicastSubject observable2 = (UnicastSubject)this.observableContext.getObservableMap().getIfPresent((Object)((RPCApi.ServerToClient.Observation)serverToClient2).getId());
                if (observable2 == null) {
                    Logger $this$debug$iv2 = log;
                    boolean $i$f$debug2 = false;
                    if ($this$debug$iv2.isDebugEnabled()) {
                        logger = $this$debug$iv2;
                        boolean bl = false;
                        logger.debug("Observation " + ((RPCApi.ServerToClient.Observation)serverToClient2).getContent() + " arrived to unknown Observable with ID " + ((RPCApi.ServerToClient.Observation)serverToClient2).getId() + ". This may be due to an observation arriving before the server was notified of observable shutdown");
                    }
                    break block20;
                }
                LazyStickyPool<ExecutorService> $this$debug$iv2 = this.observationExecutorPool;
                Trace.InvocationId stickToOrNull$iv = ((RPCApi.ServerToClient.Observation)serverToClient2).getId();
                boolean $i$f$run = false;
                Pair pair = stickToOrNull$iv == null ? this_$iv.borrow() : new Pair((Object)stickToOrNull$iv, this_$iv.borrow((Object)stickToOrNull$iv));
                Object stickTo$iv = pair.component1();
                Object instance$iv = pair.component2();
                try {
                    ExecutorService executor = (ExecutorService)instance$iv;
                    boolean bl = false;
                    Future<?> future = executor.submit(() -> RPCClientProxyHandler.artemisMessageHandler$lambda$10$lambda$9(serverToClient2, this, observable2));
                }
                finally {
                    this_$iv.release(stickTo$iv, instance$iv);
                }
            }
            finally {
                message.acknowledge();
            }
        }
    }

    public final void forceClose() {
        this.close(false);
    }

    public final void notifyServerAndClose() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void close(boolean notify) {
        Iterable observationExecutors;
        Map.Entry entry;
        Iterator $this$close_u24lambda_u2411;
        Thread thread = this.haFailoverThread;
        if (thread != null) {
            Thread thread2 = thread;
            $this$close_u24lambda_u2411 = thread2;
            boolean bl = false;
            ((Thread)((Object)$this$close_u24lambda_u2411)).interrupt();
            ((Thread)((Object)$this$close_u24lambda_u2411)).join(1000L);
        }
        if (notify) {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            if (clientSessionFactory != null) {
                clientSessionFactory.close();
            }
        } else {
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            if (clientSessionFactory != null) {
                clientSessionFactory.cleanup();
            }
        }
        ScheduledFuture<?> scheduledFuture = this.reaperScheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        ConcurrentMap concurrentMap = this.observableContext.getObservableMap().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"asMap(...)");
        Map $this$forEach$iv = concurrentMap;
        boolean $i$f$forEach = false;
        $this$close_u24lambda_u2411 = $this$forEach$iv.entrySet().iterator();
        while ($this$close_u24lambda_u2411.hasNext()) {
            Map.Entry element$iv;
            entry = element$iv = (Map.Entry)$this$close_u24lambda_u2411.next();
            boolean bl = false;
            Trace.InvocationId key = (Trace.InvocationId)entry.getKey();
            UnicastSubject observable2 = (UnicastSubject)entry.getValue();
            LazyStickyPool<ExecutorService> this_$iv = this.observationExecutorPool;
            boolean $i$f$run = false;
            Pair pair = key == null ? this_$iv.borrow() : new Pair((Object)key, this_$iv.borrow((Object)key));
            Object stickTo$iv = pair.component1();
            Object instance$iv = pair.component2();
            try {
                ExecutorService it = (ExecutorService)instance$iv;
                boolean bl2 = false;
                UnicastSubject unicastSubject = observable2;
                if (unicastSubject != null) {
                    Intrinsics.checkNotNull((Object)unicastSubject);
                    UnicastSubject unicastSubject2 = observable2;
                    Companion companion = Companion;
                    UnicastSubject p0 = unicastSubject2;
                    boolean bl3 = false;
                    companion.closeObservable(p0);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.release(stickTo$iv, instance$iv);
            }
        }
        this.observableContext.getObservableMap().invalidateAll();
        $this$forEach$iv = this.rpcReplyMap;
        $i$f$forEach = false;
        $this$close_u24lambda_u2411 = $this$forEach$iv.entrySet().iterator();
        while ($this$close_u24lambda_u2411.hasNext()) {
            Map.Entry element$iv;
            entry = element$iv = $this$close_u24lambda_u2411.next();
            boolean bl = false;
            SettableFuture replyFuture = (SettableFuture)entry.getValue();
            replyFuture.setException((Throwable)((Object)new ConnectionFailureException(null, 1, null)));
        }
        this.rpcReplyMap.clear();
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
        if (concurrentHashMap != null) {
            concurrentHashMap.clear();
        }
        this.reapObservables(notify);
        ScheduledExecutorService scheduledExecutorService = this.reaperExecutor;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdownNow();
        }
        ExecutorService executorService = this.sendExecutor;
        if (executorService != null) {
            executorService.shutdownNow();
        }
        Iterable $this$forEach$iv2 = observationExecutors = this.observationExecutorPool.close();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ExecutorService it = (ExecutorService)element$iv;
            boolean bl = false;
            it.shutdownNow();
        }
        this.notificationDistributionMux.onDisconnect$rpc(null);
        this.lifeCycle.justTransition((Enum)State.FINISHED);
    }

    static /* synthetic */ void close$default(RPCClientProxyHandler rPCClientProxyHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        rPCClientProxyHandler.close(bl);
    }

    private final void checkProtocolVersion(Method calledMethod) {
        Integer serverProtocolVersion = this.serverProtocolVersion;
        if (serverProtocolVersion == null) {
            this.lifeCycle.requireState((Enum)State.SERVER_VERSION_NOT_SET);
        } else {
            int sinceVersion;
            this.lifeCycle.requireState((Enum)State.STARTED);
            RPCSinceVersion rPCSinceVersion = calledMethod.getAnnotation(RPCSinceVersion.class);
            int n = sinceVersion = rPCSinceVersion != null ? rPCSinceVersion.version() : 0;
            if (sinceVersion > serverProtocolVersion) {
                throw new UnsupportedOperationException("Method " + calledMethod + " was added in RPC protocol version " + sinceVersion + " but the server is running " + serverProtocolVersion);
            }
        }
    }

    public final void setServerProtocolVersion$rpc(int version) {
        if (this.serverProtocolVersion != null) {
            throw new IllegalStateException("setServerProtocolVersion called, but the protocol version was already set!");
        }
        this.serverProtocolVersion = version;
        this.lifeCycle.transition((Enum)State.SERVER_VERSION_NOT_SET, (Enum)State.STARTED);
    }

    private final void reapObservablesAndNotify() {
        RPCClientProxyHandler.reapObservables$default(this, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reapObservables(boolean notify) {
        ArrayList<Trace.InvocationId> arrayList;
        this.observableContext.getObservableMap().cleanUp();
        if (!notify) {
            return;
        }
        ThreadBox<observablesToReap.1> this_$iv = this.observablesToReap;
        boolean $i$f$locked = false;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            ArrayList<Trace.InvocationId> arrayList2;
            boolean bl = false;
            observablesToReap.1 $this$reapObservables_u24lambda_u2416 = this_$iv.getContent();
            boolean bl2 = false;
            if (!((Collection)$this$reapObservables_u24lambda_u2416.getObservables()).isEmpty()) {
                ArrayList<Trace.InvocationId> temporary = $this$reapObservables_u24lambda_u2416.getObservables();
                $this$reapObservables_u24lambda_u2416.setObservables(new ArrayList<Trace.InvocationId>());
                arrayList2 = temporary;
            } else {
                arrayList2 = null;
            }
            arrayList = arrayList2;
        }
        finally {
            lock.unlock();
        }
        ArrayList<Trace.InvocationId> observableIds = arrayList;
        if (observableIds != null) {
            Logger $this$debug$iv = log;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                logger.debug("Reaping " + observableIds.size() + " observables");
            }
            try {
                this.sendMessage((RPCApi.ClientToServer)new RPCApi.ClientToServer.ObservablesClosed((List)observableIds));
            }
            catch (Exception ex) {
                log.warn("Unable to close observables", (Throwable)ex);
            }
        }
    }

    static /* synthetic */ void reapObservables$default(RPCClientProxyHandler rPCClientProxyHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        rPCClientProxyHandler.reapObservables(bl);
    }

    private final void attemptReconnect() {
        boolean maxReconnectReached;
        Logger logger;
        int maxReconnectCount = this.rpcConfiguration.getMaxReconnectAttempts() * this.serverLocator.getStaticTransportConfigurations().length;
        Logger $this$debug$iv = log;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            logger.debug("maxReconnectCount = " + maxReconnectCount);
        }
        int reconnectAttempt = 0;
        reconnectAttempt = 1;
        Duration retryInterval = this.rpcConfiguration.getConnectionRetryInterval();
        Duration maxRetryInterval = this.rpcConfiguration.getConnectionMaxRetryInterval();
        while (RPCClientProxyHandler.attemptReconnect$shouldRetry(maxReconnectCount, reconnectAttempt)) {
            boolean $i$f$debug2;
            Logger $this$debug$iv2;
            TransportConfiguration transport;
            block10: {
                TransportConfiguration[] it = this.serverLocator.getStaticTransportConfigurations();
                boolean bl = false;
                transport = it[(reconnectAttempt - 1) % it.length];
                $this$debug$iv2 = log;
                $i$f$debug2 = false;
                if ($this$debug$iv2.isDebugEnabled()) {
                    logger = $this$debug$iv2;
                    boolean bl2 = false;
                    logger.debug("Trying to connect using " + transport.getParams());
                }
                try {
                    if (!this.serverLocator.isClosed()) {
                        this.sessionFactory = this.serverLocator.createSessionFactory(transport);
                        break block10;
                    }
                    log.warn("Stopping reconnect attempts.");
                    $this$debug$iv2 = log;
                    $i$f$debug2 = false;
                    if (!$this$debug$iv2.isDebugEnabled()) break;
                    logger = $this$debug$iv2;
                    boolean bl3 = false;
                    logger.debug("Server locator is closed or garbage collected. Proxy may have been closed during reconnect.");
                    break;
                }
                catch (ActiveMQException e) {
                    try {
                        Thread.sleep(retryInterval.toMillis());
                    }
                    catch (InterruptedException $i$f$debug3) {
                        // empty catch block
                    }
                    int $i$f$debug3 = reconnectAttempt;
                    reconnectAttempt = $i$f$debug3 + 1;
                    retryInterval = (Duration)ComparisonsKt.minOf((Comparable)maxRetryInterval, (Comparable)InternalUtils.times((Duration)retryInterval, (long)((long)this.rpcConfiguration.getConnectionRetryIntervalMultiplier())));
                    continue;
                }
            }
            $this$debug$iv2 = log;
            $i$f$debug2 = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                logger = $this$debug$iv2;
                boolean bl = false;
                logger.debug("Connected successfully after " + reconnectAttempt + " attempts using " + transport.getParams() + ".");
            }
            log.info("RPC server available.");
            ClientSessionFactory clientSessionFactory = this.sessionFactory;
            Intrinsics.checkNotNull((Object)clientSessionFactory);
            clientSessionFactory.addFailoverListener((FailoverEventListener)this.haFailoverHandler);
            this.initSessions();
            this.startSessions();
            this.sendingEnabled.set(true);
            this.notificationDistributionMux.onConnect$rpc();
            break;
        }
        boolean bl = maxReconnectReached = !RPCClientProxyHandler.attemptReconnect$shouldRetry(maxReconnectCount, reconnectAttempt);
        if (maxReconnectReached || this.sessionFactory == null) {
            String errMessage = "Could not reconnect to the RPC server after trying " + reconnectAttempt + " times." + (this.sessionFactory != null ? "" : " It was never possible to to establish connection with any of the endpoints.");
            log.error(errMessage);
            this.notificationDistributionMux.onPermanentFailure$rpc(new IllegalStateException(errMessage));
        }
    }

    private final void initSessions() {
        ClientSessionFactory clientSessionFactory = this.sessionFactory;
        Intrinsics.checkNotNull((Object)clientSessionFactory);
        ClientSession clientSession = this.producerSession = clientSessionFactory.createSession(this.rpcUsername, this.rpcPassword, false, true, true, false, 0x100000);
        Intrinsics.checkNotNull((Object)clientSession);
        this.rpcProducer = clientSession.createProducer("rpc.server");
        ClientSessionFactory clientSessionFactory2 = this.sessionFactory;
        Intrinsics.checkNotNull((Object)clientSessionFactory2);
        this.consumerSession = clientSessionFactory2.createSession(this.rpcUsername, this.rpcPassword, false, true, true, false, 16384);
        this.clientAddress = SimpleString.of((String)("rpc.client." + this.rpcUsername + "." + CryptoUtils.random63BitValue()));
        Logger $this$debug$iv = log;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            logger.debug("Client address: " + this.clientAddress);
        }
        ClientSession clientSession2 = this.consumerSession;
        Intrinsics.checkNotNull((Object)clientSession2);
        clientSession2.createQueue(QueueConfiguration.of((SimpleString)this.clientAddress).setAddress(this.clientAddress).setRoutingType(RoutingType.ANYCAST).setTemporary(Boolean.valueOf(true)).setDurable(Boolean.valueOf(false)));
        ClientSession clientSession3 = this.consumerSession;
        Intrinsics.checkNotNull((Object)clientSession3);
        ClientConsumer clientConsumer = this.rpcConsumer = clientSession3.createConsumer(this.clientAddress);
        Intrinsics.checkNotNull((Object)clientConsumer);
        clientConsumer.setMessageHandler(this::artemisMessageHandler);
    }

    private final void startSessions() {
        ClientSession clientSession = this.consumerSession;
        Intrinsics.checkNotNull((Object)clientSession);
        clientSession.start();
        ClientSession clientSession2 = this.producerSession;
        Intrinsics.checkNotNull((Object)clientSession2);
        clientSession2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUpOnConnectionLoss() {
        Logger logger;
        Object element$iv;
        this.sendingEnabled.set(false);
        log.warn("Terminating observables.");
        ConcurrentMap m = this.observableContext.getObservableMap().asMap();
        ConnectionFailureException connectionFailureException = new ConnectionFailureException(null, 1, null);
        Object $this$forEach$iv = m.keySet();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Trace.InvocationId k = (Trace.InvocationId)element$iv;
            boolean bl = false;
            LazyStickyPool<ExecutorService> this_$iv = this.observationExecutorPool;
            boolean $i$f$run = false;
            Pair pair = k == null ? this_$iv.borrow() : new Pair((Object)k, this_$iv.borrow((Object)k));
            Object stickTo$iv = pair.component1();
            Object instance$iv = pair.component2();
            try {
                ExecutorService it = (ExecutorService)instance$iv;
                boolean bl2 = false;
                try {
                    UnicastSubject unicastSubject = (UnicastSubject)m.get(k);
                    if (unicastSubject != null) {
                        unicastSubject.onError((Throwable)((Object)connectionFailureException));
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception when RPC connection failure handling", (Throwable)e);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.release(stickTo$iv, instance$iv);
            }
        }
        this.observableContext.getObservableMap().invalidateAll();
        $this$forEach$iv = this.rpcReplyMap;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            SettableFuture replyFuture = (SettableFuture)object.getValue();
            replyFuture.setException((Throwable)((Object)connectionFailureException));
        }
        Logger $this$debug$iv = log;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            logger.debug("rpcReplyMap size before clear: " + this.rpcReplyMap.size());
        }
        this.rpcReplyMap.clear();
        $this$debug$iv = log;
        $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
            logger.debug("callSiteMap size before clear: " + (concurrentHashMap != null ? Integer.valueOf(concurrentHashMap.size()) : null));
        }
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this.callSiteMap;
        if (concurrentHashMap != null) {
            concurrentHashMap.clear();
        }
        this.notificationDistributionMux.onDisconnect$rpc((Throwable)((Object)connectionFailureException));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.corda.client.rpc.internal.RPCClientProxyHandler");
        RPCClientProxyHandler cfr_ignored_0 = (RPCClientProxyHandler)other;
        if (!Intrinsics.areEqual((Object)this.rpcUsername, (Object)((RPCClientProxyHandler)other).rpcUsername)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sessionId, (Object)((RPCClientProxyHandler)other).sessionId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.targetLegalIdentity, (Object)((RPCClientProxyHandler)other).targetLegalIdentity);
    }

    public int hashCode() {
        int result = this.rpcUsername.hashCode();
        result = 31 * result + this.sessionId.hashCode();
        CordaX500Name cordaX500Name = this.targetLegalIdentity;
        result = 31 * result + (cordaX500Name != null ? cordaX500Name.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "{rpcUsername='" + this.rpcUsername + "', clientAddress=" + this.clientAddress + ", sessionId=" + this.sessionId + ", targetLegalIdentity=" + this.targetLegalIdentity + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createRpcObservableMap$lambda$1(RPCClientProxyHandler this$0, Trace.InvocationId key, UnicastSubject unicastSubject, RemovalCause cause) {
        CallSite rpcCallSite;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Trace.InvocationId invocationId = key;
        Intrinsics.checkNotNull((Object)invocationId);
        Trace.InvocationId observableId = invocationId;
        ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this$0.callSiteMap;
        CallSite callSite = rpcCallSite = concurrentHashMap != null ? concurrentHashMap.remove(observableId) : null;
        if (cause == RemovalCause.COLLECTED) {
            Object[] objectArray = new String[]{"A hot observable returned from an RPC was never subscribed to.", "This wastes server-side resources because it was queueing observations for retrieval.", "It is being closed now, but please adjust your code to call .notUsed() on the observable", "to close it explicitly. (Java users: subscribe to it then unsubscribe). If you aren't sure", "where the leak is coming from, set -Dnet.corda.client.rpc.trackRpcCallSites=true on the JVM", "command line and you will get a stack trace with this warning."};
            log.warn(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (Throwable)rpcCallSite);
            CallSite callSite2 = rpcCallSite;
            if (callSite2 != null) {
                callSite2.printStackTrace();
            }
        }
        ThreadBox<observablesToReap.1> this_$iv = this$0.observablesToReap;
        boolean $i$f$locked = false;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            boolean bl = false;
            observablesToReap.1 $this$createRpcObservableMap_u24lambda_u241_u24lambda_u240 = this_$iv.getContent();
            boolean bl2 = false;
            $this$createRpcObservableMap_u24lambda_u241_u24lambda_u240.getObservables().add(observableId);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private static final void sendMessage$lambda$6(ClientMessage $artemisMessage, RPCClientProxyHandler this$0, RPCApi.ClientToServer $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        $artemisMessage.putLongProperty("deduplication-sequence-number", this$0.deduplicationSequenceNumber.getAndIncrement());
        Logger $this$debug$iv = log;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            logger.debug("-> RPC -> " + $message);
        }
        ClientProducer clientProducer = this$0.rpcProducer;
        Intrinsics.checkNotNull((Object)clientProducer);
        ClientProducer it = clientProducer;
        boolean bl = false;
        if (!it.isClosed()) {
            it.send((Message)$artemisMessage);
        } else {
            log.info("Producer is already closed. Not sending: " + $message);
        }
    }

    private static final void artemisMessageHandler$completeExceptionally(RPCClientProxyHandler this$0, Trace.InvocationId id, Throwable e, SettableFuture<Object> future) {
        block2: {
            CallSite rpcCallSite;
            ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this$0.callSiteMap;
            CallSite callSite = rpcCallSite = concurrentHashMap != null ? concurrentHashMap.get(id) : null;
            if (rpcCallSite != null) {
                RPCClientProxyHandler.Companion.addRpcCallSiteToThrowable(e, rpcCallSite);
            }
            SettableFuture<Object> settableFuture = future;
            if (settableFuture == null) break block2;
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            settableFuture.setException(throwable);
        }
    }

    private static final void artemisMessageHandler$lambda$10$lambda$9(RPCApi.ServerToClient $serverToClient, RPCClientProxyHandler this$0, UnicastSubject $observable) {
        Intrinsics.checkNotNullParameter((Object)$serverToClient, (String)"$serverToClient");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Notification content = ((RPCApi.ServerToClient.Observation)$serverToClient).getContent();
        if (content.isOnCompleted() || content.isOnError()) {
            this$0.observableContext.getObservableMap().invalidate((Object)((RPCApi.ServerToClient.Observation)$serverToClient).getId());
        }
        if (content.isOnError()) {
            CallSite rpcCallSite;
            ConcurrentHashMap<Trace.InvocationId, CallSite> concurrentHashMap = this$0.callSiteMap;
            CallSite callSite = rpcCallSite = concurrentHashMap != null ? concurrentHashMap.get(((RPCApi.ServerToClient.Observation)$serverToClient).getId()) : null;
            if (rpcCallSite != null) {
                Throwable throwable = content.getThrowable();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getThrowable(...)");
                RPCClientProxyHandler.Companion.addRpcCallSiteToThrowable(throwable, rpcCallSite);
            }
        }
        $observable.onNext((Object)content);
    }

    private static final boolean attemptReconnect$shouldRetry(int maxReconnectCount, int reconnectAttempt) {
        return maxReconnectCount < 0 ? true : reconnectAttempt <= maxReconnectCount;
    }

    public static final /* synthetic */ ThreadFactory access$getObservationExecutorThreadFactory$p(RPCClientProxyHandler $this) {
        return $this.observationExecutorThreadFactory;
    }

    public static final /* synthetic */ void access$cleanUpOnConnectionLoss(RPCClientProxyHandler $this) {
        $this.cleanUpOnConnectionLoss();
    }

    public static final /* synthetic */ ClientSessionFactory access$getSessionFactory$p(RPCClientProxyHandler $this) {
        return $this.sessionFactory;
    }

    public static final /* synthetic */ void access$setHaFailoverThread$p(RPCClientProxyHandler $this, Thread thread) {
        $this.haFailoverThread = thread;
    }

    public static final /* synthetic */ void access$attemptReconnect(RPCClientProxyHandler $this) {
        $this.attemptReconnect();
    }

    public static final /* synthetic */ AtomicBoolean access$getSendingEnabled$p(RPCClientProxyHandler $this) {
        return $this.sendingEnabled;
    }

    static {
        Method method = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)Companion.toStringMethod.1.INSTANCE));
        Intrinsics.checkNotNull((Object)method);
        toStringMethod = method;
        Method method2 = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)Companion.equalsMethod.1.INSTANCE));
        Intrinsics.checkNotNull((Object)method2);
        equalsMethod = method2;
        Method method3 = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)Companion.hashCodeMethod.1.INSTANCE));
        Intrinsics.checkNotNull((Object)method3);
        hashCodeMethod = method3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u00142\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler$Companion;", "", "()V", "equalsMethod", "Ljava/lang/reflect/Method;", "getEqualsMethod", "()Ljava/lang/reflect/Method;", "hashCodeMethod", "getHashCodeMethod", "log", "Lorg/slf4j/Logger;", "terminating", "", "getTerminating", "()Z", "setTerminating", "(Z)V", "toStringMethod", "getToStringMethod", "addRpcCallSiteToThrowable", "", "throwable", "", "callSite", "Lnet/corda/nodeapi/internal/rpc/client/CallSite;", "closeObservable", "observable", "Lrx/subjects/UnicastSubject;", "Lrx/Notification;", "rpc"})
    @SourceDebugExtension(value={"SMAP\nRPCClientProxyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCClientProxyHandler.kt\nnet/corda/client/rpc/internal/RPCClientProxyHandler$Companion\n+ 2 KotlinUtils.kt\nnet/corda/core/utilities/KotlinUtilsKt\n*L\n1#1,722:1\n50#2,2:723\n*S KotlinDebug\n*F\n+ 1 RPCClientProxyHandler.kt\nnet/corda/client/rpc/internal/RPCClientProxyHandler$Companion\n*L\n159#1:723,2\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Method getToStringMethod() {
            return toStringMethod;
        }

        @NotNull
        public final Method getEqualsMethod() {
            return equalsMethod;
        }

        @NotNull
        public final Method getHashCodeMethod() {
            return hashCodeMethod;
        }

        public final boolean getTerminating() {
            return terminating;
        }

        public final void setTerminating(boolean bl) {
            terminating = bl;
        }

        private final void addRpcCallSiteToThrowable(Throwable throwable, CallSite callSite) {
            Throwable currentThrowable = throwable;
            while (true) {
                Throwable cause;
                if ((cause = currentThrowable.getCause()) == null) {
                    try {
                        currentThrowable.initCause((Throwable)callSite);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    break;
                }
                currentThrowable = cause;
            }
        }

        private final void closeObservable(UnicastSubject<Notification<?>> observable2) {
            try {
                observable2.onError((Throwable)((Object)new ConnectionFailureException(null, 1, null)));
            }
            catch (OnErrorNotImplementedException ex) {
                Logger $this$debug$iv = log;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl = false;
                    logger.debug("Closed connection on observable whose observers have no error handling.");
                }
            }
            catch (Exception ex) {
                log.error("Unexpected exception when RPC connection failure handling", (Throwable)ex);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler$FailoverHandler;", "Lorg/apache/activemq/artemis/api/core/client/FailoverEventListener;", "detected", "Lkotlin/Function0;", "", "completed", "failed", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "failoverEvent", "eventType", "Lorg/apache/activemq/artemis/api/core/client/FailoverEventType;", "rpc"})
    public static final class FailoverHandler
    implements FailoverEventListener {
        @NotNull
        private final Function0<Unit> detected;
        @NotNull
        private final Function0<Unit> completed;
        @NotNull
        private final Function0<Unit> failed;

        public FailoverHandler(@NotNull Function0<Unit> detected, @NotNull Function0<Unit> completed, @NotNull Function0<Unit> failed) {
            Intrinsics.checkNotNullParameter(detected, (String)"detected");
            Intrinsics.checkNotNullParameter(completed, (String)"completed");
            Intrinsics.checkNotNullParameter(failed, (String)"failed");
            this.detected = detected;
            this.completed = completed;
            this.failed = failed;
        }

        public /* synthetic */ FailoverHandler(Function0 function0, Function0 function02, Function0 function03, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = 1.INSTANCE;
            }
            if ((n & 2) != 0) {
                function02 = 2.INSTANCE;
            }
            if ((n & 4) != 0) {
                function03 = 3.INSTANCE;
            }
            this((Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
        }

        public void failoverEvent(@NotNull FailoverEventType eventType) {
            Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
            switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                case 1: {
                    this.detected.invoke();
                    break;
                }
                case 2: {
                    this.completed.invoke();
                    break;
                }
                case 3: {
                    if (Companion.getTerminating()) break;
                    this.failed.invoke();
                }
            }
        }

        public FailoverHandler() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FailoverEventType.values().length];
                try {
                    nArray[FailoverEventType.FAILURE_DETECTED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FailoverEventType.FAILOVER_COMPLETED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FailoverEventType.FAILOVER_FAILED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/client/rpc/internal/RPCClientProxyHandler$State;", "", "(Ljava/lang/String;I)V", "UNSTARTED", "SERVER_VERSION_NOT_SET", "STARTED", "FINISHED", "rpc"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State UNSTARTED = new State();
        public static final /* enum */ State SERVER_VERSION_NOT_SET = new State();
        public static final /* enum */ State STARTED = new State();
        public static final /* enum */ State FINISHED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.UNSTARTED, State.SERVER_VERSION_NOT_SET, State.STARTED, State.FINISHED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

