/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.client.rpc.CordaRPCClientConfiguration;
import net.corda.client.rpc.RPCConnection;
import net.corda.client.rpc.UnrecoverableRPCException;
import net.corda.client.rpc.ext.RPCConnectionListener;
import net.corda.client.rpc.internal.DistributionMux;
import net.corda.client.rpc.internal.RPCClient;
import net.corda.client.rpc.internal.RPCClientProxyHandler;
import net.corda.client.rpc.internal.RPCClientTelemetry;
import net.corda.core.context.Actor;
import net.corda.core.context.Trace;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.internal.InternalUtils;
import net.corda.core.messaging.ClientRpcSslOptions;
import net.corda.core.messaging.RPCOps;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationDefaults;
import net.corda.core.serialization.internal.SerializationEnvironmentKt;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.ArtemisTcpTransport;
import net.corda.nodeapi.internal.RoundRobinConnectionPolicy;
import net.corda.nodeapi.internal.config.SslConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001+B/\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\r\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eB5\b\u0016\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011B1\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019JN\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/corda/client/rpc/internal/RPCClient;", "I", "Lnet/corda/core/messaging/RPCOps;", "", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "sslConfiguration", "Lnet/corda/core/messaging/ClientRpcSslOptions;", "configuration", "Lnet/corda/client/rpc/CordaRPCClientConfiguration;", "serializationContext", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/utilities/NetworkHostAndPort;Lnet/corda/core/messaging/ClientRpcSslOptions;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;)V", "Lnet/corda/nodeapi/internal/config/SslConfiguration;", "(Lnet/corda/core/utilities/NetworkHostAndPort;Lnet/corda/nodeapi/internal/config/SslConfiguration;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;)V", "haAddressPool", "", "(Ljava/util/List;Lnet/corda/core/messaging/ClientRpcSslOptions;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;)V", "transport", "Lorg/apache/activemq/artemis/api/core/TransportConfiguration;", "rpcConfiguration", "haPoolTransportConfigurations", "(Lorg/apache/activemq/artemis/api/core/TransportConfiguration;Lnet/corda/client/rpc/CordaRPCClientConfiguration;Lnet/corda/core/serialization/SerializationContext;Ljava/util/List;)V", "listeners", "", "Lnet/corda/client/rpc/ext/RPCConnectionListener;", "addConnectionListener", "", "listener", "removeConnectionListener", "start", "Lnet/corda/client/rpc/RPCConnection;", "rpcOpsClass", "Ljava/lang/Class;", "username", "", "password", "externalTrace", "Lnet/corda/core/context/Trace;", "impersonatedActor", "Lnet/corda/core/context/Actor;", "targetLegalIdentity", "Lnet/corda/core/identity/CordaX500Name;", "Companion", "rpc"})
@SourceDebugExtension(value={"SMAP\nRPCClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCClient.kt\nnet/corda/client/rpc/internal/RPCClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1549#2:181\n1620#2,3:182\n*S KotlinDebug\n*F\n+ 1 RPCClient.kt\nnet/corda/client/rpc/internal/RPCClient\n*L\n68#1:181\n68#1:182,3\n*E\n"})
public final class RPCClient<I extends RPCOps> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransportConfiguration transport;
    @NotNull
    private final CordaRPCClientConfiguration rpcConfiguration;
    @NotNull
    private final SerializationContext serializationContext;
    @NotNull
    private final List<TransportConfiguration> haPoolTransportConfigurations;
    @NotNull
    private final Set<RPCConnectionListener<I>> listeners;
    @NotNull
    private static final Logger log = KotlinUtilsKt.contextLogger((Object)Companion);

    public RPCClient(@NotNull TransportConfiguration transport, @NotNull CordaRPCClientConfiguration rpcConfiguration, @NotNull SerializationContext serializationContext, @NotNull List<? extends TransportConfiguration> haPoolTransportConfigurations) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)rpcConfiguration, (String)"rpcConfiguration");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkNotNullParameter(haPoolTransportConfigurations, (String)"haPoolTransportConfigurations");
        this.transport = transport;
        this.rpcConfiguration = rpcConfiguration;
        this.serializationContext = serializationContext;
        this.haPoolTransportConfigurations = haPoolTransportConfigurations;
        this.listeners = new CopyOnWriteArraySet();
    }

    public /* synthetic */ RPCClient(TransportConfiguration transportConfiguration, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 4) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(transportConfiguration, cordaRPCClientConfiguration, serializationContext, list);
    }

    public RPCClient(@NotNull NetworkHostAndPort hostAndPort, @Nullable ClientRpcSslOptions sslConfiguration, @NotNull CordaRPCClientConfiguration configuration, @NotNull SerializationContext serializationContext) {
        Intrinsics.checkNotNullParameter((Object)hostAndPort, (String)"hostAndPort");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        this(ArtemisTcpTransport.Companion.rpcConnectorTcpTransport$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, (NetworkHostAndPort)hostAndPort, (ClientRpcSslOptions)sslConfiguration, (boolean)false, (boolean)false, null, (int)28, null), configuration, serializationContext, null, 8, null);
    }

    public /* synthetic */ RPCClient(NetworkHostAndPort networkHostAndPort, ClientRpcSslOptions clientRpcSslOptions, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clientRpcSslOptions = null;
        }
        if ((n & 4) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 8) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        this(networkHostAndPort, clientRpcSslOptions, cordaRPCClientConfiguration, serializationContext);
    }

    public RPCClient(@NotNull NetworkHostAndPort hostAndPort, @NotNull SslConfiguration sslConfiguration, @NotNull CordaRPCClientConfiguration configuration, @NotNull SerializationContext serializationContext) {
        Intrinsics.checkNotNullParameter((Object)hostAndPort, (String)"hostAndPort");
        Intrinsics.checkNotNullParameter((Object)sslConfiguration, (String)"sslConfiguration");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        this(ArtemisTcpTransport.Companion.rpcInternalClientTcpTransport$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, (NetworkHostAndPort)hostAndPort, (SslConfiguration)sslConfiguration, null, (boolean)false, (int)12, null), configuration, serializationContext, null, 8, null);
    }

    public /* synthetic */ RPCClient(NetworkHostAndPort networkHostAndPort, SslConfiguration sslConfiguration, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 8) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        this(networkHostAndPort, sslConfiguration, cordaRPCClientConfiguration, serializationContext);
    }

    /*
     * WARNING - void declaration
     */
    public RPCClient(@NotNull List<NetworkHostAndPort> haAddressPool, @Nullable ClientRpcSslOptions sslConfiguration, @NotNull CordaRPCClientConfiguration configuration, @NotNull SerializationContext serializationContext) {
        Collection<TransportConfiguration> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(haAddressPool, (String)"haAddressPool");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Iterable iterable = haAddressPool;
        SerializationContext serializationContext2 = serializationContext;
        CordaRPCClientConfiguration cordaRPCClientConfiguration = configuration;
        TransportConfiguration transportConfiguration = ArtemisTcpTransport.Companion.rpcConnectorTcpTransport$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, (NetworkHostAndPort)((NetworkHostAndPort)CollectionsKt.first(haAddressPool)), (ClientRpcSslOptions)sslConfiguration, (boolean)false, (boolean)false, null, (int)28, null);
        RPCClient<I> rPCClient = this;
        boolean $i$f$map = false;
        void var7_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NetworkHostAndPort networkHostAndPort = (NetworkHostAndPort)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ArtemisTcpTransport.Companion.rpcConnectorTcpTransport$default((ArtemisTcpTransport.Companion)ArtemisTcpTransport.Companion, (NetworkHostAndPort)it, (ClientRpcSslOptions)sslConfiguration, (boolean)false, (boolean)false, null, (int)28, null));
        }
        collection = (List)destination$iv$iv;
        rPCClient(transportConfiguration, cordaRPCClientConfiguration, serializationContext2, (List<? extends TransportConfiguration>)collection);
    }

    public /* synthetic */ RPCClient(List list, ClientRpcSslOptions clientRpcSslOptions, CordaRPCClientConfiguration cordaRPCClientConfiguration, SerializationContext serializationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clientRpcSslOptions = null;
        }
        if ((n & 4) != 0) {
            cordaRPCClientConfiguration = CordaRPCClientConfiguration.DEFAULT;
        }
        if ((n & 8) != 0) {
            serializationContext = SerializationDefaults.INSTANCE.getRPC_CLIENT_CONTEXT();
        }
        this(list, clientRpcSslOptions, cordaRPCClientConfiguration, serializationContext);
    }

    @NotNull
    public final RPCConnection<I> start(@NotNull Class<I> rpcOpsClass, @NotNull String username, @NotNull String password, @Nullable Trace externalTrace, @Nullable Actor impersonatedActor, @Nullable CordaX500Name targetLegalIdentity) {
        Intrinsics.checkNotNullParameter(rpcOpsClass, (String)"rpcOpsClass");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return (RPCConnection)InternalUtils.logElapsedTime((Logger)log, (String)"Startup", (Function0)new Function0<start.connection.1<I>>(this, username, password, rpcOpsClass, externalTrace, impersonatedActor, targetLegalIdentity){
            final /* synthetic */ RPCClient<I> this$0;
            final /* synthetic */ String $username;
            final /* synthetic */ String $password;
            final /* synthetic */ Class<I> $rpcOpsClass;
            final /* synthetic */ Trace $externalTrace;
            final /* synthetic */ Actor $impersonatedActor;
            final /* synthetic */ CordaX500Name $targetLegalIdentity;
            {
                this.this$0 = $receiver;
                this.$username = $username;
                this.$password = $password;
                this.$rpcOpsClass = $rpcOpsClass;
                this.$externalTrace = $externalTrace;
                this.$impersonatedActor = $impersonatedActor;
                this.$targetLegalIdentity = $targetLegalIdentity;
                super(0);
            }

            @NotNull
            public final start.connection.1<I> invoke() {
                RPCConnection<I> rPCConnection;
                Object $this$toTypedArray$iv;
                ServerLocator serverLocator;
                ServerLocator serverLocator2;
                if (RPCClient.access$getHaPoolTransportConfigurations$p(this.this$0).isEmpty()) {
                    serverLocator2 = new ServerLocator[]{RPCClient.access$getTransport$p(this.this$0)};
                    serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])serverLocator2);
                } else {
                    $this$toTypedArray$iv = RPCClient.access$getHaPoolTransportConfigurations$p(this.this$0);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    serverLocator2 = thisCollection$iv.toArray(new TransportConfiguration[0]);
                    serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])Arrays.copyOf(serverLocator2, ((TransportConfiguration[])serverLocator2).length));
                }
                serverLocator2 = serverLocator;
                $this$toTypedArray$iv = this.this$0;
                ServerLocator $this$invoke_u24lambda_u240 = serverLocator2;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setConnectionTTL(60000L);
                $this$invoke_u24lambda_u240.setClientFailureCheckPeriod(30000L);
                $this$invoke_u24lambda_u240.setRetryInterval(RPCClient.access$getRpcConfiguration$p((RPCClient)$this$toTypedArray$iv).getConnectionRetryInterval().toMillis());
                $this$invoke_u24lambda_u240.setRetryIntervalMultiplier(RPCClient.access$getRpcConfiguration$p((RPCClient)$this$toTypedArray$iv).getConnectionRetryIntervalMultiplier());
                $this$invoke_u24lambda_u240.setMaxRetryInterval(RPCClient.access$getRpcConfiguration$p((RPCClient)$this$toTypedArray$iv).getConnectionMaxRetryInterval().toMillis());
                $this$invoke_u24lambda_u240.setReconnectAttempts(RPCClient.access$getHaPoolTransportConfigurations$p((RPCClient)$this$toTypedArray$iv).isEmpty() ? RPCClient.access$getRpcConfiguration$p((RPCClient)$this$toTypedArray$iv).getMaxReconnectAttempts() : 0);
                $this$invoke_u24lambda_u240.setMinLargeMessageSize(RPCClient.access$getRpcConfiguration$p((RPCClient)$this$toTypedArray$iv).getMaxFileSize());
                $this$invoke_u24lambda_u240.setUseGlobalPools(SerializationEnvironmentKt.getNodeSerializationEnv() != null);
                $this$invoke_u24lambda_u240.setConnectionLoadBalancingPolicyClassName(RoundRobinConnectionPolicy.class.getCanonicalName());
                $this$invoke_u24lambda_u240.setBlockOnNonDurableSend(true);
                ServerLocator serverLocator3 = serverLocator2;
                String targetString = RPCClient.access$getTransport$p(this.this$0).getParams().get("host") + ":" + RPCClient.access$getTransport$p(this.this$0).getParams().get("port");
                RPCClientTelemetry rpcClientTelemetry = new RPCClientTelemetry("rpcClient-" + targetString, RPCClient.access$getRpcConfiguration$p(this.this$0).getOpenTelemetryEnabled(), RPCClient.access$getRpcConfiguration$p(this.this$0).getSimpleLogTelemetryEnabled(), RPCClient.access$getRpcConfiguration$p(this.this$0).getSpanStartEndEventsEnabled(), RPCClient.access$getRpcConfiguration$p(this.this$0).getCopyBaggageToTags());
                Trace.SessionId sessionId = Trace.SessionId.Companion.newInstance$default((Trace.SessionId.Companion)Trace.SessionId.Companion, null, null, (int)3, null);
                DistributionMux<I> distributionMux = new DistributionMux<I>(RPCClient.access$getListeners$p(this.this$0), this.$username);
                CordaRPCClientConfiguration cordaRPCClientConfiguration = RPCClient.access$getRpcConfiguration$p(this.this$0);
                Intrinsics.checkNotNull((Object)serverLocator3);
                RPCClientProxyHandler proxyHandler = new RPCClientProxyHandler(cordaRPCClientConfiguration, this.$username, this.$password, serverLocator3, this.$rpcOpsClass, RPCClient.access$getSerializationContext$p(this.this$0), sessionId, this.$externalTrace, this.$impersonatedActor, this.$targetLegalIdentity, distributionMux, rpcClientTelemetry, null, 4096, null);
                try {
                    proxyHandler.start();
                    Class[] classArray = new Class[]{this.$rpcOpsClass};
                    RPCOps ops = (RPCOps)InternalUtils.uncheckedCast((Object)Proxy.newProxyInstance(this.$rpcOpsClass.getClassLoader(), classArray, (InvocationHandler)proxyHandler));
                    int serverProtocolVersion = ops.getProtocolVersion();
                    if (serverProtocolVersion < RPCClient.access$getRpcConfiguration$p(this.this$0).getMinimumServerProtocolVersion()) {
                        throw new UnrecoverableRPCException("Requested minimum protocol version (" + RPCClient.access$getRpcConfiguration$p(this.this$0).getMinimumServerProtocolVersion() + ") is higher than the server's supported protocol version (" + serverProtocolVersion + ")", null, 2, null);
                    }
                    proxyHandler.setServerProtocolVersion$rpc(serverProtocolVersion);
                    RPCClient.access$getLog$cp().debug("RPC connected, returning proxy");
                    RPCConnection<I> connection2 = new RPCConnection<I>(ops, serverProtocolVersion, rpcClientTelemetry, proxyHandler, serverLocator3){
                        @NotNull
                        private final I proxy;
                        private final int serverProtocolVersion;
                        final /* synthetic */ RPCClientTelemetry $rpcClientTelemetry;
                        final /* synthetic */ RPCClientProxyHandler $proxyHandler;
                        final /* synthetic */ ServerLocator $serverLocator;
                        {
                            this.$rpcClientTelemetry = $rpcClientTelemetry;
                            this.$proxyHandler = $proxyHandler;
                            this.$serverLocator = $serverLocator;
                            this.proxy = $ops;
                            this.serverProtocolVersion = $serverProtocolVersion;
                        }

                        @NotNull
                        public I getProxy() {
                            return this.proxy;
                        }

                        public int getServerProtocolVersion() {
                            return this.serverProtocolVersion;
                        }

                        @Nullable
                        public <T> T getTelemetryHandle(@NotNull Class<T> telemetryClass) {
                            Intrinsics.checkNotNullParameter(telemetryClass, (String)"telemetryClass");
                            return this.$rpcClientTelemetry.getTelemetryHandle(telemetryClass);
                        }

                        private final void close(boolean notify) {
                            if (notify) {
                                this.$proxyHandler.notifyServerAndClose();
                            } else {
                                this.$proxyHandler.forceClose();
                            }
                            this.$serverLocator.close();
                            this.$rpcClientTelemetry.getTelemetryService().shutdownTelemetry();
                        }

                        public void notifyServerAndClose() {
                            this.close(true);
                        }

                        public void forceClose() {
                            this.close(false);
                        }
                    };
                    distributionMux.setConnectionOpt$rpc(connection2);
                    distributionMux.onConnect$rpc();
                    rPCConnection = connection2;
                }
                catch (Throwable throwable) {
                    proxyHandler.notifyServerAndClose();
                    serverLocator3.close();
                    distributionMux.onPermanentFailure$rpc(throwable);
                    throw throwable;
                }
                return rPCConnection;
            }
        });
    }

    public static /* synthetic */ RPCConnection start$default(RPCClient rPCClient, Class clazz, String string, String string2, Trace trace, Actor actor, CordaX500Name cordaX500Name, int n, Object object) {
        if ((n & 8) != 0) {
            trace = null;
        }
        if ((n & 0x10) != 0) {
            actor = null;
        }
        if ((n & 0x20) != 0) {
            cordaX500Name = null;
        }
        return rPCClient.start(clazz, string, string2, trace, actor, cordaX500Name);
    }

    public final boolean addConnectionListener(@NotNull RPCConnectionListener<I> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.listeners.add(listener);
    }

    public final boolean removeConnectionListener(@NotNull RPCConnectionListener<I> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.listeners.remove(listener);
    }

    public static final /* synthetic */ List access$getHaPoolTransportConfigurations$p(RPCClient $this) {
        return $this.haPoolTransportConfigurations;
    }

    public static final /* synthetic */ TransportConfiguration access$getTransport$p(RPCClient $this) {
        return $this.transport;
    }

    public static final /* synthetic */ CordaRPCClientConfiguration access$getRpcConfiguration$p(RPCClient $this) {
        return $this.rpcConfiguration;
    }

    public static final /* synthetic */ Set access$getListeners$p(RPCClient $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ SerializationContext access$getSerializationContext$p(RPCClient $this) {
        return $this.serializationContext;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/client/rpc/internal/RPCClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "rpc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

