/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.corda.client.rpc.CordaRPCClientConfiguration;
import net.corda.client.rpc.GracefulReconnect;
import net.corda.client.rpc.RPCConnection;
import net.corda.client.rpc.internal.ReconnectingCordaRPCOps;
import net.corda.core.CordaInternal;
import net.corda.core.messaging.ClientRpcSslOptions;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.utilities.NetworkHostAndPort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0017\b\u0010\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0004B+\b\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0082\bJ\b\u0010\u0019\u001a\u00020\u0016H\u0016J#\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0016H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lnet/corda/client/rpc/CordaRPCConnection;", "Lnet/corda/client/rpc/RPCConnection;", "Lnet/corda/core/messaging/CordaRPCOps;", "connection", "(Lnet/corda/client/rpc/RPCConnection;)V", "oneTimeConnection", "observersPool", "Ljava/util/concurrent/ExecutorService;", "reconnectingCordaRPCOps", "Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps;", "(Lnet/corda/client/rpc/RPCConnection;Ljava/util/concurrent/ExecutorService;Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps;)V", "actualConnection", "getActualConnection", "()Lnet/corda/client/rpc/RPCConnection;", "proxy", "getProxy", "()Lnet/corda/core/messaging/CordaRPCOps;", "serverProtocolVersion", "", "getServerProtocolVersion", "()I", "doCloseLogic", "", "close", "Lkotlin/Function0;", "forceClose", "getTelemetryHandle", "T", "telemetryClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "notifyServerAndClose", "Companion", "rpc"})
@SourceDebugExtension(value={"SMAP\nCordaRPCClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CordaRPCClient.kt\nnet/corda/client/rpc/CordaRPCConnection\n*L\n1#1,671:1\n86#1,11:672\n86#1,11:683\n*S KotlinDebug\n*F\n+ 1 CordaRPCClient.kt\nnet/corda/client/rpc/CordaRPCConnection\n*L\n77#1:672,11\n79#1:683,11\n*E\n"})
public final class CordaRPCConnection
implements RPCConnection<CordaRPCOps> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final RPCConnection<CordaRPCOps> oneTimeConnection;
    @Nullable
    private final ExecutorService observersPool;
    @Nullable
    private final ReconnectingCordaRPCOps reconnectingCordaRPCOps;

    private CordaRPCConnection(RPCConnection<? extends CordaRPCOps> oneTimeConnection, ExecutorService observersPool, ReconnectingCordaRPCOps reconnectingCordaRPCOps) {
        this.oneTimeConnection = oneTimeConnection;
        this.observersPool = observersPool;
        this.reconnectingCordaRPCOps = reconnectingCordaRPCOps;
    }

    public CordaRPCConnection(@Nullable RPCConnection<? extends CordaRPCOps> connection2) {
        this(connection2, null, null);
    }

    @Override
    @NotNull
    public CordaRPCOps getProxy() {
        CordaRPCOps cordaRPCOps;
        ReconnectingCordaRPCOps reconnectingCordaRPCOps = this.reconnectingCordaRPCOps;
        if (reconnectingCordaRPCOps != null) {
            cordaRPCOps = reconnectingCordaRPCOps;
        } else {
            RPCConnection<CordaRPCOps> rPCConnection = this.oneTimeConnection;
            Intrinsics.checkNotNull(rPCConnection);
            cordaRPCOps = rPCConnection.getProxy();
        }
        return cordaRPCOps;
    }

    private final RPCConnection<CordaRPCOps> getActualConnection() {
        RPCConnection<CordaRPCOps> rPCConnection;
        Object object = this.reconnectingCordaRPCOps;
        if (object != null && (object = ((ReconnectingCordaRPCOps)object).getReconnectingRPCConnection()) != null) {
            rPCConnection = (RPCConnection<CordaRPCOps>)object;
        } else {
            RPCConnection<CordaRPCOps> rPCConnection2 = this.oneTimeConnection;
            rPCConnection = rPCConnection2;
            Intrinsics.checkNotNull(rPCConnection2);
        }
        return rPCConnection;
    }

    @Override
    public int getServerProtocolVersion() {
        return this.getActualConnection().getServerProtocolVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyServerAndClose() {
        CordaRPCConnection this_$iv = this;
        boolean $i$f$doCloseLogic = false;
        try {
            boolean bl = false;
            this.getActualConnection().notifyServerAndClose();
        }
        finally {
            ExecutorService executorService = this_$iv.observersPool;
            if (executorService != null) {
                ExecutorService executorService2;
                ExecutorService $this$doCloseLogic_u24lambda_u242$iv = executorService2 = executorService;
                boolean bl = false;
                $this$doCloseLogic_u24lambda_u242$iv.shutdown();
                if (!$this$doCloseLogic_u24lambda_u242$iv.awaitTermination(30L, TimeUnit.SECONDS)) {
                    $this$doCloseLogic_u24lambda_u242$iv.shutdownNow();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceClose() {
        CordaRPCConnection this_$iv = this;
        boolean $i$f$doCloseLogic = false;
        try {
            boolean bl = false;
            this.getActualConnection().forceClose();
        }
        finally {
            ExecutorService executorService = this_$iv.observersPool;
            if (executorService != null) {
                ExecutorService executorService2;
                ExecutorService $this$doCloseLogic_u24lambda_u242$iv = executorService2 = executorService;
                boolean bl = false;
                $this$doCloseLogic_u24lambda_u242$iv.shutdown();
                if (!$this$doCloseLogic_u24lambda_u242$iv.awaitTermination(30L, TimeUnit.SECONDS)) {
                    $this$doCloseLogic_u24lambda_u242$iv.shutdownNow();
                }
            }
        }
    }

    @Override
    @Nullable
    public <T> T getTelemetryHandle(@NotNull Class<T> telemetryClass) {
        Intrinsics.checkNotNullParameter(telemetryClass, (String)"telemetryClass");
        return this.getActualConnection().getTelemetryHandle(telemetryClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doCloseLogic(Function0<Unit> close) {
        boolean $i$f$doCloseLogic = false;
        try {
            close.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            ExecutorService executorService = this.observersPool;
            if (executorService != null) {
                ExecutorService executorService2;
                ExecutorService $this$doCloseLogic_u24lambda_u242 = executorService2 = executorService;
                boolean bl = false;
                $this$doCloseLogic_u24lambda_u242.shutdown();
                if (!$this$doCloseLogic_u24lambda_u242.awaitTermination(30L, TimeUnit.SECONDS)) {
                    $this$doCloseLogic_u24lambda_u242.shutdownNow();
                }
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    public /* synthetic */ CordaRPCConnection(RPCConnection oneTimeConnection, ExecutorService observersPool, ReconnectingCordaRPCOps reconnectingCordaRPCOps, DefaultConstructorMarker $constructor_marker) {
        this(oneTimeConnection, observersPool, reconnectingCordaRPCOps);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0001\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lnet/corda/client/rpc/CordaRPCConnection$Companion;", "", "()V", "createWithGracefulReconnection", "Lnet/corda/client/rpc/CordaRPCConnection;", "username", "", "password", "addresses", "", "Lnet/corda/core/utilities/NetworkHostAndPort;", "rpcConfiguration", "Lnet/corda/client/rpc/CordaRPCClientConfiguration;", "gracefulReconnect", "Lnet/corda/client/rpc/GracefulReconnect;", "sslConfiguration", "Lnet/corda/core/messaging/ClientRpcSslOptions;", "classLoader", "Ljava/lang/ClassLoader;", "createWithGracefulReconnection$rpc", "rpc"})
    public static final class Companion {
        private Companion() {
        }

        @CordaInternal
        @NotNull
        public final CordaRPCConnection createWithGracefulReconnection$rpc(@NotNull String username, @NotNull String password, @NotNull List<NetworkHostAndPort> addresses, @NotNull CordaRPCClientConfiguration rpcConfiguration, @NotNull GracefulReconnect gracefulReconnect, @Nullable ClientRpcSslOptions sslConfiguration, @Nullable ClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
            Intrinsics.checkNotNullParameter((Object)rpcConfiguration, (String)"rpcConfiguration");
            Intrinsics.checkNotNullParameter((Object)gracefulReconnect, (String)"gracefulReconnect");
            ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("RPCObserver"));
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
            ExecutorService observersPool = executorService;
            return new CordaRPCConnection(null, observersPool, new ReconnectingCordaRPCOps(addresses, username, password, rpcConfiguration, gracefulReconnect, sslConfiguration, classLoader, observersPool), null);
        }

        public static /* synthetic */ CordaRPCConnection createWithGracefulReconnection$rpc$default(Companion companion, String string, String string2, List list, CordaRPCClientConfiguration cordaRPCClientConfiguration, GracefulReconnect gracefulReconnect, ClientRpcSslOptions clientRpcSslOptions, ClassLoader classLoader, int n, Object object) {
            if ((n & 0x20) != 0) {
                clientRpcSslOptions = null;
            }
            if ((n & 0x40) != 0) {
                classLoader = null;
            }
            return companion.createWithGracefulReconnection$rpc(string, string2, list, cordaRPCClientConfiguration, gracefulReconnect, clientRpcSslOptions, classLoader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

