/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0015"}, d2={"Lnet/corda/packaging/internal/ZipTweaker;", "", "()V", "run", "", "source", "Ljava/io/InputStream;", "destination", "Ljava/io/OutputStream;", "tweakEntry", "Lnet/corda/packaging/internal/ZipTweaker$AfterTweakAction;", "inputStream", "Ljava/util/zip/ZipInputStream;", "outputStream", "Ljava/util/zip/ZipOutputStream;", "currentEntry", "Ljava/util/zip/ZipEntry;", "buffer", "", "AfterTweakAction", "Companion", "packaging"})
public class ZipTweaker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected AfterTweakAction tweakEntry(@NotNull ZipInputStream inputStream, @NotNull ZipOutputStream outputStream, @NotNull ZipEntry currentEntry, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)currentEntry, (String)"currentEntry");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return AfterTweakAction.WRITE_ORIGINAL_ENTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void run(@NotNull InputStream source, @NotNull OutputStream destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        buffer = new byte[8192];
        var4_4 = new ZipInputStream(source);
        var5_5 = false;
        var6_6 = false;
        var6_7 = null;
        try {
            inputStream = (ZipInputStream)var4_4;
            $i$a$-use-ZipTweaker$run$1 = false;
            var9_12 = new ZipOutputStream(destination);
            var10_13 = false;
            var11_14 = false;
            var11_15 = null;
            try {
                outputStream = (ZipOutputStream)var9_12;
                $i$a$-use-ZipTweaker$run$1$1 = false;
                block10: while (true) {
                    if (inputStream.getNextEntry() == null) {
                        break;
                    }
                    if (this.tweakEntry(inputStream, outputStream, zipEntry, buffer) != AfterTweakAction.WRITE_ORIGINAL_ENTRY) continue;
                    outputStream.putNextEntry(zipEntry);
                    while (true) {
                        if ((read = inputStream.read(buffer)) >= 0) ** break;
                        continue block10;
                        outputStream.write(buffer, 0, read);
                    }
                    break;
                }
                var12_16 = Unit.INSTANCE;
            }
            catch (Throwable var12_17) {
                var11_15 = var12_17;
                throw var12_17;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var9_12, (Throwable)var11_15);
            }
            var7_8 = Unit.INSTANCE;
        }
        catch (Throwable var7_9) {
            var6_7 = var7_9;
            throw var7_9;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_4, (Throwable)var6_7);
        }
    }

    @JvmStatic
    public static final void write2Stream(@NotNull ZipOutputStream outputStream, @NotNull InputStream inputStream, @NotNull byte[] buffer) {
        Companion.write2Stream(outputStream, inputStream, buffer);
    }

    @JvmStatic
    public static final void writeZipEntry(@NotNull ZipOutputStream zip, @NotNull Function0<? extends InputStream> source, @NotNull String destinationFileName, @NotNull byte[] buffer, int compressionMethod) {
        Companion.writeZipEntry(zip, source, destinationFileName, buffer, compressionMethod);
    }

    @JvmStatic
    public static final void removeJarSignature(@NotNull Path jarFile, @Nullable Path outFile) {
        Companion.removeJarSignature(jarFile, outFile);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/packaging/internal/ZipTweaker$AfterTweakAction;", "", "(Ljava/lang/String;I)V", "WRITE_ORIGINAL_ENTRY", "DO_NOTHING", "packaging"})
    protected static final class AfterTweakAction
    extends Enum<AfterTweakAction> {
        public static final /* enum */ AfterTweakAction WRITE_ORIGINAL_ENTRY;
        public static final /* enum */ AfterTweakAction DO_NOTHING;
        private static final /* synthetic */ AfterTweakAction[] $VALUES;

        static {
            AfterTweakAction[] afterTweakActionArray = new AfterTweakAction[2];
            AfterTweakAction[] afterTweakActionArray2 = afterTweakActionArray;
            afterTweakActionArray[0] = WRITE_ORIGINAL_ENTRY = new AfterTweakAction();
            afterTweakActionArray[1] = DO_NOTHING = new AfterTweakAction();
            $VALUES = afterTweakActionArray;
        }

        public static AfterTweakAction[] values() {
            return (AfterTweakAction[])$VALUES.clone();
        }

        public static AfterTweakAction valueOf(String string) {
            return Enum.valueOf(AfterTweakAction.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J:\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007\u00a8\u0006\u001a"}, d2={"Lnet/corda/packaging/internal/ZipTweaker$Companion;", "", "()V", "computeSizeAndCrc32", "", "zipEntry", "Ljava/util/zip/ZipEntry;", "inputStream", "Ljava/io/InputStream;", "buffer", "", "removeJarSignature", "jarFile", "Ljava/nio/file/Path;", "outFile", "write2Stream", "outputStream", "Ljava/util/zip/ZipOutputStream;", "writeZipEntry", "zip", "source", "Lkotlin/Function0;", "destinationFileName", "", "compressionMethod", "", "packaging"})
    public static final class Companion {
        private final void computeSizeAndCrc32(ZipEntry zipEntry, InputStream inputStream, byte[] buffer) {
            int read;
            CRC32 crc32 = new CRC32();
            long sz = 0L;
            while ((read = inputStream.read(buffer)) >= 0) {
                sz += (long)read;
                crc32.update(buffer, 0, read);
            }
            zipEntry.setSize(sz);
            zipEntry.setCompressedSize(sz);
            zipEntry.setCrc(crc32.getValue());
        }

        @JvmStatic
        public final void write2Stream(@NotNull ZipOutputStream outputStream, @NotNull InputStream inputStream, @NotNull byte[] buffer) {
            int read;
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void writeZipEntry(@NotNull ZipOutputStream zip, @NotNull Function0<? extends InputStream> source, @NotNull String destinationFileName, @NotNull byte[] buffer, int compressionMethod) {
            Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destinationFileName, (String)"destinationFileName");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Object object = new ZipEntry(destinationFileName);
            boolean bl = false;
            boolean bl2 = false;
            ZipEntry $this$apply = object;
            boolean bl3 = false;
            ZipEntry ze = $this$apply;
            $this$apply.setMethod(compressionMethod);
            switch ($this$apply.getMethod()) {
                case 0: {
                    Closeable closeable = (Closeable)source.invoke();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl6 = false;
                        Companion.computeSizeAndCrc32(ze, it, buffer);
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                case 8: {
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported zip entry compression method value: " + compressionMethod);
                }
            }
            ZipEntry zipEntry = object;
            zip.putNextEntry(zipEntry);
            object = (Closeable)source.invoke();
            bl = false;
            bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl7 = false;
                Companion.write2Stream(zip, it, buffer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            zip.closeEntry();
        }

        public static /* synthetic */ void writeZipEntry$default(Companion companion, ZipOutputStream zipOutputStream, Function0 function0, String string, byte[] byArray, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                byArray = new byte[8192];
            }
            if ((n2 & 0x10) != 0) {
                n = 8;
            }
            companion.writeZipEntry(zipOutputStream, (Function0<? extends InputStream>)function0, string, byArray, n);
        }

        @JvmStatic
        public final void removeJarSignature(@NotNull Path jarFile, @Nullable Path outFile) {
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            Path path = outFile;
            if (path == null) {
                path = Files.createTempFile(jarFile.getParent(), ((Object)jarFile.getFileName()).toString(), ".tmp", new FileAttribute[0]);
            }
            Path destination = path;
            try {
                Unit unit;
                ZipTweaker zipTweaker = new ZipTweaker(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    protected AfterTweakAction tweakEntry(@NotNull ZipInputStream inputStream, @NotNull ZipOutputStream outputStream, @NotNull ZipEntry currentEntry, @NotNull byte[] buffer) {
                        AfterTweakAction afterTweakAction;
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        Intrinsics.checkNotNullParameter((Object)currentEntry, (String)"currentEntry");
                        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                        String string = currentEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentEntry.name");
                        if (StringsKt.startsWith$default((String)string, (String)"META-INF/", (boolean)false, (int)2, null)) {
                            String string2 = currentEntry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentEntry.name");
                            String string3 = string2;
                            boolean bl = false;
                            String string4 = string3;
                            if (string4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string5 = string4.toUpperCase();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
                            if (StringsKt.endsWith$default((String)string5, (String)".SF", (boolean)false, (int)2, null)) {
                                afterTweakAction = AfterTweakAction.DO_NOTHING;
                                return afterTweakAction;
                            }
                        }
                        afterTweakAction = AfterTweakAction.WRITE_ORIGINAL_ENTRY;
                        return afterTweakAction;
                    }
                };
                InputStream inputStream = Files.newInputStream(jarFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(jarFile)");
                OutputStream outputStream = Files.newOutputStream(destination, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(destination)");
                zipTweaker.run(inputStream, outputStream);
                if (outFile == null) {
                    Files.move(destination, jarFile, StandardCopyOption.REPLACE_EXISTING);
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
            }
            catch (Throwable e) {
                Path path2 = destination;
                boolean bl = false;
                boolean bl2 = false;
                Path p1 = path2;
                boolean bl3 = false;
                path2 = Files.exists(p1, new LinkOption[0]) ? path2 : null;
                bl = false;
                bl2 = false;
                p1 = path2;
                boolean bl4 = false;
                Files.delete(p1);
                throw e;
            }
        }

        public static /* synthetic */ void removeJarSignature$default(Companion companion, Path path, Path path2, int n, Object object) {
            if ((n & 2) != 0) {
                path2 = null;
            }
            companion.removeJarSignature(path, path2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

