/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/corda/packaging/internal/ZipExtractorInputStream;", "Ljava/util/zip/ZipInputStream;", "source", "Ljava/io/InputStream;", "destination", "Ljava/nio/file/Path;", "filter", "Lkotlin/Function1;", "Ljava/util/zip/ZipEntry;", "", "(Ljava/io/InputStream;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)V", "currentFile", "Ljava/io/OutputStream;", "closeEntry", "", "getNextEntry", "read", "", "b", "", "off", "len", "packaging"})
public final class ZipExtractorInputStream
extends ZipInputStream {
    private OutputStream currentFile;
    private final Path destination;
    private final Function1<ZipEntry, Boolean> filter;

    @Override
    @Nullable
    public ZipEntry getNextEntry() {
        ZipEntry zipEntry;
        ZipEntry zipEntry2 = super.getNextEntry();
        if (zipEntry2 != null) {
            ZipEntry zipEntry3 = zipEntry2;
            boolean bl = false;
            boolean bl2 = false;
            ZipEntry entry = zipEntry3;
            boolean bl3 = false;
            Path newFileSystemLocation = this.destination.resolve(entry.getName());
            if (((Boolean)this.filter.invoke((Object)entry)).booleanValue()) {
                if (entry.isDirectory()) {
                    Files.createDirectories(newFileSystemLocation, new FileAttribute[0]);
                } else {
                    Path path = newFileSystemLocation;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"newFileSystemLocation");
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    this.currentFile = Files.newOutputStream(this.destination.resolve(entry.getName()), new OpenOption[0]);
                }
            }
            zipEntry = zipEntry3;
        } else {
            zipEntry = null;
        }
        return zipEntry;
    }

    @Override
    public int read() {
        int result;
        block1: {
            result = super.read();
            if (result == -1) break block1;
            OutputStream outputStream = this.currentFile;
            if (outputStream != null) {
                outputStream.write(result);
            }
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int read;
        block1: {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            read = super.read(b, off, len);
            if (read == -1) break block1;
            OutputStream outputStream = this.currentFile;
            if (outputStream != null) {
                outputStream.write(b, off, read);
            }
        }
        return read;
    }

    @Override
    public void closeEntry() {
        super.closeEntry();
        OutputStream outputStream = this.currentFile;
        if (outputStream != null) {
            outputStream.close();
        }
        this.currentFile = null;
    }

    public ZipExtractorInputStream(@NotNull InputStream source, @NotNull Path destination, @NotNull Function1<? super ZipEntry, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        super(source);
        this.destination = destination;
        this.filter = filter;
    }

    public /* synthetic */ ZipExtractorInputStream(InputStream inputStream, Path path, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(inputStream, path, (Function1<? super ZipEntry, Boolean>)function1);
    }
}

