/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging.internal;

import java.security.CodeSigner;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/corda/packaging/internal/SignatureCollector;", "", "()V", "_certificates", "", "Ljava/security/cert/Certificate;", "certificates", "", "getCertificates", "()Ljava/util/Set;", "codeSigners", "", "Ljava/security/CodeSigner;", "[Ljava/security/CodeSigner;", "firstSignedEntry", "", "addEntry", "", "jarEntry", "Ljava/util/jar/JarEntry;", "Companion", "packaging"})
public final class SignatureCollector {
    private String firstSignedEntry;
    private CodeSigner[] codeSigners;
    private final Set<Certificate> _certificates;
    private static final Regex unsignableEntryName;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Set<Certificate> getCertificates() {
        Set<Certificate> set = Collections.unmodifiableSet(this._certificates);
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiableSet(_certificates)");
        return set;
    }

    public final void addEntry(@NotNull JarEntry jarEntry) {
        Intrinsics.checkNotNullParameter((Object)jarEntry, (String)"jarEntry");
        if (Companion.isSignable(jarEntry)) {
            Object[] entrySigners;
            Object[] objectArray = jarEntry.getCodeSigners();
            if (objectArray == null) {
                objectArray = entrySigners = new CodeSigner[]{};
            }
            if (this.codeSigners == null) {
                this.codeSigners = entrySigners;
                this.firstSignedEntry = jarEntry.getName();
                Object[] objectArray2 = entrySigners;
                int n = objectArray2.length;
                for (int j = 0; j < n; ++j) {
                    Object signer;
                    Object object = signer = objectArray2[j];
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signer");
                    CertPath certPath = ((CodeSigner)object).getSignerCertPath();
                    Intrinsics.checkNotNullExpressionValue((Object)certPath, (String)"signer.signerCertPath");
                    List<? extends Certificate> list = certPath.getCertificates();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"signer.signerCertPath.certificates");
                    Object object2 = CollectionsKt.first(list);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"signer.signerCertPath.certificates.first()");
                    this._certificates.add((Certificate)object2);
                }
            }
            if (!Arrays.equals(this.codeSigners, entrySigners)) {
                StringBuilder stringBuilder = new StringBuilder().append("\n                    Mismatch between signers ");
                Intrinsics.checkNotNull((Object)this.codeSigners);
                throw (Throwable)new IllegalArgumentException(StringsKt.replace$default((String)StringsKt.trimIndent((String)stringBuilder.append(SignatureCollector.Companion.signers2OrderedPublicKeys(this.codeSigners)).append(" for file ").append(this.firstSignedEntry).append("\n                    and signers ").append(SignatureCollector.Companion.signers2OrderedPublicKeys((CodeSigner[])entrySigners)).append(" for file ").append(jarEntry.getName()).append("\n                    ").toString()), (char)'\n', (char)' ', (boolean)false, (int)4, null));
            }
        }
    }

    public SignatureCollector() {
        boolean bl = false;
        this._certificates = new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        String string = "META-INF/(?:(?:.*[.](?:SF|DSA|RSA|EC)|SIG-.*)|INDEX\\.LIST)";
        boolean bl = false;
        unsignableEntryName = new Regex(string);
    }

    @JvmStatic
    public static final boolean isSignable(@NotNull JarEntry entry) {
        return Companion.isSignable(entry);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J)\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/corda/packaging/internal/SignatureCollector$Companion;", "", "()V", "unsignableEntryName", "Lkotlin/text/Regex;", "isSignable", "", "entry", "Ljava/util/jar/JarEntry;", "signers2OrderedPublicKeys", "Ljava/util/LinkedHashSet;", "Ljava/security/PublicKey;", "kotlin.jvm.PlatformType", "signers", "", "Ljava/security/CodeSigner;", "([Ljava/security/CodeSigner;)Ljava/util/LinkedHashSet;", "packaging"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isSignable(@NotNull JarEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            if (entry.isDirectory()) return false;
            Regex regex = unsignableEntryName;
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
            if (regex.matches((CharSequence)string)) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final LinkedHashSet<PublicKey> signers2OrderedPublicKeys(CodeSigner[] signers) {
            void var3_3;
            void $this$mapTo$iv;
            CodeSigner[] codeSignerArray = signers;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            void var5_5 = $this$mapTo$iv;
            int n = ((void)var5_5).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv;
                void var9_9 = item$iv = var5_5[j];
                Collection collection = destination$iv;
                boolean bl = false;
                CertPath certPath = it.getSignerCertPath();
                Intrinsics.checkNotNullExpressionValue((Object)certPath, (String)"it.signerCertPath");
                Certificate certificate = certPath.getCertificates().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"(it.signerCertPath.certificates[0])");
                PublicKey publicKey = certificate.getPublicKey();
                collection.add(publicKey);
            }
            return (LinkedHashSet)var3_3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

