/*
 * Decompiled with CFR 0.152.
 */
package net.corda.packaging.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.packaging.PackagingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/corda/packaging/internal/JarExtractorInputStream;", "Ljava/util/jar/JarInputStream;", "source", "Ljava/io/InputStream;", "destination", "Ljava/nio/file/Path;", "verify", "", "sourceLocation", "", "outputNameTransformer", "Lkotlin/Function1;", "filter", "Ljava/util/zip/ZipEntry;", "(Ljava/io/InputStream;Ljava/nio/file/Path;ZLjava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "currentFile", "Ljava/io/OutputStream;", "hasAnyEntry", "checkHasAnyEntry", "", "nextEntry", "closeEntry", "getNextEntry", "read", "", "b", "", "off", "len", "packaging"})
public final class JarExtractorInputStream
extends JarInputStream {
    private OutputStream currentFile;
    private boolean hasAnyEntry;
    private final Path destination;
    private final String sourceLocation;
    private final Function1<String, String> outputNameTransformer;
    private final Function1<ZipEntry, Boolean> filter;

    @Override
    @Nullable
    public ZipEntry getNextEntry() {
        ZipEntry zipEntry;
        ZipEntry nextEntry = super.getNextEntry();
        this.checkHasAnyEntry(nextEntry);
        ZipEntry zipEntry2 = nextEntry;
        if (zipEntry2 != null) {
            ZipEntry zipEntry3 = zipEntry2;
            boolean bl = false;
            boolean bl2 = false;
            ZipEntry entry = zipEntry3;
            boolean bl3 = false;
            Path newFileSystemLocation = this.destination.resolve(entry.getName());
            if (((Boolean)this.filter.invoke((Object)entry)).booleanValue()) {
                if (entry.isDirectory()) {
                    Files.createDirectories(newFileSystemLocation, new FileAttribute[0]);
                } else {
                    Path path = newFileSystemLocation;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"newFileSystemLocation");
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                    String name = (String)this.outputNameTransformer.invoke((Object)string);
                    this.currentFile = Files.newOutputStream(this.destination.resolve(name), new OpenOption[0]);
                }
            }
            zipEntry = zipEntry3;
        } else {
            zipEntry = null;
        }
        return zipEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkHasAnyEntry(ZipEntry nextEntry) {
        block2: {
            block3: {
                String string;
                StringBuilder stringBuilder;
                block5: {
                    block4: {
                        void it;
                        if (this.hasAnyEntry) break block2;
                        if (nextEntry != null || this.getManifest() != null) break block3;
                        stringBuilder = new StringBuilder().append("The source stream ");
                        string = this.sourceLocation;
                        if (string == null) break block4;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String string3 = string2;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl3 = false;
                        String string4 = "from '" + (String)it + '\'';
                        stringBuilder = stringBuilder2;
                        string = string4;
                        if (string != null) break block5;
                    }
                    string = "";
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 2;
                Throwable throwable = null;
                String string5 = stringBuilder.append(string).append(" doesn't represent a valid jar file").toString();
                throw (Throwable)new PackagingException(string5, throwable, n, defaultConstructorMarker);
            }
            this.hasAnyEntry = true;
        }
    }

    @Override
    public int read() {
        int result;
        block1: {
            result = super.read();
            if (result == -1) break block1;
            OutputStream outputStream = this.currentFile;
            if (outputStream != null) {
                outputStream.write(result);
            }
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int read;
        block1: {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            read = super.read(b, off, len);
            if (read == -1) break block1;
            OutputStream outputStream = this.currentFile;
            if (outputStream != null) {
                outputStream.write(b, off, read);
            }
        }
        return read;
    }

    @Override
    public void closeEntry() {
        super.closeEntry();
        OutputStream outputStream = this.currentFile;
        if (outputStream != null) {
            outputStream.close();
        }
        this.currentFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarExtractorInputStream(@NotNull InputStream source, @NotNull Path destination, boolean verify, @Nullable String sourceLocation, @NotNull Function1<? super String, String> outputNameTransformer, @NotNull Function1<? super ZipEntry, Boolean> filter) {
        Path newFileSystemLocation;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(outputNameTransformer, (String)"outputNameTransformer");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        super(source, verify);
        this.destination = destination;
        this.sourceLocation = sourceLocation;
        this.outputNameTransformer = outputNameTransformer;
        this.filter = filter;
        Path path = newFileSystemLocation = this.destination.resolve("META-INF/MANIFEST.MF");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"newFileSystemLocation");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            Manifest manifest2 = manifest;
            boolean bl = false;
            boolean bl2 = false;
            Manifest mf = manifest2;
            boolean bl3 = false;
            Closeable closeable = Files.newOutputStream(newFileSystemLocation, new OpenOption[0]);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                OutputStream p1 = (OutputStream)closeable;
                boolean bl6 = false;
                mf.write(p1);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public /* synthetic */ JarExtractorInputStream(InputStream inputStream, Path path, boolean bl, String string, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function12 = 2.INSTANCE;
        }
        this(inputStream, path, bl, string, (Function1<? super String, String>)function1, (Function1<? super ZipEntry, Boolean>)function12);
    }
}

